import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "@angular/common";
export class StiTableCheckboxComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
        this.buttonClick = new EventEmitter();
    }
    get cell() {
        return this.item.cells[this.index] ? this.item.cells[this.index] : null;
    }
    changeState() {
        this.buttonClick.emit();
    }
    ngOnInit() { }
    get tabIndex() {
        try {
            let columns = this.object.columns;
            return this.object["tabIndex"] + columns.indexOf(this.item) + columns.length * this.index;
        }
        catch { }
    }
}
StiTableCheckboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableCheckboxComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiTableCheckboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableCheckboxComponent, selector: "sti-table-checkbox-component", inputs: { item: "item", index: "index", object: "object", disabled: "disabled", isClone: "isClone", alignment: "alignment" }, outputs: { buttonClick: "buttonClick" }, ngImport: i0, template: ` <div
    class="custom-checkbox"
    [style.justify-content]="alignment"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <input
      type="checkbox"
      name=""
      tooltipPosition="bottom"
      showDelay="500"
      [tabIndex]="tabIndex"
      (click)="changeState()"
      [disabled]="disabled"
    />
    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
      <rect
        class="box"
        x="0.5"
        y="15.5"
        width="16"
        height="16"
        transform="rotate(-90 0.5 15.5)"
        [attr.fill]="item.cellBackColor.toHtmlColor()"
        [attr.stroke]="item.cellBorderColor.toHtmlColor()"
      />
      <path
        *ngIf="cell?.isChecked"
        class="check"
        d="M5 7.23529L8.15 12L14 3"
        [attr.stroke]="item.cellForeColor.toHtmlColor()"
        fill="transparent"
        stroke-width="2"
        stroke-linecap="round"
        stroke-linejoin="round"
      />
    </svg>
  </div>`, isInline: true, styles: ["input[type=checkbox]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=checkbox]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=checkbox]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-checkbox{align-items:center;width:-moz-fit-content;width:fit-content;position:relative;display:flex;width:100%}.custom-checkbox input[type=checkbox]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableCheckboxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-checkbox-component", template: ` <div
    class="custom-checkbox"
    [style.justify-content]="alignment"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <input
      type="checkbox"
      name=""
      tooltipPosition="bottom"
      showDelay="500"
      [tabIndex]="tabIndex"
      (click)="changeState()"
      [disabled]="disabled"
    />
    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
      <rect
        class="box"
        x="0.5"
        y="15.5"
        width="16"
        height="16"
        transform="rotate(-90 0.5 15.5)"
        [attr.fill]="item.cellBackColor.toHtmlColor()"
        [attr.stroke]="item.cellBorderColor.toHtmlColor()"
      />
      <path
        *ngIf="cell?.isChecked"
        class="check"
        d="M5 7.23529L8.15 12L14 3"
        [attr.stroke]="item.cellForeColor.toHtmlColor()"
        fill="transparent"
        stroke-width="2"
        stroke-linecap="round"
        stroke-linejoin="round"
      />
    </svg>
  </div>`, styles: ["input[type=checkbox]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=checkbox]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=checkbox]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-checkbox{align-items:center;width:-moz-fit-content;width:fit-content;position:relative;display:flex;width:100%}.custom-checkbox input[type=checkbox]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }], object: [{
                type: Input
            }], disabled: [{
                type: Input
            }], isClone: [{
                type: Input
            }], alignment: [{
                type: Input
            }], buttonClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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