import { Component, Input } from "@angular/core";
import { StiTableElement } from "../elements/StiTableElement";
import { StiColumnItem } from "../elements/table/StiColumnItem";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/mouse.service";
export class StiTableColumnResizerComponent {
    constructor(model, mouseService) {
        this.model = model;
        this.mouseService = mouseService;
        this.minWidth = 40;
        this.isResizing = false;
    }
    initResize(event) {
        event.stopPropagation();
        if (this.model.isPreviewMode) {
            return;
        }
        this.isResizing = true;
        this.startPoint = event.clientX;
        if (this.resizableItem instanceof StiColumnItem) {
            this.startColumnWidth = this.resizableItem.width;
            this.maxWidth = this.startColumnWidth + this.element.columns[this.index + 1].width;
            this.adjacentColumnWidth = this.element.columns[this.index + 1].width;
        }
        else {
            this.startColumnWidth = this.resizableItem.rowLabelsWidth;
            this.maxWidth = this.startColumnWidth + this.element.columns[0].width;
            this.adjacentColumnWidth = this.element.columns[0].width;
        }
    }
    resize(event) {
        if (this.isResizing) {
            let delta = event.clientX - this.startPoint;
            if (this.startColumnWidth + delta >= this.minWidth && this.adjacentColumnWidth - delta >= this.minWidth) {
                if (this.resizableItem instanceof StiColumnItem) {
                    this.resizableItem.width = this.startColumnWidth + delta;
                    this.element.columns[this.index + 1].width = this.adjacentColumnWidth - delta;
                }
                else {
                    this.resizableItem.rowLabelsWidth = this.startColumnWidth + delta;
                    this.element.columns[0].width = this.adjacentColumnWidth - delta;
                }
            }
            else {
                if (this.resizableItem instanceof StiColumnItem) {
                    if (this.startColumnWidth + delta <= this.minWidth) {
                        this.resizableItem.width = this.minWidth;
                        this.element.columns[this.index + 1].width = this.maxWidth - this.minWidth;
                    }
                    else if (this.adjacentColumnWidth - delta <= this.minWidth) {
                        this.element.columns[this.index + 1].width = this.minWidth;
                        this.resizableItem.width = this.maxWidth - this.minWidth;
                    }
                }
                else {
                    if (this.startColumnWidth + delta <= this.minWidth) {
                        this.resizableItem.rowLabelsWidth = this.minWidth;
                        this.element.columns[0].width = this.maxWidth - this.minWidth;
                    }
                    else if (this.adjacentColumnWidth - delta <= this.minWidth) {
                        this.element.columns[0].width = this.minWidth;
                        this.resizableItem.rowLabelsWidth = this.maxWidth - this.minWidth;
                    }
                }
            }
        }
    }
    get showResizePreview() {
        return this.element instanceof StiTableElement &&
            !this.model.isPreviewMode &&
            ((!this.element.gridLines.drawVertical && this.resizableItem instanceof StiColumnItem) ||
                (!this.element.columnHeadersBorder.drawLeft && !(this.resizableItem instanceof StiColumnItem))) &&
            this.model.selectedComponent?.element == this.element
            ? true
            : false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.mouseMoveSubscription?.unsubscribe();
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.isResizing = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.resize(event);
        });
    }
}
StiTableColumnResizerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableColumnResizerComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }], target: i0.ɵɵFactoryTarget.Component });
StiTableColumnResizerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableColumnResizerComponent, selector: "sti-table-column-resizer", inputs: { resizableItem: "resizableItem", element: "element", index: "index" }, ngImport: i0, template: `
    <div
      class="column-resizer"
      (mousedown)="initResize($event)"
      [style.border-right]="showResizePreview ? '1px solid black' : ''"
      [style.cursor]="model.isPreviewMode ? 'default' : 'ew-resize'"
    ></div>
    <style>
      .column-resizer {
        height: 100%;
        width: 5px;
        position: absolute;
        opacity: 0.5;
        top: 0;
        right: 0;
      }
      .column-resizer:hover {
        cursor: ew-resize;
      }
    </style>
  `, isInline: true, styles: ["\n      .column-resizer {\n        height: 100%;\n        width: 5px;\n        position: absolute;\n        opacity: 0.5;\n        top: 0;\n        right: 0;\n      }\n      .column-resizer:hover {\n        cursor: ew-resize;\n      }\n    "] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableColumnResizerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-table-column-resizer",
                    template: `
    <div
      class="column-resizer"
      (mousedown)="initResize($event)"
      [style.border-right]="showResizePreview ? '1px solid black' : ''"
      [style.cursor]="model.isPreviewMode ? 'default' : 'ew-resize'"
    ></div>
    <style>
      .column-resizer {
        height: 100%;
        width: 5px;
        position: absolute;
        opacity: 0.5;
        top: 0;
        right: 0;
      }
      .column-resizer:hover {
        cursor: ew-resize;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }]; }, propDecorators: { resizableItem: [{
                type: Input
            }], element: [{
                type: Input
            }], index: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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