import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../svg.components/svg.radiobutton.component";
export class StiSingleSelectionComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    get columns() {
        return (this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) >
            this.element.columns
            ? new Array(Number(this.element.columns)).fill(3)
            : new Array(this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length).fill(1);
    }
    get rows() {
        return this.element.useCustomOption
            ? new Array(Math.ceil((this.element.options.length + 1) / Number(this.element.columns))).fill(2)
            : new Array(Math.ceil(this.element.options.length / Number(this.element.columns))).fill(2);
    }
    getColumns(rowIndex) {
        if ((this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) -
            Number(this.element.columns) * rowIndex >=
            Number(this.element.columns)) {
            return new Array(Number(this.element.columns)).fill(3);
        }
        else {
            let count = (this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) -
                Number(this.element.columns) * rowIndex;
            return new Array(Number(count)).fill(3);
        }
    }
    get align() {
        return "start";
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    changeState(option) {
        this.element.selectedOption = option;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    ngOnInit() { }
}
StiSingleSelectionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSingleSelectionComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiSingleSelectionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiSingleSelectionComponent, selector: "sti-singleselection-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-single-selection">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element?.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="table-container" [style.maxWidth.px]="element.maxWidth + 0.1">
            <table>
              <tr *ngFor="let row of rows; let i = index">
                <td
                  *ngFor="let column of getColumns(i); let idx = index"
                  [colSpan]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length
                      ? element.columns - idx + 1
                      : 0
                  "
                  [style.width]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length ? '100%' : ''
                  "
                  [style.padding-top.px]="(element?.useCustomOption && i == rows.length - 1) || i == 0 ? 0 : 3"
                  [style.padding-bottom.px]="
                    (element?.useCustomOption && i == rows.length - 1) || i == rows.length - 1 ? 0 : 3
                  "
                >
                  <sti-svg-radiobutton-component
                    *ngIf="element?.options[i * element.columns + idx] != null"
                    [element]="element"
                    [id]="element?.options[i * element.columns + idx] + i + element?.name"
                    [text]="element.optionsContentEditable[i * element.columns + idx]"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [state]="
                      element?.options[i * element.columns + idx] == element?.selectedOption && element?.selectedOption
                    "
                    (buttonClick)="changeState(element?.options[i * element.columns + idx])"
                  ></sti-svg-radiobutton-component>
                  <sti-svg-radiobutton-component
                    *ngIf="element?.useCustomOption && i * element.columns + idx == element.options.length"
                    [element]="element"
                    [useCustomOption]="element?.useCustomOption"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [id]="'SingleSelectionCustomOption'"
                    [text]="element?.customOptionText"
                    [state]="element?.customOptionText == element?.selectedOption"
                    (buttonClick)="changeState(element?.customOptionText)"
                    [style.width]="'100%'"
                  ></sti-svg-radiobutton-component>
                </td>
                <td [style.width]="'100%'" *ngIf="i != rows.length - 1 || (i == 0 && !element.useCustomOption)"></td>
              </tr>
            </table>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: [".table-container{overflow:hidden}table{width:100%;border-spacing:0;overflow:hidden}ul{width:100%;margin:0;padding:0;list-style:none;column-width:auto;column-gap:10px}li{margin-top:5px}.custom-radio{position:absolute;opacity:0;z-index:-1;left:0}tr{width:100%;max-width:inherit;height:max-content;padding:0;margin:0}td{max-width:inherit;height:100%;padding:0;margin:0}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i5.StiSvgRadiobuttonComponent, selector: "sti-svg-radiobutton-component", inputs: ["element", "id", "text", "state", "useCustomOption", "tabIndex"], outputs: ["buttonClick"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSingleSelectionComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-singleselection-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-single-selection">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element?.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="table-container" [style.maxWidth.px]="element.maxWidth + 0.1">
            <table>
              <tr *ngFor="let row of rows; let i = index">
                <td
                  *ngFor="let column of getColumns(i); let idx = index"
                  [colSpan]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length
                      ? element.columns - idx + 1
                      : 0
                  "
                  [style.width]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length ? '100%' : ''
                  "
                  [style.padding-top.px]="(element?.useCustomOption && i == rows.length - 1) || i == 0 ? 0 : 3"
                  [style.padding-bottom.px]="
                    (element?.useCustomOption && i == rows.length - 1) || i == rows.length - 1 ? 0 : 3
                  "
                >
                  <sti-svg-radiobutton-component
                    *ngIf="element?.options[i * element.columns + idx] != null"
                    [element]="element"
                    [id]="element?.options[i * element.columns + idx] + i + element?.name"
                    [text]="element.optionsContentEditable[i * element.columns + idx]"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [state]="
                      element?.options[i * element.columns + idx] == element?.selectedOption && element?.selectedOption
                    "
                    (buttonClick)="changeState(element?.options[i * element.columns + idx])"
                  ></sti-svg-radiobutton-component>
                  <sti-svg-radiobutton-component
                    *ngIf="element?.useCustomOption && i * element.columns + idx == element.options.length"
                    [element]="element"
                    [useCustomOption]="element?.useCustomOption"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [id]="'SingleSelectionCustomOption'"
                    [text]="element?.customOptionText"
                    [state]="element?.customOptionText == element?.selectedOption"
                    (buttonClick)="changeState(element?.customOptionText)"
                    [style.width]="'100%'"
                  ></sti-svg-radiobutton-component>
                </td>
                <td [style.width]="'100%'" *ngIf="i != rows.length - 1 || (i == 0 && !element.useCustomOption)"></td>
              </tr>
            </table>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: [".table-container{overflow:hidden}table{width:100%;border-spacing:0;overflow:hidden}ul{width:100%;margin:0;padding:0;list-style:none;column-width:auto;column-gap:10px}li{margin-top:5px}.custom-radio{position:absolute;opacity:0;z-index:-1;left:0}tr{width:100%;max-width:inherit;height:max-content;padding:0;margin:0}td{max-width:inherit;height:100%;padding:0;margin:0}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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