import { Component, Input, ViewChild, } from "@angular/core";
import { StiHorizontalAlignment, StiLabelAlignment } from "../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/mouse.service";
import * as i3 from "../../services/sti-component-resizer.service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "../../services/sti-signature.service";
import * as i6 from "../../services/sti-helper.service";
import * as i7 from "@angular/common";
import * as i8 from "../sti-component";
import * as i9 from "../sti-editable-content.component";
export class StiSignatureComponent {
    constructor(model, mouse, resize, loc, signatureService, helper, cdr) {
        this.model = model;
        this.mouse = mouse;
        this.resize = resize;
        this.loc = loc;
        this.signatureService = signatureService;
        this.helper = helper;
        this.cdr = cdr;
        this.isClone = false;
        this.topMargin = 8;
        this.drawingMode = false;
        this.textMode = false;
        this.isDrawing = false;
        this.loadedImage = false;
        this.isInitialized = false;
    }
    isDrawingMode() {
        if (this.isCurrentEditableSignature) {
            return this.signatureService.selectedMode == "Draw";
        }
        else {
            return this.element.currentSignatureMode == "Draw";
        }
    }
    get isAspectRatio() {
        if (this.isCurrentEditableSignature) {
            return (this.signatureService?.currentEditableImage?.aspectRatio && this.signatureService?.currentEditableImage?.stretch);
        }
        else {
            return this.element?.insertedImage?.aspectRatio && this.element?.insertedImage?.stretch;
        }
    }
    get align() {
        return "start";
    }
    get isCurrentEditableSignature() {
        return (this.signatureService?.currentSignatureElement == this.element && this.model.showSignatureEditor && !this.isClone);
    }
    getImageWidth(parentContainer) {
        if (this.isInitialized && parentContainer) {
            return this.isAspectRatio
                ? parentContainer.clientHeight > parentContainer.clientWidth
                    ? parentContainer.clientWidth
                    : parentContainer.clientHeight
                : parentContainer.clientWidth;
        }
        else {
            return 0;
        }
    }
    get cursor() {
        return this.signatureService.drawingMode
            ? `url(${this.model.getImage("signature.Brush.png")}) 8 ${16 * window.devicePixelRatio - 4 * window.devicePixelRatio}, auto`
            : "";
    }
    isOldVersion() {
        if (this.element.backgroundImage &&
            !this.element.insertedImage.loadedImage &&
            !this.element.drawedImage &&
            !this.element.insertedText.value &&
            !this.element.fullName &&
            !this.element.initials) {
            return true;
        }
        else
            return false;
    }
    getInsertedTextValue() {
        if (this.isCurrentEditableSignature) {
            return this.signatureService.selectedMode === "Draw" ? this.signatureService?.currentEditableText?.value : "";
        }
        else {
            return this.element.currentSignatureMode === "Draw" ? this.element?.insertedText?.value : "";
        }
    }
    getTypeTextValue() {
        if (this.isCurrentEditableSignature) {
            return this.signatureService.selectedMode === "Type"
                ? `${this.signatureService.currentEditableFullName} ${this.signatureService.currentEditableInitials}`
                : "";
        }
        else {
            return this.element.currentSignatureMode === "Type" ? `${this.element?.fullName} ${this.element?.initials}` : "";
        }
    }
    showSignatureEditor() {
        if (!this.isClone) {
            this.signatureService.currentEditableImage = this.element.insertedImage;
            this.signatureService.currentEditableText = this.element.insertedText;
            this.signatureService.currentCanvasContent = this.element.drawedImage;
            this.signatureService.currentEditableFullName = this.element.fullName;
            this.signatureService.currentEditableInitials = this.element.initials;
            this.signatureService.selectedMode = this.element.currentSignatureMode;
            this.signatureService.currentPreviewFont = this.element.specialFont;
            this.signatureService.currentCanvasContent = this.element.drawedImage;
            // this.signatureService.currentSignatureElement = this.helper.clone(this.element) as StiSignatureElement;
            this.signatureService.currentSignatureElement = this.element;
            this.model.showSignatureEditor = !this.model.showSignatureEditor;
        }
    }
    get canvasWidth() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top && this.element["label"]["value"]) {
                return (this.element.width - this.element.label.width - this.element.padding.right - this.element.padding.left - 2);
            }
            else {
                return this.element.width - this.element.padding.right - this.element.padding.left;
            }
        }
    }
    get oldBackgroundImage() {
        return this.getUrlImage(this.element.backgroundImage);
    }
    get image() {
        return this.isCurrentEditableSignature && this.signatureService.selectedMode == "Draw"
            ? this.getUrlImage(this.signatureService?.currentEditableImage?.loadedImage)
            : this.isCurrentEditableSignature && this.signatureService.selectedMode == "Type"
                ? ""
                : this.getUrlImage(this.element?.insertedImage?.loadedImage);
    }
    get drawedImage() {
        return this.isCurrentEditableSignature && this.signatureService.selectedMode == "Draw"
            ? this.getUrlImage(this.signatureService?.currentCanvasContent)
            : this.isCurrentEditableSignature && this.signatureService.selectedMode == "Type"
                ? ""
                : this.getUrlImage(this.element?.drawedImage);
    }
    getUrlImage(image) {
        return image ? "url(" + image + ")" : null;
    }
    get alignment() {
        if (this.isCurrentEditableSignature) {
            if (this.signatureService.selectedMode == "Type") {
                return "start";
            }
            else {
                if (this.signatureService?.currentEditableText?.horizontalAlignment == StiHorizontalAlignment.Center) {
                    return "center";
                }
                else if (this.signatureService?.currentEditableText?.horizontalAlignment == StiHorizontalAlignment.Right) {
                    return "end";
                }
                else {
                    return "start";
                }
            }
        }
        else {
            if (this.element.currentSignatureMode == "Type") {
                return "start";
            }
            else {
                if (this.element?.insertedText?.horizontalAlignment == StiHorizontalAlignment.Center) {
                    return "center";
                }
                else if (this.element?.insertedText?.horizontalAlignment == StiHorizontalAlignment.Right) {
                    return "end";
                }
                else {
                    return "start";
                }
            }
        }
    }
    getHorizontalAlignment() {
        if (this.isCurrentEditableSignature) {
            if (this.signatureService?.currentEditableImage?.horizontalAlignment == StiHorizontalAlignment.Center) {
                return "center";
            }
            else if (this.signatureService?.currentEditableImage?.horizontalAlignment == StiHorizontalAlignment.Left) {
                return "start";
            }
            else {
                return "end";
            }
        }
        else {
            if (this.element?.insertedImage?.horizontalAlignment == StiHorizontalAlignment.Center) {
                return "center";
            }
            else if (this.element?.insertedImage?.horizontalAlignment == StiHorizontalAlignment.Left) {
                return "start";
            }
            else {
                return "end";
            }
        }
    }
    getBackgroundSize(container) {
        if (this.isCurrentEditableSignature) {
            if (!this.signatureService?.currentEditableImage?.loadedImage) {
                return;
            }
            if (this.signatureService?.currentEditableImage?.aspectRatio &&
                this.signatureService?.currentEditableImage?.stretch) {
                return "contain";
            }
            if (this.signatureService?.currentEditableImage?.stretch) {
                return `${container.offsetWidth}px ${container.offsetHeight}px`;
            }
            else {
                return `${this.signatureService?.currentEditableImage?.naturalWidth}px ${this.signatureService?.currentEditableImage?.naturalHeight}px`;
            }
        }
        else {
            if (!this.element?.insertedImage?.loadedImage) {
                return;
            }
            if (this.element?.insertedImage?.aspectRatio && this.element?.insertedImage?.stretch) {
                return "contain";
            }
            if (this.element?.insertedImage?.stretch) {
                return `${container.offsetWidth}px ${container.offsetHeight}px`;
            }
            else {
                return `${this.element?.insertedImage?.naturalWidth}px ${this.element?.insertedImage?.naturalHeight}px`;
            }
        }
    }
    getCanvasSize(container) {
        return `${container.offsetWidth}px ${container.offsetHeight}px`;
    }
    getBackgroundPosition() {
        if (this.isCurrentEditableSignature) {
            if (this.signatureService?.currentEditableImage?.stretch &&
                !this.signatureService?.currentEditableImage?.aspectRatio) {
                return `center`;
            }
            else {
                return `${this.signatureService.getVerticalPosition(this.signatureService?.currentEditableImage?.verticalAlignment)} ${this.signatureService.getHorizontalPosition(this.signatureService?.currentEditableImage?.horizontalAlignment)}`;
            }
        }
        else {
            if (this.element?.insertedImage?.stretch && !this.element?.insertedImage?.aspectRatio) {
                return `center`;
            }
            else {
                return `${this.signatureService.getVerticalPosition(this.element?.insertedImage?.verticalAlignment)} ${this.signatureService.getHorizontalPosition(this.element?.insertedImage?.horizontalAlignment)}`;
            }
        }
    }
    get canvasHeight() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top) {
                return this.element.height - this.element.padding.top - this.element.padding.bottom;
            }
            else {
                return (this.element.height -
                    (this.labelRef?.offsetHeight ? this.labelRef?.offsetHeight : 0) -
                    this.element.padding.top -
                    this.element.padding.bottom -
                    (this.labelRef?.offsetHeight ? this.topMargin : 0));
            }
        }
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.buttonClickSubscribe?.unsubscribe();
        this.loadedImageSubscribe?.unsubscribe();
    }
    ngDoCheck() {
        this.labelRef = this.label ? this.label["elementRef"]["nativeElement"] : null;
    }
    isCanvasBlank(canvas) {
        const context = canvas.getContext("2d");
        const pixelBuffer = new Uint32Array(context.getImageData(0, 0, canvas.width, canvas.height).data.buffer);
        return !pixelBuffer.some((color) => color !== 0);
    }
    ngAfterViewInit() {
        if (!this.isClone) {
            this.element.element = this.sigPad;
            this.cdr.detectChanges();
            this.sigPadElement = this.sigPad?.nativeElement;
            if (this.element.backgroundImage && this.context) {
                // this.drawImage(this.element.backgroundImage);
            }
            setTimeout(() => {
                this.isInitialized = true;
            });
        }
    }
    ngOnInit() {
        this.resize.EndResizeSubj.subscribe(() => this.UpdateState());
        this.loadedImageSubscribe = this.signatureService.loadedImage.subscribe((any) => {
            if (this.element == this.model.selectedComponent?.element) {
                this.loadedImage = true;
                // this.drawImage(any);
            }
        });
    }
    UpdateState() {
        if (!this.isClone) {
            // this.drawImage(this.element.backgroundImage);
        }
    }
    relativeCoords(event) {
        const bounds = this.model.getPositionRelativeToForm(this.sigPad.nativeElement);
        const x = (event.clientX - bounds.left) / this.model.zoom;
        const y = (event.clientY - bounds.top) / this.model.zoom;
        return { x: x, y: y };
    }
    clear() {
        if (!this.isClone) {
            this.context.clearRect(0, 0, this.sigPadElement.width, this.sigPadElement.height);
            this.context.beginPath();
            this.element.backgroundImage = "";
        }
    }
}
StiSignatureComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSignatureComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.StiComponentResizerService }, { token: i4.StiLocalizationService }, { token: i5.SignatureService }, { token: i6.StiHelperService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
StiSignatureComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiSignatureComponent, selector: "sti-signature-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "sigPad", first: true, predicate: ["sigPad"], descendants: true }, { propertyName: "ref", first: true, predicate: ["ref"], descendants: true }, { propertyName: "label", first: true, predicate: ["label"], descendants: true }], ngImport: i0, template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    class="sti-signature"
    (dblclick)="!model.isPreviewMode ? showSignatureEditor() : ''"
    (click)="model.isPreviewMode ? showSignatureEditor() : ''"
  >
    <div class="component-container" #previewContainer>
      <div
        class="signature-image-container"
        *ngIf="isOldVersion() && !isCurrentEditableSignature"
        [style.justify-content]="getHorizontalAlignment()"
      >
        <div
          class="signature-image"
          [style.background-image]="oldBackgroundImage"
          [style.background-position]="'center'"
          [style.background-size]="'contain'"
          [style.background-repeat]="'no-repeat'"
        ></div>
      </div>
      <div class="inserted-image-container" [style.justify-content]="getHorizontalAlignment()">
        <div
          class="preview-inserted-image"
          *ngIf="isDrawingMode()"
          [style.width.px]="getImageWidth(previewContainer)"
          [style.height.px]="previewContainer.clientHeight"
          [style.background-image]="image"
          [style.background-position]="getBackgroundPosition()"
          [style.background-size]="getBackgroundSize(previewContainer)"
          [style.background-repeat]="image ? 'no-repeat' : ''"
        ></div>
        <div
          *ngIf="isDrawingMode()"
          class="preview-drawed-image"
          [style.background-size]="'contain'"
          [style.background-image]="drawedImage"
        ></div>
      </div>
      <div
        class="preview-inserted-text"
        [style]="
          isCurrentEditableSignature
            ? signatureService?.currentEditableText?.htmlStyle()
            : element?.insertedText?.htmlStyle()
        "
        [style.justify-content]="alignment"
      >
        <span>{{ getInsertedTextValue() }}</span>
      </div>
      <div class="signature-content">
        <div
          class="preview-inserted-type-text"
          [style.font-family]="isCurrentEditableSignature ? signatureService.currentPreviewFont : element.specialFont"
          [style.font-size]="'16pt'"
          [style.justify-content]="alignment"
        >
          <span>{{ getTypeTextValue() }}</span>
        </div>
      </div>
      <div class="signature-description" [style]="element?.description?.htmlStyle()">
        <sti-editable-content-component
          *ngIf="element?.description.value?.length > 0"
          [editableContent]="element.description"
        >
        </sti-editable-content-component>
      </div>
    </div>
  </sti-component>`, isInline: true, styles: ["@font-face{font-family:Teddy Bear;src:url(projects/stimulsoft-forms/src/lib/assets/TeddyBear.ttf) format(\"truetype\")}@font-face{font-family:Denistina;src:url(projects/stimulsoft-forms/src/lib/assets/Denistina.ttf) format(\"truetype\")}@font-face{font-family:MADE Likes Script;src:url(projects/stimulsoft-forms/src/lib/assets/MADELikesScript.otf) format(\"opentype\")}.signature-image,.preview-inserted-image{position:absolute;height:100%;width:100%}.preview-inserted-type-text{height:100%;width:100%;display:flex;align-items:flex-end;overflow:hidden;white-space:nowrap}.preview-inserted-text{position:absolute;width:100%;height:100%;display:flex;align-items:center;justify-content:center;overflow:hidden;white-space:nowrap}.signature-description{width:calc(100% - 10px);height:50px;margin:0 5px;padding:0 5px;border-top:1px solid lightgray;display:flex;align-items:center;overflow:hidden;z-index:100}.signature-content{z-index:9999;height:100%;width:100%}.preview-drawed-image{position:absolute;width:100%;height:100%;background-position:center;background-repeat:no-repeat;z-index:100}.signature-image-container{position:absolute;left:0;top:0;display:flex;height:100%;width:100%;z-index:999}.inserted-image-container{position:absolute;left:0;top:0;display:flex;height:100%;width:100%}.component-container{width:100%;height:100%;display:flex;flex-direction:column;position:relative}table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.canvas{position:relative;cursor:inherit}.text-preview:focus{outline:none}.text-preview{position:absolute;white-space:nowrap;display:flex;align-items:center;justify-content:center;text-align:center;width:100%;height:100%;overflow-x:hidden;z-index:100;font-size:28px;cursor:text}input{visibility:hidden;width:0px}\n"], dependencies: [{ kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i8.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i9.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSignatureComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-signature-component", template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    class="sti-signature"
    (dblclick)="!model.isPreviewMode ? showSignatureEditor() : ''"
    (click)="model.isPreviewMode ? showSignatureEditor() : ''"
  >
    <div class="component-container" #previewContainer>
      <div
        class="signature-image-container"
        *ngIf="isOldVersion() && !isCurrentEditableSignature"
        [style.justify-content]="getHorizontalAlignment()"
      >
        <div
          class="signature-image"
          [style.background-image]="oldBackgroundImage"
          [style.background-position]="'center'"
          [style.background-size]="'contain'"
          [style.background-repeat]="'no-repeat'"
        ></div>
      </div>
      <div class="inserted-image-container" [style.justify-content]="getHorizontalAlignment()">
        <div
          class="preview-inserted-image"
          *ngIf="isDrawingMode()"
          [style.width.px]="getImageWidth(previewContainer)"
          [style.height.px]="previewContainer.clientHeight"
          [style.background-image]="image"
          [style.background-position]="getBackgroundPosition()"
          [style.background-size]="getBackgroundSize(previewContainer)"
          [style.background-repeat]="image ? 'no-repeat' : ''"
        ></div>
        <div
          *ngIf="isDrawingMode()"
          class="preview-drawed-image"
          [style.background-size]="'contain'"
          [style.background-image]="drawedImage"
        ></div>
      </div>
      <div
        class="preview-inserted-text"
        [style]="
          isCurrentEditableSignature
            ? signatureService?.currentEditableText?.htmlStyle()
            : element?.insertedText?.htmlStyle()
        "
        [style.justify-content]="alignment"
      >
        <span>{{ getInsertedTextValue() }}</span>
      </div>
      <div class="signature-content">
        <div
          class="preview-inserted-type-text"
          [style.font-family]="isCurrentEditableSignature ? signatureService.currentPreviewFont : element.specialFont"
          [style.font-size]="'16pt'"
          [style.justify-content]="alignment"
        >
          <span>{{ getTypeTextValue() }}</span>
        </div>
      </div>
      <div class="signature-description" [style]="element?.description?.htmlStyle()">
        <sti-editable-content-component
          *ngIf="element?.description.value?.length > 0"
          [editableContent]="element.description"
        >
        </sti-editable-content-component>
      </div>
    </div>
  </sti-component>`, styles: ["@font-face{font-family:Teddy Bear;src:url(projects/stimulsoft-forms/src/lib/assets/TeddyBear.ttf) format(\"truetype\")}@font-face{font-family:Denistina;src:url(projects/stimulsoft-forms/src/lib/assets/Denistina.ttf) format(\"truetype\")}@font-face{font-family:MADE Likes Script;src:url(projects/stimulsoft-forms/src/lib/assets/MADELikesScript.otf) format(\"opentype\")}.signature-image,.preview-inserted-image{position:absolute;height:100%;width:100%}.preview-inserted-type-text{height:100%;width:100%;display:flex;align-items:flex-end;overflow:hidden;white-space:nowrap}.preview-inserted-text{position:absolute;width:100%;height:100%;display:flex;align-items:center;justify-content:center;overflow:hidden;white-space:nowrap}.signature-description{width:calc(100% - 10px);height:50px;margin:0 5px;padding:0 5px;border-top:1px solid lightgray;display:flex;align-items:center;overflow:hidden;z-index:100}.signature-content{z-index:9999;height:100%;width:100%}.preview-drawed-image{position:absolute;width:100%;height:100%;background-position:center;background-repeat:no-repeat;z-index:100}.signature-image-container{position:absolute;left:0;top:0;display:flex;height:100%;width:100%;z-index:999}.inserted-image-container{position:absolute;left:0;top:0;display:flex;height:100%;width:100%}.component-container{width:100%;height:100%;display:flex;flex-direction:column;position:relative}table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.canvas{position:relative;cursor:inherit}.text-preview:focus{outline:none}.text-preview{position:absolute;white-space:nowrap;display:flex;align-items:center;justify-content:center;text-align:center;width:100%;height:100%;overflow-x:hidden;z-index:100;font-size:28px;cursor:text}input{visibility:hidden;width:0px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.StiComponentResizerService }, { type: i4.StiLocalizationService }, { type: i5.SignatureService }, { type: i6.StiHelperService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }], sigPad: [{
                type: ViewChild,
                args: ["sigPad"]
            }], ref: [{
                type: ViewChild,
                args: ["ref"]
            }], label: [{
                type: ViewChild,
                args: ["label"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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