import { Component, ContentChild, EventEmitter, Input, Output, TemplateRef } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
export class StiSelectButtonComponent {
    constructor() {
        this.onOptionClick = new EventEmitter();
        this.onChange = new EventEmitter();
        this.valueChange = new EventEmitter();
    }
    getOptionLabel(option) {
        return option[this.optionLabel];
    }
    isSelected(option) {
        let optionValue = this.getOptionValue(option);
        if (this.multiple) {
            if (this.value && this.value?.indexOf(optionValue) != -1) {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return optionValue === this.value;
        }
    }
    getOptionValue(option) {
        return option.value ? option.value : option;
    }
    removeOption(option) {
        let optionValue = this.getOptionValue(option);
        this.value = this.value.filter((item) => item != optionValue);
    }
    selectOption(event, option, index) {
        if (this.disabled) {
            return;
        }
        let optionValue = this.getOptionValue(option);
        if (this.multiple) {
            if (this.isSelected(option))
                this.removeOption(option);
            else
                this.value = [...(this.value || []), optionValue];
            this.onChange.emit({
                originalEvent: event,
                value: this.value,
            });
            this.valueChange.emit(this.value);
        }
        else if (this.value !== optionValue) {
            this.value = optionValue;
            this.onChange.emit({
                originalEvent: event,
                value: this.value,
            });
            this.valueChange.emit(this.value);
        }
        this.onOptionClick.emit({
            originalEvent: event,
            option: option,
            index: index,
        });
    }
    ngOnInit() { }
}
StiSelectButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSelectButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
StiSelectButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiSelectButtonComponent, selector: "sti-selectButton", inputs: { options: "options", value: "value", optionLabel: "optionLabel", optionValue: "optionValue", multiple: "multiple", disabled: "disabled" }, outputs: { onOptionClick: "onOptionClick", onChange: "onChange", valueChange: "valueChange" }, queries: [{ propertyName: "itemTemplate", first: true, predicate: TemplateRef, descendants: true }], ngImport: i0, template: ` <div class="button-container {{ disabled ? 'disabled' : '' }}">
    <div
      #button
      class="button {{ isSelected(option) ? 'selected' : '' }} {{ i == 0 ? 'left' : '' }} {{
        i == options.length - 1 ? 'right' : ''
      }}"
      [style.border-right-width.px]="i == options.length - 1 ? 1 : 0"
      *ngFor="let option of options; let i = index"
      (click)="selectOption($event, option, i)"
    >
      <ng-container *ngIf="!itemTemplate; else customcontent">
        <span class="label">{{ getOptionLabel(option) }}</span>
      </ng-container>
      <ng-template #customcontent>
        <ng-container *ngTemplateOutlet="itemTemplate; context: { $implicit: option, index: i }"></ng-container>
      </ng-template>
    </div>
  </div>`, isInline: true, styles: [".disabled{pointer-events:none;opacity:.5}.button{background-color:var(--back-color);border:1px solid var(--back-color);color:var(--text-color);padding:3px 6px;width:auto;height:inherit;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:14px;font-weight:400;display:flex;align-items:center;justify-content:center}.button:hover{background-color:var(--active-color);border-color:var(--active-color);cursor:pointer}.selected{background-color:var(--active-color);border-color:var(--active-color)}.button-container{display:flex;width:100%;height:inherit}.left{border-top-left-radius:3px;border-bottom-left-radius:3px}.right{border-top-right-radius:3px;border-bottom-right-radius:3px}\n"], dependencies: [{ kind: "directive", type: i1.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i1.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSelectButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-selectButton", template: ` <div class="button-container {{ disabled ? 'disabled' : '' }}">
    <div
      #button
      class="button {{ isSelected(option) ? 'selected' : '' }} {{ i == 0 ? 'left' : '' }} {{
        i == options.length - 1 ? 'right' : ''
      }}"
      [style.border-right-width.px]="i == options.length - 1 ? 1 : 0"
      *ngFor="let option of options; let i = index"
      (click)="selectOption($event, option, i)"
    >
      <ng-container *ngIf="!itemTemplate; else customcontent">
        <span class="label">{{ getOptionLabel(option) }}</span>
      </ng-container>
      <ng-template #customcontent>
        <ng-container *ngTemplateOutlet="itemTemplate; context: { $implicit: option, index: i }"></ng-container>
      </ng-template>
    </div>
  </div>`, styles: [".disabled{pointer-events:none;opacity:.5}.button{background-color:var(--back-color);border:1px solid var(--back-color);color:var(--text-color);padding:3px 6px;width:auto;height:inherit;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:14px;font-weight:400;display:flex;align-items:center;justify-content:center}.button:hover{background-color:var(--active-color);border-color:var(--active-color);cursor:pointer}.selected{background-color:var(--active-color);border-color:var(--active-color)}.button-container{display:flex;width:100%;height:inherit}.left{border-top-left-radius:3px;border-bottom-left-radius:3px}.right{border-top-right-radius:3px;border-bottom-right-radius:3px}\n"] }]
        }], ctorParameters: function () { return []; }, propDecorators: { options: [{
                type: Input
            }], value: [{
                type: Input
            }], optionLabel: [{
                type: Input
            }], optionValue: [{
                type: Input
            }], multiple: [{
                type: Input
            }], disabled: [{
                type: Input
            }], onOptionClick: [{
                type: Output
            }], onChange: [{
                type: Output
            }], valueChange: [{
                type: Output
            }], itemTemplate: [{
                type: ContentChild,
                args: [TemplateRef]
            }] } });
//# sourceMappingURL=data:application/json;base64,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