import { Component, Input, ViewChild, } from "@angular/core";
import { StiLabelAlignment } from "../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/mouse.service";
import * as i3 from "../../services/sti-component-resizer.service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "../../services/sti-signature.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-component";
import * as i8 from "../sti-editable-content.component";
export class StiPDFSignatureComponent {
    constructor(model, mouse, resize, loc, signatureService, cdr) {
        this.model = model;
        this.mouse = mouse;
        this.resize = resize;
        this.loc = loc;
        this.signatureService = signatureService;
        this.cdr = cdr;
        this.isClone = false;
        this.topMargin = 8;
    }
    get align() {
        return "start";
    }
    get cursor() {
        return this.signatureService.drawingMode
            ? `url(${this.model.getImage("signature.Brush.png")}) 8 ${16 * window.devicePixelRatio - 4 * window.devicePixelRatio}, auto`
            : "";
    }
    get canvasWidth() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top && this.element["label"]["value"]) {
                return (this.element.width - this.element.label.width - this.element.padding.right - this.element.padding.left - 2);
            }
            else {
                return this.element.width - this.element.padding.right - this.element.padding.left;
            }
        }
    }
    get canvasHeight() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top) {
                return this.element.height - this.element.padding.top - this.element.padding.bottom;
            }
            else {
                return (this.element.height -
                    (this.labelRef?.offsetHeight ? this.labelRef?.offsetHeight : 0) -
                    this.element.padding.top -
                    this.element.padding.bottom -
                    (this.labelRef?.offsetHeight ? this.topMargin : 0));
            }
        }
    }
    ngAfterContentChecked() { }
    ngOnDestroy() { }
    ngDoCheck() {
        this.labelRef = this.label ? this.label["elementRef"]["nativeElement"] : null;
    }
    ngAfterViewInit() {
        if (!this.isClone) {
            this.element.element = this.sigPad;
            this.cdr.detectChanges();
        }
    }
    onMouseDown(event) { }
    ngOnInit() { }
}
StiPDFSignatureComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPDFSignatureComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.StiComponentResizerService }, { token: i4.StiLocalizationService }, { token: i5.SignatureService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
StiPDFSignatureComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiPDFSignatureComponent, selector: "sti-pdf-signature-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "sigPad", first: true, predicate: ["sigPad"], descendants: true }, { propertyName: "text", first: true, predicate: ["textPreview"], descendants: true }, { propertyName: "ref", first: true, predicate: ["ref"], descendants: true }, { propertyName: "label", first: true, predicate: ["label"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-signature">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
      #label
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div [style.align-self]="align" [style.position]="'relative'" [style.display]="'flex'">
            <div
              class="canvas"
              [style.width.px]="canvasWidth"
              [style.height.px]="canvasHeight"
              [style.cursor]="cursor"
            ></div>
            <div
              class="digital-signature"
              [style.width.px]="canvasWidth"
              [style.height.px]="canvasHeight"
              [style.border]="model.isPreviewMode ? '' : '1px dashed lightgray'"
              [style.background-color]="element?.placeholderBackColor.toHtmlColor()"
              [style.position]="'absolute'"
              [style.left]="0"
              [style.top]="0"
              #sigPad
            >
              <h2>{{ element.placeholder }}</h2>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td>
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.canvas{position:relative;cursor:inherit}.digital-signature{background-color:#d3d3d3;text-align:center;display:flex;align-items:center;justify-content:center;overflow:hidden}.digital-signature h2{color:red;margin:0;font-size:8px}input{visibility:hidden;width:0px}\n"], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i8.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPDFSignatureComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-pdf-signature-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-signature">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
      #label
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div [style.align-self]="align" [style.position]="'relative'" [style.display]="'flex'">
            <div
              class="canvas"
              [style.width.px]="canvasWidth"
              [style.height.px]="canvasHeight"
              [style.cursor]="cursor"
            ></div>
            <div
              class="digital-signature"
              [style.width.px]="canvasWidth"
              [style.height.px]="canvasHeight"
              [style.border]="model.isPreviewMode ? '' : '1px dashed lightgray'"
              [style.background-color]="element?.placeholderBackColor.toHtmlColor()"
              [style.position]="'absolute'"
              [style.left]="0"
              [style.top]="0"
              #sigPad
            >
              <h2>{{ element.placeholder }}</h2>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td>
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.canvas{position:relative;cursor:inherit}.digital-signature{background-color:#d3d3d3;text-align:center;display:flex;align-items:center;justify-content:center;overflow:hidden}.digital-signature h2{color:red;margin:0;font-size:8px}input{visibility:hidden;width:0px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.StiComponentResizerService }, { type: i4.StiLocalizationService }, { type: i5.SignatureService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }], sigPad: [{
                type: ViewChild,
                args: ["sigPad"]
            }], text: [{
                type: ViewChild,
                args: ["textPreview"]
            }], ref: [{
                type: ViewChild,
                args: ["ref"]
            }], label: [{
                type: ViewChild,
                args: ["label"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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