import { Component, Input } from "@angular/core";
import { StiNumberBoxElement } from "../elements/StiNumberBoxElement";
import { StiInputTextItem } from "../helper/StiInputTextItem";
import { StiDisplayCurrencyAs, StiNumberType, StiUnitAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-helper.service";
import * as i3 from "../services/sti-editable-content.service";
import * as i4 from "../services/mouse.service";
import * as i5 from "@angular/common";
import * as i6 from "./sti-tooltip/sti-tooltip.directive";
export class StiNumberComponent {
    constructor(model, helper, editableService, mouseService) {
        this.model = model;
        this.helper = helper;
        this.editableService = editableService;
        this.mouseService = mouseService;
        this.buttonDown = 0;
        this.mouseOver = false;
        this.focused = false;
    }
    get isNumberBox() {
        return this.element instanceof StiNumberBoxElement;
    }
    get needToFill() {
        return this.element["required"] && !this.element["value"] && this.model.hasEmptyReuiredFields;
    }
    get disabled() {
        return (this.element.type == "Number_BoxElement" && this.element.readOnly) ||
            (this.element.type != "Number_BoxElement" && this.element.eParent?.readOnly)
            ? true
            : false;
    }
    get tabIndex() {
        try {
            let columns = this.table?.columns;
            return columns
                ? this.table["tabIndex"] + columns.indexOf(this.element) + columns.length * this.index
                : this.element["tabIndex"];
        }
        catch { }
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
    }
    clear() {
        setTimeout(() => {
            this.buttonDown = 0;
        }, 0);
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getCaptureMouseUp().subscribe(() => {
            this.buttonDown = 0;
        });
    }
    onFocus(event) {
        this.focused = true;
        setTimeout(() => {
            let editableContent;
            if (this.element.type == "Number_BoxElement") {
                let nbe = this.element;
                editableContent = new StiInputTextItem(this.elementValue?.toString(), nbe.font, nbe.textColor, nbe.backgroundColor, nbe.contentAlignment);
            }
            else {
                let nbce = this.element;
                editableContent = new StiInputTextItem(this.elementValue?.toString(), this.table.font, nbce.cellForeColor, nbce.cellBackColor, nbce.cellAlignment);
            }
            editableContent.element = this.element;
            this.editableService.editableContent = editableContent;
            this.editableService.usedElement = this.element;
        }, 0);
        event.currentTarget.value = this.elementValue?.toString();
    }
    get elementBorderColor() {
        return this.element.type == "Number_BoxElement"
            ? this.element.borderColor
            : this.element.cellBorderColor;
    }
    get readonly() {
        return this.element.type == "Number_BoxElement"
            ? this.element.readOnly
            : this.element.eParent?.readOnly;
    }
    get cellBackgroundColor() {
        return this.element.type == "Number_BoxElement"
            ? this.element.backgroundColor
            : this.element.cellBackColor;
    }
    get elementTextColor() {
        return this.element.type == "Number_BoxElement"
            ? this.element.textColor
            : this.element.cellForeColor;
    }
    get elementHtmlStyle() {
        return this.element.type == "Number_BoxElement"
            ? this.element.htmlStyle()
            : this.element.htmlStyle();
    }
    get elementValue() {
        return this.element.type == "Number_BoxElement"
            ? this.element.value
            : this.element.cells[this.index].value;
    }
    set elementValue(value) {
        if (this.element.type == "Number_BoxElement") {
            this.element.value = value;
            if (this.element.useRange) {
                this.model.checkNumberRange(this.element);
            }
        }
        else {
            this.element.cells[this.index].value = value;
        }
    }
    onLostFocus(event) {
        if (this.model.selectedComponent?.element != this.element) {
            this.editableService.editableContent = null;
        }
        this.editableService.usedElement = this.element;
        let value = 0;
        try {
            value = parseFloat(event.currentTarget.value);
        }
        catch { }
        this.focused = false;
        this.elementValue = !isNaN(value) ? value : 0;
        event.currentTarget.value = this.value;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    setIncDec(value) {
        if (!this.readonly) {
            if (this.incTimeout) {
                clearTimeout(this.incTimeout);
                this.incTimeout = null;
            }
            setTimeout(() => {
                this.elementValue += value;
                this.buttonDown = value;
                this.incDecTimer();
                this.model.formEvents.next({ name: "ValueChanged" });
            }, 0);
        }
    }
    incDecTimer(first = true) {
        let this_ = this;
        this.incTimeout = setTimeout(() => {
            if (this_.buttonDown != 0) {
                this_.elementValue += this_.buttonDown;
                this_.incDecTimer(false);
                this.model.formEvents.next({ name: "ValueChanged" });
            }
        }, first ? 400 : 50);
    }
    get isCurrency() {
        return this.element?.numberType == StiNumberType.Currency ? true : false;
    }
    getCurrency(currency) {
        if (this.isCurrency) {
            let value = this.helper.currencyInfo.find((item) => item.code == currency);
            if (this.element.currencyLabelFormat == StiDisplayCurrencyAs.Symbol) {
                return value.symbol;
            }
            else {
                return value.code;
            }
        }
    }
    get value() {
        let unit = this.element.numberType == StiNumberType.Decimal
            ? this.element.unitLabel
            : this.getCurrency(this.element.currency);
        return this.focused
            ? this.elementValue?.toString()
            : this.model.formatNumber(this.elementValue, this.element.thousandSeparator, this.element.decimalDigits, this.element.unitAlignment, unit);
    }
    get isPrefix() {
        return this.element.unitAlignment == StiUnitAlignment.Prefix;
    }
    get isSuffix() {
        return this.element.unitAlignment == StiUnitAlignment.Suffix;
    }
    borderWidth() {
        return `${this.element["borderWeight"]}px`;
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
}
StiNumberComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiNumberComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiEditableContentService }, { token: i4.StiMouseService }], target: i0.ɵɵFactoryTarget.Component });
StiNumberComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiNumberComponent, selector: "sti-number-component", inputs: { element: "element", index: "index", table: "table" }, ngImport: i0, template: `
    <div class="number-component" [style.align-self]="'start'" [style.flexDirection]="isPrefix ? 'row' : 'row-reverse'">
      <div
        class="unit"
        *ngIf="(element.unitLabel && !isCurrency && (isPrefix || isSuffix)) || (isCurrency && (isPrefix || isSuffix))"
      >
        <span [style]="element?.htmlStyle()" [style.color]="element.unitForeground?.toHtmlColor()">{{
          isCurrency ? getCurrency(element.currency) : element.unitLabel
        }}</span>
      </div>

      <div
        class="number-box"
        [stiTooltip]="element['tooltip']"
        tooltipPosition="bottom"
        showDelay="500"
        [style.border-width]="borderWidth()"
        [style.border-color]="needToFill ? 'red' : elementBorderColor.toHtmlColor()"
        [style.background-color]="element['backgroundColor'].toHtmlColor()"
        (mouseover)="mouseOver = true"
        (mouseleave)="mouseOver = false"
      >
        <input
          type="text"
          (focus)="onFocus($event)"
          (blur)="onLostFocus($event)"
          [value]="value"
          [required]="element['required']"
          [style.border-width]="borderWidth()"
          [readonly]="readonly"
          [tabIndex]="tabIndex"
          [style]="elementHtmlStyle"
          [style.color]="elementTextColor.toHtmlColor()"
          [style.background-color]="cellBackgroundColor.toHtmlColor()"
          [style.pointer-events]="disabled ? 'none' : ''"
          (mousedown)="disableDrag($event)"
          (mouseup)="this.model.canDrag = true"
        />
        <div
          class="buttons"
          [style.width.px]="isNumberBox ? 28 : 20"
          *ngIf="((focused || mouseOver) && !disabled) || isNumberBox"
        >
          <div class="button-up" (mousedown)="setIncDec(1)" (mouseup)="clear()">
            <i class="pi pi-angle-up"></i>
          </div>
          <div class="button-down" (mousedown)="setIncDec(-1)" (mouseup)="clear()">
            <i class="pi pi-angle-down"></i>
          </div>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".number-component{display:flex;width:100%}.unit{align-self:center;padding-left:1px;padding-right:1px}.number-box{width:100%;height:auto;border:1px solid rgb(171,170,169);background-color:#fff;position:relative;display:flex}.number-box:hover{border-color:#a3bde3!important}input{outline:none;border:0px;width:100%;height:auto;padding:3px 5px}.buttons{width:20px;height:100%;align-self:flex-end;display:flex;flex-direction:column;color:#bab9b8}.button-up{width:100%;height:50%;display:flex;justify-content:center}.button-up i{margin-top:.4px}.button-up:hover{cursor:default;background-color:#d5e1f2}.button-up:active{background-color:#a3bde3}.button-down{width:100%;height:50%;display:flex;align-items:center;justify-content:center}.button-down i{margin-bottom:2px}.button-down:hover{cursor:default;background-color:#d5e1f2}.button-down:active{background-color:#a3bde3}i{margin:0;height:8px}\n"], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiNumberComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-number-component", template: `
    <div class="number-component" [style.align-self]="'start'" [style.flexDirection]="isPrefix ? 'row' : 'row-reverse'">
      <div
        class="unit"
        *ngIf="(element.unitLabel && !isCurrency && (isPrefix || isSuffix)) || (isCurrency && (isPrefix || isSuffix))"
      >
        <span [style]="element?.htmlStyle()" [style.color]="element.unitForeground?.toHtmlColor()">{{
          isCurrency ? getCurrency(element.currency) : element.unitLabel
        }}</span>
      </div>

      <div
        class="number-box"
        [stiTooltip]="element['tooltip']"
        tooltipPosition="bottom"
        showDelay="500"
        [style.border-width]="borderWidth()"
        [style.border-color]="needToFill ? 'red' : elementBorderColor.toHtmlColor()"
        [style.background-color]="element['backgroundColor'].toHtmlColor()"
        (mouseover)="mouseOver = true"
        (mouseleave)="mouseOver = false"
      >
        <input
          type="text"
          (focus)="onFocus($event)"
          (blur)="onLostFocus($event)"
          [value]="value"
          [required]="element['required']"
          [style.border-width]="borderWidth()"
          [readonly]="readonly"
          [tabIndex]="tabIndex"
          [style]="elementHtmlStyle"
          [style.color]="elementTextColor.toHtmlColor()"
          [style.background-color]="cellBackgroundColor.toHtmlColor()"
          [style.pointer-events]="disabled ? 'none' : ''"
          (mousedown)="disableDrag($event)"
          (mouseup)="this.model.canDrag = true"
        />
        <div
          class="buttons"
          [style.width.px]="isNumberBox ? 28 : 20"
          *ngIf="((focused || mouseOver) && !disabled) || isNumberBox"
        >
          <div class="button-up" (mousedown)="setIncDec(1)" (mouseup)="clear()">
            <i class="pi pi-angle-up"></i>
          </div>
          <div class="button-down" (mousedown)="setIncDec(-1)" (mouseup)="clear()">
            <i class="pi pi-angle-down"></i>
          </div>
        </div>
      </div>
    </div>
  `, styles: [".number-component{display:flex;width:100%}.unit{align-self:center;padding-left:1px;padding-right:1px}.number-box{width:100%;height:auto;border:1px solid rgb(171,170,169);background-color:#fff;position:relative;display:flex}.number-box:hover{border-color:#a3bde3!important}input{outline:none;border:0px;width:100%;height:auto;padding:3px 5px}.buttons{width:20px;height:100%;align-self:flex-end;display:flex;flex-direction:column;color:#bab9b8}.button-up{width:100%;height:50%;display:flex;justify-content:center}.button-up i{margin-top:.4px}.button-up:hover{cursor:default;background-color:#d5e1f2}.button-up:active{background-color:#a3bde3}.button-down{width:100%;height:50%;display:flex;align-items:center;justify-content:center}.button-down i{margin-bottom:2px}.button-down:hover{cursor:default;background-color:#d5e1f2}.button-down:active{background-color:#a3bde3}i{margin:0;height:8px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiEditableContentService }, { type: i4.StiMouseService }]; }, propDecorators: { element: [{
                type: Input
            }], index: [{
                type: Input
            }], table: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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