import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../svg.components/svg.checkbox.component";
export class StiMultipleSelectionComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    get columns() {
        return (this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) >
            this.element.columns
            ? new Array(Number(this.element.columns)).fill(3)
            : new Array(this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length).fill(1);
    }
    get rows() {
        return this.element.useCustomOption
            ? new Array(Math.ceil((this.element.options.length + 1) / Number(this.element.columns))).fill(2)
            : new Array(Math.ceil(this.element.options.length / Number(this.element.columns))).fill(2);
    }
    getColumns(rowIndex) {
        if ((this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) -
            Number(this.element.columns) * rowIndex >=
            Number(this.element.columns)) {
            return new Array(Number(this.element.columns)).fill(3);
        }
        else {
            let count = (this.element.useCustomOption ? this.element.options.length + 1 : this.element.options.length) -
                Number(this.element.columns) * rowIndex;
            return new Array(Number(count)).fill(3);
        }
    }
    get align() {
        return "start";
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    changeState(option) {
        if (this.element.selectedOptions.indexOf(option) >= 0) {
            this.element.selectedOptions.splice(this.element.selectedOptions.indexOf(option), 1);
        }
        else {
            this.element.selectedOptions.push(option);
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    ngOnInit() { }
}
StiMultipleSelectionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMultipleSelectionComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiMultipleSelectionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiMultipleSelectionComponent, selector: "sti-multipleselection-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-multiple-selection">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="table-container" [style.maxWidth.px]="element.maxWidth + 0.1">
            <table>
              <tr *ngFor="let row of rows; let i = index">
                <td
                  *ngFor="let column of getColumns(i); let idx = index"
                  [colSpan]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length
                      ? element.columns - idx + 1
                      : 0
                  "
                  [style.width]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length ? '100%' : ''
                  "
                  [style.padding-top.px]="(element?.useCustomOption && i == rows.length - 1) || i == 0 ? 0 : 3"
                  [style.padding-bottom.px]="
                    (element?.useCustomOption && i == rows.length - 1) || i == rows.length - 1 ? 0 : 3
                  "
                >
                  <sti-svg-checkbox-component
                    *ngIf="element?.options[i * element.columns + idx] != null"
                    [element]="element"
                    [id]="element?.options[i * element.columns + idx] + i + element?.name"
                    [text]="element.optionsContentEditable[i * element.columns + idx]"
                    [state]="element.selectedOptions.indexOf(element?.options[i * element.columns + idx]) >= 0"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    (buttonClick)="changeState(element?.options[i * element.columns + idx])"
                  ></sti-svg-checkbox-component>
                  <sti-svg-checkbox-component
                    *ngIf="element?.useCustomOption && i * element.columns + idx == element.options.length"
                    [element]="element"
                    [useCustomOption]="element?.useCustomOption"
                    [id]="'MultipleSelectionCustomOption'"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [text]="element?.customOptionText"
                    [state]="element.selectedOptions.indexOf(element?.customOptionText) >= 0"
                    (buttonClick)="changeState(element?.customOptionText)"
                    [style.width]="'100%'"
                  ></sti-svg-checkbox-component>
                </td>
                <td [style.width]="'100%'" *ngIf="i != rows.length - 1 || (i == 0 && !element.useCustomOption)"></td>
              </tr>
            </table>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: [".table-container{overflow:hidden}table{width:100%;border-spacing:0;overflow:hidden}ul{width:100%;margin:0;padding:0;list-style:none;column-width:auto;column-gap:10px}li{margin-top:5px}tr{max-width:inherit;height:max-content;padding:0;margin:0}td{max-width:inherit;height:100%;padding:0;margin:0}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i5.StiSvgCheckBoxComponent, selector: "sti-svg-checkbox-component", inputs: ["element", "id", "text", "state", "useCustomOption", "disablePlaceHolder", "tabIndex"], outputs: ["buttonClick"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMultipleSelectionComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-multipleselection-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-multiple-selection">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="table-container" [style.maxWidth.px]="element.maxWidth + 0.1">
            <table>
              <tr *ngFor="let row of rows; let i = index">
                <td
                  *ngFor="let column of getColumns(i); let idx = index"
                  [colSpan]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length
                      ? element.columns - idx + 1
                      : 0
                  "
                  [style.width]="
                    element?.useCustomOption && i * element.columns + idx == element.options.length ? '100%' : ''
                  "
                  [style.padding-top.px]="(element?.useCustomOption && i == rows.length - 1) || i == 0 ? 0 : 3"
                  [style.padding-bottom.px]="
                    (element?.useCustomOption && i == rows.length - 1) || i == rows.length - 1 ? 0 : 3
                  "
                >
                  <sti-svg-checkbox-component
                    *ngIf="element?.options[i * element.columns + idx] != null"
                    [element]="element"
                    [id]="element?.options[i * element.columns + idx] + i + element?.name"
                    [text]="element.optionsContentEditable[i * element.columns + idx]"
                    [state]="element.selectedOptions.indexOf(element?.options[i * element.columns + idx]) >= 0"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    (buttonClick)="changeState(element?.options[i * element.columns + idx])"
                  ></sti-svg-checkbox-component>
                  <sti-svg-checkbox-component
                    *ngIf="element?.useCustomOption && i * element.columns + idx == element.options.length"
                    [element]="element"
                    [useCustomOption]="element?.useCustomOption"
                    [id]="'MultipleSelectionCustomOption'"
                    [tabIndex]="i == 0 && idx == 0 ? element['tabIndex'] : null"
                    [text]="element?.customOptionText"
                    [state]="element.selectedOptions.indexOf(element?.customOptionText) >= 0"
                    (buttonClick)="changeState(element?.customOptionText)"
                    [style.width]="'100%'"
                  ></sti-svg-checkbox-component>
                </td>
                <td [style.width]="'100%'" *ngIf="i != rows.length - 1 || (i == 0 && !element.useCustomOption)"></td>
              </tr>
            </table>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: [".table-container{overflow:hidden}table{width:100%;border-spacing:0;overflow:hidden}ul{width:100%;margin:0;padding:0;list-style:none;column-width:auto;column-gap:10px}li{margin-top:5px}tr{max-width:inherit;height:max-content;padding:0;margin:0}td{max-width:inherit;height:100%;padding:0;margin:0}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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