import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
export class StiLoginComponent {
    constructor() {
        this.onLogin = new EventEmitter();
    }
    ngOnInit() { }
    get window() {
        return window;
    }
    doLogin() {
        if (this.login?.length > 0 && this.password?.length > 0) {
            this.onLogin.emit({ login: this.login, password: this.password });
        }
    }
    keydown(event) {
        if (event.key === 'Enter') {
            this.doLogin();
        }
    }
}
StiLoginComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLoginComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
StiLoginComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiLoginComponent, selector: "sti-login", inputs: { loginInfo: "loginInfo" }, outputs: { onLogin: "onLogin" }, ngImport: i0, template: `
  <div id="cd334261b95f4a98802f0b2b478f726e" class="stiJsViewerForm"
	style="z-index: 21; width: 380px; background-color: white; left: 0px; opacity: 1;"
  [style.left.px]="window.innerWidth / 2 - 140"
  [style.top.px]="window.innerHeight / 2 - 200">
	<div class="stiJsViewerAuthFormHeader" style="position: relative;">
		<table class="stiJsViewerClearAllStyles" cellpadding="0"
			cellspacing="0" style="width: 100%;">
			<tbody>
				<tr class="stiJsViewerClearAllStyles">
					<td class="stiJsViewerAuthFormCaption"
						style="text-align: left; padding: 45px 133px 45px 33px;">{{loginInfo.AuthorizationWindowTitleLogin.toUpperCase()}}</td>
					<td class="stiJsViewerClearAllStyles"
						style="vertical-align: top; width: 30px; text-align: right; padding: 2px 2px 1px 1px;"><div
							class="stiJsViewerStandartSmallButton stiJsViewerStandartSmallButtonDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; display: none;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="line-height: 0; text-align: center; padding: 0px 4px;"><img
											src="data:image/png;base64,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"
											style="width: 16px; height: 16px; margin: 0px 2px;"></td>
									</tr>
								</tbody>
							</table>
						</div></td>
				</tr>
			</tbody>
		</table>
		<img
			src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAK4AAAAqCAYAAAAqLWAgAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTM4IDc5LjE1OTgyNCwgMjAxNi8wOS8xNC0wMTowOTowMSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDplNzEwYmIyZC01NmUyLTc2NDItOGUyMi01YmE3MjYwOWZiZTMiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RjY0N0Q0REE5RTA2MTFFN0EwMEY4MTlBNDU0RjlFNjMiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RjY0N0Q0RDk5RTA2MTFFN0EwMEY4MTlBNDU0RjlFNjMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTcgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6NTYxZDc3OWMtYjFkYS00NDQyLTgxZWYtMzU2ZDQ0Nzk0N2IyIiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmU3MTBiYjJkLTU2ZTItNzY0Mi04ZTIyLTViYTcyNjA5ZmJlMyIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PvXpS+8AAAedSURBVHja7Fxdrqs2ECbV2UC2wF1CIrVS+1ZYAmcJyXv7AOrtY28FD+17WEKyhNC3VmqlsISTLbCE0xnumE4cG8xfYm49EuIcMI7t+Tz+Zhi8en9/97j88dc/GzjFcETevZzgyL//9utCXFitVvW5+PNvfCb1+ksYfPdNwS9AXe+6e4oyOZTZm/4YPHeA0w7/hudWivsBnM66+5o6sXygay8bmwLuh95AgXo6daMbL0VdEdW1kW6VcCQm9fTU+U3fx+AF8feVBFpU6IUNDHYCO1DR/3j9DOVSzx7ZwSD4hsryBWiXJtB2I91AudRw8h4ZaK90eHTtTGWslRcG2jWbATnOOkB2xe77NDipYpaidcrglLVYo4TKzCHYpleDcoeFgvZONzCWlTQhtbqR6joy8CdkpStFPWgQPMPVrPdKIvCiWPEbvAD+sk7gkiXCAbrCA3eNhWs4IzOouLBQtxEu8W3LG1GAwFumNLpRAQmu1bqBPhYGS3tEVhppTampp6JJjuAt4Xpu24BwquAzrqQVAHCJh00Gic5xR7lYKr8kMdINAlEGo2S1xRhkunJUT07W2BvIQx8K3LU0SEuRnCxIQFa1zdpWVH5pMoVuuNXupGxUBi3wmvi1tcAVMzACOhAtSKkV49Zxh7XNmDOzJCkZJRqqm4BNdFM5Sc9aCdycKfUI4L3AEVN4bElWN1J44wFZjyVa2zvdQJ8uyFcpPNYXuOWACWMdBl4Yd60ApCFxmoAauyFPryJuWEA565SPXjEoMSGHIpW4IOd1WG5xqKV2K3VDjlRBnr2JbvqsOJUhRQlYXF0loWl8eYjFFY4XDlBIy+qVcSy0ZAcA8ZuNVpiUhu31BSejs0+8bqnWljterbqB/r71tMKLlRdN5KCgWZyw+G1Esxz/x5cQWwqR2SQZWd2YllfObU1lSJ+CBwK40Q2Lu97oBq5vKbTV5uj1cQq7xmTUG8HRFlcDYozrZnBs4d8961BsoVXiVvdMiuwVh+QKN7FeFGYaA/ox/a0jBHCY6KYYMMk2A3ixHcCVQJwzB8fWsNleUlAywos3UbIoU7VYuUdN2jbdCOAaRSVoQu6kZ+0DLr3ynWspfaQCCzbQxUCnQDxjEr/cSaGjyUWy6kN1IyITPr1BM+nX2lb/gFtcDIEdDAAcDPBOn8F1i57cVlay16VkFmqbFbje5xDYwQDAWt1QPoIYj7TtpQLdS0esWI9xzsgBE53GFxC14vmrXSoTe8MC2c+0uoO4I4XXUlIycr1EUAEpGaWeKFOHexiIbnQD/2e0kpRSmU7dIB9mGXIH6lcm9Stmqwgm4JysBS46YBTDPRA/SgmsWovEc3K/RJGUHBFolGMBZU2tUle8U0gT96RJdKeblnh0a04uJulQ7FcAdKepa85svumoAgIRjg/k3JxauN+rKnvsCwUv9jPUjAdavH2fJPYxKwgcRroxaQ9NNFW/RC7H1mbQoqzkfEguRA/wqHQZYeILiP+DCI7Jc2Gf2JZGN22ZXrb3qw1/g4HrxIn1VMGJEwdcJ04ccJ04uZcXNwSPkR8//drkw/728afqWc7tD798wtgtOmPV7z9/fHoOgnPO7ARrHSf17hOx66R2AHCmAy4ArNl3AAC2GglW8ZVw5N1mh+EEwpBYBr9x7ahDfH1bQNnQ4DdFeWX7ef800rQNxunqqMJjALuGAxV38NRfD9QvEqDMhUA1p4VFsL55/+UecBGJNBcqZ5OItr3BOKUOuA8Arfd5JxyeN4DB/IQO/t3bhsrOCdojA2xJbdjTuWQgOT4RvIni4DQmhnE9OI47r/BtjXDwQ85pCdwZAbb+BAeXTVhOs4lBu/ZuN0BJFL+RSUv2Af4vu2jD1IKUSXE5I79ATLwd/F9A2ZOzuNNbW5GkInjsHWhJUfWGHFQmmRq0JCmztNrfoOsJs7zWfCAA41S/xpb65KjCTNa2sRgq0Erg3c4BWrK2IsPr2vUbdF9Y2d3cvHsAeJs0UzAOkQPu9NLwWhjw3EApc+UGcK5qmn6aa563QQrJsXXAnVh8xm2f7ZF7PdtSap63DbiBA+60/DbQDPQzLT/SAKO2SOWs2rlGtTI54E4nlUUWq5L4rikv7rOqDBmXycQBdzqrwJfaZ2/KMaQtG8MVw+9Z32jaRLFxB9wHACZQDfYD5ToSuFVbnWCdfQPrPWX/72iYA+60wj+F6fy0HcA9l2XmW+ybbhG60/RDNRm6OHA0Md/fOeDOK3xXxbgNmGSR8TXrGxyTOkPgaFUMfD69HWuzkDGjADk93zYp475AG0ET+BYAV0HJHHCn934z5qCdVeBl+Qziu7E5vPiETaJUB17plW/lafZRoNfABZsMB019PLGoGJM6CeOEbeO/03wI6tIaZxBKCJGX3pI5Nzy9sM5nkK2cBCiTz99Pco4B5d6evdvN604EULHLo89AG7YBjbjtRVOfsLRG9XX0T0xmzqXxTWTigDs/eFODJbV+F69amg3yVWUJVTFbBXh1ztyriXU0rA/7s4f6Th30xKR/FYE2c1GFx9AG3d4FwgLvoUyo4ZNT8l0E4weyalcFYPH61nRJZ/XliuhDsy9DG2h7OJh121TZY/8KMAD0W9tx3mWyBAAAAABJRU5ErkJggg=="
			style="position: absolute; top: 50px; right: 42px; width: 87px; height: 21px;">
	</div>
	<div class="stiJsViewerAuthFormContainer"
		style="overflow: hidden; padding: 0px;">
		<div>
			<table class="stiJsViewerClearAllStyles" cellpadding="0"
				cellspacing="0" style="width: 100%;">
				<tbody>
					<tr class="stiJsViewerClearAllStyles">
						<td class="stiJsViewerClearAllStyles" style="width: 50%;"><table
								class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="margin: 0px auto;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles"></tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="line-height: 0; background-color: rgb(242, 241, 241); width: 30px; text-align: center;"><img
															src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDAyIDc5LjE2NDM1MiwgMjAyMC8wMS8zMC0xNTo1MDozOCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIxLjEgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkNGQzNFQTREQTQ2OTExRUFBQzFBQjcwQUVCQUVFNURFIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkNGQzNFQTRFQTQ2OTExRUFBQzFBQjcwQUVCQUVFNURFIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Q0ZDM0VBNEJBNDY5MTFFQUFDMUFCNzBBRUJBRUU1REUiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6Q0ZDM0VBNENBNDY5MTFFQUFDMUFCNzBBRUJBRUU1REUiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7qFruUAAAApUlEQVR42mL8//8/AwhIeXQzIAFXIE4FYlkgfgzEs4F4N0zy2Y5SuEIWBkzgDMTtSHwlJP5udMVMWAxIZ8AOUrEJYjNAFocBssQa8BiHAY+JNWAWDgPmEGvAHiCuAuL7QPwHSoP4u7AZwILDtl24NBBywRkojkMTj0OSI+gFEMgF4iAoOwjKZyDFC4xAXAHEmkDsD+WTZADMdYGkhgHJYBgYABBgAAcgHJxJDtSoAAAAAElFTkSuQmCC"
															style="vertical-align: middle; opacity: 0.8; width: 16px; height: 16px;"></td>
														<td class="stiJsViewerClearAllStyles"><input
                              [(ngModel)]="login"
															name="null" title="{{loginInfo.AuthorizationTextUserName}}"
															class="stiJsViewerTextBox stiJsViewerTextBoxDefault"
															placeholder="{{loginInfo.AuthorizationTextUserName}}"
															style="font-family: Arial; width: 280px; height: 30px; line-height: 21px; box-sizing: content-box; background-color: rgb(242, 241, 241); border: none;"></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding-top: 17px;"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="line-height: 0; background-color: rgb(242, 241, 241); width: 30px; text-align: center;"><img
															src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDAyIDc5LjE2NDM1MiwgMjAyMC8wMS8zMC0xNTo1MDozOCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIxLjEgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkNBNjE4NDExQTQ2OTExRUE4Qjg4OUQyMDc0MzI4QjQzIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkNBNjE4NDEyQTQ2OTExRUE4Qjg4OUQyMDc0MzI4QjQzIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Q0E2MTg0MEZBNDY5MTFFQThCODg5RDIwNzQzMjhCNDMiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6Q0E2MTg0MTBBNDY5MTFFQThCODg5RDIwNzQzMjhCNDMiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6i/NOXAAAA5UlEQVR42mKUdO9igAI7II4CYi0o/xoQLwXiwwx4AAuUzgLiJDQ5EyieB8TTcBnABMS2UM0TgNgSiPvQ1CRBXYfTgGgoex0Q/wbijVjUReEzAObnQCDmBGJ/LOq0CIUBCBRCMUmACRrahMBbfAYsI8IAWVzhwMyr4voQ6hVDAoZYQsPCAYiPAPEfmAsYoPFcBMRngPg7FD/GYogNELsghx1yIB6CYmQQjSNgQd5+AMR5LAScvRQphpCBFBD/gIUBoQC8DMRfoGGADASB+BsxBuAzxIKJhDSzDEs+YWAiMeFhGAIQYABSSCj4eeytwAAAAABJRU5ErkJggg=="
															style="vertical-align: middle; opacity: 0.8; width: 16px; height: 16px;"></td>
														<td class="stiJsViewerClearAllStyles"><input
                              [(ngModel)]="password"
                              (keydown)="keydown($event)"
															name="null" title="{{loginInfo.AuthorizationTextPassword}}"
															class="stiJsViewerTextBox stiJsViewerTextBoxDefault"
															placeholder="{{loginInfo.AuthorizationTextPassword}}" type="password"
															style="font-family: Arial; width: 280px; height: 30px; line-height: 21px; box-sizing: content-box; background-color: rgb(242, 241, 241); border: none;"></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0" style="width: 100%;">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="padding-top: 20px;"><div
																class="stiJsViewerLoginButton stiJsViewerLoginButtonDefault"
																style="font-family: Arial; height: 40px; box-sizing: content-box; min-width: 80px; cursor: pointer; margin: 8px 0px 80px; display: inline-block;">
																<table class="stiJsViewerClearAllStyles" cellpadding="0"
                                (click)="doLogin()"
																	cellspacing="0" style="width: 100%; height: 100%;">
																	<tbody>
																		<tr class="stiJsViewerClearAllStyles">
																			<td class="stiJsViewerClearAllStyles"
																				style="padding: 0px 10px; white-space: nowrap; text-align: center;">{{loginInfo.AuthorizationWindowTitleLogin}}</td>
																		</tr>
																	</tbody>
																</table>
															</div></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
								</tbody>
							</table></td>
					</tr>
					<tr class="stiJsViewerClearAllStyles">
						<td class="stiJsViewerClearAllStyles" colspan="2"
							style="text-align: center;"><div
								style="width: 380px; margin: 0px auto;"></div></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="stiJsViewerFormButtonsPanel" style="display: none;">
		<table class="stiJsViewerClearAllStyles" cellpadding="0"
			cellspacing="0">
			<tbody>
				<tr class="stiJsViewerClearAllStyles">
					<td class="stiJsViewerClearAllStyles" style="padding: 12px;"><div
							class="stiJsViewerFormButtonTheme stiJsViewerFormButtonThemeDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; min-width: 80px;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding: 0px 10px; white-space: nowrap; text-align: center; width: 100%;">OK</td>
									</tr>
								</tbody>
							</table>
						</div></td>
					<td class="stiJsViewerClearAllStyles"
						style="padding: 12px 12px 12px 0px;"><div
							class="stiJsViewerFormButton stiJsViewerFormButtonDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; min-width: 80px;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding: 0px 10px; white-space: nowrap; text-align: center; width: 100%;">Cancel</td>
									</tr>
								</tbody>
							</table>
						</div></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<style>
  .stiJsViewerMainPanel *, .stiJsViewerMainPanel *:before, .stiJsViewerMainPanel *:after {
    box-sizing: content-box;
    border-collapse: initial;
}

.stiJsViewerForm {
    position: absolute;
    border: 1px solid #19478a;
    background: #ffffff;
    -moz-box-shadow: 0px 0px 7px rgba(0,0,0,0.6);
    -webkit-box-shadow: 0px 0px 7px rgb(0 0 0 / 60%);
    box-shadow: 0 0 7px rgb(0 0 0 / 30%);
    cursor: default;
    -moz-user-select: none;
    -khtml-user-select: none;
    -webkit-user-select: none;
    -ms-user-select: none;
    text-align: left;
    color: #202020;
}

.stiJsViewerClearAllStyles {
    padding: 0px;
    margin: 0px;
    border: 0px;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 0px;
    margin-right: 0px;
    line-height: normal;
}

.stiJsViewerAuthFormCaption {
    font-family: Arial;
    color: #7a8d8e;
    font-size: 28px;
}

.stiJsViewerAuthFormContainer {
    padding: 5px 10px 0px 10px;
    background: #ffffff;
    overflow-y: auto;
    overflow-x: hidden;
}

.stiJsViewerTextBoxDefault {
    border-radius: 3px;
    border: 1px solid #ababab;
}

.stiJsViewerTextBox {
    font-size: 12px;
    margin: 0px;
    padding: 0px 0px 0px 4px;
    -webkit-border-radius: 0px;
    outline: none;
    background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(hsla(0,0%,100%,0)), to(hsla(0,0%,100%,0)));
    background-image: -webkit-linear-gradient(hsla(0,0%,100%,0), hsla(0,0%,100%,0));
    background: #ffffff;
    color: #202020;
}

.stiJsViewerLoginButtonDefault {
    background: #19478a;
}

.stiJsViewerLoginButton {
    border: none;
    border-radius: 3px;
    height: 40px;
    color: white;
    cursor: default;
    font-family: Arial;
    font-size: 19px;
    width: 100%;
    -moz-user-select: none;
    -khtml-user-select: none;
    -webkit-user-select: none;
    -ms-user-select: none;
}

.stiJsViewerLoginButton:hover {
    background: #3b629b;
}
</style>
  `, isInline: true, styles: ["\n  .stiJsViewerMainPanel *, .stiJsViewerMainPanel *:before, .stiJsViewerMainPanel *:after {\n    box-sizing: content-box;\n    border-collapse: initial;\n}\n\n.stiJsViewerForm {\n    position: absolute;\n    border: 1px solid #19478a;\n    background: #ffffff;\n    -moz-box-shadow: 0px 0px 7px rgba(0,0,0,0.6);\n    -webkit-box-shadow: 0px 0px 7px rgb(0 0 0 / 60%);\n    box-shadow: 0 0 7px rgb(0 0 0 / 30%);\n    cursor: default;\n    -moz-user-select: none;\n    -khtml-user-select: none;\n    -webkit-user-select: none;\n    -ms-user-select: none;\n    text-align: left;\n    color: #202020;\n}\n\n.stiJsViewerClearAllStyles {\n    padding: 0px;\n    margin: 0px;\n    border: 0px;\n    margin-top: 0px;\n    margin-bottom: 0px;\n    margin-left: 0px;\n    margin-right: 0px;\n    line-height: normal;\n}\n\n.stiJsViewerAuthFormCaption {\n    font-family: Arial;\n    color: #7a8d8e;\n    font-size: 28px;\n}\n\n.stiJsViewerAuthFormContainer {\n    padding: 5px 10px 0px 10px;\n    background: #ffffff;\n    overflow-y: auto;\n    overflow-x: hidden;\n}\n\n.stiJsViewerTextBoxDefault {\n    border-radius: 3px;\n    border: 1px solid #ababab;\n}\n\n.stiJsViewerTextBox {\n    font-size: 12px;\n    margin: 0px;\n    padding: 0px 0px 0px 4px;\n    -webkit-border-radius: 0px;\n    outline: none;\n    background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(hsla(0,0%,100%,0)), to(hsla(0,0%,100%,0)));\n    background-image: -webkit-linear-gradient(hsla(0,0%,100%,0), hsla(0,0%,100%,0));\n    background: #ffffff;\n    color: #202020;\n}\n\n.stiJsViewerLoginButtonDefault {\n    background: #19478a;\n}\n\n.stiJsViewerLoginButton {\n    border: none;\n    border-radius: 3px;\n    height: 40px;\n    color: white;\n    cursor: default;\n    font-family: Arial;\n    font-size: 19px;\n    width: 100%;\n    -moz-user-select: none;\n    -khtml-user-select: none;\n    -webkit-user-select: none;\n    -ms-user-select: none;\n}\n\n.stiJsViewerLoginButton:hover {\n    background: #3b629b;\n}\n"], dependencies: [{ kind: "directive", type: i1.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i1.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i1.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLoginComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-login',
                    template: `
  <div id="cd334261b95f4a98802f0b2b478f726e" class="stiJsViewerForm"
	style="z-index: 21; width: 380px; background-color: white; left: 0px; opacity: 1;"
  [style.left.px]="window.innerWidth / 2 - 140"
  [style.top.px]="window.innerHeight / 2 - 200">
	<div class="stiJsViewerAuthFormHeader" style="position: relative;">
		<table class="stiJsViewerClearAllStyles" cellpadding="0"
			cellspacing="0" style="width: 100%;">
			<tbody>
				<tr class="stiJsViewerClearAllStyles">
					<td class="stiJsViewerAuthFormCaption"
						style="text-align: left; padding: 45px 133px 45px 33px;">{{loginInfo.AuthorizationWindowTitleLogin.toUpperCase()}}</td>
					<td class="stiJsViewerClearAllStyles"
						style="vertical-align: top; width: 30px; text-align: right; padding: 2px 2px 1px 1px;"><div
							class="stiJsViewerStandartSmallButton stiJsViewerStandartSmallButtonDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; display: none;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="line-height: 0; text-align: center; padding: 0px 4px;"><img
											src="data:image/png;base64,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"
											style="width: 16px; height: 16px; margin: 0px 2px;"></td>
									</tr>
								</tbody>
							</table>
						</div></td>
				</tr>
			</tbody>
		</table>
		<img
			src="data:image/png;base64,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"
			style="position: absolute; top: 50px; right: 42px; width: 87px; height: 21px;">
	</div>
	<div class="stiJsViewerAuthFormContainer"
		style="overflow: hidden; padding: 0px;">
		<div>
			<table class="stiJsViewerClearAllStyles" cellpadding="0"
				cellspacing="0" style="width: 100%;">
				<tbody>
					<tr class="stiJsViewerClearAllStyles">
						<td class="stiJsViewerClearAllStyles" style="width: 50%;"><table
								class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="margin: 0px auto;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles"></tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="line-height: 0; background-color: rgb(242, 241, 241); width: 30px; text-align: center;"><img
															src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDAyIDc5LjE2NDM1MiwgMjAyMC8wMS8zMC0xNTo1MDozOCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIxLjEgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkNGQzNFQTREQTQ2OTExRUFBQzFBQjcwQUVCQUVFNURFIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkNGQzNFQTRFQTQ2OTExRUFBQzFBQjcwQUVCQUVFNURFIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Q0ZDM0VBNEJBNDY5MTFFQUFDMUFCNzBBRUJBRUU1REUiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6Q0ZDM0VBNENBNDY5MTFFQUFDMUFCNzBBRUJBRUU1REUiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7qFruUAAAApUlEQVR42mL8//8/AwhIeXQzIAFXIE4FYlkgfgzEs4F4N0zy2Y5SuEIWBkzgDMTtSHwlJP5udMVMWAxIZ8AOUrEJYjNAFocBssQa8BiHAY+JNWAWDgPmEGvAHiCuAuL7QPwHSoP4u7AZwILDtl24NBBywRkojkMTj0OSI+gFEMgF4iAoOwjKZyDFC4xAXAHEmkDsD+WTZADMdYGkhgHJYBgYABBgAAcgHJxJDtSoAAAAAElFTkSuQmCC"
															style="vertical-align: middle; opacity: 0.8; width: 16px; height: 16px;"></td>
														<td class="stiJsViewerClearAllStyles"><input
                              [(ngModel)]="login"
															name="null" title="{{loginInfo.AuthorizationTextUserName}}"
															class="stiJsViewerTextBox stiJsViewerTextBoxDefault"
															placeholder="{{loginInfo.AuthorizationTextUserName}}"
															style="font-family: Arial; width: 280px; height: 30px; line-height: 21px; box-sizing: content-box; background-color: rgb(242, 241, 241); border: none;"></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding-top: 17px;"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="line-height: 0; background-color: rgb(242, 241, 241); width: 30px; text-align: center;"><img
															src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDAyIDc5LjE2NDM1MiwgMjAyMC8wMS8zMC0xNTo1MDozOCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIxLjEgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkNBNjE4NDExQTQ2OTExRUE4Qjg4OUQyMDc0MzI4QjQzIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkNBNjE4NDEyQTQ2OTExRUE4Qjg4OUQyMDc0MzI4QjQzIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Q0E2MTg0MEZBNDY5MTFFQThCODg5RDIwNzQzMjhCNDMiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6Q0E2MTg0MTBBNDY5MTFFQThCODg5RDIwNzQzMjhCNDMiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6i/NOXAAAA5UlEQVR42mKUdO9igAI7II4CYi0o/xoQLwXiwwx4AAuUzgLiJDQ5EyieB8TTcBnABMS2UM0TgNgSiPvQ1CRBXYfTgGgoex0Q/wbijVjUReEzAObnQCDmBGJ/LOq0CIUBCBRCMUmACRrahMBbfAYsI8IAWVzhwMyr4voQ6hVDAoZYQsPCAYiPAPEfmAsYoPFcBMRngPg7FD/GYogNELsghx1yIB6CYmQQjSNgQd5+AMR5LAScvRQphpCBFBD/gIUBoQC8DMRfoGGADASB+BsxBuAzxIKJhDSzDEs+YWAiMeFhGAIQYABSSCj4eeytwAAAAABJRU5ErkJggg=="
															style="vertical-align: middle; opacity: 0.8; width: 16px; height: 16px;"></td>
														<td class="stiJsViewerClearAllStyles"><input
                              [(ngModel)]="password"
                              (keydown)="keydown($event)"
															name="null" title="{{loginInfo.AuthorizationTextPassword}}"
															class="stiJsViewerTextBox stiJsViewerTextBoxDefault"
															placeholder="{{loginInfo.AuthorizationTextPassword}}" type="password"
															style="font-family: Arial; width: 280px; height: 30px; line-height: 21px; box-sizing: content-box; background-color: rgb(242, 241, 241); border: none;"></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0" style="width: 100%;">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="padding-top: 20px;"><div
																class="stiJsViewerLoginButton stiJsViewerLoginButtonDefault"
																style="font-family: Arial; height: 40px; box-sizing: content-box; min-width: 80px; cursor: pointer; margin: 8px 0px 80px; display: inline-block;">
																<table class="stiJsViewerClearAllStyles" cellpadding="0"
                                (click)="doLogin()"
																	cellspacing="0" style="width: 100%; height: 100%;">
																	<tbody>
																		<tr class="stiJsViewerClearAllStyles">
																			<td class="stiJsViewerClearAllStyles"
																				style="padding: 0px 10px; white-space: nowrap; text-align: center;">{{loginInfo.AuthorizationWindowTitleLogin}}</td>
																		</tr>
																	</tbody>
																</table>
															</div></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
								</tbody>
							</table></td>
					</tr>
					<tr class="stiJsViewerClearAllStyles">
						<td class="stiJsViewerClearAllStyles" colspan="2"
							style="text-align: center;"><div
								style="width: 380px; margin: 0px auto;"></div></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="stiJsViewerFormButtonsPanel" style="display: none;">
		<table class="stiJsViewerClearAllStyles" cellpadding="0"
			cellspacing="0">
			<tbody>
				<tr class="stiJsViewerClearAllStyles">
					<td class="stiJsViewerClearAllStyles" style="padding: 12px;"><div
							class="stiJsViewerFormButtonTheme stiJsViewerFormButtonThemeDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; min-width: 80px;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding: 0px 10px; white-space: nowrap; text-align: center; width: 100%;">OK</td>
									</tr>
								</tbody>
							</table>
						</div></td>
					<td class="stiJsViewerClearAllStyles"
						style="padding: 12px 12px 12px 0px;"><div
							class="stiJsViewerFormButton stiJsViewerFormButtonDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; min-width: 80px;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding: 0px 10px; white-space: nowrap; text-align: center; width: 100%;">Cancel</td>
									</tr>
								</tbody>
							</table>
						</div></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<style>
  .stiJsViewerMainPanel *, .stiJsViewerMainPanel *:before, .stiJsViewerMainPanel *:after {
    box-sizing: content-box;
    border-collapse: initial;
}

.stiJsViewerForm {
    position: absolute;
    border: 1px solid #19478a;
    background: #ffffff;
    -moz-box-shadow: 0px 0px 7px rgba(0,0,0,0.6);
    -webkit-box-shadow: 0px 0px 7px rgb(0 0 0 / 60%);
    box-shadow: 0 0 7px rgb(0 0 0 / 30%);
    cursor: default;
    -moz-user-select: none;
    -khtml-user-select: none;
    -webkit-user-select: none;
    -ms-user-select: none;
    text-align: left;
    color: #202020;
}

.stiJsViewerClearAllStyles {
    padding: 0px;
    margin: 0px;
    border: 0px;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 0px;
    margin-right: 0px;
    line-height: normal;
}

.stiJsViewerAuthFormCaption {
    font-family: Arial;
    color: #7a8d8e;
    font-size: 28px;
}

.stiJsViewerAuthFormContainer {
    padding: 5px 10px 0px 10px;
    background: #ffffff;
    overflow-y: auto;
    overflow-x: hidden;
}

.stiJsViewerTextBoxDefault {
    border-radius: 3px;
    border: 1px solid #ababab;
}

.stiJsViewerTextBox {
    font-size: 12px;
    margin: 0px;
    padding: 0px 0px 0px 4px;
    -webkit-border-radius: 0px;
    outline: none;
    background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(hsla(0,0%,100%,0)), to(hsla(0,0%,100%,0)));
    background-image: -webkit-linear-gradient(hsla(0,0%,100%,0), hsla(0,0%,100%,0));
    background: #ffffff;
    color: #202020;
}

.stiJsViewerLoginButtonDefault {
    background: #19478a;
}

.stiJsViewerLoginButton {
    border: none;
    border-radius: 3px;
    height: 40px;
    color: white;
    cursor: default;
    font-family: Arial;
    font-size: 19px;
    width: 100%;
    -moz-user-select: none;
    -khtml-user-select: none;
    -webkit-user-select: none;
    -ms-user-select: none;
}

.stiJsViewerLoginButton:hover {
    background: #3b629b;
}
</style>
  `
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { loginInfo: [{
                type: Input
            }], onLogin: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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