import { Component } from "@angular/core";
import { StiLocalizationService } from "../services/sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/http-client.service";
import * as i3 from "../services/sti-user-service";
import * as i4 from "../services/sti-localization.service";
import * as i5 from "../services/sti-helper.service";
import * as i6 from "../services/sti-local-storage.service";
import * as i7 from "@angular/common";
export class StiLocalizationPreviewComponent {
    constructor(model, httpService, userService, loc, helper, stiLocalStorage) {
        this.model = model;
        this.httpService = httpService;
        this.userService = userService;
        this.loc = loc;
        this.helper = helper;
        this.stiLocalStorage = stiLocalStorage;
        this.itemWidth = 150;
    }
    get items() {
        return this.loc.localizationList ? this.loc.localizationList : [];
    }
    get itemsInRow() {
        return new Array(3).fill(1);
    }
    get rows() {
        return this.items ? new Array(Math.ceil(this.items.length / this.itemsInRow.length)).fill(2) : new Array(0).fill(0);
    }
    setEvent(event) {
        let localization;
        if (event != "Default") {
            localization = this.loc.localizationList?.find((item) => this.model.isWebView ? item.language == event : item.fileName == event);
        }
        else {
            localization = this.loc.defaultLocalization;
        }
        this.loc.currentLocalization = localization;
        if (event == "Default") {
            this.httpService
                .post("", {
                action: "InterfaceEvent",
                event: "LocalizationButtonClick",
                localization: this.model.isWebView
                    ? this.loc.defaultLocalization.language
                    : this.loc.defaultLocalization.fileName,
            })
                .subscribe(() => { });
            this.loc.currentLocalization = this.loc.defaultLocalization;
        }
        else {
            this.httpService
                .post("", { action: "InterfaceEvent", event: "LocalizationButtonClick", localization: event })
                .subscribe(() => { });
            this.loc.currentLocalization = this.loc.localizationList?.find((item) => this.model.isWebView ? item.language == event : item.fileName == event);
        }
        this.stiLocalStorage.setItem("StiFormsLocalization", JSON.stringify(this.loc.currentLocalization));
        this.httpService
            .post(this.model.requestUrl, { action: "GetLocalization", localization: localization.cultureName })
            .subscribe((data) => {
            StiLocalizationService.setLocalization(data.localization);
            this.model.needToRefresh.next(true);
            this.helper.updateHelper();
        });
    }
    ngOnInit() { }
}
StiLocalizationPreviewComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLocalizationPreviewComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }, { token: i3.StiUserService }, { token: i4.StiLocalizationService }, { token: i5.StiHelperService }, { token: i6.StiLocalStorageService }], target: i0.ɵɵFactoryTarget.Component });
StiLocalizationPreviewComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiLocalizationPreviewComponent, selector: "sti-localization-preview", ngImport: i0, template: `
    <div
      class="parent-localization-container"
      [style.visibility]="userService.showLocalizationPreview ? 'visible' : 'hidden'"
      [style.left.px]="userService.previewX"
      [style.top.px]="userService.previewY"
      [style.width.px]="loc.localizationList?.length > 0 ? 465 : 155"
    >
      <div class="default" [style.width.px]="loc.localizationList?.length > 0 ? 460 : 155">
        <div class="item" (click)="setEvent('Default')" [style.margin.px]="1">
          <span>{{ loc.getP("Default") }}</span>
        </div>
        <div
          *ngIf="loc.localizationList?.length > 0"
          class="item {{ loc.defaultLocalization?.language == loc.currentLocalization?.language ? 'current' : '' }}"
          [style.margin.px]="1"
          (click)="setEvent('Default')"
        >
          <span>{{ loc.defaultLocalization?.description }}</span>
        </div>
      </div>
      <div *ngIf="loc.localizationList?.length > 0" class="localization-list">
        <table class="sti-clear" [style.width]="'100%'">
          <tr *ngFor="let row of rows; index as i" class="row-container">
            <td *ngFor="let item of itemsInRow; index as ind">
              <div
                *ngIf="items[i * itemsInRow.length + ind]"
                (click)="
                  model.isWebView
                    ? setEvent(items[i * itemsInRow.length + ind]?.language)
                    : setEvent(items[i * itemsInRow.length + ind]?.fileName)
                "
                class="item {{
                  items[i * itemsInRow.length + ind]?.language == loc.currentLocalization?.language ? 'current' : ''
                }}"
              >
                <span>{{ items[i * itemsInRow.length + ind]?.description }}</span>
              </div>
            </td>
          </tr>
        </table>
      </div>
    </div>
  `, isInline: true, styles: ["table{border-spacing:2px}td{padding:0;max-width:150px;height:32px}.parent-localization-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px;border:1px solid #c6c6c6;border-radius:3px;font-size:12px;font-family:Arial;color:#444;overflow:hidden;max-height:600px;box-shadow:0 0 7px #0000004d}.localization-list{width:460px;display:flex;flex-wrap:wrap;padding-top:1px}.default{width:460px;display:flex;flex-wrap:wrap;padding-bottom:1px;border-bottom:1px dotted #c6c6c6}.item{width:151.2px;border-radius:3px;height:32px;display:flex;align-items:center;justify-content:center;background-color:var(--back-color);border:1px solid #c6c6c6}.item:hover{background-color:#dadada;border-color:#c6c6c6}.current{background-color:#e5e5e5}\n"], dependencies: [{ kind: "directive", type: i7.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLocalizationPreviewComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-localization-preview", template: `
    <div
      class="parent-localization-container"
      [style.visibility]="userService.showLocalizationPreview ? 'visible' : 'hidden'"
      [style.left.px]="userService.previewX"
      [style.top.px]="userService.previewY"
      [style.width.px]="loc.localizationList?.length > 0 ? 465 : 155"
    >
      <div class="default" [style.width.px]="loc.localizationList?.length > 0 ? 460 : 155">
        <div class="item" (click)="setEvent('Default')" [style.margin.px]="1">
          <span>{{ loc.getP("Default") }}</span>
        </div>
        <div
          *ngIf="loc.localizationList?.length > 0"
          class="item {{ loc.defaultLocalization?.language == loc.currentLocalization?.language ? 'current' : '' }}"
          [style.margin.px]="1"
          (click)="setEvent('Default')"
        >
          <span>{{ loc.defaultLocalization?.description }}</span>
        </div>
      </div>
      <div *ngIf="loc.localizationList?.length > 0" class="localization-list">
        <table class="sti-clear" [style.width]="'100%'">
          <tr *ngFor="let row of rows; index as i" class="row-container">
            <td *ngFor="let item of itemsInRow; index as ind">
              <div
                *ngIf="items[i * itemsInRow.length + ind]"
                (click)="
                  model.isWebView
                    ? setEvent(items[i * itemsInRow.length + ind]?.language)
                    : setEvent(items[i * itemsInRow.length + ind]?.fileName)
                "
                class="item {{
                  items[i * itemsInRow.length + ind]?.language == loc.currentLocalization?.language ? 'current' : ''
                }}"
              >
                <span>{{ items[i * itemsInRow.length + ind]?.description }}</span>
              </div>
            </td>
          </tr>
        </table>
      </div>
    </div>
  `, styles: ["table{border-spacing:2px}td{padding:0;max-width:150px;height:32px}.parent-localization-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px;border:1px solid #c6c6c6;border-radius:3px;font-size:12px;font-family:Arial;color:#444;overflow:hidden;max-height:600px;box-shadow:0 0 7px #0000004d}.localization-list{width:460px;display:flex;flex-wrap:wrap;padding-top:1px}.default{width:460px;display:flex;flex-wrap:wrap;padding-bottom:1px;border-bottom:1px dotted #c6c6c6}.item{width:151.2px;border-radius:3px;height:32px;display:flex;align-items:center;justify-content:center;background-color:var(--back-color);border:1px solid #c6c6c6}.item:hover{background-color:#dadada;border-color:#c6c6c6}.current{background-color:#e5e5e5}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }, { type: i3.StiUserService }, { type: i4.StiLocalizationService }, { type: i5.StiHelperService }, { type: i6.StiLocalStorageService }]; } });
//# sourceMappingURL=data:application/json;base64,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