import { Component, Input } from "@angular/core";
import { StiTextItem } from "../../elements/text/StiTextItem";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-editable-content.service";
import * as i3 from "@angular/common";
import * as i4 from "../sti-component";
import * as i5 from "../sti-editable-content.component";
import * as i6 from "../sti-tooltip/sti-tooltip.directive";
export class StiListBoxComponent {
    constructor(model, editableService) {
        this.model = model;
        this.editableService = editableService;
        this.isClone = false;
    }
    get align() {
        return "start";
    }
    get needToFill() {
        return this.element.required && this.element.value.length == 0 && this.model.hasEmptyReuiredFields;
    }
    disableDrag(event) {
        setTimeout(() => {
            this.editableService.editableContent = new StiTextItem("", this.element.font, this.element.textColor, this.element.backgroundColor);
            this.editableService.usedElement = this.element;
        }, 0);
        this.model.canDrag = false;
    }
    ngOnInit() { }
    borderWidth() {
        return `${this.element.borderWeight}px`;
    }
    selectValue(option) {
        if (this.element.allowMultiselection) {
            if (this.element.selectedOptions.indexOf(option) >= 0) {
                this.element?.selectedOptions.splice(this.element.selectedOptions.indexOf(option), 1);
            }
            else {
                this.element.selectedOptions.push(option);
            }
        }
        else {
            this.element.selectedOptions = [];
            this.element.selectedOptions.push(option);
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    get htmlStyleElement() {
        return this.element;
    }
}
StiListBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiListBoxComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component });
StiListBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiListBoxComponent, selector: "sti-listbox-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-list-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [required]="element.required"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <ul
            [style.margin-top.px]="element?.getTopMargin()"
            [style.align-self]="'center'"
            class="{{ element?.readOnly ? 'disabled' : '' }}"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.background-color]="element?.backgroundColor.toHtmlColor()"
            [style.color]="element?.textColor.toHtmlColor()"
            [style]="htmlStyleElement?.htmlStyle()"
            [style.border-width]="borderWidth()"
            [stiTooltip]="element?.tooltip"
            [tabIndex]="element['tabIndex']"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="disableDrag($event)"
            (mouseup)="this.model.canDrag = true"
          >
            <li
              *ngFor="let option of element.options"
              [disabled]="element?.readOnly ? true : false"
              (mousedown)="selectValue(option)"
              class="{{ element.selectedOptions.indexOf(option) >= 0 ? 'active' : '' }}"
            >
              {{ option }}
            </li>
          </ul>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-list-box ul{width:100%;list-style:none;padding:2px;margin-top:10px;margin-bottom:0;border:1px solid}.sti-list-box li{padding:1px 4px;border:1px solid transparent}.sti-list-box li:hover{background-color:#e5f3fb;border-color:#70c0e7}.sti-list-box li:active{background-color:#cbe8f6;border-color:#26a0da}.active{background-color:#f6f6f6;border-color:#dadada!important}.active:hover{background-color:#e5f3fb;border-color:#70c0e7}.active:focus{background-color:#cbe8f6;border-color:#26a0da}.disabled{pointer-events:none;opacity:.5}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i5.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiListBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-listbox-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-list-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [required]="element.required"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <ul
            [style.margin-top.px]="element?.getTopMargin()"
            [style.align-self]="'center'"
            class="{{ element?.readOnly ? 'disabled' : '' }}"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.background-color]="element?.backgroundColor.toHtmlColor()"
            [style.color]="element?.textColor.toHtmlColor()"
            [style]="htmlStyleElement?.htmlStyle()"
            [style.border-width]="borderWidth()"
            [stiTooltip]="element?.tooltip"
            [tabIndex]="element['tabIndex']"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="disableDrag($event)"
            (mouseup)="this.model.canDrag = true"
          >
            <li
              *ngFor="let option of element.options"
              [disabled]="element?.readOnly ? true : false"
              (mousedown)="selectValue(option)"
              class="{{ element.selectedOptions.indexOf(option) >= 0 ? 'active' : '' }}"
            >
              {{ option }}
            </li>
          </ul>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-list-box ul{width:100%;list-style:none;padding:2px;margin-top:10px;margin-bottom:0;border:1px solid}.sti-list-box li{padding:1px 4px;border:1px solid transparent}.sti-list-box li:hover{background-color:#e5f3fb;border-color:#70c0e7}.sti-list-box li:active{background-color:#cbe8f6;border-color:#26a0da}.active{background-color:#f6f6f6;border-color:#dadada!important}.active:hover{background-color:#e5f3fb;border-color:#70c0e7}.active:focus{background-color:#cbe8f6;border-color:#26a0da}.disabled{pointer-events:none;opacity:.5}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiEditableContentService }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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