import { Component, Input } from "@angular/core";
import { StiVerticalAlignment } from "../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
export class StiLineComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    get verticalAlignment() {
        if (this.element.verticalAlignment == StiVerticalAlignment.Top) {
            return "start";
        }
        else if (this.element.verticalAlignment == StiVerticalAlignment.Bottom) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    ngOnInit() { }
}
StiLineComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLineComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiLineComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiLineComponent, selector: "sti-line-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-line">
    <div class="line-container" [style.align-items]="verticalAlignment">
      <div class="line" [style.border-bottom]="element.toHtmlBorder()"></div>
    </div>
    <sti-editable-content-component
      *ngIf="element?.description.value?.length > 0"
      [editableContent]="element.description"
    >
    </sti-editable-content-component>
  </sti-component>`, isInline: true, styles: [".line-container{height:100%;width:100%;display:flex}.line{width:100%;margin:0;font-size:1px;height:1px;border-bottom:1px solid transparent}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLineComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-line-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-line">
    <div class="line-container" [style.align-items]="verticalAlignment">
      <div class="line" [style.border-bottom]="element.toHtmlBorder()"></div>
    </div>
    <sti-editable-content-component
      *ngIf="element?.description.value?.length > 0"
      [editableContent]="element.description"
    >
    </sti-editable-content-component>
  </sti-component>`, styles: [".line-container{height:100%;width:100%;display:flex}.line{width:100%;margin:0;font-size:1px;height:1px;border-bottom:1px solid transparent}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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