import { Component, Input } from "@angular/core";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../sti-component";
import * as i3 from "../sti-editable-content.component";
export class StiLabelComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    get borderInnerWidth() {
        return Number(this.element.width) + Number(this.element.border.pen.width);
    }
    get borderInnerHeight() {
        return Number(this.element.height) + Number(this.element.border.pen.width);
    }
    get selected() {
        return this.model.selectedComponent?.element == this.element;
    }
    get exceedMarginsLeft() {
        if (this.element.exceedMargins.drawLeft) {
            return -this.model.getElementPage(this.element)?.padding.left - this.element.geometry.x;
        }
        else {
            return 0;
        }
    }
    get exceedMarginsTop() {
        if (this.element.exceedMargins.drawTop) {
            return -this.model.getElementPage(this.element)?.padding.top - this.element.geometry.y;
        }
        else {
            return 0;
        }
    }
    get exceedMarginsWidth() {
        if (!this.element.exceedMargins.drawLeft && !this.element.exceedMargins.drawRight) {
            return this.element.width;
        }
        else if (this.element.exceedMargins.drawLeft && !this.element.exceedMargins.drawRight) {
            return (this.element.width -
                this.element.padding.right +
                this.model.getElementPage(this.element)?.padding.left +
                this.element.geometry.x);
        }
        else if (!this.element.exceedMargins.drawLeft && this.element.exceedMargins.drawRight) {
            return (this.model.getElementPage(this.element)?.width -
                this.model.getElementPage(this.element)?.padding.left -
                this.element.x -
                this.element.padding.left);
        }
        else {
            return this.model.getElementPage(this.element)?.width;
        }
    }
    get exceedMarginsHeight() {
        if (!this.element.exceedMargins.drawTop && !this.element.exceedMargins.drawBottom) {
            return this.element.height;
        }
        else if (this.element.exceedMargins.drawTop && !this.element.exceedMargins.drawBottom) {
            return (this.element.height -
                this.element.padding.bottom +
                this.model.getElementPage(this.element)?.padding.top +
                this.element.geometry.y);
        }
        else if (!this.element.exceedMargins.drawTop && this.element.exceedMargins.drawBottom) {
            return (this.model.getElementPage(this.element)?.height -
                this.model.getElementPage(this.element)?.padding.top -
                this.element.y -
                this.element.padding.top);
        }
        else {
            return this.model.getElementPage(this.element)?.height;
        }
    }
    get horizontalAlignment() {
        if (this.element.text.horizontalAlignment == StiHorizontalAlignment.Left) {
            return "start";
        }
        else if (this.element.text.horizontalAlignment == StiHorizontalAlignment.Right) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    get verticalAlignment() {
        if (this.element.text.verticalAlignment == StiVerticalAlignment.Top) {
            return "start";
        }
        else if (this.element.text.verticalAlignment == StiVerticalAlignment.Bottom) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    openLink() {
        if (this.element.hyperlink.length > 0 && this.model.isPreviewMode) {
            window.open(this.element.hyperlink, "_blank");
        }
    }
    ngOnInit() { }
}
StiLabelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLabelComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiLabelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiLabelComponent, selector: "sti-label-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    class="sti-label"
    [style.pointer-events]="model.isPreviewMode ? 'none' : ''"
  >
    <div
      [style]="element.htmlStyle()"
      [style.justify-content]="horizontalAlignment"
      [style.align-items]="verticalAlignment"
      [style.overflow]="'hidden'"
    >
      <sti-editable-content-component
        [editableContent]="element?.text"
        [displayContent]="element?.displayValue"
        [style]="element.htmlStyle()"
        [hideEmpty]="false"
        [active]="selected"
        [disablePadding]="true"
        (click)="openLink()"
        [parentCursor]="element.hyperlink.length > 0 && model.isPreviewMode ? 'pointer' : 'text'"
      >
      </sti-editable-content-component>
    </div>
    <div
      style="position: absolute;pointer-events:none;width:100%;height:100%; left:0; top:0;z-index:999"
      [style.height.px]="borderInnerHeight"
      [style.width.px]="borderInnerWidth"
      [style.left.px]="-(element.border.pen.width / 2)"
      [style.top.px]="-(element.border.pen.width / 2)"
      [style.border-top]="element.border.drawTop ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-left]="element.border.drawLeft ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-right]="element.border.drawRight ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-bottom]="element.border.drawBottom ? element.border.pen.toHtmlBorder() : 'transparent'"
    ></div>
    <div
      class="exceed-margins"
      [style.background-color]="element?.text.backgroundColor.toHtmlColor()"
      [style.left.px]="exceedMarginsLeft"
      [style.top.px]="exceedMarginsTop"
      [style.width.px]="exceedMarginsWidth"
      [style.height.px]="exceedMarginsHeight"
      [style.pointer-events]="'none'"
    ></div>
  </sti-component>`, isInline: true, styles: [".sti-label p{font-size:12px;font-weight:400;margin:0}div{display:flex;height:100%;width:100%}.exceed-margins{position:absolute;background-color:red;z-index:-1}\n"], dependencies: [{ kind: "component", type: i2.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i3.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLabelComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-label-component", template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    class="sti-label"
    [style.pointer-events]="model.isPreviewMode ? 'none' : ''"
  >
    <div
      [style]="element.htmlStyle()"
      [style.justify-content]="horizontalAlignment"
      [style.align-items]="verticalAlignment"
      [style.overflow]="'hidden'"
    >
      <sti-editable-content-component
        [editableContent]="element?.text"
        [displayContent]="element?.displayValue"
        [style]="element.htmlStyle()"
        [hideEmpty]="false"
        [active]="selected"
        [disablePadding]="true"
        (click)="openLink()"
        [parentCursor]="element.hyperlink.length > 0 && model.isPreviewMode ? 'pointer' : 'text'"
      >
      </sti-editable-content-component>
    </div>
    <div
      style="position: absolute;pointer-events:none;width:100%;height:100%; left:0; top:0;z-index:999"
      [style.height.px]="borderInnerHeight"
      [style.width.px]="borderInnerWidth"
      [style.left.px]="-(element.border.pen.width / 2)"
      [style.top.px]="-(element.border.pen.width / 2)"
      [style.border-top]="element.border.drawTop ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-left]="element.border.drawLeft ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-right]="element.border.drawRight ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-bottom]="element.border.drawBottom ? element.border.pen.toHtmlBorder() : 'transparent'"
    ></div>
    <div
      class="exceed-margins"
      [style.background-color]="element?.text.backgroundColor.toHtmlColor()"
      [style.left.px]="exceedMarginsLeft"
      [style.top.px]="exceedMarginsTop"
      [style.width.px]="exceedMarginsWidth"
      [style.height.px]="exceedMarginsHeight"
      [style.pointer-events]="'none'"
    ></div>
  </sti-component>`, styles: [".sti-label p{font-size:12px;font-weight:400;margin:0}div{display:flex;height:100%;width:100%}.exceed-margins{position:absolute;background-color:red;z-index:-1}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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