import { Component, Input } from "@angular/core";
import { StiInputTextItem } from "../helper/StiInputTextItem";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-helper.service";
import * as i3 from "../services/sti-editable-content.service";
import * as i4 from "@angular/forms";
export class StiInputTextComponent {
    constructor(model, helper, editableService) {
        this.model = model;
        this.helper = helper;
        this.editableService = editableService;
    }
    get needToFill() {
        return this.element.required && !this.value && this.model.hasEmptyReuiredFields;
    }
    get value() {
        return this.helper.getProperty(this.element, this.property);
    }
    set value(val) {
        this.helper.setProperty(this.element, this.property, val);
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    disableDrag(event) {
        let t = null;
        this.model.canDrag = false;
    }
    borderWidth() {
        return `${this.element.borderWeight}px`;
    }
    inFocus() {
        setTimeout(() => {
            let editableContent = new StiInputTextItem(this.element.text, this.element.font, this.element.textColor, this.element.backgroundColor, this.element.contentAlignment);
            editableContent.element = this.element;
            this.editableService.editableContent = editableContent;
            this.editableService.usedElement = this.element;
        }, 0);
    }
    lostFocus() {
        if (this.model.selectedComponent?.element != this.element) {
            this.editableService.editableContent = null;
        }
    }
    ngOnInit() { }
}
StiInputTextComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiInputTextComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component });
StiInputTextComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiInputTextComponent, selector: "sti-input-text-component", inputs: { element: "element", property: "property", tabIndex: "tabIndex" }, ngImport: i0, template: `
    <input
      type="text"
      [style]="element?.htmlStyle()"
      [style.color]="element?.textColor.toHtmlColor()"
      [style.background-color]="element?.backgroundColor.toHtmlColor()"
      [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
      [style.border-width]="borderWidth()"
      autocomplete="disabled"
      spellcheck="false"
      [style.align-self]="'center'"
      [attr.maxlength]="element['useRange'] ? element['maximum'] : '255'"
      tooltipPosition="bottom"
      showDelay="500"
      [required]="element?.required"
      [readonly]="element?.readOnly"
      [tabIndex]="tabIndex"
      [(ngModel)]="value"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
      (focus)="inFocus()"
      (blur)="lostFocus()"
    />
  `, isInline: true, styles: ["input{height:-moz-fit-content;height:fit-content;padding:3px 4px;width:100%;border:1px solid rgb(198,198,198)}input:hover{border-color:#a3bde3!important}input:focus{outline:none;border:1px solid rgb(163,189,227)}\n"], dependencies: [{ kind: "directive", type: i4.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.RequiredValidator, selector: ":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]", inputs: ["required"] }, { kind: "directive", type: i4.MaxLengthValidator, selector: "[maxlength][formControlName],[maxlength][formControl],[maxlength][ngModel]", inputs: ["maxlength"] }, { kind: "directive", type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiInputTextComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-input-text-component", template: `
    <input
      type="text"
      [style]="element?.htmlStyle()"
      [style.color]="element?.textColor.toHtmlColor()"
      [style.background-color]="element?.backgroundColor.toHtmlColor()"
      [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
      [style.border-width]="borderWidth()"
      autocomplete="disabled"
      spellcheck="false"
      [style.align-self]="'center'"
      [attr.maxlength]="element['useRange'] ? element['maximum'] : '255'"
      tooltipPosition="bottom"
      showDelay="500"
      [required]="element?.required"
      [readonly]="element?.readOnly"
      [tabIndex]="tabIndex"
      [(ngModel)]="value"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
      (focus)="inFocus()"
      (blur)="lostFocus()"
    />
  `, styles: ["input{height:-moz-fit-content;height:fit-content;padding:3px 4px;width:100%;border:1px solid rgb(198,198,198)}input:hover{border-color:#a3bde3!important}input:focus{outline:none;border:1px solid rgb(163,189,227)}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiEditableContentService }]; }, propDecorators: { element: [{
                type: Input
            }], property: [{
                type: Input
            }], tabIndex: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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