import { Component, Input, ViewChild } from "@angular/core";
import { StiLabelAlignment } from "../../system/enums";
import { StiBorderArea } from "../../properties/StiBorderArea";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../sti-tooltip/sti-tooltip.directive";
export class StiImageComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    get align() {
        return "start";
    }
    get image() {
        return "url(" + this.element.image + ")";
    }
    get imageWidth() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top && this.element["label"]["value"]) {
                return this.element.width - this.element.label.width - this.element.padding.right - this.element.padding.left;
            }
            else {
                return this.element.width - this.element.padding.right - this.element.padding.left /*borderWidth */;
            }
        }
    }
    get imageHeight() {
        return this.element.canvasHeight;
    }
    get borderArea() {
        if (!this.isClone) {
            let borderArea = new StiBorderArea();
            borderArea.top =
                this.ref?.nativeElement?.offsetTop -
                    (this.element.label.alignment != StiLabelAlignment.Top ? this.element.padding.top : 0);
            borderArea.left = this.ref?.nativeElement?.offsetLeft;
            borderArea.width = this.ref?.nativeElement?.offsetWidth - this.element.padding.left - this.element.padding.right;
            borderArea.height = this.ref?.nativeElement?.offsetHeight;
            borderArea.border = this.element.border;
            return borderArea;
        }
    }
    onFileSelected(event) {
        if (event.files && event.files[0]) {
            var reader = new FileReader();
            reader.onload = (e) => {
                this.element.image = e.target.result;
            };
            reader.readAsDataURL(event.files[0]);
        }
    }
    openLink() {
        if (this.element.hyperlink.length > 0 && this.model.isPreviewMode) {
            window.open(this.element.hyperlink, "_blank");
        }
    }
    get backgroundSize() {
        if (this.element.preserveAspectRatio) {
            return "contain";
        }
        else {
            return this.imageWidth + "px " + this.imageHeight + "px";
        }
    }
    ngAfterViewInit() {
        if (!this.isClone) {
            this.element.element = this.ref?.nativeElement;
        }
    }
    ngOnInit() { }
}
StiImageComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiImageComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiImageComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiImageComponent, selector: "sti-image-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "ref", first: true, predicate: ["ref"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" [borderArea]="borderArea" [isClone]="isClone" class="sti-image">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'100%'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.height]="'100%'">
          <div
            #ref
            (dblclick)="!model.isPreviewMode ? inputFile.click() : ''"
            (click)="openLink()"
            class="image"
            [style.align-self]="'center'"
            [style.width]="'100%'"
            [style.height]="'100%'"
            [style.min-width.px]="isClone ? 30 : 0"
            [style.min-height.px]="isClone ? 30 : 0"
            [style.background-image]="image"
            [style.background-position]="element.preserveAspectRatio ? '' : 'center'"
            [style.background-size]="backgroundSize"
            [style.background-repeat]="image ? 'no-repeat' : ''"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
            [style.cursor]="element.hyperlink.length > 0 ? 'pointer' : model.isPreviewMode ? 'default' : 'move'"
          ></div>
          <input
            type="file"
            [style.display]="'none'"
            accept=".jpg, .jpeg, .png"
            (change)="onFileSelected($event.target)"
            #inputFile
          />
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-image .image{position:relative}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiImageComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-image-component", template: ` <sti-component [element]="element" [borderArea]="borderArea" [isClone]="isClone" class="sti-image">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'100%'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.height]="'100%'">
          <div
            #ref
            (dblclick)="!model.isPreviewMode ? inputFile.click() : ''"
            (click)="openLink()"
            class="image"
            [style.align-self]="'center'"
            [style.width]="'100%'"
            [style.height]="'100%'"
            [style.min-width.px]="isClone ? 30 : 0"
            [style.min-height.px]="isClone ? 30 : 0"
            [style.background-image]="image"
            [style.background-position]="element.preserveAspectRatio ? '' : 'center'"
            [style.background-size]="backgroundSize"
            [style.background-repeat]="image ? 'no-repeat' : ''"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
            [style.cursor]="element.hyperlink.length > 0 ? 'pointer' : model.isPreviewMode ? 'default' : 'move'"
          ></div>
          <input
            type="file"
            [style.display]="'none'"
            accept=".jpg, .jpeg, .png"
            (change)="onFileSelected($event.target)"
            #inputFile
          />
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-image .image{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }], ref: [{
                type: ViewChild,
                args: ["ref"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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