import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/mouse.service";
import * as i4 from "../../services/sti-form-checker.service";
import * as i5 from "@angular/common";
import * as i6 from "./sti-form-checker-item.component";
export class StiFormCheckerComponent {
    constructor(model, loc, mouseService, formCheckerService) {
        this.model = model;
        this.loc = loc;
        this.mouseService = mouseService;
        this.formCheckerService = formCheckerService;
        this.isDragging = false;
    }
    ngOnDestroy() {
        this.mouseMoveSubscription?.unsubscribe();
        this.mouseUpSubscription?.unsubscribe();
    }
    startDrag(event) {
        this.startX = event.clientX;
        this.startY = event.clientY;
        this.startComponentX = this.formCheckerService.componentX;
        this.startComponentY = this.formCheckerService.componentY;
        this.isDragging = true;
    }
    showInfo() { }
    onMouseMove(event) {
        if (this.isDragging) {
            let deltaX = event.clientX - this.startX;
            let deltaY = event.clientY - this.startY;
            if (this.startComponentX + deltaX < 0) {
                this.formCheckerService.componentX = 0;
            }
            else if (this.startComponentX + deltaX > window.innerWidth - this.formCheckerService.componentWidth) {
                this.formCheckerService.componentX = window.innerWidth - this.formCheckerService.componentWidth;
            }
            else {
                this.formCheckerService.componentX = this.startComponentX + deltaX;
            }
            if (this.startComponentY + deltaY < 0) {
                this.formCheckerService.componentY = 0;
            }
            else if (this.startComponentY + deltaY > window.innerHeight - this.formCheckerService.componentHeight) {
                this.formCheckerService.componentY = window.innerHeight - this.formCheckerService.componentHeight;
            }
            else {
                this.formCheckerService.componentY = this.startComponentY + deltaY;
            }
        }
    }
    ngOnInit() {
        this.formCheckerService.getButtonNames();
        this.formCheckerService.componentX = (window.innerWidth - this.formCheckerService.componentWidth) / 2;
        this.formCheckerService.componentY = (window.innerHeight - this.formCheckerService.componentHeight) / 2;
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.isDragging = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
    }
}
StiFormCheckerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormCheckerComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiMouseService }, { token: i4.StiFormCheckerService }], target: i0.ɵɵFactoryTarget.Component });
StiFormCheckerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFormCheckerComponent, selector: "sti-form-checker", ngImport: i0, template: `<div
    class="form-checker-container"
    [style.left.px]="formCheckerService.componentX"
    [style.top.px]="formCheckerService.componentY"
  >
    <div class="header-navigation" (mousedown)="startDrag($event)">
      <!-- <span>{{ loc.get2("FormTitles", "FormsChecker") }}</span> -->
      <span>{{ "Form Checker" }}</span>
      <!-- <div class="nav-button" (click)="showInfo()"><img [src]="model.getImage('images.Other.HelpIcon.png')" /></div> -->
      <div class="nav-button" (click)="formCheckerService.showFormCheckerWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="content">
      <sti-form-checker-item
        *ngFor="let item of formCheckerService.formMessages; let i = index"
        [index]="i + 1"
        [item]="item"
      ></sti-form-checker-item>
    </div>
  </div>`, isInline: true, styles: [".content{flex:1;overflow-x:hidden;overflow-y:auto}.form-checker-container{position:absolute;font-size:13px;font-family:Arial;color:var(--text-color);min-height:480px;width:700px;border-radius:5px;left:calc(50% - 350px);top:calc(50% - 250px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;box-shadow:0 0 7px #0000004d;z-index:999;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;-webkit-touch-callout:none;-webkit-user-select:none}.header-navigation{display:flex;height:40px;align-items:center;padding-left:15px;padding-right:5px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;color:#fff;-webkit-user-select:none}.header-navigation span{width:100%;font-size:17px;-webkit-user-select:none;cursor:default}.nav-button{height:24px;width:28px;border-radius:3px;display:flex;align-items:center;justify-content:center;align-self:start;margin-top:5px}.nav-button:hover{background-color:#d3d3d3}.nav-button img{height:16px;width:16px;filter:brightness(0) invert(1)}\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i6.StiFormCheckerItemComponent, selector: "sti-form-checker-item", inputs: ["item", "index"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormCheckerComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-form-checker", template: `<div
    class="form-checker-container"
    [style.left.px]="formCheckerService.componentX"
    [style.top.px]="formCheckerService.componentY"
  >
    <div class="header-navigation" (mousedown)="startDrag($event)">
      <!-- <span>{{ loc.get2("FormTitles", "FormsChecker") }}</span> -->
      <span>{{ "Form Checker" }}</span>
      <!-- <div class="nav-button" (click)="showInfo()"><img [src]="model.getImage('images.Other.HelpIcon.png')" /></div> -->
      <div class="nav-button" (click)="formCheckerService.showFormCheckerWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="content">
      <sti-form-checker-item
        *ngFor="let item of formCheckerService.formMessages; let i = index"
        [index]="i + 1"
        [item]="item"
      ></sti-form-checker-item>
    </div>
  </div>`, styles: [".content{flex:1;overflow-x:hidden;overflow-y:auto}.form-checker-container{position:absolute;font-size:13px;font-family:Arial;color:var(--text-color);min-height:480px;width:700px;border-radius:5px;left:calc(50% - 350px);top:calc(50% - 250px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;box-shadow:0 0 7px #0000004d;z-index:999;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;-webkit-touch-callout:none;-webkit-user-select:none}.header-navigation{display:flex;height:40px;align-items:center;padding-left:15px;padding-right:5px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;color:#fff;-webkit-user-select:none}.header-navigation span{width:100%;font-size:17px;-webkit-user-select:none;cursor:default}.nav-button{height:24px;width:28px;border-radius:3px;display:flex;align-items:center;justify-content:center;align-self:start;margin-top:5px}.nav-button:hover{background-color:#d3d3d3}.nav-button img{height:16px;width:16px;filter:brightness(0) invert(1)}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiMouseService }, { type: i4.StiFormCheckerService }]; } });
//# sourceMappingURL=data:application/json;base64,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