import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-form-checker.service";
import * as i4 from "../../services/http-client.service";
export class StiFormCheckerItemComponent {
    constructor(model, loc, formCheckerService, httpService) {
        this.model = model;
        this.loc = loc;
        this.formCheckerService = formCheckerService;
        this.httpService = httpService;
    }
    save() {
        let currentForm = this.model.form.saveToReportJsonObject().serialize();
        if (this.model.isWebView) {
            this.httpService
                .post("", { action: "InterfaceEvent", event: "SaveToCloudButtonClickForDesigner", data: { form: currentForm } })
                .subscribe(() => { });
        }
        else {
            this.httpService
                .post("", { action: "InterfaceEvent", event: "SaveToCloudButtonClick", data: { form: currentForm } })
                .subscribe(() => { });
        }
        // this.model.showSaveDialogFromCloud = true;
    }
    edit() {
        this.formCheckerService.showFormCheckerWindow = false;
    }
    ignore() {
        // this.formCheckerService.formMessages.splice(this.index - 1, 1);
        this.formCheckerService.showFormCheckerWindow = false;
        this.model.formEvents.next({ name: this.formCheckerService.currentPressedButton });
    }
    ngOnInit() { }
}
StiFormCheckerItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormCheckerItemComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiFormCheckerService }, { token: i4.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Component });
StiFormCheckerItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFormCheckerItemComponent, selector: "sti-form-checker-item", inputs: { item: "item", index: "index" }, ngImport: i0, template: ` <div class="form-checker-item">
    <div class="item-container">
      <div class="item-icon">
        <img [src]="model.getImage('images.Form_Checker.Warning32.png')" />
      </div>
      <div class="item-content">
        <div class="item-label">{{ index + "." }}{{ item.label }}</div>
        <div class="item-message">{{ item.content.replace("{0}", formCheckerService.buttonNames) }}</div>
      </div>
    </div>
    <div class="item-navigation">
      <div class="button" (click)="save()">{{ "Save to cloud" }}</div>
      <!-- <div class="button" (click)="edit()">{{ loc.get2("MainMenu", "menuEditEdit") }}</div>
      <div class="button" (click)="ignore()">{{ loc.get2("PropertyEnum", "DialogResultIgnore") }}</div> -->
    </div>
  </div>`, isInline: true, styles: [".item-navigation{display:flex;justify-content:end;margin:5px 0}.form-checker-item{padding-top:10px;border-bottom:1px dashed lightgray;margin:0 10px;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;-webkit-touch-callout:none;-webkit-user-select:none}.button{background-color:#ddd;height:24px;min-width:24px;padding:0 10px;border-radius:3px;color:#444;margin:5px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:#d5d5d5}.item-icon{display:flex;align-items:center}.item-icon img{width:32px;height:32px;margin-right:12px}.item-container{display:flex}.item-content{font-family:Arial;color:#444;font-size:12px}.item-label{font-weight:700;margin-top:5px}.item-message{margin-top:15px}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormCheckerItemComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-form-checker-item", template: ` <div class="form-checker-item">
    <div class="item-container">
      <div class="item-icon">
        <img [src]="model.getImage('images.Form_Checker.Warning32.png')" />
      </div>
      <div class="item-content">
        <div class="item-label">{{ index + "." }}{{ item.label }}</div>
        <div class="item-message">{{ item.content.replace("{0}", formCheckerService.buttonNames) }}</div>
      </div>
    </div>
    <div class="item-navigation">
      <div class="button" (click)="save()">{{ "Save to cloud" }}</div>
      <!-- <div class="button" (click)="edit()">{{ loc.get2("MainMenu", "menuEditEdit") }}</div>
      <div class="button" (click)="ignore()">{{ loc.get2("PropertyEnum", "DialogResultIgnore") }}</div> -->
    </div>
  </div>`, styles: [".item-navigation{display:flex;justify-content:end;margin:5px 0}.form-checker-item{padding-top:10px;border-bottom:1px dashed lightgray;margin:0 10px;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;-webkit-touch-callout:none;-webkit-user-select:none}.button{background-color:#ddd;height:24px;min-width:24px;padding:0 10px;border-radius:3px;color:#444;margin:5px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:#d5d5d5}.item-icon{display:flex;align-items:center}.item-icon img{width:32px;height:32px;margin-right:12px}.item-container{display:flex}.item-content{font-family:Arial;color:#444;font-size:12px}.item-label{font-weight:700;margin-top:5px}.item-message{margin-top:15px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiFormCheckerService }, { type: i4.StiHttpClientService }]; }, propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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