import { Component } from "@angular/core";
import { StiLocalizationService } from "../../services/sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/http-client.service";
import * as i3 from "../../services/sti-export.service";
export class StiFileSaveDialogComponent {
    constructor(model, httpService, exportService) {
        this.model = model;
        this.httpService = httpService;
        this.exportService = exportService;
        this.designer = StiLocalizationService.get("Permissions", "ItemForms");
        this.yes = StiLocalizationService.get("PropertyMain", "Yes");
        this.no = StiLocalizationService.get("PropertyMain", "No");
        this.cancel = StiLocalizationService.get("PropertyMain", "Cancel");
    }
    get question() {
        return this.model.showSaveDialog
            ? StiLocalizationService.get("Questions", "qnSaveChanges").replace("{0}", StiLocalizationService.get("Dialogs", "StiForm"))
            : "Would you like to save the form to Stimulsoft Cloud?";
    }
    close(option) {
        if (this.model.showSaveDialog) {
            this.model.showSaveDialog = false;
            if (option === "No") {
                if (this.model.saveDialogFromNew) {
                    this.model.interfaceEvent.next({ name: "FormNew" });
                }
                else if (this.model.saveDialogFromOpen) {
                    this.model.interfaceEvent.next({ name: "FormOpen" });
                }
            }
        }
        else {
            this.model.showSaveDialogFromCloud = false;
            if (option === "No") {
                this.exportService.showModalWindow = !this.exportService.showModalWindow;
            }
        }
    }
    save() {
        if (this.model.showSaveDialog) {
            this.model.attachedFiles = [];
            this.model.saveLastFormState();
            this.model.interfaceEvent.next({ name: "FormSave", data: { form: this.model.form, name: this.model.fileName } });
            this.model.showSaveDialog = false;
            if (this.model.saveDialogFromNew) {
                this.model.interfaceEvent.next({ name: "FormNew" });
            }
            else if (this.model.saveDialogFromOpen) {
                this.model.interfaceEvent.next({ name: "FormOpen" });
            }
        }
        else {
            let currentForm = this.model.form.saveToReportJsonObject().serialize();
            this.httpService
                .post("", { action: "InterfaceEvent", event: "SaveToCloudButtonClick", data: { form: currentForm } })
                .subscribe(() => { });
            this.model.showSaveDialogFromCloud = false;
        }
    }
    ngOnInit() { }
}
StiFileSaveDialogComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileSaveDialogComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }, { token: i3.StiExportService }], target: i0.ɵɵFactoryTarget.Component });
StiFileSaveDialogComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFileSaveDialogComponent, selector: "sti-file-save-dialog", ngImport: i0, template: `<div class="save-dialog">
    <div class="save-dialog-navigation">
      <label>{{ designer }}</label>
      <div class="close-button" (click)="close('Cancel')">
        <img [src]="model.getImage('images.Other.CloseForm.png')" alt="" />
      </div>
    </div>
    <div class="text-content">
      <img [src]="model.getImage('images.Other.Question.png')" />
      <span>{{ question }}</span>
    </div>
    <div class="buttons-container">
      <div class="button accept" (click)="save()">
        <span>{{ yes }}</span>
      </div>
      <div class="button cancel" (click)="close('No')">
        <span>{{ no }}</span>
      </div>
      <div class="button cancel" (click)="close('Cancel')" [style.margin-right.px]="10">
        <span>{{ cancel }}</span>
      </div>
    </div>
  </div>`, isInline: true, styles: [".save-dialog{width:500px;height:150px;position:absolute;z-index:9999999;left:calc(50% - 250px);top:calc(50% - 70px);background-color:#fff;cursor:default;box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);display:flex;border-top-right-radius:5px;border-top-left-radius:5px;flex-direction:column;color:#444}.save-dialog-navigation{height:30px;width:100%;display:flex;align-items:center;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none}.text-content{flex:1;padding:20px 10px;display:flex;align-items:center}.text-content span{font-size:13px;margin:12px 0}.text-content img{margin-left:10px;margin-right:10px;width:32px;height:32px}.close-button{width:28px;height:28px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}label{font-size:13px;color:#fff;font-family:Arial;flex:1;display:flex;align-items:center;margin-left:10px}.buttons-container{height:50px;width:100%;display:flex;align-items:center;justify-content:flex-end}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px}span{height:100%;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileSaveDialogComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-save-dialog", template: `<div class="save-dialog">
    <div class="save-dialog-navigation">
      <label>{{ designer }}</label>
      <div class="close-button" (click)="close('Cancel')">
        <img [src]="model.getImage('images.Other.CloseForm.png')" alt="" />
      </div>
    </div>
    <div class="text-content">
      <img [src]="model.getImage('images.Other.Question.png')" />
      <span>{{ question }}</span>
    </div>
    <div class="buttons-container">
      <div class="button accept" (click)="save()">
        <span>{{ yes }}</span>
      </div>
      <div class="button cancel" (click)="close('No')">
        <span>{{ no }}</span>
      </div>
      <div class="button cancel" (click)="close('Cancel')" [style.margin-right.px]="10">
        <span>{{ cancel }}</span>
      </div>
    </div>
  </div>`, styles: [".save-dialog{width:500px;height:150px;position:absolute;z-index:9999999;left:calc(50% - 250px);top:calc(50% - 70px);background-color:#fff;cursor:default;box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);display:flex;border-top-right-radius:5px;border-top-left-radius:5px;flex-direction:column;color:#444}.save-dialog-navigation{height:30px;width:100%;display:flex;align-items:center;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none}.text-content{flex:1;padding:20px 10px;display:flex;align-items:center}.text-content span{font-size:13px;margin:12px 0}.text-content img{margin-left:10px;margin-right:10px;width:32px;height:32px}.close-button{width:28px;height:28px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}label{font-size:13px;color:#fff;font-family:Arial;flex:1;display:flex;align-items:center;margin-left:10px}.buttons-container{height:50px;width:100%;display:flex;align-items:center;justify-content:flex-end}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px}span{height:100%;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }, { type: i3.StiExportService }]; } });
//# sourceMappingURL=data:application/json;base64,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