import { Component, } from "@angular/core";
import { StiLocalizationService } from "../../services/sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "@angular/forms";
export class StiFileSaveContentComponent {
    constructor(model, helper, loc, cdr) {
        this.model = model;
        this.helper = helper;
        this.loc = loc;
        this.cdr = cdr;
        this.name = StiLocalizationService.get("PropertyMain", "Name");
        this.save = StiLocalizationService.get("PropertyMain", "Save");
        this.cancel = StiLocalizationService.get("PropertyMain", "Cancel");
        this.browse = StiLocalizationService.get("ReportOpen", "Browse");
        this.isSmallWindow = false;
    }
    ngAfterViewInit() {
        let element = document.getElementsByClassName("file-save-container")[0];
        let isSmall = element ? element.clientWidth < 450 : window.innerWidth < 450 + 170;
        if (isSmall != this.isSmallWindow) {
            this.isSmallWindow = isSmall;
            this.cdr.detach();
            setTimeout(() => {
                this.cdr.reattach();
            });
        }
    }
    close() {
        this.model.changeFileMenuState();
    }
    saveFile() {
        this.model.saveLastFormState();
        this.model.changeFileMenuState();
        this.model.interfaceEvent.next({ name: "FormSaveAs", data: { form: this.model.form, name: this.model.fileName } });
    }
    ngOnInit() { }
}
StiFileSaveContentComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileSaveContentComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiLocalizationService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
StiFileSaveContentComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFileSaveContentComponent, selector: "sti-file-save-content", ngImport: i0, template: `
    <div class="{{ isSmallWindow ? 'small-file-save-container' : 'file-save-container' }}">
      <div class="{{ isSmallWindow ? 'small-file-save-navigation' : 'file-save-navigation' }}">
        <div class="navigation-item">
          <div class="navigation-icon">
            <img [src]="model.getImage('images.Other.FileMenu.Open.png')" alt="" />
          </div>
          <span>{{ browse }}</span>
        </div>
      </div>
      <div class="content">
        <div class="{{ isSmallWindow ? 'small-save-container' : 'save-container' }}">
          <!-- <div class="save-container-navigation">
            <label>{{
              model.currentSelectedFileOption != "SaveAs"
                ? loc.getP(model.currentSelectedFileOption)
                : loc.get2("MainMenu", "menuFileSaveAs").replace("...", "")
            }}</label>
            <div class="close-button" (click)="close()">
              <img [src]="model.getImage('images.Other.ClosePanel.png')" alt="" />
            </div>
          </div> -->
          <div class="save-input">
            <span>{{ name }}</span>
            <input type="text" spellcheck="false" [(ngModel)]="model.fileName" />
          </div>
          <div class="save-buttons-container">
            <div class="button accept" (click)="saveFile()">
              <span>{{ save }}</span>
            </div>
            <!-- <div class="button cancel" (click)="close()">
              <span>{{ cancel }}</span>
            </div> -->
          </div>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".content{width:100%}.file-save-container{height:100%;width:100%;display:flex;padding:10px 30px}.small-file-save-container{height:100%;width:100%;display:flex;padding:10px 30px;flex-direction:column;align-items:center;border-right:1px solid rgb(218,218,218)}.file-save-navigation{min-width:150px;width:50%;max-width:260px;padding-right:10px;border-right:1px solid rgb(218,218,218)}.small-file-save-navigation{min-width:150px;width:100%;max-width:260px}.navigation-item{display:flex;height:50px;min-width:130px;background-color:#e5e5e5;border-radius:3px}.navigation-item:hover{background-color:#dadada}.navigation-icon{padding:0 10px;display:flex;align-items:center;justify-content:center}.save-container{max-width:500px;height:50px;background-color:#fff;margin-left:10px;display:flex;align-items:center}.small-save-container{max-width:500px;height:50px;background-color:#fff;margin-top:20px;display:flex;align-items:center}img{width:32px;height:32px}span{height:100%;padding:0 20px 0 10px;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}label{font-size:13px;font-weight:700;color:#19478a;font-family:Arial;flex:1;padding-left:15px}.save-container-navigation{height:30px;width:100%;display:flex;align-items:center}.close-button{width:28px;height:28px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{width:16px;height:16px}.save-input{display:flex;align-items:center;flex:1;padding:0 10px}.save-input input{width:100%;height:24px;border:1px solid rgb(171,171,171);background-color:#fff;color:#444;font-size:12px;border-radius:3px;padding:0 0 0 4px;outline:none}.save-buttons-container{height:58px;width:-moz-fit-content;width:fit-content;display:flex;align-items:center;justify-content:flex-end}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 10px}.button span{margin:0;padding:0}.accept{background-color:#19478a;color:#fff;margin-right:0}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"], dependencies: [{ kind: "directive", type: i4.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileSaveContentComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-save-content", template: `
    <div class="{{ isSmallWindow ? 'small-file-save-container' : 'file-save-container' }}">
      <div class="{{ isSmallWindow ? 'small-file-save-navigation' : 'file-save-navigation' }}">
        <div class="navigation-item">
          <div class="navigation-icon">
            <img [src]="model.getImage('images.Other.FileMenu.Open.png')" alt="" />
          </div>
          <span>{{ browse }}</span>
        </div>
      </div>
      <div class="content">
        <div class="{{ isSmallWindow ? 'small-save-container' : 'save-container' }}">
          <!-- <div class="save-container-navigation">
            <label>{{
              model.currentSelectedFileOption != "SaveAs"
                ? loc.getP(model.currentSelectedFileOption)
                : loc.get2("MainMenu", "menuFileSaveAs").replace("...", "")
            }}</label>
            <div class="close-button" (click)="close()">
              <img [src]="model.getImage('images.Other.ClosePanel.png')" alt="" />
            </div>
          </div> -->
          <div class="save-input">
            <span>{{ name }}</span>
            <input type="text" spellcheck="false" [(ngModel)]="model.fileName" />
          </div>
          <div class="save-buttons-container">
            <div class="button accept" (click)="saveFile()">
              <span>{{ save }}</span>
            </div>
            <!-- <div class="button cancel" (click)="close()">
              <span>{{ cancel }}</span>
            </div> -->
          </div>
        </div>
      </div>
    </div>
  `, styles: [".content{width:100%}.file-save-container{height:100%;width:100%;display:flex;padding:10px 30px}.small-file-save-container{height:100%;width:100%;display:flex;padding:10px 30px;flex-direction:column;align-items:center;border-right:1px solid rgb(218,218,218)}.file-save-navigation{min-width:150px;width:50%;max-width:260px;padding-right:10px;border-right:1px solid rgb(218,218,218)}.small-file-save-navigation{min-width:150px;width:100%;max-width:260px}.navigation-item{display:flex;height:50px;min-width:130px;background-color:#e5e5e5;border-radius:3px}.navigation-item:hover{background-color:#dadada}.navigation-icon{padding:0 10px;display:flex;align-items:center;justify-content:center}.save-container{max-width:500px;height:50px;background-color:#fff;margin-left:10px;display:flex;align-items:center}.small-save-container{max-width:500px;height:50px;background-color:#fff;margin-top:20px;display:flex;align-items:center}img{width:32px;height:32px}span{height:100%;padding:0 20px 0 10px;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}label{font-size:13px;font-weight:700;color:#19478a;font-family:Arial;flex:1;padding-left:15px}.save-container-navigation{height:30px;width:100%;display:flex;align-items:center}.close-button{width:28px;height:28px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{width:16px;height:16px}.save-input{display:flex;align-items:center;flex:1;padding:0 10px}.save-input input{width:100%;height:24px;border:1px solid rgb(171,171,171);background-color:#fff;color:#444;font-size:12px;border-radius:3px;padding:0 0 0 4px;outline:none}.save-buttons-container{height:58px;width:-moz-fit-content;width:fit-content;display:flex;align-items:center;justify-content:flex-end}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 10px}.button span{margin:0;padding:0}.accept{background-color:#19478a;color:#fff;margin-right:0}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiLocalizationService }, { type: i0.ChangeDetectorRef }]; } });
//# sourceMappingURL=data:application/json;base64,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