import { Component } from "@angular/core";
import { StiLocalizationService } from "../../services/sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-undo-service";
export class StiFileOpenContentComponent {
    constructor(model, undoService) {
        this.model = model;
        this.undoService = undoService;
        this.browse = StiLocalizationService.get("ReportOpen", "Browse");
    }
    open() {
        this.model.attachedFiles = [];
        this.model.changeFileMenuState();
        if (this.model.currentFormState &&
            this.model.currentFormState !== this.model.lastSavedFormState &&
            this.undoService.undos.length >= 2) {
            this.model.showSaveDialog = true;
            this.model.saveDialogFromNew = false;
            this.model.saveDialogFromOpen = true;
        }
        else {
            this.model.interfaceEvent.next({ name: "FormOpen" });
        }
    }
    ngOnInit() { }
}
StiFileOpenContentComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileOpenContentComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiUndoService }], target: i0.ɵɵFactoryTarget.Component });
StiFileOpenContentComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFileOpenContentComponent, selector: "sti-file-open-content", ngImport: i0, template: `
    <div class="file-open-container">
      <div class="file-open-navigation">
        <div class="navigation-item" (click)="open()">
          <div class="navigation-icon">
            <img [src]="model.getImage('images.Other.FileMenu.Open.png')" alt="" />
          </div>
          <span>{{ browse }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".file-open-container{height:100%;width:100%;display:flex;padding:10px 30px}.file-open-navigation{width:260px;border-right:1px solid rgb(218,218,218)}.navigation-item{display:flex;height:50px;width:250px;background-color:#fff;border-radius:3px}.navigation-item:hover{background-color:#dadada}.navigation-icon{padding:0 10px;display:flex;align-items:center;justify-content:center}img{width:32px;height:32px}span{height:100%;padding:0 20px 0 10px;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileOpenContentComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-open-content", template: `
    <div class="file-open-container">
      <div class="file-open-navigation">
        <div class="navigation-item" (click)="open()">
          <div class="navigation-icon">
            <img [src]="model.getImage('images.Other.FileMenu.Open.png')" alt="" />
          </div>
          <span>{{ browse }}</span>
        </div>
      </div>
    </div>
  `, styles: [".file-open-container{height:100%;width:100%;display:flex;padding:10px 30px}.file-open-navigation{width:260px;border-right:1px solid rgb(218,218,218)}.navigation-item{display:flex;height:50px;width:250px;background-color:#fff;border-radius:3px}.navigation-item:hover{background-color:#dadada}.navigation-icon{padding:0 10px;display:flex;align-items:center;justify-content:center}img{width:32px;height:32px}span{height:100%;padding:0 20px 0 10px;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiUndoService }]; } });
//# sourceMappingURL=data:application/json;base64,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