import { Component } from "@angular/core";
import { StiForm } from "../../elements/StiForm";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-undo-service";
export class StiFileNewContentComponent {
    constructor(model, undoService) {
        this.model = model;
        this.undoService = undoService;
        this.blankForm = "Blank Form";
    }
    createNew() {
        this.model.attachedFiles = [];
        this.model.changeFileMenuState();
        if (this.model.currentFormState &&
            this.model.currentFormState !== this.model.lastSavedFormState &&
            this.undoService.undos.length > 1) {
            this.model.showSaveDialog = true;
            this.model.saveDialogFromNew = true;
            this.model.saveDialogFromOpen = false;
        }
        else {
            let form = new StiForm();
            this.model.form = form;
        }
        this.model.formEvents.next({ name: "New" });
    }
    ngOnInit() { }
}
StiFileNewContentComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileNewContentComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiUndoService }], target: i0.ɵɵFactoryTarget.Component });
StiFileNewContentComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFileNewContentComponent, selector: "sti-file-new-content", ngImport: i0, template: `
    <div class="file-new-container">
      <div class="file-new-navigation" (click)="createNew()">
        <div>
          <img [src]="model.getImage('images.Other.BlankReport.png')" alt="" />
        </div>
        <span>{{ blankForm }} </span>
      </div>
      <div class="divider"></div>
    </div>
  `, isInline: true, styles: [".file-new-container{width:100%;height:100%;padding-left:20px;background-color:#fff;-webkit-user-select:none}.file-new-navigation{height:250px;width:200px;display:flex;flex-direction:column;justify-content:center;align-items:center}.file-new-navigation:hover{background-color:#dadada}.file-new-navigation img{height:203px;width:144px}.divider{margin:20px 0;height:1px;width:calc(100% - 20px);background-color:#c6c6c6}img{margin:12px 12px 0}span{height:25px;font-family:Arial;font-size:12px;display:flex;align-items:flex-end}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileNewContentComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-new-content", template: `
    <div class="file-new-container">
      <div class="file-new-navigation" (click)="createNew()">
        <div>
          <img [src]="model.getImage('images.Other.BlankReport.png')" alt="" />
        </div>
        <span>{{ blankForm }} </span>
      </div>
      <div class="divider"></div>
    </div>
  `, styles: [".file-new-container{width:100%;height:100%;padding-left:20px;background-color:#fff;-webkit-user-select:none}.file-new-navigation{height:250px;width:200px;display:flex;flex-direction:column;justify-content:center;align-items:center}.file-new-navigation:hover{background-color:#dadada}.file-new-navigation img{height:203px;width:144px}.divider{margin:20px 0;height:1px;width:calc(100% - 20px);background-color:#c6c6c6}img{margin:12px 12px 0}span{height:25px;font-family:Arial;font-size:12px;display:flex;align-items:flex-end}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiUndoService }]; } });
//# sourceMappingURL=data:application/json;base64,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