import { Component } from "@angular/core";
import { fileNavigationAnimation } from "../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "@angular/common";
export class StiFileMenuNavigationComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    setEvent(name) {
        if (name == "About") {
            this.model.changeFileMenuState();
            this.model.showAboutWindow = true;
        }
        else if (name == "Save") {
            this.model.saveLastFormState();
            this.model.changeFileMenuState();
            this.model.interfaceEvent.next({ name: "FormSave", data: { form: this.model.form, name: this.model.fileName } });
        }
        else if (name == "SaveAs" || name == "Open" || name == "New") {
            this.model.currentSelectedFileOption = name;
        }
    }
    ngOnInit() { }
}
StiFileMenuNavigationComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileMenuNavigationComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }], target: i0.ɵɵFactoryTarget.Component });
StiFileMenuNavigationComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFileMenuNavigationComponent, selector: "sti-file-menu-navigation", ngImport: i0, template: `<div [@fileNavigation]="model.showFileMenuNavigation ? 'in' : 'out'" class="file-navigation">
    <div class="back-button-container">
      <div class="back-button" (click)="model.changeFileMenuState()">
        <img [src]="model.getImage('images.Other.Back.png')" />
      </div>
    </div>
    <div
      class="option {{ item.name == 'Divider' ? 'divider-container' : '' }} {{
        item.name == model.currentSelectedFileOption ? 'current' : ''
      }}"
      *ngFor="let item of helper.fileMenuItems"
      (click)="setEvent(item.name)"
    >
      <div class="item" *ngIf="item.name != 'Divider'">
        <div class="image-container" [style.min-height.px]="36">
          <img *ngIf="item.image" [src]="model.getImage(item.image)" />
        </div>
        <span>{{ item.caption }}</span>
      </div>
      <div class="divider" *ngIf="item.name == 'Divider'"></div>
    </div>
  </div>`, isInline: true, styles: [".file-navigation{-webkit-user-select:none;width:0px;height:inherit;background-color:#19478a;z-index:99999999;position:absolute;top:0;left:0}.back-button{padding:20px 0 0 9px}.back-button img{width:32px;height:32px;opacity:1}.back-button img:hover{opacity:.7}.divider{height:1px;width:100%;border:0;background-color:#fff}.divider-container{padding:5px 25px!important;pointer-events:none}.option{width:100%;height:max-content;padding:3px 0}.option:hover{background-color:#3d6298}.item{display:flex;width:100%;align-items:center}.image-container{width:50px;text-align:center}.current{background-color:#11315f}img{height:32px;width:32px}span{color:#fff;font-size:12px;font-family:Arial;cursor:default;white-space:nowrap}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }], animations: [fileNavigationAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileMenuNavigationComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-menu-navigation", template: `<div [@fileNavigation]="model.showFileMenuNavigation ? 'in' : 'out'" class="file-navigation">
    <div class="back-button-container">
      <div class="back-button" (click)="model.changeFileMenuState()">
        <img [src]="model.getImage('images.Other.Back.png')" />
      </div>
    </div>
    <div
      class="option {{ item.name == 'Divider' ? 'divider-container' : '' }} {{
        item.name == model.currentSelectedFileOption ? 'current' : ''
      }}"
      *ngFor="let item of helper.fileMenuItems"
      (click)="setEvent(item.name)"
    >
      <div class="item" *ngIf="item.name != 'Divider'">
        <div class="image-container" [style.min-height.px]="36">
          <img *ngIf="item.image" [src]="model.getImage(item.image)" />
        </div>
        <span>{{ item.caption }}</span>
      </div>
      <div class="divider" *ngIf="item.name == 'Divider'"></div>
    </div>
  </div>`, animations: [fileNavigationAnimation], styles: [".file-navigation{-webkit-user-select:none;width:0px;height:inherit;background-color:#19478a;z-index:99999999;position:absolute;top:0;left:0}.back-button{padding:20px 0 0 9px}.back-button img{width:32px;height:32px;opacity:1}.back-button img:hover{opacity:.7}.divider{height:1px;width:100%;border:0;background-color:#fff}.divider-container{padding:5px 25px!important;pointer-events:none}.option{width:100%;height:max-content;padding:3px 0}.option:hover{background-color:#3d6298}.item{display:flex;width:100%;align-items:center}.image-container{width:50px;text-align:center}.current{background-color:#11315f}img{height:32px;width:32px}span{color:#fff;font-size:12px;font-family:Arial;cursor:default;white-space:nowrap}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }]; } });
//# sourceMappingURL=data:application/json;base64,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