import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "@angular/common";
import * as i4 from "./sti-file-new-content.component";
import * as i5 from "./sti-file-open-content.component";
import * as i6 from "./sti-file-save-content.component";
export class StiFileMenuContentComponent {
    constructor(model, loc) {
        this.model = model;
        this.loc = loc;
    }
    isCurrent(content) {
        return content == this.model.currentSelectedFileOption ? true : false;
    }
    ngOnInit() { }
}
StiFileMenuContentComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileMenuContentComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiFileMenuContentComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFileMenuContentComponent, selector: "sti-file-menu-content", ngImport: i0, template: ` <div class="file-menu-container">
    <div class="current-option-label">
      <span>{{
        model.currentSelectedFileOption != "SaveAs"
          ? loc.getP(model.currentSelectedFileOption)
          : loc.get2("MainMenu", "menuFileSaveAs").replace("...", "")
      }}</span>
    </div>
    <sti-file-new-content *ngIf="isCurrent('New')"></sti-file-new-content>
    <sti-file-open-content *ngIf="isCurrent('Open')"></sti-file-open-content>
    <sti-file-save-content *ngIf="isCurrent('SaveAs')"></sti-file-save-content>
  </div>`, isInline: true, styles: ["sti-file-new-content,sti-file-open-content,sti-file-save-content{height:100%;width:100%}.file-menu-container{height:100%;width:100%;background-color:#fff;display:flex;flex-direction:column}.current-option-label{padding:30px;width:100%}.current-option-label span{font-size:36px;font-family:Arial;color:#8f8f8f}\n"], dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiFileNewContentComponent, selector: "sti-file-new-content" }, { kind: "component", type: i5.StiFileOpenContentComponent, selector: "sti-file-open-content" }, { kind: "component", type: i6.StiFileSaveContentComponent, selector: "sti-file-save-content" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFileMenuContentComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-menu-content", template: ` <div class="file-menu-container">
    <div class="current-option-label">
      <span>{{
        model.currentSelectedFileOption != "SaveAs"
          ? loc.getP(model.currentSelectedFileOption)
          : loc.get2("MainMenu", "menuFileSaveAs").replace("...", "")
      }}</span>
    </div>
    <sti-file-new-content *ngIf="isCurrent('New')"></sti-file-new-content>
    <sti-file-open-content *ngIf="isCurrent('Open')"></sti-file-open-content>
    <sti-file-save-content *ngIf="isCurrent('SaveAs')"></sti-file-save-content>
  </div>`, styles: ["sti-file-new-content,sti-file-open-content,sti-file-save-content{height:100%;width:100%}.file-menu-container{height:100%;width:100%;background-color:#fff;display:flex;flex-direction:column}.current-option-label{padding:30px;width:100%}.current-option-label span{font-size:36px;font-family:Arial;color:#8f8f8f}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,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