import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
export class StiExpressionHelpWindowComponent {
    constructor(model, loc) {
        this.model = model;
        this.loc = loc;
    }
    get itemInfo() {
        if (this.model.currentExpressionInfo == 1) {
            return `Supports list operations: adding, subtracting and multiplying lists, list and value.
Example:
    { Col( 'Qty' ) * Col( 'Price' ) }
    { ( Col( 'Fahrenheit degrees' ) - 32 ) * 5 / 9 }
Available functions:
    Count,
    Min,
    Max,
    Sum,
    Value,
    Cell,
    Total,
    Col`;
        }
        else if (this.model.currentExpressionInfo == 2) {
            return `Example:
  { Sum( Col( 'Final price' ) ) }
  { ( Total( 'Tax' ) + 1 ) * Total( 'Price' ) }
Available functions:
  Count,
  Min,
  Max,
  Sum,
  Value,
  Cell,
  Total,
  Col,
  Row`;
        }
        else if (this.model.currentExpressionInfo == 3) {
            return `Multiple expressions, enclosed in { and }, are supported.
Example:
    "Tax is { Value( 'Tax' ) * 100}%, total is { Value( 'Tax' ) * Value( 'Subtotal' ) } dollars",
    evaluates to "Tax is 15%, total is 230 dollars"
Available functions:
    Count,
    Min,
    Max,
    Sum,
    Value,
    Cell,
    Total,
    Col,
    Row`;
        }
        else {
            return "";
        }
    }
    get generalInfo() {
        return `Expressions : used in Label element, Labels column and Totals fields of Table element.
|
|- Values: numbers: 1, 2.3, -4.5.
|          strings: 'text'.
|          lists: returned from some functions.
|
|- Operators: JS-style type casting is applied when possible.
|   |
|   |- "+" : when applied to numbers:            2 + 3 = 5
|   |        when applied to strings:            'abc' + 'def' = 'abcdef'
|   |        in Labels column expressions, when applied to lists of same size: [ 1, 2, 3 ] + [ 4, 5, 6 ] = [ 5, 7, 9 ].
|   |        in Labels column expressions, when applied to list and number:    [ 1, 2, 3 ] + 8 = [ 9, 10, 11 ].
|   |
|   |- "-" : when applied to numbers:            2 - 3 = 5
|   |        in Labels column expressions, when applied to lists of same size: [ 1, 2, 3 ] - [ 4, 5, 6 ] = [ -3, -3, -3 ].
|   |        in Labels column expressions, when applied to list and number:    [ 1, 2, 3 ] - 8 = [ -7, -6, -5 ].
|   |
|   |- "*" : when applied to numbers:            2 * 3 = 6
|   |        in Labels column expressions, when applied to lists of same size: [ 1, 2, 3 ] * [ 4, 5, 6 ] = [ 4, 10, 18 ].
|   |        in Labels column expressions, when applied to list and number:    [ 1, 2, 3 ] * 8 = [ 8, 16, 24 ].
|   |
|   |- "/" : when applied to numbers: 2 / 3 = 0.666667.
|   |
|   |- "(" and ")" : operations order.
|
|- Functions:
    |
    |- Value( name ) - value of NumberBox, TextBox or Label element.
    |                  For Label element - value of the last expression,
    |                  for ex., value of Label with text "Price: {2 * 100} dollars" is 200.
    |
    |- Count( list ) - number of items in the list.
    |
    |- Min( list ) - the smallest number in list.
    |
    |- Max( list ) - the largest number in list.
    |
    |- Sum( list ) - sum of all numbers in list.
    |
    |- Cell( oneBasedColumnIndex, oneBasedRowIndex, 'tableName' ) - number value of specified cell.
    |                                                               Cell must be from either NumberBox column or Label column.
    |                                                               Parameter 'tableName' can be omitted if function is used
    |                                                               in the same table (for ex., in Totals field's expression)
    |                                                               as the specified cell.
    |
    |- Total( totalsFieldID, 'tableName' ) - value of Table's Totals field.
    |                                        totalsFieldID - either one-based index or header text of desired totals field.
    |                                        Parameter 'tableName' can be omitted if function is used
    |                                        in the same table (for ex., in Totals field's expression)
    |                                        as the specified totals field.
    |
    |- Col( columnID, 'tableName' ) - list of numbers which are cell values from specified column.
    |                                 columnID - either one-based index or label text of desired column.
    |                                 Only NumberBox and Label columns are supported.
    |                                 Parameter 'tableName' can be omitted if function is used
    |                                 in the same table (for ex., in Totals field's expression)
    |                                 as the specified column.
    |
    |
    |- Row( rowID, 'tableName' ) - list of numbers which are cell values from specified row.
                                  rowID - either one-based index or label text of desired row.
                                  Only cells from NumberBox or Label columns are included.
                                  Parameter 'tableName' can be omitted if function is used
                                  in the same table (for ex., in Totals field's expression)
                                  as the specified row.
                                  Not available in Label column expressions.
  `;
    }
    ngOnInit() { }
}
StiExpressionHelpWindowComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiExpressionHelpWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiExpressionHelpWindowComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiExpressionHelpWindowComponent, selector: "expression-help-window", ngImport: i0, template: `<div class="help-window">
    <div class="navigation">
      <span>{{ loc.get2("HelpDesigner", "StimulsoftHelp") }}</span>
      <div class="close-button" (click)="model.showHelpWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" alt="" />
      </div>
    </div>
    <div class="content">
      <div class="item-info">{{ itemInfo }}</div>
      <div class="general-info">{{ generalInfo }}</div>
    </div>
  </div>`, isInline: true, styles: [".pi{font-size:.825rem;color:var(--text-color)}.help-window{position:absolute;height:500px;width:620px;display:flex;flex-direction:column;left:calc(50% - 310px);top:calc(50% - 250px);z-index:9999999;background:var(--back-color);border:1px solid rgb(25,71,138);box-shadow:0 0 7px #0000004d;font-family:Arial;border-radius:5px;font-size:12px}.navigation{height:30px;width:100%;display:flex;align-items:center;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a}.navigation span{padding-left:10px;color:#fff;flex:1}.item-info{margin-bottom:10px}.close-button{height:30px;width:30px;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.close-button:hover{background-color:#dadada}.content{height:100%;width:100%;overflow-y:scroll;padding:0 10px;word-wrap:auto;white-space:pre-wrap}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiExpressionHelpWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "expression-help-window", template: `<div class="help-window">
    <div class="navigation">
      <span>{{ loc.get2("HelpDesigner", "StimulsoftHelp") }}</span>
      <div class="close-button" (click)="model.showHelpWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" alt="" />
      </div>
    </div>
    <div class="content">
      <div class="item-info">{{ itemInfo }}</div>
      <div class="general-info">{{ generalInfo }}</div>
    </div>
  </div>`, styles: [".pi{font-size:.825rem;color:var(--text-color)}.help-window{position:absolute;height:500px;width:620px;display:flex;flex-direction:column;left:calc(50% - 310px);top:calc(50% - 250px);z-index:9999999;background:var(--back-color);border:1px solid rgb(25,71,138);box-shadow:0 0 7px #0000004d;font-family:Arial;border-radius:5px;font-size:12px}.navigation{height:30px;width:100%;display:flex;align-items:center;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a}.navigation span{padding-left:10px;color:#fff;flex:1}.item-info{margin-bottom:10px}.close-button{height:30px;width:30px;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.close-button:hover{background-color:#dadada}.content{height:100%;width:100%;overflow-y:scroll;padding:0 10px;word-wrap:auto;white-space:pre-wrap}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,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