import { Component, ViewChild } from "@angular/core";
import { StiFormElement } from "../../elements/base/StiFormElement";
import { StiLabelElement } from "../../elements/StiLabelElement";
import { StiNumberBoxElement } from "../../elements/StiNumberBoxElement";
import { StiTableElement } from "../../elements/StiTableElement";
import { StiTextBoxElement } from "../../elements/StiTextBoxElement";
import { StiTotalsFieldItem } from "../../elements/table/StiTotalsFieldItem";
import { StiExpressionService } from "../../services/sti-expression.service";
import { RotateAnimation } from "../animations/animations";
import { StiColumnItem } from "../../elements/table/StiColumnItem";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-expression.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "../../services/mouse.service";
import * as i5 from "../../services/sti-editable-content.service";
import * as i6 from "@angular/common";
import * as i7 from "./sti-columns-preview.component";
import * as i8 from "../sti-tooltip/sti-tooltip.directive";
export class StiExpressionEditorComponent {
    constructor(model, expressionService, loc, mouseService, editableService, cdr) {
        this.model = model;
        this.expressionService = expressionService;
        this.loc = loc;
        this.mouseService = mouseService;
        this.editableService = editableService;
        this.cdr = cdr;
        this.expressionString = "{}";
        this.currentSelectedMode = "functions";
        this.currentSelectedFunction = "value";
        this.canDragExpression = false;
        this.arrayOfSamples = [
            {
                functionName: "value",
                samples: ["Value('TextBox')", "Value('NumberBox')", "Value('Label')"],
                title: "Value of NumberBox, TextBox or Label element",
            },
            {
                functionName: "count",
                samples: ["Count(Col(1,'Table'))", "Count(Row('First','Table'))"],
                title: "Number of items in the list",
            },
            {
                functionName: "min",
                samples: ["Min(Col(1,'Table'))", "Min(Row('First','Table'))"],
                title: "The smallest number in list",
            },
            {
                functionName: "max",
                samples: ["Max(Col(1,'Table'))", "Max(Row('First','Table'))"],
                title: "The largest number in list",
            },
            {
                functionName: "sum",
                samples: ["Sum(Col(1,'Table'))", "Sum(Row('First','Table'))"],
                title: "Sum of all numbers in list",
            },
            {
                functionName: "cell",
                samples: ["Cell(columnId,rowId)", "Cell(columnId,rowId,'Table')"],
                title: "Number value of specified cell",
            },
            {
                functionName: "total",
                samples: ["Total(totalId)", "Total(totalId,'Table')"],
                title: "Value of Tables Totals field",
            },
            {
                functionName: "col",
                samples: ["Col(columnId)", "Col(columnId,'Table')"],
                title: "List of numbers which are cell values from specified column",
            },
            {
                functionName: "row",
                samples: ["Row(rowLabel)", "Row(rowLabel,'Table')"],
                title: "List of numbers which are cell values from specified row",
            },
            {
                functionName: "line",
                samples: ["Line"],
                title: "Returns the current table line number (starts from 1).",
            },
            {
                functionName: "today",
                samples: ["Today"],
                title: "Returns the current date in default format.",
            },
            {
                functionName: "time",
                samples: ["Time"],
                title: "Returns the current time in default format.",
            },
        ];
        this.arrayOfStates = [];
    }
    ngAfterViewInit() {
        this.expressionService.elementRef = this.elementRef;
    }
    ngOnDestroy() {
        this.mouseMoveSubscription?.unsubscribe();
        this.mouseUpSubscription?.unsubscribe();
        this.expressionUpdatingSubscription?.unsubscribe();
        this.expressionService.elementRef = null;
    }
    startExpressionDragging(dragObject) {
        this.startX = dragObject.event.clientX;
        this.startY = dragObject.event.clientY;
        this.canDragExpression = true;
        this.dragObject = dragObject;
    }
    setContent(innerText) {
        if (this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") {
            this.cdr.detach();
        }
        this.expressionString = innerText;
    }
    checkBrackets() {
        let haveCloseBreaket = false;
        let haveOpenBreaket = false;
        if (this.lastCaretPosition) {
            for (let i = this.lastCaretPosition - 1; i >= 0; i--) {
                if (this.expressionString[i] === "}") {
                    haveCloseBreaket = true;
                    break;
                }
                else if (this.expressionString[i] === "{") {
                    haveOpenBreaket = true;
                    break;
                }
            }
        }
        if (haveCloseBreaket || (!haveCloseBreaket && !haveOpenBreaket)) {
            return true;
        }
        else {
            return false;
        }
    }
    showInfo() {
        this.model.showHelpWindow = true;
    }
    addValue(element) {
        this.addFunction("Value", element.name, true);
    }
    changeMode(mode) {
        if (this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") {
            this.cdr.reattach();
            this.cdr.detectChanges();
        }
        if (this.currentSelectedMode != mode && mode == "systemVariable") {
            this.currentSelectedFunction = "line";
        }
        else {
            this.currentSelectedFunction = "value";
        }
        this.currentSelectedMode = mode;
    }
    changeCurrentFuction(func) {
        this.currentSelectedFunction = func;
    }
    startDrag(event) {
        this.startX = event.clientX;
        this.startY = event.clientY;
        this.startComponentX = this.expressionService.componentX;
        this.startComponentY = this.expressionService.componentY;
        this.isDragging = true;
    }
    get samples() {
        return this.arrayOfSamples.find((sample) => sample.functionName == this.currentSelectedFunction).samples;
    }
    get title() {
        return this.arrayOfSamples.find((sample) => sample.functionName == this.currentSelectedFunction).title;
    }
    nestedFieldClick(field) {
        if (field instanceof StiTotalsFieldItem) {
            this.insertInExpression(this.lastCaretPosition, `Total(${field.eParent.totalsFields.indexOf(field) + 1},'${field.eParent.name}')`);
        }
        else {
            this.insertInExpression(this.lastCaretPosition, `Cell(${field.column.eParent.columns.indexOf(field.column) + 1},${field.index},'${field.column.eParent.name}')`);
        }
    }
    get fields() {
        let fields = [];
        this.model?.form?.pages?.forEach((page) => {
            page.allElements.forEach((element) => {
                if (this.haveExpression(element)) {
                    fields.push(element);
                }
            });
        });
        return fields;
    }
    isTable(element) {
        return element instanceof StiTableElement;
    }
    haveExpression(element) {
        return element instanceof StiTableElement ||
            element instanceof StiTextBoxElement ||
            element instanceof StiNumberBoxElement
            ? true
            : false;
    }
    addOperator(operator) {
        this.insertInExpression(this.lastCaretPosition, operator, true);
    }
    addFunction(func, name, filled = false) {
        let string = "";
        if (func.toLowerCase() == "value") {
            string = func + `('${name ? name : ""}')`;
        }
        else if (func.toLowerCase() == "line" || func.toLowerCase() == "today" || func.toLowerCase() == "time") {
            string = func;
        }
        else if (func.toLowerCase() == "cell") {
            string = func + "(,,'')";
        }
        else if (func.toLowerCase() == "total" || func.toLowerCase() == "col" || func.toLowerCase() == "row") {
            string = func + "(,'')";
        }
        else {
            string = func + "()";
        }
        this.insertInExpression(this.lastCaretPosition, string, false, filled ? false : true);
    }
    insertInExpression(position, string, isOperator = false, isFunction = false) {
        let needBrackets = isOperator ? false : this.checkBrackets();
        let previousString = this.expressionString;
        let insertedExpression = `${needBrackets ? "{" : ""}${string}${needBrackets ? "}" : ""}`;
        if (this.expressionString.length > 0 && position) {
            if (position == 0) {
                this.expressionString = insertedExpression + previousString;
            }
            else {
                this.expressionString =
                    previousString.slice(0, position) +
                        insertedExpression +
                        previousString.slice(position, previousString.length);
            }
        }
        else {
            this.expressionString += insertedExpression;
        }
        this.setCaret(insertedExpression, isFunction);
    }
    setCaret(insertedExpression, isFunction = false) {
        let leftBracketIndex = insertedExpression.indexOf("(");
        let carretOffset = 0;
        if (!this.lastCaretPosition) {
            this.lastCaretPosition = this.expressionString.length - insertedExpression.length;
        }
        if (isFunction) {
            if (insertedExpression[leftBracketIndex + 1] == "'") {
                carretOffset = this.lastCaretPosition + leftBracketIndex + 2;
            }
            else {
                carretOffset = this.lastCaretPosition + leftBracketIndex + 1;
            }
        }
        else {
            carretOffset = this.lastCaretPosition + insertedExpression.length;
        }
        let elem = this.elementRef.nativeElement;
        elem.focus();
        setTimeout(() => {
            var range = document.createRange();
            var sel = window.getSelection();
            range.setStart(elem.childNodes[0], carretOffset);
            range.collapse(true);
            this.lastCaretPosition += insertedExpression.length;
            sel.removeAllRanges();
            sel.addRange(range);
        });
    }
    save() {
        if (this.expressionService.currentSelectedObject instanceof StiLabelElement) {
            this.expressionService.currentSelectedObject.text.value = this.expressionString;
            this.model.formEvents.next({ name: "ValueChanged" });
        }
        else {
            this.expressionService.currentSelectedObject.expression = this.expressionString;
        }
        this.model.showExpressionEditor = false;
    }
    ngOnInit() {
        this.expressionService.componentX = (window.innerWidth - this.expressionService.componentWidth) / 2;
        this.expressionService.componentY = (window.innerHeight - this.expressionService.componentHeight) / 2;
        this.expressionString = this.expressionService.currentSelectedObject?.expression
            ? this.expressionService.currentSelectedObject?.expression
            : this.expressionService.currentSelectedObject?.text?.value
                ? this.expressionService.currentSelectedObject?.text?.value
                : "";
        this.fields?.forEach((field) => {
            if (this.isTable(field)) {
                this.arrayOfStates.push({ element: field, state: "default" });
            }
        });
        this.currentSelectedFunction = "value";
        this.currentSelectedMode = "functions";
        this.expressionUpdatingSubscription = this.expressionService.needToAddExpression.subscribe((object) => {
            this.addExpressionByDrag(object);
        });
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.isDragging = false;
            this.canDragExpression = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
    }
    addExpressionByDrag(expressionObject) {
        if (this.expressionString.length == 0) {
            this.lastCaretPosition = 0;
        }
        else {
            this.lastCaretPosition = expressionObject.lastCaretOffset;
        }
        if (typeof expressionObject.startObject.object == "string") {
            if (expressionObject.startObject.object.length == 1) {
                this.addOperator(expressionObject.startObject.object);
            }
            else {
                this.addFunction(expressionObject.startObject.object);
            }
        }
        else {
            if (expressionObject.startObject.object instanceof StiFormElement) {
                this.addFunction("Value", expressionObject.startObject.object.name, true);
            }
            else {
                if (expressionObject.startObject.object instanceof StiTotalsFieldItem) {
                    this.insertInExpression(this.lastCaretPosition, `Total(${expressionObject.startObject.object.eParent.totalsFields.indexOf(expressionObject.startObject.object) + 1},'${expressionObject.startObject.object.eParent.name}')`);
                }
                else if (expressionObject.startObject.object instanceof StiColumnItem &&
                    !expressionObject.startObject.isCell) {
                    this.insertInExpression(this.lastCaretPosition, `Col(${expressionObject.startObject.object.eParent.columns.indexOf(expressionObject.startObject.object) + 1},'${expressionObject.startObject.object.eParent.name}')`);
                }
                else {
                    this.insertInExpression(this.lastCaretPosition, `Cell(${expressionObject.startObject.object.eParent.columns.indexOf(expressionObject.startObject.object) + 1},${expressionObject.startObject.index},'${expressionObject.startObject.object.eParent.name}')`);
                }
            }
        }
    }
    onMouseMove(event) {
        if (this.canDragExpression &&
            Math.max(Math.abs(this.startX - event.clientX), Math.abs(this.startY - event.clientY)) >
                StiExpressionService.MOUSE_DELTA) {
            this.expressionService.expressionDraggableContainerX = this.dragObject.event.clientX - 10;
            this.expressionService.expressionDraggableContainerY = this.dragObject.event.clientY - 10;
            this.expressionService.startContainerDrag(this.dragObject);
            this.canDragExpression = false;
        }
        if (this.isDragging) {
            let deltaX = event.clientX - this.startX;
            let deltaY = event.clientY - this.startY;
            if (this.startComponentX + deltaX < 0) {
                this.expressionService.componentX = 0;
            }
            else if (this.startComponentX + deltaX > window.innerWidth - this.expressionService.componentWidth) {
                this.expressionService.componentX = window.innerWidth - this.expressionService.componentWidth;
            }
            else {
                this.expressionService.componentX = this.startComponentX + deltaX;
            }
            if (this.startComponentY + deltaY < 0) {
                this.expressionService.componentY = 0;
            }
            else if (this.startComponentY + deltaY > window.innerHeight - this.expressionService.componentHeight) {
                this.expressionService.componentY = window.innerHeight - this.expressionService.componentHeight;
            }
            else {
                this.expressionService.componentY = this.startComponentY + deltaY;
            }
        }
    }
    getState(element) {
        return this.arrayOfStates.find((item) => item.element == element).state;
    }
    changeState(element) {
        let index = this.arrayOfStates.findIndex((item) => item.element == element);
        this.arrayOfStates[index].state == "default"
            ? (this.arrayOfStates[index].state = "rotated")
            : (this.arrayOfStates[index].state = "default");
    }
    focus() {
        this.expressionService.elementRef = this.elementRef;
    }
    blur() {
        if (this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") {
            this.cdr.reattach();
            this.cdr.detectChanges();
        }
    }
    getCaret() {
        this.lastCaretPosition = this.expressionService.getCaretOffset(this.elementRef.nativeElement ?? this.elementRef);
    }
}
StiExpressionEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiExpressionEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiExpressionService }, { token: i3.StiLocalizationService }, { token: i4.StiMouseService }, { token: i5.StiEditableContentService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
StiExpressionEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiExpressionEditorComponent, selector: "sti-expression-editor", viewQueries: [{ propertyName: "elementRef", first: true, predicate: ["expressionRef"], descendants: true }], ngImport: i0, template: `<div
    class="expression-editor-container"
    [style.left.px]="expressionService.componentX"
    [style.top.px]="expressionService.componentY"
    [style.pointer-events]="model.showHelpWindow ? 'none' : ''"
  >
    <div class="header-navigation" (mousedown)="startDrag($event)">
      <span>{{ loc.get2("FormTitles", "ExpressionEditorForm") }}</span>
      <div class="nav-button" (click)="showInfo()"><img [src]="model.getImage('images.Other.HelpIcon.png')" /></div>
      <div class="nav-button" (click)="model.showExpressionEditor = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
        <!-- <i class="pi pi-times"></i> -->
      </div>
    </div>
    <div
      class="expression-preview {{ expressionService.isDragging ? 'dragging-over' : '' }}"
      (click)="expressionRef.focus()"
    >
      <label
        [id]="'expressionLabel'"
        #expressionRef
        contenteditable="plaintext-only"
        (mouseup)="getCaret()"
        (input)="setContent($event.target.textContent)"
        (keyup)="getCaret()"
        spellcheck="false"
        [textContent]="expressionString"
        [style.cursor]="expressionService.isDragging ? 'default' : 'text'"
      ></label>
    </div>
    <div class="expression-navigation">
      <div
        class="expression-functions column"
        [style.width]="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable' ? '100%' : '30%'"
      >
        <div class="column-content">
          <span
            class="column-item {{ currentSelectedMode == 'functions' ? 'selected' : '' }}"
            (click)="changeMode('functions')"
          >
            {{ loc.getP("Functions") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'elements' ? 'selected' : '' }}"
            (click)="changeMode('elements')"
          >
            {{ loc.get2("Report", "Components") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'systemVariable' ? 'selected' : '' }}"
            (click)="changeMode('systemVariable')"
          >
            {{ loc.getP("SystemVariable") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'operators' ? 'selected' : '' }}"
            (click)="changeMode('operators')"
          >
            {{ loc.get2("MathFormula", "Operators") }}
          </span>
        </div>
      </div>
      <div
        class="expression-operators column"
        *ngIf="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable'"
      >
        <div class="column-content" *ngIf="currentSelectedMode == 'functions'">
          <span
            class="column-item {{ currentSelectedFunction == 'value' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('value')"
            (mousedown)="startExpressionDragging({ object: 'Value', event: $event })"
            (dblclick)="addFunction('Value')"
          >
            {{ "Value()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'count' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('count')"
            (mousedown)="startExpressionDragging({ object: 'Count', event: $event })"
            (dblclick)="addFunction('Count')"
          >
            {{ "Count()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'min' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('min')"
            (mousedown)="startExpressionDragging({ object: 'Min', event: $event })"
            (dblclick)="addFunction('Min')"
          >
            {{ "Min()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'max' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('max')"
            (mousedown)="startExpressionDragging({ object: 'Max', event: $event })"
            (dblclick)="addFunction('Max')"
          >
            {{ "Max()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'sum' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('sum')"
            (mousedown)="startExpressionDragging({ object: 'Sum', event: $event })"
            (dblclick)="addFunction('Sum')"
          >
            {{ "Sum()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'cell' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('cell')"
            (mousedown)="startExpressionDragging({ object: 'Cell', event: $event })"
            (dblclick)="addFunction('Cell')"
          >
            {{ "Cell()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'total' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('total')"
            (mousedown)="startExpressionDragging({ object: 'Total', event: $event })"
            (dblclick)="addFunction('Total')"
          >
            {{ "Total()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'col' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('col')"
            (mousedown)="startExpressionDragging({ object: 'Col', event: $event })"
            (dblclick)="addFunction('Col')"
          >
            {{ "Col()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'row' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('row')"
            (mousedown)="startExpressionDragging({ object: 'Row', event: $event })"
            (dblclick)="addFunction('Row')"
          >
            {{ "Row()" }}
          </span>
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'systemVariable'">
          <span
            class="column-item {{ currentSelectedFunction == 'line' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('line')"
            (mousedown)="startExpressionDragging({ object: 'Line', event: $event })"
            (dblclick)="addFunction('Line')"
          >
            {{ "Line" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'today' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('today')"
            (mousedown)="startExpressionDragging({ object: 'Today', event: $event })"
            (dblclick)="addFunction('Today')"
          >
            {{ "Today" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'time' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('time')"
            (mousedown)="startExpressionDragging({ object: 'Time', event: $event })"
            (dblclick)="addFunction('Time')"
          >
            {{ "Time" }}
          </span>
        </div>
      </div>
      <div class="expression-fields column">
        <div
          class="column-content"
          *ngIf="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable'"
        >
          <div *ngFor="let sample of samples" class="sample-item">
            <span>{{ sample }}</span>
          </div>
          <div class="sample-item" [style.padding]="'15px 0px'">
            <span>{{ title }}</span>
          </div>
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'operators'">
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Plus')"
            tooltipPosition="bottom"
            showDelay="500"
            (dblclick)="addOperator('+')"
            (mousedown)="startExpressionDragging({ object: '+', event: $event })"
            >+</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Minus')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '-', event: $event })"
            (dblclick)="addOperator('-')"
            >-</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Multiply')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '*', event: $event })"
            (dblclick)="addOperator('*')"
            >*</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Division')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '/', event: $event })"
            (dblclick)="addOperator('/')"
            >/</span
          >
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'elements'">
          <div *ngFor="let field of fields">
            <div
              class="column-item field"
              [style.padding]="isTable(field) ? '4px 5px 4px 0px' : '4px 5px'"
              (click)="isTable(field) ? changeState(field) : ''"
              (mousedown)="!isTable(field) ? startExpressionDragging({ object: field, event: $event }) : ''"
              (dblclick)="!isTable(field) ? addValue(field) : ''"
            >
              <div *ngIf="isTable(field)" class="arrow" [@rotatedState]="getState(field)">
                <i class="pi pi-chevron-right"></i>
              </div>
              <span>{{ field.name }}</span>
            </div>
            <sti-columns-preview
              *ngIf="isTable(field)"
              [object]="field"
              (fieldClick)="nestedFieldClick($event)"
              (startFieldDrag)="startExpressionDragging($event)"
              [state]="getState(field) == 'default' ? false : true"
            ></sti-columns-preview>
          </div>
        </div>
      </div>
    </div>
    <div class="footer-navigation">
      <div class="footer-button accept" (click)="save()" [style.margin-right.px]="0">
        <span>{{ loc.get2("Buttons", "Save") }}</span>
      </div>
      <div class="footer-button cancel" (click)="model.showExpressionEditor = false">
        <span>{{ loc.getP("Cancel") }}</span>
      </div>
    </div>
  </div>`, isInline: true, styles: [".arrow{width:20px;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;display:flex;align-items:center;justify-content:center}.arrow .pi{font-size:.625rem}.pi{font-size:.825rem}.selected{background-color:#e5e5e5}.expression-editor-container{position:absolute;font-size:13px;font-family:Arial;color:var(--text-color);min-height:480px;width:700px;border-radius:5px;left:calc(50% - 350px);top:calc(50% - 250px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;box-shadow:0 0 7px #0000004d;z-index:999}.header-navigation{display:flex;height:40px;align-items:center;padding-left:15px;padding-right:5px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;color:#fff;-webkit-user-select:none}.header-navigation span{width:100%;font-size:17px;-webkit-user-select:none;cursor:default}.nav-button{height:24px;width:28px;border-radius:3px;display:flex;align-items:center;justify-content:center;align-self:start;margin-top:5px}.nav-button:hover{background-color:#d3d3d3}.nav-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.expression-preview{width:calc(100% - 20px);margin:10px 10px 5px;padding:5px;background-color:#fafafa;border:1px solid lightgray;height:135px;-webkit-user-select:text;display:flex}.expression-preview label{-webkit-user-select:text;font-size:13px;outline:none;height:100%;width:100%;overflow:auto}.dragging-over{background-color:#ebebeb!important;border:1px dashed black!important}.expression-navigation{display:flex;width:100%;padding:0 5px}.column{border:1px solid lightgray;height:230px;width:100%;margin:5px}.buttons{height:250px;min-width:150px;display:flex;flex-direction:column;justify-content:center;align-items:center}.buttons img{height:52px;width:52px;border-radius:3px;margin:5px;padding:10px}.buttons img:hover{background-color:#d3d3d3}.column-header{-webkit-user-select:none;height:30px;background-color:#d3d3d3;display:flex;align-items:center;padding:0 10px;border-top-left-radius:4px;border-top-right-radius:4px}.column-header span{font-size:15px;-webkit-user-select:none;cursor:default}.footer-navigation{width:100%;display:flex;justify-content:flex-end;height:50px;align-items:center}.footer-button{min-width:90px;height:30px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 10px;-webkit-user-select:none;font-size:12px}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.column-content{width:100%;padding:5px;display:flex;max-height:229px;overflow-y:auto;flex-direction:column}.operator-item{font-family:Arial;color:var(--text-color);font-size:17px;padding:2px 7px;border-radius:3px;-webkit-user-select:none}.operator-item:hover{background-color:#f0f0f0}.sample-item{font-family:Arial;color:var(--text-color);font-size:12px;-webkit-user-select:none;padding-bottom:3px;cursor:default}.column-item{font-family:Arial;color:var(--text-color);font-size:12px;-webkit-user-select:none;padding:5px;cursor:default}.column-item:hover{background-color:#f0f0f0}.info{height:30px;width:30px;display:flex;align-items:center;justify-content:center}.info img{height:16px;width:16px;cursor:pointer}.field{display:flex;align-items:center}.field img{height:16px;width:16px;margin-right:5px}\n"], dependencies: [{ kind: "directive", type: i6.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiColumnsPreviewComponent, selector: "sti-columns-preview", inputs: ["state", "object"], outputs: ["fieldClick", "startFieldDrag"] }, { kind: "directive", type: i8.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }], animations: [RotateAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiExpressionEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-expression-editor", template: `<div
    class="expression-editor-container"
    [style.left.px]="expressionService.componentX"
    [style.top.px]="expressionService.componentY"
    [style.pointer-events]="model.showHelpWindow ? 'none' : ''"
  >
    <div class="header-navigation" (mousedown)="startDrag($event)">
      <span>{{ loc.get2("FormTitles", "ExpressionEditorForm") }}</span>
      <div class="nav-button" (click)="showInfo()"><img [src]="model.getImage('images.Other.HelpIcon.png')" /></div>
      <div class="nav-button" (click)="model.showExpressionEditor = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
        <!-- <i class="pi pi-times"></i> -->
      </div>
    </div>
    <div
      class="expression-preview {{ expressionService.isDragging ? 'dragging-over' : '' }}"
      (click)="expressionRef.focus()"
    >
      <label
        [id]="'expressionLabel'"
        #expressionRef
        contenteditable="plaintext-only"
        (mouseup)="getCaret()"
        (input)="setContent($event.target.textContent)"
        (keyup)="getCaret()"
        spellcheck="false"
        [textContent]="expressionString"
        [style.cursor]="expressionService.isDragging ? 'default' : 'text'"
      ></label>
    </div>
    <div class="expression-navigation">
      <div
        class="expression-functions column"
        [style.width]="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable' ? '100%' : '30%'"
      >
        <div class="column-content">
          <span
            class="column-item {{ currentSelectedMode == 'functions' ? 'selected' : '' }}"
            (click)="changeMode('functions')"
          >
            {{ loc.getP("Functions") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'elements' ? 'selected' : '' }}"
            (click)="changeMode('elements')"
          >
            {{ loc.get2("Report", "Components") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'systemVariable' ? 'selected' : '' }}"
            (click)="changeMode('systemVariable')"
          >
            {{ loc.getP("SystemVariable") }}
          </span>
          <span
            class="column-item {{ currentSelectedMode == 'operators' ? 'selected' : '' }}"
            (click)="changeMode('operators')"
          >
            {{ loc.get2("MathFormula", "Operators") }}
          </span>
        </div>
      </div>
      <div
        class="expression-operators column"
        *ngIf="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable'"
      >
        <div class="column-content" *ngIf="currentSelectedMode == 'functions'">
          <span
            class="column-item {{ currentSelectedFunction == 'value' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('value')"
            (mousedown)="startExpressionDragging({ object: 'Value', event: $event })"
            (dblclick)="addFunction('Value')"
          >
            {{ "Value()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'count' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('count')"
            (mousedown)="startExpressionDragging({ object: 'Count', event: $event })"
            (dblclick)="addFunction('Count')"
          >
            {{ "Count()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'min' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('min')"
            (mousedown)="startExpressionDragging({ object: 'Min', event: $event })"
            (dblclick)="addFunction('Min')"
          >
            {{ "Min()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'max' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('max')"
            (mousedown)="startExpressionDragging({ object: 'Max', event: $event })"
            (dblclick)="addFunction('Max')"
          >
            {{ "Max()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'sum' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('sum')"
            (mousedown)="startExpressionDragging({ object: 'Sum', event: $event })"
            (dblclick)="addFunction('Sum')"
          >
            {{ "Sum()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'cell' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('cell')"
            (mousedown)="startExpressionDragging({ object: 'Cell', event: $event })"
            (dblclick)="addFunction('Cell')"
          >
            {{ "Cell()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'total' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('total')"
            (mousedown)="startExpressionDragging({ object: 'Total', event: $event })"
            (dblclick)="addFunction('Total')"
          >
            {{ "Total()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'col' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('col')"
            (mousedown)="startExpressionDragging({ object: 'Col', event: $event })"
            (dblclick)="addFunction('Col')"
          >
            {{ "Col()" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'row' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('row')"
            (mousedown)="startExpressionDragging({ object: 'Row', event: $event })"
            (dblclick)="addFunction('Row')"
          >
            {{ "Row()" }}
          </span>
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'systemVariable'">
          <span
            class="column-item {{ currentSelectedFunction == 'line' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('line')"
            (mousedown)="startExpressionDragging({ object: 'Line', event: $event })"
            (dblclick)="addFunction('Line')"
          >
            {{ "Line" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'today' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('today')"
            (mousedown)="startExpressionDragging({ object: 'Today', event: $event })"
            (dblclick)="addFunction('Today')"
          >
            {{ "Today" }}
          </span>
          <span
            class="column-item {{ currentSelectedFunction == 'time' ? 'selected' : '' }}"
            (click)="changeCurrentFuction('time')"
            (mousedown)="startExpressionDragging({ object: 'Time', event: $event })"
            (dblclick)="addFunction('Time')"
          >
            {{ "Time" }}
          </span>
        </div>
      </div>
      <div class="expression-fields column">
        <div
          class="column-content"
          *ngIf="currentSelectedMode == 'functions' || currentSelectedMode == 'systemVariable'"
        >
          <div *ngFor="let sample of samples" class="sample-item">
            <span>{{ sample }}</span>
          </div>
          <div class="sample-item" [style.padding]="'15px 0px'">
            <span>{{ title }}</span>
          </div>
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'operators'">
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Plus')"
            tooltipPosition="bottom"
            showDelay="500"
            (dblclick)="addOperator('+')"
            (mousedown)="startExpressionDragging({ object: '+', event: $event })"
            >+</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Minus')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '-', event: $event })"
            (dblclick)="addOperator('-')"
            >-</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Multiply')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '*', event: $event })"
            (dblclick)="addOperator('*')"
            >*</span
          >
          <span
            class="operator-item"
            [stiTooltip]="loc.get2('Shapes', 'Division')"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="startExpressionDragging({ object: '/', event: $event })"
            (dblclick)="addOperator('/')"
            >/</span
          >
        </div>
        <div class="column-content" *ngIf="currentSelectedMode == 'elements'">
          <div *ngFor="let field of fields">
            <div
              class="column-item field"
              [style.padding]="isTable(field) ? '4px 5px 4px 0px' : '4px 5px'"
              (click)="isTable(field) ? changeState(field) : ''"
              (mousedown)="!isTable(field) ? startExpressionDragging({ object: field, event: $event }) : ''"
              (dblclick)="!isTable(field) ? addValue(field) : ''"
            >
              <div *ngIf="isTable(field)" class="arrow" [@rotatedState]="getState(field)">
                <i class="pi pi-chevron-right"></i>
              </div>
              <span>{{ field.name }}</span>
            </div>
            <sti-columns-preview
              *ngIf="isTable(field)"
              [object]="field"
              (fieldClick)="nestedFieldClick($event)"
              (startFieldDrag)="startExpressionDragging($event)"
              [state]="getState(field) == 'default' ? false : true"
            ></sti-columns-preview>
          </div>
        </div>
      </div>
    </div>
    <div class="footer-navigation">
      <div class="footer-button accept" (click)="save()" [style.margin-right.px]="0">
        <span>{{ loc.get2("Buttons", "Save") }}</span>
      </div>
      <div class="footer-button cancel" (click)="model.showExpressionEditor = false">
        <span>{{ loc.getP("Cancel") }}</span>
      </div>
    </div>
  </div>`, animations: [RotateAnimation], styles: [".arrow{width:20px;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;display:flex;align-items:center;justify-content:center}.arrow .pi{font-size:.625rem}.pi{font-size:.825rem}.selected{background-color:#e5e5e5}.expression-editor-container{position:absolute;font-size:13px;font-family:Arial;color:var(--text-color);min-height:480px;width:700px;border-radius:5px;left:calc(50% - 350px);top:calc(50% - 250px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;box-shadow:0 0 7px #0000004d;z-index:999}.header-navigation{display:flex;height:40px;align-items:center;padding-left:15px;padding-right:5px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;color:#fff;-webkit-user-select:none}.header-navigation span{width:100%;font-size:17px;-webkit-user-select:none;cursor:default}.nav-button{height:24px;width:28px;border-radius:3px;display:flex;align-items:center;justify-content:center;align-self:start;margin-top:5px}.nav-button:hover{background-color:#d3d3d3}.nav-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.expression-preview{width:calc(100% - 20px);margin:10px 10px 5px;padding:5px;background-color:#fafafa;border:1px solid lightgray;height:135px;-webkit-user-select:text;display:flex}.expression-preview label{-webkit-user-select:text;font-size:13px;outline:none;height:100%;width:100%;overflow:auto}.dragging-over{background-color:#ebebeb!important;border:1px dashed black!important}.expression-navigation{display:flex;width:100%;padding:0 5px}.column{border:1px solid lightgray;height:230px;width:100%;margin:5px}.buttons{height:250px;min-width:150px;display:flex;flex-direction:column;justify-content:center;align-items:center}.buttons img{height:52px;width:52px;border-radius:3px;margin:5px;padding:10px}.buttons img:hover{background-color:#d3d3d3}.column-header{-webkit-user-select:none;height:30px;background-color:#d3d3d3;display:flex;align-items:center;padding:0 10px;border-top-left-radius:4px;border-top-right-radius:4px}.column-header span{font-size:15px;-webkit-user-select:none;cursor:default}.footer-navigation{width:100%;display:flex;justify-content:flex-end;height:50px;align-items:center}.footer-button{min-width:90px;height:30px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 10px;-webkit-user-select:none;font-size:12px}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.column-content{width:100%;padding:5px;display:flex;max-height:229px;overflow-y:auto;flex-direction:column}.operator-item{font-family:Arial;color:var(--text-color);font-size:17px;padding:2px 7px;border-radius:3px;-webkit-user-select:none}.operator-item:hover{background-color:#f0f0f0}.sample-item{font-family:Arial;color:var(--text-color);font-size:12px;-webkit-user-select:none;padding-bottom:3px;cursor:default}.column-item{font-family:Arial;color:var(--text-color);font-size:12px;-webkit-user-select:none;padding:5px;cursor:default}.column-item:hover{background-color:#f0f0f0}.info{height:30px;width:30px;display:flex;align-items:center;justify-content:center}.info img{height:16px;width:16px;cursor:pointer}.field{display:flex;align-items:center}.field img{height:16px;width:16px;margin-right:5px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiExpressionService }, { type: i3.StiLocalizationService }, { type: i4.StiMouseService }, { type: i5.StiEditableContentService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { elementRef: [{
                type: ViewChild,
                args: ["expressionRef"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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