import { Component, EventEmitter, Input, Output } from "@angular/core";
import { StiColumnItem } from "../../elements/table/StiColumnItem";
import { RotateAnimation, SlideInOutAnimation } from "../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "./sti-cells-preview.component";
export class StiColumnsPreviewComponent {
    constructor() {
        this.fieldClick = new EventEmitter();
        this.startFieldDrag = new EventEmitter();
        this.arrayOfStates = [];
    }
    get columns() {
        let columns = [];
        this.object.columns.forEach((column) => {
            columns.push(column);
        });
        this.object.totalsFields.forEach((total) => {
            columns.push(total);
        });
        return columns;
    }
    isColumn(column) {
        return column instanceof StiColumnItem;
    }
    addTotal(column) {
        this.fieldClick.emit(column);
    }
    addCell(cellObject) {
        this.fieldClick.emit(cellObject);
    }
    startItemDrag(dragObject) {
        this.startFieldDrag.emit(dragObject);
    }
    ngOnInit() {
        this.columns?.forEach((field) => {
            if (this.isColumn(field)) {
                this.arrayOfStates.push({ element: field, state: "default" });
            }
        });
    }
    getState(element) {
        return this.arrayOfStates.find((item) => item.element == element).state;
    }
    changeState(element) {
        let index = this.arrayOfStates.findIndex((item) => item.element == element);
        this.arrayOfStates[index].state == "default"
            ? (this.arrayOfStates[index].state = "rotated")
            : (this.arrayOfStates[index].state = "default");
    }
}
StiColumnsPreviewComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColumnsPreviewComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
StiColumnsPreviewComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiColumnsPreviewComponent, selector: "sti-columns-preview", inputs: { state: "state", object: "object" }, outputs: { fieldClick: "fieldClick", startFieldDrag: "startFieldDrag" }, ngImport: i0, template: ` <div [@slideInOut]="state ? 'in' : 'out'">
    <div *ngFor="let column of columns; let i = index" class="column-field">
      <div
        class="field-content"
        [style.padding]="!isColumn(column) ? '3px 2px 3px 5px' : '3px 2px 3px 0px'"
        (click)="isColumn(column) ? changeState(column) : ''"
        (mousedown)="startItemDrag({ object: column, event: $event })"
        (dblclick)="!isColumn(column) ? addTotal(column) : ''"
      >
        <div *ngIf="isColumn(column)" class="arrow" [@rotatedState]="getState(column)">
          <i class="pi pi-chevron-right"></i>
        </div>
        <span>{{ column.label ? column.label : column.header ? column.header : "Column " + (i + 1) }}</span>
      </div>
      <sti-cells-preview
        *ngIf="isColumn(column)"
        (cellClick)="addCell($event)"
        (startCellDrag)="startItemDrag($event)"
        [object]="column"
        [state]="getState(column) == 'default' ? false : true"
      ></sti-cells-preview>
    </div>
  </div>`, isInline: true, styles: [".field-content{display:flex;border-radius:3px;padding:2px 5px;margin-left:5px}.field-content:hover{background-color:#f0f0f0}.arrow{width:20px;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;display:flex;align-items:center;justify-content:center}.arrow .pi{font-size:.625rem}.column-field{font-family:Segoe UI;color:var(--text-color);font-size:13px;-webkit-user-select:none;display:flex;flex-direction:column}\n"], dependencies: [{ kind: "directive", type: i1.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.StiCellsPreviewComponent, selector: "sti-cells-preview", inputs: ["state", "object"], outputs: ["cellClick", "startCellDrag"] }], animations: [SlideInOutAnimation, RotateAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColumnsPreviewComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-columns-preview", template: ` <div [@slideInOut]="state ? 'in' : 'out'">
    <div *ngFor="let column of columns; let i = index" class="column-field">
      <div
        class="field-content"
        [style.padding]="!isColumn(column) ? '3px 2px 3px 5px' : '3px 2px 3px 0px'"
        (click)="isColumn(column) ? changeState(column) : ''"
        (mousedown)="startItemDrag({ object: column, event: $event })"
        (dblclick)="!isColumn(column) ? addTotal(column) : ''"
      >
        <div *ngIf="isColumn(column)" class="arrow" [@rotatedState]="getState(column)">
          <i class="pi pi-chevron-right"></i>
        </div>
        <span>{{ column.label ? column.label : column.header ? column.header : "Column " + (i + 1) }}</span>
      </div>
      <sti-cells-preview
        *ngIf="isColumn(column)"
        (cellClick)="addCell($event)"
        (startCellDrag)="startItemDrag($event)"
        [object]="column"
        [state]="getState(column) == 'default' ? false : true"
      ></sti-cells-preview>
    </div>
  </div>`, animations: [SlideInOutAnimation, RotateAnimation], styles: [".field-content{display:flex;border-radius:3px;padding:2px 5px;margin-left:5px}.field-content:hover{background-color:#f0f0f0}.arrow{width:20px;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;display:flex;align-items:center;justify-content:center}.arrow .pi{font-size:.625rem}.column-field{font-family:Segoe UI;color:var(--text-color);font-size:13px;-webkit-user-select:none;display:flex;flex-direction:column}\n"] }]
        }], ctorParameters: function () { return []; }, propDecorators: { state: [{
                type: Input
            }], object: [{
                type: Input
            }], fieldClick: [{
                type: Output
            }], startFieldDrag: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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