import { Component, EventEmitter, Input, Output } from "@angular/core";
import { SlideInOutAnimation } from "../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
export class StiCellsPreviewComponent {
    constructor() {
        this.cellClick = new EventEmitter();
        this.startCellDrag = new EventEmitter();
    }
    get cells() {
        return new Array(this.object?.eParent?.rowLabels?.length).fill(1);
    }
    addCell(index) {
        this.cellClick.emit({ column: this.object, index: index + 1 });
    }
    startDragEvent(event, index) {
        this.startCellDrag.emit({ object: this.object, index: index + 1, event: event, isCell: true });
    }
    getValue(index) {
        return this.object["cells"][index].value;
    }
    ngOnInit() { }
}
StiCellsPreviewComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiCellsPreviewComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
StiCellsPreviewComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiCellsPreviewComponent, selector: "sti-cells-preview", inputs: { state: "state", object: "object" }, outputs: { cellClick: "cellClick", startCellDrag: "startCellDrag" }, ngImport: i0, template: `<div [@slideInOut]="state ? 'in' : 'out'">
    <div
      *ngFor="let cell of cells; let i = index"
      class="cell-field"
      (dblclick)="addCell(i)"
      (mousedown)="startDragEvent($event, i)"
    >
      <span>{{ "Cell - " + (i + 1) }}</span>
    </div>
  </div>`, isInline: true, styles: [".cell-field{font-family:Segoe UI;color:var(--text-color);font-size:13px;-webkit-user-select:none;padding:3px 2px 3px 5px;margin-left:25px;border-radius:3px;display:flex}.cell-field:hover{background-color:#f0f0f0}\n"], dependencies: [{ kind: "directive", type: i1.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }], animations: [SlideInOutAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiCellsPreviewComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-cells-preview", template: `<div [@slideInOut]="state ? 'in' : 'out'">
    <div
      *ngFor="let cell of cells; let i = index"
      class="cell-field"
      (dblclick)="addCell(i)"
      (mousedown)="startDragEvent($event, i)"
    >
      <span>{{ "Cell - " + (i + 1) }}</span>
    </div>
  </div>`, animations: [SlideInOutAnimation], styles: [".cell-field{font-family:Segoe UI;color:var(--text-color);font-size:13px;-webkit-user-select:none;padding:3px 2px 3px 5px;margin-left:25px;border-radius:3px;display:flex}.cell-field:hover{background-color:#f0f0f0}\n"] }]
        }], ctorParameters: function () { return []; }, propDecorators: { state: [{
                type: Input
            }], object: [{
                type: Input
            }], cellClick: [{
                type: Output
            }], startCellDrag: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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