import { Component, ViewChild } from "@angular/core";
import { StiHorizontalAlignment } from "../../system/enums";
import { StiTextItem } from "../../elements/text/StiTextItem";
import StiJson from "../../system/StiJson";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "../../services/sti-color-dialog.service";
import * as i5 from "../../services/sti-signature.service";
import * as i6 from "../sti-dropdown-component/sti-dropdown-component";
import * as i7 from "../sti-tooltip/sti-tooltip.directive";
import * as i8 from "../sti-select-button/sti-select-button.component";
export class StiEmbedTextEditorComponent {
    constructor(model, helper, loc, colorService, signatureService) {
        this.model = model;
        this.helper = helper;
        this.loc = loc;
        this.colorService = colorService;
        this.signatureService = signatureService;
        this.currentText = new StiTextItem();
    }
    get alignment() {
        if (this.currentText.horizontalAlignment == StiHorizontalAlignment.Center) {
            return "center";
        }
        else if (this.currentText.horizontalAlignment == StiHorizontalAlignment.Right) {
            return "end";
        }
        else {
            return "start";
        }
    }
    ngAfterViewInit() {
        setTimeout(() => {
            this.textInput.nativeElement.focus();
        });
    }
    showColorPicker(element, object, isRichText = false) {
        this.colorService.openDialog(element, object, isRichText);
    }
    setContent(innerText) {
        /* if ((this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") && this.showPlaceholder) {
          this.editableContentService.startEdit();
        }
        if (
          this.model.getBrowserType() == "safari" ||
          (this.model.getBrowserType() == "firefox" && !this.showPlaceholder)
        ) {
          this.cdr.detach();
        } */
        this.currentText.value = innerText;
    }
    ngOnInit() {
        this.currentText = this.cloneTextItem(this.signatureService.currentEditableText);
        this.updateSignatureSubscription = this.signatureService.getInsertedInformation.subscribe((event) => {
            if (event.eventName == "TextEditor") {
                this.signatureService.updateSignature.next({ type: "Text", value: this.currentText });
            }
        });
    }
    cloneTextItem(textItem) {
        let result = new StiTextItem();
        let jObject = new StiJson();
        jObject.deserialize(textItem.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        return result;
    }
}
StiEmbedTextEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEmbedTextEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiLocalizationService }, { token: i4.StiColorDialogService }, { token: i5.SignatureService }], target: i0.ɵɵFactoryTarget.Component });
StiEmbedTextEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiEmbedTextEditorComponent, selector: "embed-text-editor", viewQueries: [{ propertyName: "textInput", first: true, predicate: ["textInput"], descendants: true }], ngImport: i0, template: ` <div class="editor-container">
    <div class="editor-navigation">
      <sti-dropdown-component
        [id]="4"
        [options]="model.fontFamilies"
        [(value)]="currentText.font.family"
        [tooltip]="loc.get2('HelpDesigner', 'FontName')"
        [isMinVersion]="true"
        [optionLabel]="'name'"
        [optionValue]="'name'"
        [style]="{
          width: '100px',
          height: '24px',
          alignItems: 'center',
          marginRight: '5px',
          fontSize: '12px'
        }"
      ></sti-dropdown-component>
      <sti-dropdown-component
        [id]="5"
        [options]="helper.fontSizes"
        [(value)]="currentText.font.size"
        [tooltip]="loc.getP('FontSize')"
        [isMinVersion]="true"
        [style]="{
          width: '45px',
          height: '24px',
          alignItems: 'center',
          marginRight: '5px',
          fontSize: '12px'
        }"
      ></sti-dropdown-component>
      <sti-selectButton
        [options]="helper.styleOptions"
        [(value)]="currentText.font.style"
        [multiple]="true"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '87px' }"
        ><ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.value)"
            tooltipPosition="bottom"
            showDelay="500"
          /> </ng-template
      ></sti-selectButton>
      <div class="vertical-line"></div>
      <div
        class="button-container"
        [stiTooltip]="loc.getP('ForeColor')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="showColorPicker(fontColorEditor, currentText.color)"
        (mousedown)="$event.preventDefault()"
        #fontColorEditor
      >
        <div class="preview-container">
          <div class="foreground" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
            <img [src]="model.getImage('images.Brush.png')" alt="" />
          </div>
          <span
            class="color-preview"
            [style.background-color]="
              currentText.color != null ? currentText.color?.toHtmlColor() : 'rgb(182, 181, 180)'
            "
          ></span>
        </div>
        <div [style]="{ position: 'relative', alignSelf: 'center' }">
          <i class="pi pi-chevron-down"></i>
        </div>
      </div>
      <div class="vertical-line"></div>
      <sti-selectButton
        [options]="helper.justifyOptions"
        [(value)]="currentText.eContentAlignment"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
    </div>
    <div class="text-container" (click)="textInput.focus()">
      <label
        class="text-input"
        #textInput
        spellcheck="false"
        [attr.contenteditable]="'plaintext-only'"
        [style]="currentText.htmlStyle()"
        [textContent]="currentText.value"
        [style.text-align]="alignment"
        (input)="setContent($event.target.textContent)"
      ></label>
    </div>
  </div>`, isInline: true, styles: [".text-input{width:100%;height:100%;min-width:10px;margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth;padding:4px}.text-container:hover{cursor:text}.text-container{display:flex}.preview-container{display:flex;width:100%;position:relative;flex-direction:column}.button-container{display:flex;height:26px;width:40px;position:relative;margin:0 2px;border-radius:3px}.button-container:hover{background-color:var(--hover-color)}.button-container:active{background-color:var(--columnDeleteHover-color)}.color-preview{width:20px;height:5px;margin-left:4px}i{height:12px;width:12px;right:3px;top:50%;vertical-align:middle;color:var(--text-color)}.button-container:hover i{color:#fff}.foreground{margin-left:8px;margin-top:2px;width:16px;height:18px}.vertical-line{height:26px;width:1px;background-color:#d3d3d3;margin:0 3px}img{max-width:16px}.text-container{border-radius:3px;border:1px dashed lightgray;height:100%;width:100%}.editor-container{height:calc(100% - 20px);width:calc(100% - 20px);margin:10px;display:flex;flex-direction:column}.editor-navigation{height:26px;margin-bottom:5px;margin-top:10px;display:flex}.navigation-button:hover{background-color:#d3d3d3}.navigation-button{height:26px;width:26px;margin-right:2px;border-radius:3px;display:flex;align-items:center;justify-content:center}.navigation-button img{height:16px;width:16px}\n"], dependencies: [{ kind: "component", type: i6.StiDropdownComponent, selector: "sti-dropdown-component", inputs: ["id", "options", "value", "disabled", "optionLabel", "optionValue", "isMinVersion", "tooltip"], outputs: ["valueChange"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i8.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEmbedTextEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "embed-text-editor", template: ` <div class="editor-container">
    <div class="editor-navigation">
      <sti-dropdown-component
        [id]="4"
        [options]="model.fontFamilies"
        [(value)]="currentText.font.family"
        [tooltip]="loc.get2('HelpDesigner', 'FontName')"
        [isMinVersion]="true"
        [optionLabel]="'name'"
        [optionValue]="'name'"
        [style]="{
          width: '100px',
          height: '24px',
          alignItems: 'center',
          marginRight: '5px',
          fontSize: '12px'
        }"
      ></sti-dropdown-component>
      <sti-dropdown-component
        [id]="5"
        [options]="helper.fontSizes"
        [(value)]="currentText.font.size"
        [tooltip]="loc.getP('FontSize')"
        [isMinVersion]="true"
        [style]="{
          width: '45px',
          height: '24px',
          alignItems: 'center',
          marginRight: '5px',
          fontSize: '12px'
        }"
      ></sti-dropdown-component>
      <sti-selectButton
        [options]="helper.styleOptions"
        [(value)]="currentText.font.style"
        [multiple]="true"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '87px' }"
        ><ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.value)"
            tooltipPosition="bottom"
            showDelay="500"
          /> </ng-template
      ></sti-selectButton>
      <div class="vertical-line"></div>
      <div
        class="button-container"
        [stiTooltip]="loc.getP('ForeColor')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="showColorPicker(fontColorEditor, currentText.color)"
        (mousedown)="$event.preventDefault()"
        #fontColorEditor
      >
        <div class="preview-container">
          <div class="foreground" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
            <img [src]="model.getImage('images.Brush.png')" alt="" />
          </div>
          <span
            class="color-preview"
            [style.background-color]="
              currentText.color != null ? currentText.color?.toHtmlColor() : 'rgb(182, 181, 180)'
            "
          ></span>
        </div>
        <div [style]="{ position: 'relative', alignSelf: 'center' }">
          <i class="pi pi-chevron-down"></i>
        </div>
      </div>
      <div class="vertical-line"></div>
      <sti-selectButton
        [options]="helper.justifyOptions"
        [(value)]="currentText.eContentAlignment"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
    </div>
    <div class="text-container" (click)="textInput.focus()">
      <label
        class="text-input"
        #textInput
        spellcheck="false"
        [attr.contenteditable]="'plaintext-only'"
        [style]="currentText.htmlStyle()"
        [textContent]="currentText.value"
        [style.text-align]="alignment"
        (input)="setContent($event.target.textContent)"
      ></label>
    </div>
  </div>`, styles: [".text-input{width:100%;height:100%;min-width:10px;margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth;padding:4px}.text-container:hover{cursor:text}.text-container{display:flex}.preview-container{display:flex;width:100%;position:relative;flex-direction:column}.button-container{display:flex;height:26px;width:40px;position:relative;margin:0 2px;border-radius:3px}.button-container:hover{background-color:var(--hover-color)}.button-container:active{background-color:var(--columnDeleteHover-color)}.color-preview{width:20px;height:5px;margin-left:4px}i{height:12px;width:12px;right:3px;top:50%;vertical-align:middle;color:var(--text-color)}.button-container:hover i{color:#fff}.foreground{margin-left:8px;margin-top:2px;width:16px;height:18px}.vertical-line{height:26px;width:1px;background-color:#d3d3d3;margin:0 3px}img{max-width:16px}.text-container{border-radius:3px;border:1px dashed lightgray;height:100%;width:100%}.editor-container{height:calc(100% - 20px);width:calc(100% - 20px);margin:10px;display:flex;flex-direction:column}.editor-navigation{height:26px;margin-bottom:5px;margin-top:10px;display:flex}.navigation-button:hover{background-color:#d3d3d3}.navigation-button{height:26px;width:26px;margin-right:2px;border-radius:3px;display:flex;align-items:center;justify-content:center}.navigation-button img{height:16px;width:16px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiLocalizationService }, { type: i4.StiColorDialogService }, { type: i5.SignatureService }]; }, propDecorators: { textInput: [{
                type: ViewChild,
                args: ["textInput"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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