import { Component } from "@angular/core";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../../system/enums";
import { StiImageEditorResult } from "../../elements/signature/StiImageEditorResult";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-helper.service";
import * as i4 from "../../services/sti-signature.service";
import * as i5 from "../sti-universal-checkbox/sti-universal-checkbox.component";
import * as i6 from "../sti-tooltip/sti-tooltip.directive";
import * as i7 from "../sti-select-button/sti-select-button.component";
export class StiEmbedImageEditorComponent {
    constructor(model, loc, helper, signatureService) {
        this.model = model;
        this.loc = loc;
        this.helper = helper;
        this.signatureService = signatureService;
        this.currentVerticalAlignment = StiVerticalAlignment.Center;
        this.currentHorizontalAlignment = StiHorizontalAlignment.Center;
        this.useAspectRatio = false;
        this.useStretch = false;
        this.currentImageNaturalWidth = 0;
        this.currentImageNaturalHeight = 0;
    }
    get hasImage() {
        return this.loadedImage ? true : false;
    }
    get image() {
        return "url(" + this.loadedImage + ")";
    }
    clear() {
        this.loadedImage = null;
    }
    getBackgroundSize(container) {
        if (!this.loadedImage) {
            return;
        }
        if (this.useAspectRatio && this.useStretch) {
            return "contain";
        }
        if (this.useStretch) {
            return `${container.offsetWidth}px ${container.offsetHeight}px`;
        }
        else {
            return `${this.currentImageNaturalWidth}px ${this.currentImageNaturalHeight}px`;
        }
    }
    getBackgroundPosition() {
        if (this.useStretch && !this.useAspectRatio) {
            return `center`;
        }
        else {
            return `${this.signatureService.getVerticalPosition(this.currentVerticalAlignment)} ${this.signatureService.getHorizontalPosition(this.currentHorizontalAlignment)}`;
        }
    }
    getHorizontalAlignment() {
        if (this.currentHorizontalAlignment == StiHorizontalAlignment.Center) {
            return "center";
        }
        else if (this.currentHorizontalAlignment == StiHorizontalAlignment.Left) {
            return "start";
        }
        else {
            return "end";
        }
    }
    onFileSelected(event) {
        if (event.files && event.files[0]) {
            var reader = new FileReader();
            reader.onload = (e) => {
                let image = new Image();
                image.onload = () => {
                    this.currentImageNaturalHeight = image.naturalHeight;
                    this.currentImageNaturalWidth = image.naturalWidth;
                };
                image.src = e.target.result;
                setTimeout(() => {
                    this.loadedImage = e.target.result;
                });
            };
            reader.readAsDataURL(event.files[0]);
        }
    }
    ngOnInit() {
        if (this.signatureService.currentEditableImage) {
            this.loadedImage = this.signatureService.currentEditableImage.loadedImage;
            this.currentVerticalAlignment = this.signatureService.currentEditableImage.verticalAlignment;
            this.currentHorizontalAlignment = this.signatureService.currentEditableImage.horizontalAlignment;
            this.useAspectRatio = this.signatureService.currentEditableImage.aspectRatio;
            this.useStretch = this.signatureService.currentEditableImage.stretch;
            this.currentImageNaturalHeight = this.signatureService.currentEditableImage.naturalHeight;
            this.currentImageNaturalWidth = this.signatureService.currentEditableImage.naturalWidth;
        }
        this.updateSignatureSubscription = this.signatureService.getInsertedInformation.subscribe((event) => {
            if (event.eventName == "ImageEditor") {
                let resultObject = new StiImageEditorResult();
                resultObject.loadedImage = this.loadedImage;
                resultObject.verticalAlignment = this.currentVerticalAlignment;
                resultObject.horizontalAlignment = this.currentHorizontalAlignment;
                resultObject.aspectRatio = this.useAspectRatio;
                resultObject.stretch = this.useStretch;
                resultObject.naturalHeight = this.currentImageNaturalHeight;
                resultObject.naturalWidth = this.currentImageNaturalWidth;
                this.signatureService.updateSignature.next({ type: "Image", value: resultObject });
            }
        });
    }
}
StiEmbedImageEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEmbedImageEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiHelperService }, { token: i4.SignatureService }], target: i0.ɵɵFactoryTarget.Component });
StiEmbedImageEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiEmbedImageEditorComponent, selector: "embed-image-editor", ngImport: i0, template: `<div class="editor-container">
    <div class="editor-navigation">
      <div
        class="navigation-button"
        [style.min-width.px]="50"
        [style.padding]="'0px 10px'"
        [style.width]="'auto'"
        (click)="inputFile.click()"
      >
        <img [src]="model.getImage('images.Other.Open.png')" />
        <span [style.margin-left.px]="2"> {{ loc.get2("Buttons", "Open") }}</span>
      </div>
      <div class="navigation-button {{ hasImage ? '' : 'disabled' }}" (click)="clear()">
        <img [src]="model.getImage('images.Ribbon.Delete.png')" />
      </div>
      <sti-selectButton
        [options]="helper.justifyOptions"
        [(value)]="currentHorizontalAlignment"
        [disabled]="!hasImage"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
      <sti-selectButton
        [options]="helper.verticalAlignment"
        [(value)]="currentVerticalAlignment"
        [disabled]="!hasImage"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
      <sti-checkbox
        class="min-version"
        [(value)]="useAspectRatio"
        [disabled]="!hasImage"
        [label]="'Aspect Ratio'"
      ></sti-checkbox>
      <sti-checkbox
        class="min-version"
        [(value)]="useStretch"
        [disabled]="!hasImage"
        [label]="'Stretch'"
      ></sti-checkbox>
    </div>
    <div class="image-container" #imageContainer [style.justify-content]="getHorizontalAlignment()">
      <input
        type="file"
        [style.display]="'none'"
        accept=".jpg, .jpeg, .png"
        (click)="$event.target.value = null"
        (change)="onFileSelected($event.target)"
        #inputFile
      />
      <div
        class="image-preview"
        [style.width.px]="useStretch && useAspectRatio ? imageContainer.clientHeight : imageContainer.clientWidth"
        [style.height.px]="imageContainer.clientHeight"
        [style.background-image]="image"
        [style.background-position]="getBackgroundPosition()"
        [style.background-size]="getBackgroundSize(imageContainer)"
        [style.background-repeat]="image ? 'no-repeat' : ''"
      ></div>
    </div>
  </div>`, isInline: true, styles: [".image-preview{width:100%;height:100%}.disabled{pointer-events:none;opacity:.6}sti-checkbox{font-size:12px!important;font-family:Arial!important;margin:0 5px}sti-checkbox .label{font-size:12px!important}.image-container{border-radius:3px;border:1px dashed lightgray;height:100%;width:100%;display:flex}.editor-container{height:calc(100% - 20px);width:calc(100% - 20px);margin:10px;display:flex;flex-direction:column}.editor-navigation{height:26px;margin-bottom:5px;margin-top:10px;display:flex}.navigation-button:hover{background-color:#d3d3d3}.navigation-button{height:26px;width:26px;margin-right:2px;border-radius:3px;display:flex;align-items:center;justify-content:center}.navigation-button img{height:16px;width:16px}\n"], dependencies: [{ kind: "component", type: i5.StiUniversalCheckboxComponent, selector: "sti-checkbox", inputs: ["value", "disabled", "label"], outputs: ["valueChange"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i7.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEmbedImageEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "embed-image-editor", template: `<div class="editor-container">
    <div class="editor-navigation">
      <div
        class="navigation-button"
        [style.min-width.px]="50"
        [style.padding]="'0px 10px'"
        [style.width]="'auto'"
        (click)="inputFile.click()"
      >
        <img [src]="model.getImage('images.Other.Open.png')" />
        <span [style.margin-left.px]="2"> {{ loc.get2("Buttons", "Open") }}</span>
      </div>
      <div class="navigation-button {{ hasImage ? '' : 'disabled' }}" (click)="clear()">
        <img [src]="model.getImage('images.Ribbon.Delete.png')" />
      </div>
      <sti-selectButton
        [options]="helper.justifyOptions"
        [(value)]="currentHorizontalAlignment"
        [disabled]="!hasImage"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
      <sti-selectButton
        [options]="helper.verticalAlignment"
        [(value)]="currentVerticalAlignment"
        [disabled]="!hasImage"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
      <sti-checkbox
        class="min-version"
        [(value)]="useAspectRatio"
        [disabled]="!hasImage"
        [label]="'Aspect Ratio'"
      ></sti-checkbox>
      <sti-checkbox
        class="min-version"
        [(value)]="useStretch"
        [disabled]="!hasImage"
        [label]="'Stretch'"
      ></sti-checkbox>
    </div>
    <div class="image-container" #imageContainer [style.justify-content]="getHorizontalAlignment()">
      <input
        type="file"
        [style.display]="'none'"
        accept=".jpg, .jpeg, .png"
        (click)="$event.target.value = null"
        (change)="onFileSelected($event.target)"
        #inputFile
      />
      <div
        class="image-preview"
        [style.width.px]="useStretch && useAspectRatio ? imageContainer.clientHeight : imageContainer.clientWidth"
        [style.height.px]="imageContainer.clientHeight"
        [style.background-image]="image"
        [style.background-position]="getBackgroundPosition()"
        [style.background-size]="getBackgroundSize(imageContainer)"
        [style.background-repeat]="image ? 'no-repeat' : ''"
      ></div>
    </div>
  </div>`, styles: [".image-preview{width:100%;height:100%}.disabled{pointer-events:none;opacity:.6}sti-checkbox{font-size:12px!important;font-family:Arial!important;margin:0 5px}sti-checkbox .label{font-size:12px!important}.image-container{border-radius:3px;border:1px dashed lightgray;height:100%;width:100%;display:flex}.editor-container{height:calc(100% - 20px);width:calc(100% - 20px);margin:10px;display:flex;flex-direction:column}.editor-navigation{height:26px;margin-bottom:5px;margin-top:10px;display:flex}.navigation-button:hover{background-color:#d3d3d3}.navigation-button{height:26px;width:26px;margin-right:2px;border-radius:3px;display:flex;align-items:center;justify-content:center}.navigation-button img{height:16px;width:16px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiHelperService }, { type: i4.SignatureService }]; } });
//# sourceMappingURL=data:application/json;base64,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