import { Component, Input, ViewChild, } from "@angular/core";
import { StiHorizontalAlignment, StiLabelAlignment } from "../system/enums";
import { Enum } from "../system/Enum";
import { StiTableElement } from "../elements/StiTableElement";
import { StiColumnItem } from "../elements/table/StiColumnItem";
import { StiRowLabel } from "../elements/table/StiRowLabel";
import { StiTotalsFieldItem } from "../elements/table/StiTotalsFieldItem";
import { StiLabelItem } from "../elements/text/StiLabelItem";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-editable-content.service";
import * as i3 from "../services/mouse.service";
import * as i4 from "@angular/common";
////
export class StiEditableContentComponent {
    constructor(model, editableContentService, mouseService, cdr) {
        this.model = model;
        this.editableContentService = editableContentService;
        this.mouseService = mouseService;
        this.cdr = cdr;
        this.required = false;
        this.hideEmpty = true;
        this.active = true;
        this.isTableTotalHeader = false;
        this.disablePadding = false;
        this.fromButton = false;
        this.isTableHeader = false;
        this.isInitialize = false;
        this.focused = false;
    }
    get cursor() {
        if (this.model.isPreviewMode) {
            return "default";
        }
        else {
            return this.showPlaceholder ? "text" : "";
        }
    }
    get showPlaceholder() {
        return (!this.hideEmpty &&
            !(!this.focused && this.displayContent != null ? this.displayContent : this.editableContent?.eValue) &&
            this.active &&
            !this.model.isPreviewMode /* &&
        this.editableContentService.editableContent != this.editableContent */);
    }
    hasWordWrap() {
        return this.editableContent["useWordWrap"] ? true : false;
    }
    get showNonActivePlaceholder() {
        return (!this.hideEmpty &&
            !(!this.focused && this.displayContent != null ? this.displayContent : this.editableContent?.eValue) &&
            ((!this.active && !this.model.isPreviewMode) ||
                (!this.active && this.model.isPreviewMode) ||
                (this.active && this.model.isPreviewMode)) /* &&
      this.editableContentService.editableContent != this.editableContent */);
    }
    get placeholderOutline() {
        if (this.showPlaceholder) {
            return !this.fromButton ? "1px dashed rgba(213, 213, 213, 0.8)" : "1px dashed rgba(255, 255, 255, 1)";
        }
        else {
            return "";
        }
    }
    click() {
        if (this.showPlaceholder) {
            this.elementRef.nativeElement.focus();
        }
    }
    get isEditable() {
        return (!this.model.isPreviewMode &&
            (this.editableContentService.editableContent == this.editableContent || this.showPlaceholder));
    }
    get width() {
        if (this.editableContent instanceof StiLabelItem && this.editableContent.alignment != StiLabelAlignment.Top) {
            return this.editableContent.width + "px";
        }
        else {
            return "100%";
        }
    }
    get align() {
        if (this.alignment) {
            return Enum.getName(StiHorizontalAlignment, this.alignment);
        }
        else {
            return "";
        }
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
    }
    ngAfterContentInit() {
        setTimeout(() => {
            if (this.editableContent && this.eParent) {
                this.editableContent.eParent = this.eParent;
            }
        }, 0);
    }
    needToUpdate(event) {
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        let needToUpdate = true;
        elements.forEach((element) => {
            if (element.className == "Properties") {
                needToUpdate = false;
            }
        });
        if (needToUpdate &&
            typeof this.editableContentService.editableContent != typeof this.editableContent &&
            this.isInitialize &&
            !this.editableContentService.activeControl) {
            this.closeAll(this.model.selectedComponent?.element);
            this.isInitialize = false;
            needToUpdate = true;
            this.model.needToRefresh.next(true);
        }
    }
    focus() {
        this.editableContentService.editableContent = this.editableContent;
        this.editableContentService.editableElementRef = this.elementRef;
        if (this.model.selectedComponent?.element instanceof StiTableElement) {
            // this.closeAll(this.model.selectedComponent.element);
            // this.model.currentTablePropertyHeader.next("Table");
            if (this.editableContent instanceof StiColumnItem) {
                if (!this.model.selectedComponent?.element.showColumnsEditor) {
                    this.model.selectedComponent.element.showColumnsEditor = true;
                    this.model.needToRefresh.next(true);
                }
                // this.model.currentTablePropertyHeader.next("Columns");
                setTimeout(() => {
                    if (this.model.selectedComponent?.element instanceof StiTableElement) {
                        let index = this.model.selectedComponent.element.columns.findIndex((column) => column == this.editableContent);
                        if (this.model.currentContentEditableItemIndex != index ||
                            this.model.previousSelectedComponent != this.model.selectedComponent)
                            this.model.currentContentEditableItem.next(index);
                        this.model.currentContentEditableItemIndex = index;
                    }
                }, 0);
            }
            else if (this.editableContent instanceof StiRowLabel) {
                this.model.selectedComponent.element.showRowsEditor = true;
                this.model.needToRefresh.next(true);
                // this.model.currentTablePropertyHeader.next("Rows");
                /*  setTimeout(() => {
                  if (this.model.selectedComponent.element instanceof StiTableElement) {
                    this.model.currentContentEditableItem.next(
                      this.model.selectedComponent.element.rowLabelsContentEditable.findIndex(
                        (column) => column == this.editableContent
                      )
                    );
                  }
                }, 0); */
            }
            else if (this.editableContent instanceof StiTotalsFieldItem) {
                if (!this.model.selectedComponent.element.showTotalsEditor) {
                    this.model.selectedComponent.element.showTotalsEditor = true;
                    this.model.needToRefresh.next(true);
                }
                // this.model.currentTablePropertyHeader.next("Totals");
                setTimeout(() => {
                    if (this.model.selectedComponent.element instanceof StiTableElement) {
                        let index = this.model.selectedComponent.element.totalsFields.findIndex((column) => column == this.editableContent);
                        this.model.currentContentEditableItem.next(index);
                    }
                }, 0);
            }
            else if (this.isTableTotalHeader) {
                this.model.selectedComponent.element.showTotalsEditor = true;
                this.model.needToRefresh.next(true);
            }
            else {
                this.model.selectedComponent.element.showHeaderEditor = true;
                this.model.needToRefresh.next(true);
            }
        }
        this.isInitialize = true;
        this.focused = true;
    }
    blur() {
        if (!this.editableContentService.activeControl) {
            setTimeout(() => {
                if (this.editableContentService.editableContent == this.editableContent) {
                    this.editableContentService.editableContent = null;
                    this.editableContentService.editableElementRef = null;
                    if (this.model.getBrowserType() == "safari" ||
                        (this.model.getBrowserType() == "firefox" && !this.showPlaceholder)) {
                        this.cdr.reattach();
                        this.cdr.detectChanges();
                    }
                    this.model.formEvents.next({ name: "ValueChanged" });
                }
            }, 0);
            this.focused = false;
            // this.model.needToRefresh.next(true);
        }
    }
    setContent(innerText) {
        if ((this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") && this.showPlaceholder) {
            this.editableContentService.startEdit();
        }
        if (this.model.getBrowserType() == "safari" ||
            (this.model.getBrowserType() == "firefox" && !this.showPlaceholder)) {
            this.cdr.detach();
        }
        this.editableContent.eValue = innerText;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    getCharCode(event) {
        return null === event.which ? event.keyCode : !(0 === event.which || 0 === event.charCode) ? event.which : -1;
    }
    disableEnter(event) {
        if (13 === this.getCharCode(event)) {
            event.preventDefault();
            this.blur();
        }
    }
    disableDrag(event) {
        event.fromEditableContent = true;
        this.focus();
    }
    closeAll(element) {
        if (element instanceof StiTableElement) {
            element.showTotalsEditor = false;
            element.showRowsEditor = false;
            element.showColumnsEditor = false;
        }
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.needToUpdate(event);
        });
    }
}
StiEditableContentComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEditableContentComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiEditableContentService }, { token: i3.StiMouseService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
StiEditableContentComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiEditableContentComponent, selector: "sti-editable-content-component", inputs: { editableContent: "editableContent", displayContent: "displayContent", required: "required", eParent: "eParent", hideEmpty: "hideEmpty", active: "active", alignment: "alignment", isTableTotalHeader: "isTableTotalHeader", disablePadding: "disablePadding", fromButton: "fromButton", parentCursor: "parentCursor", isTableHeader: "isTableHeader" }, viewQueries: [{ propertyName: "elementRef", first: true, predicate: ["elementRef"], descendants: true }], ngImport: i0, template: ` <div
    style="-webkit-user-select: {{ model.getBrowserType() == 'safari' ? 'text' : '' }}"
    [style.width]="width"
    [style.overflow]="'hidden'"
  >
    <div
      class="editable-content"
      [style.display]="alignment ? 'flex' : ''"
      [style.justify-content]="align"
      [style.width]="showPlaceholder ? '10px' : width"
      [style.minWidth.px]="showPlaceholder ? 10 : 0"
      [style.outline]="placeholderOutline"
      [style.outline-offset]="'-1px'"
      [style.cursor]="cursor"
      (click)="click()"
    >
      <label
        #elementRef
        *ngIf="!focused && displayContent != null ? displayContent : editableContent?.eValue || !hideEmpty"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        [style.padding-right.px]="disablePadding || required ? 0.1 : showNonActivePlaceholder ? 0 : 5"
        spellcheck="false"
        [style.cursor]="parentCursor ? parentCursor : !model.isPreviewMode ? 'text' : 'default'"
        [attr.contenteditable]="isEditable ? 'plaintext-only' : false"
        [textContent]="!focused && displayContent != null ? displayContent : editableContent?.eValue"
        [style.word-wrap]="hasWordWrap() ? 'break-word' : ''"
        [style.white-space]="hasWordWrap() ? '' : 'nowrap'"
        [style.width]="showPlaceholder ? '100%' : ''"
        [style.text-align]="isTableHeader ? align : ''"
        (input)="setContent($event.target.textContent)"
        (keypress)="disableEnter($event)"
        (focus)="focus()"
        (mousedown)="disableDrag($event)"
        (blur)="blur()"
      >
      </label>
      <span
        class="required"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        *ngIf="required"
        [style.color]="'red'"
        [style.font-style]="'normal'"
        [style.font-weight]="'normal'"
        >*</span
      >
      <div
        *ngIf="showNonActivePlaceholder"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        class="empty-content"
      >
        .
      </div>
    </div>
  </div>`, isInline: true, styles: [".empty-content{position:relative;left:0;top:0;opacity:0;max-height:1px}label{margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth}.required{color:red;position:relative;margin:0 2px}label:hover{cursor:text}.editable-content{overflow:hidden}\n"], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEditableContentComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-editable-content-component", template: ` <div
    style="-webkit-user-select: {{ model.getBrowserType() == 'safari' ? 'text' : '' }}"
    [style.width]="width"
    [style.overflow]="'hidden'"
  >
    <div
      class="editable-content"
      [style.display]="alignment ? 'flex' : ''"
      [style.justify-content]="align"
      [style.width]="showPlaceholder ? '10px' : width"
      [style.minWidth.px]="showPlaceholder ? 10 : 0"
      [style.outline]="placeholderOutline"
      [style.outline-offset]="'-1px'"
      [style.cursor]="cursor"
      (click)="click()"
    >
      <label
        #elementRef
        *ngIf="!focused && displayContent != null ? displayContent : editableContent?.eValue || !hideEmpty"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        [style.padding-right.px]="disablePadding || required ? 0.1 : showNonActivePlaceholder ? 0 : 5"
        spellcheck="false"
        [style.cursor]="parentCursor ? parentCursor : !model.isPreviewMode ? 'text' : 'default'"
        [attr.contenteditable]="isEditable ? 'plaintext-only' : false"
        [textContent]="!focused && displayContent != null ? displayContent : editableContent?.eValue"
        [style.word-wrap]="hasWordWrap() ? 'break-word' : ''"
        [style.white-space]="hasWordWrap() ? '' : 'nowrap'"
        [style.width]="showPlaceholder ? '100%' : ''"
        [style.text-align]="isTableHeader ? align : ''"
        (input)="setContent($event.target.textContent)"
        (keypress)="disableEnter($event)"
        (focus)="focus()"
        (mousedown)="disableDrag($event)"
        (blur)="blur()"
      >
      </label>
      <span
        class="required"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        *ngIf="required"
        [style.color]="'red'"
        [style.font-style]="'normal'"
        [style.font-weight]="'normal'"
        >*</span
      >
      <div
        *ngIf="showNonActivePlaceholder"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        class="empty-content"
      >
        .
      </div>
    </div>
  </div>`, styles: [".empty-content{position:relative;left:0;top:0;opacity:0;max-height:1px}label{margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth}.required{color:red;position:relative;margin:0 2px}label:hover{cursor:text}.editable-content{overflow:hidden}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiEditableContentService }, { type: i3.StiMouseService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { elementRef: [{
                type: ViewChild,
                args: ["elementRef"]
            }], editableContent: [{
                type: Input
            }], displayContent: [{
                type: Input
            }], required: [{
                type: Input
            }], eParent: [{
                type: Input
            }], hideEmpty: [{
                type: Input
            }], active: [{
                type: Input
            }], alignment: [{
                type: Input
            }], isTableTotalHeader: [{
                type: Input
            }], disablePadding: [{
                type: Input
            }], fromButton: [{
                type: Input
            }], parentCursor: [{
                type: Input
            }], isTableHeader: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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