import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./sti-dropdown-service";
import * as i2 from "../../services/sti-editable-content.service";
import * as i3 from "@angular/common";
export class StiDropdownListComponent {
    constructor(dropdownService, editableContentService) {
        this.dropdownService = dropdownService;
        this.editableContentService = editableContentService;
    }
    get list() {
        return this.dropdownService.currentOptionList;
    }
    getValue(index) {
        let value = this.list[index][this.dropdownService.optionLabel ? this.dropdownService.optionLabel : index.toString()];
        return value ? value : this.list[index];
    }
    isActive(index) {
        let value = this.list[index][this.dropdownService.optionLabel ? this.dropdownService.optionLabel : index.toString()];
        return value ? value == this.dropdownService.currentValue : this.list[index] == this.dropdownService.currentValue;
    }
    setItem(index) {
        let item = this.dropdownService.currentOptionList[index][this.dropdownService.optionValue ? this.dropdownService.optionValue : index.toString()];
        this.dropdownService.valueChanged.next(item ? item : this.dropdownService.currentOptionList[index]);
        this.dropdownService.showDropdownList = false;
        this.dropdownService.optionLabel = null;
        this.dropdownService.optionValue = null;
    }
    ngOnInit() { }
}
StiDropdownListComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDropdownListComponent, deps: [{ token: i1.StiDropdownService }, { token: i2.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component });
StiDropdownListComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiDropdownListComponent, selector: "sti-dropdown-list-component", ngImport: i0, template: `<div
    class="sti-dropdown-list"
    [style.left.px]="dropdownService.dropdownX"
    [style.top.px]="dropdownService.dropdownY + 2"
  >
    <span
      class="list-item {{ isActive(i) ? 'active' : '' }}"
      *ngFor="let item of list; let i = index"
      (click)="setItem(i)"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      >{{ getValue(i) }}</span
    >
  </div>`, isInline: true, styles: [".active{background-color:#efefef!important}.sti-dropdown-list{position:absolute;display:flex;flex-direction:column;max-height:400px;max-width:202px;overflow-x:hidden;overflow-y:auto;background:var(--input-color);color:var(--text-color);border:1px solid #c8c8c8;border-radius:3px;font-size:13px;z-index:999999999999999;box-shadow:0 3px 6px #00000029;-webkit-touch-callout:none;-webkit-user-select:none;user-select:none}.list-item{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;margin:0;padding:.429rem .857rem;border:0 none;color:var(--text-color);background:transparent;transition:background-color .2s,box-shadow .2s;border-radius:0;cursor:pointer;font-weight:400;position:relative;white-space:nowrap}.list-item:hover{background-color:#d3d3d3!important}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDropdownListComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-dropdown-list-component", template: `<div
    class="sti-dropdown-list"
    [style.left.px]="dropdownService.dropdownX"
    [style.top.px]="dropdownService.dropdownY + 2"
  >
    <span
      class="list-item {{ isActive(i) ? 'active' : '' }}"
      *ngFor="let item of list; let i = index"
      (click)="setItem(i)"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      >{{ getValue(i) }}</span
    >
  </div>`, styles: [".active{background-color:#efefef!important}.sti-dropdown-list{position:absolute;display:flex;flex-direction:column;max-height:400px;max-width:202px;overflow-x:hidden;overflow-y:auto;background:var(--input-color);color:var(--text-color);border:1px solid #c8c8c8;border-radius:3px;font-size:13px;z-index:999999999999999;box-shadow:0 3px 6px #00000029;-webkit-touch-callout:none;-webkit-user-select:none;user-select:none}.list-item{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;margin:0;padding:.429rem .857rem;border:0 none;color:var(--text-color);background:transparent;transition:background-color .2s,box-shadow .2s;border-radius:0;cursor:pointer;font-weight:400;position:relative;white-space:nowrap}.list-item:hover{background-color:#d3d3d3!important}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiDropdownService }, { type: i2.StiEditableContentService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWRyb3Bkb3duLWxpc3QuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2NvbXBvbmVudHMvc3RpLWRyb3Bkb3duLWNvbXBvbmVudC9zdGktZHJvcGRvd24tbGlzdC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBVSxNQUFNLGVBQWUsQ0FBQzs7Ozs7QUFvRWxELE1BQU0sT0FBTyx3QkFBd0I7SUF3Qm5DLFlBQW1CLGVBQW1DLEVBQVMsc0JBQWlEO1FBQTdGLG9CQUFlLEdBQWYsZUFBZSxDQUFvQjtRQUFTLDJCQUFzQixHQUF0QixzQkFBc0IsQ0FBMkI7SUFBRyxDQUFDO0lBdkJwSCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsaUJBQWlCLENBQUM7SUFDaEQsQ0FBQztJQUNNLFFBQVEsQ0FBQyxLQUFLO1FBQ25CLElBQUksS0FBSyxHQUNQLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQztRQUMzRyxPQUFPLEtBQUssQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFDTSxRQUFRLENBQUMsS0FBSztRQUNuQixJQUFJLEtBQUssR0FDUCxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7UUFDM0csT0FBTyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsZUFBZSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxJQUFJLENBQUMsZUFBZSxDQUFDLFlBQVksQ0FBQztJQUNwSCxDQUFDO0lBQ0QsT0FBTyxDQUFDLEtBQUs7UUFDWCxJQUFJLElBQUksR0FDTixJQUFJLENBQUMsZUFBZSxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQyxDQUMzQyxJQUFJLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FDdkYsQ0FBQztRQUNKLElBQUksQ0FBQyxlQUFlLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1FBQ3BHLElBQUksQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO1FBQzlDLElBQUksQ0FBQyxlQUFlLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQztRQUN4QyxJQUFJLENBQUMsZUFBZSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUM7SUFDMUMsQ0FBQztJQUdELFFBQVEsS0FBSSxDQUFDOztxSEExQkYsd0JBQXdCO3lHQUF4Qix3QkFBd0IsbUVBOUR6Qjs7Ozs7Ozs7Ozs7OztTQWFIOzJGQWlESSx3QkFBd0I7a0JBaEVwQyxTQUFTOytCQUNFLDZCQUE2QixZQUM3Qjs7Ozs7Ozs7Ozs7OztTQWFIIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBPbkluaXQgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgeyBTdGlFZGl0YWJsZUNvbnRlbnRTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL3N0aS1lZGl0YWJsZS1jb250ZW50LnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpRHJvcGRvd25TZXJ2aWNlIH0gZnJvbSBcIi4vc3RpLWRyb3Bkb3duLXNlcnZpY2VcIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcInN0aS1kcm9wZG93bi1saXN0LWNvbXBvbmVudFwiLFxyXG4gIHRlbXBsYXRlOiBgPGRpdlxyXG4gICAgY2xhc3M9XCJzdGktZHJvcGRvd24tbGlzdFwiXHJcbiAgICBbc3R5bGUubGVmdC5weF09XCJkcm9wZG93blNlcnZpY2UuZHJvcGRvd25YXCJcclxuICAgIFtzdHlsZS50b3AucHhdPVwiZHJvcGRvd25TZXJ2aWNlLmRyb3Bkb3duWSArIDJcIlxyXG4gID5cclxuICAgIDxzcGFuXHJcbiAgICAgIGNsYXNzPVwibGlzdC1pdGVtIHt7IGlzQWN0aXZlKGkpID8gJ2FjdGl2ZScgOiAnJyB9fVwiXHJcbiAgICAgICpuZ0Zvcj1cImxldCBpdGVtIG9mIGxpc3Q7IGxldCBpID0gaW5kZXhcIlxyXG4gICAgICAoY2xpY2spPVwic2V0SXRlbShpKVwiXHJcbiAgICAgIChtb3VzZWRvd24pPVwiJGV2ZW50LnByZXZlbnREZWZhdWx0KClcIlxyXG4gICAgICAobW91c2V1cCk9XCJlZGl0YWJsZUNvbnRlbnRTZXJ2aWNlLnN0YXJ0RWRpdCgpXCJcclxuICAgICAgPnt7IGdldFZhbHVlKGkpIH19PC9zcGFuXHJcbiAgICA+XHJcbiAgPC9kaXY+YCxcclxuICBzdHlsZXM6IFtcclxuICAgIGBcclxuICAgICAgLmFjdGl2ZSB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIzOSwgMjM5LCAyMzkpICFpbXBvcnRhbnQ7XHJcbiAgICAgIH1cclxuICAgICAgLnN0aS1kcm9wZG93bi1saXN0IHtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xyXG4gICAgICAgIG1heC1oZWlnaHQ6IDQwMHB4O1xyXG4gICAgICAgIG1heC13aWR0aDogMjAycHg7XHJcbiAgICAgICAgb3ZlcmZsb3cteDogaGlkZGVuO1xyXG4gICAgICAgIG92ZXJmbG93LXk6IGF1dG87XHJcbiAgICAgICAgYmFja2dyb3VuZDogdmFyKC0taW5wdXQtY29sb3IpO1xyXG4gICAgICAgIGNvbG9yOiB2YXIoLS10ZXh0LWNvbG9yKTtcclxuICAgICAgICBib3JkZXI6IDFweCBzb2xpZCAjYzhjOGM4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgICBmb250LXNpemU6IDEzcHg7XHJcbiAgICAgICAgei1pbmRleDogOTk5OTk5OTk5OTk5OTk5O1xyXG4gICAgICAgIGJveC1zaGFkb3c6IDAgM3B4IDZweCAwIHJnYmEoMCwgMCwgMCwgMC4xNik7XHJcbiAgICAgICAgLXdlYmtpdC10b3VjaC1jYWxsb3V0OiBub25lO1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgICAgLWtodG1sLXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICAgIC1tb3otdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgICAgLW1zLXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICAgIHVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICB9XHJcbiAgICAgIC5saXN0LWl0ZW0ge1xyXG4gICAgICAgIGZvbnQtZmFtaWx5OiAtYXBwbGUtc3lzdGVtLCBCbGlua01hY1N5c3RlbUZvbnQsIFwiU2Vnb2UgVUlcIiwgUm9ib3RvLCBIZWx2ZXRpY2EsIEFyaWFsLCBzYW5zLXNlcmlmLFxyXG4gICAgICAgICAgXCJBcHBsZSBDb2xvciBFbW9qaVwiLCBcIlNlZ29lIFVJIEVtb2ppXCIsIFwiU2Vnb2UgVUkgU3ltYm9sXCI7XHJcbiAgICAgICAgbWFyZ2luOiAwO1xyXG4gICAgICAgIHBhZGRpbmc6IDAuNDI5cmVtIDAuODU3cmVtO1xyXG4gICAgICAgIGJvcmRlcjogMCBub25lO1xyXG4gICAgICAgIGNvbG9yOiB2YXIoLS10ZXh0LWNvbG9yKTtcclxuICAgICAgICBiYWNrZ3JvdW5kOiB0cmFuc3BhcmVudDtcclxuICAgICAgICB0cmFuc2l0aW9uOiBiYWNrZ3JvdW5kLWNvbG9yIDAuMnMsIGJveC1zaGFkb3cgMC4ycztcclxuICAgICAgICBib3JkZXItcmFkaXVzOiAwO1xyXG4gICAgICAgIGN1cnNvcjogcG9pbnRlcjtcclxuICAgICAgICBmb250LXdlaWdodDogNDAwO1xyXG4gICAgICAgIHBvc2l0aW9uOiByZWxhdGl2ZTtcclxuICAgICAgICB3aGl0ZS1zcGFjZTogbm93cmFwO1xyXG4gICAgICB9XHJcbiAgICAgIC5saXN0LWl0ZW06aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IGxpZ2h0Z3JheSAhaW1wb3J0YW50O1xyXG4gICAgICB9XHJcbiAgICBgLFxyXG4gIF0sXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBTdGlEcm9wZG93bkxpc3RDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG4gIHB1YmxpYyBnZXQgbGlzdCgpIHtcclxuICAgIHJldHVybiB0aGlzLmRyb3Bkb3duU2VydmljZS5jdXJyZW50T3B0aW9uTGlzdDtcclxuICB9XHJcbiAgcHVibGljIGdldFZhbHVlKGluZGV4KSB7XHJcbiAgICBsZXQgdmFsdWUgPVxyXG4gICAgICB0aGlzLmxpc3RbaW5kZXhdW3RoaXMuZHJvcGRvd25TZXJ2aWNlLm9wdGlvbkxhYmVsID8gdGhpcy5kcm9wZG93blNlcnZpY2Uub3B0aW9uTGFiZWwgOiBpbmRleC50b1N0cmluZygpXTtcclxuICAgIHJldHVybiB2YWx1ZSA/IHZhbHVlIDogdGhpcy5saXN0W2luZGV4XTtcclxuICB9XHJcbiAgcHVibGljIGlzQWN0aXZlKGluZGV4KSB7XHJcbiAgICBsZXQgdmFsdWUgPVxyXG4gICAgICB0aGlzLmxpc3RbaW5kZXhdW3RoaXMuZHJvcGRvd25TZXJ2aWNlLm9wdGlvbkxhYmVsID8gdGhpcy5kcm9wZG93blNlcnZpY2Uub3B0aW9uTGFiZWwgOiBpbmRleC50b1N0cmluZygpXTtcclxuICAgIHJldHVybiB2YWx1ZSA/IHZhbHVlID09IHRoaXMuZHJvcGRvd25TZXJ2aWNlLmN1cnJlbnRWYWx1ZSA6IHRoaXMubGlzdFtpbmRleF0gPT0gdGhpcy5kcm9wZG93blNlcnZpY2UuY3VycmVudFZhbHVlO1xyXG4gIH1cclxuICBzZXRJdGVtKGluZGV4KSB7XHJcbiAgICBsZXQgaXRlbSA9XHJcbiAgICAgIHRoaXMuZHJvcGRvd25TZXJ2aWNlLmN1cnJlbnRPcHRpb25MaXN0W2luZGV4XVtcclxuICAgICAgICB0aGlzLmRyb3Bkb3duU2VydmljZS5vcHRpb25WYWx1ZSA/IHRoaXMuZHJvcGRvd25TZXJ2aWNlLm9wdGlvblZhbHVlIDogaW5kZXgudG9TdHJpbmcoKVxyXG4gICAgICBdO1xyXG4gICAgdGhpcy5kcm9wZG93blNlcnZpY2UudmFsdWVDaGFuZ2VkLm5leHQoaXRlbSA/IGl0ZW0gOiB0aGlzLmRyb3Bkb3duU2VydmljZS5jdXJyZW50T3B0aW9uTGlzdFtpbmRleF0pO1xyXG4gICAgdGhpcy5kcm9wZG93blNlcnZpY2Uuc2hvd0Ryb3Bkb3duTGlzdCA9IGZhbHNlO1xyXG4gICAgdGhpcy5kcm9wZG93blNlcnZpY2Uub3B0aW9uTGFiZWwgPSBudWxsO1xyXG4gICAgdGhpcy5kcm9wZG93blNlcnZpY2Uub3B0aW9uVmFsdWUgPSBudWxsO1xyXG4gIH1cclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgZHJvcGRvd25TZXJ2aWNlOiBTdGlEcm9wZG93blNlcnZpY2UsIHB1YmxpYyBlZGl0YWJsZUNvbnRlbnRTZXJ2aWNlOiBTdGlFZGl0YWJsZUNvbnRlbnRTZXJ2aWNlKSB7fVxyXG5cclxuICBuZ09uSW5pdCgpIHt9XHJcbn1cclxuIl19