import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./sti-dropdown-service";
import * as i2 from "../../services/model.service";
import * as i3 from "../sti-tooltip/sti-tooltip.directive";
export class StiDropdownComponent {
    constructor(dropdownService, model) {
        this.dropdownService = dropdownService;
        this.model = model;
        this.optionLabel = null;
        this.optionValue = null;
        this.isMinVersion = false;
        this.valueChange = new EventEmitter();
    }
    ngOnDestroy() {
        this.valueChangedSubscription.unsubscribe();
    }
    ngOnInit() {
        this.valueChangedSubscription = this.dropdownService.valueChanged.subscribe((value) => {
            if (this.id == this.dropdownService.currentUsedComponentId) {
                this.valueChange.emit(value);
            }
        });
    }
    getLabel() {
        if (this.optionLabel == this.optionValue) {
            return this.value;
        }
        else {
            let option = this.options.find((option) => option[this.optionValue] == this.value);
            return option[this.optionLabel];
        }
    }
    showList(event) {
        let parentRec = this.model.getPositionRelativeToForm(event.target.parentElement);
        this.dropdownService.dropdownX = parentRec.left;
        this.dropdownService.dropdownY = parentRec.bottom;
        this.dropdownService.currentOptionList = this.options;
        this.dropdownService.optionLabel = this.optionLabel;
        this.dropdownService.optionValue = this.optionValue;
        this.dropdownService.currentValue = this.getLabel();
        this.dropdownService.currentUsedComponentId = this.id;
        this.dropdownService.showDropdownList = true;
    }
}
StiDropdownComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDropdownComponent, deps: [{ token: i1.StiDropdownService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiDropdownComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiDropdownComponent, selector: "sti-dropdown-component", inputs: { id: "id", options: "options", value: "value", disabled: "disabled", optionLabel: "optionLabel", optionValue: "optionValue", isMinVersion: "isMinVersion", tooltip: "tooltip" }, outputs: { valueChange: "valueChange" }, ngImport: i0, template: `<div
    class="sti-dropdown-component {{ disabled ? 'disabled' : '' }}"
    [stiTooltip]="tooltip"
    tooltipPosition="bottom"
    showDelay="500"
    (click)="showList($event)"
  >
    <span class="current-value">{{
      value ? this.getLabel() : options.length > 0 ? (options[0]["name"] ? options[0]["name"] : options[0]) : ""
    }}</span>
    <div class="button" [style.width.px]="isMinVersion ? 15 : 20">
      <span><i class="pi pi-chevron-down"></i></span>
    </div>
  </div>`, isInline: true, styles: [".sti-dropdown-component{width:inherit;height:inherit;background:var(--input-color);border:1px solid var(--inputBorder-color);border-radius:3px;display:flex;align-items:center}.sti-dropdown-component:hover{background-color:#dadada}.current-value{flex:1;padding:3px 5px;overflow:hidden;white-space:nowrap}.button{width:20px}.button i{height:12px;width:12px;right:3px;color:#bab9b8}.disabled{pointer-events:none;opacity:.5}span{pointer-events:none}\n"], dependencies: [{ kind: "directive", type: i3.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDropdownComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-dropdown-component", template: `<div
    class="sti-dropdown-component {{ disabled ? 'disabled' : '' }}"
    [stiTooltip]="tooltip"
    tooltipPosition="bottom"
    showDelay="500"
    (click)="showList($event)"
  >
    <span class="current-value">{{
      value ? this.getLabel() : options.length > 0 ? (options[0]["name"] ? options[0]["name"] : options[0]) : ""
    }}</span>
    <div class="button" [style.width.px]="isMinVersion ? 15 : 20">
      <span><i class="pi pi-chevron-down"></i></span>
    </div>
  </div>`, styles: [".sti-dropdown-component{width:inherit;height:inherit;background:var(--input-color);border:1px solid var(--inputBorder-color);border-radius:3px;display:flex;align-items:center}.sti-dropdown-component:hover{background-color:#dadada}.current-value{flex:1;padding:3px 5px;overflow:hidden;white-space:nowrap}.button{width:20px}.button i{height:12px;width:12px;right:3px;color:#bab9b8}.disabled{pointer-events:none;opacity:.5}span{pointer-events:none}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiDropdownService }, { type: i2.StiModelService }]; }, propDecorators: { id: [{
                type: Input
            }], options: [{
                type: Input
            }], value: [{
                type: Input
            }], disabled: [{
                type: Input
            }], optionLabel: [{
                type: Input
            }], optionValue: [{
                type: Input
            }], isMinVersion: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], valueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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