import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-draggable-modal-window.service";
import * as i4 from "../../services/sti-signature.service";
import * as i5 from "../../services/mouse.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-embed-editors/sti-embed-text-editor.components";
import * as i8 from "../sti-embed-editors/sti-embed-image-editor.component";
export class StiDraggableModalWindowComponent {
    constructor(model, loc, modalWindowService, signatureService, mouseService) {
        this.model = model;
        this.loc = loc;
        this.modalWindowService = modalWindowService;
        this.signatureService = signatureService;
        this.mouseService = mouseService;
    }
    ngAfterViewInit() {
        const onResize = (event) => {
            this.modalWindowService.editorX = (window.innerWidth - this.modalWindowService.editorWidth) / 2;
            this.modalWindowService.editorY = (window.innerHeight - this.modalWindowService.editorHeight) / 2;
        };
        window.addEventListener("resize", onResize);
    }
    get header() {
        return this.modalWindowService.isTextEditor
            ? this.loc.get2("FormTitles", "TextEditorForm")
            : this.loc.get2("Components", "StiImage");
    }
    startDrag(event) {
        this.startX = event.clientX;
        this.startY = event.clientY;
        this.startComponentX = this.modalWindowService.editorX;
        this.startComponentY = this.modalWindowService.editorY;
        this.isDragging = true;
    }
    accept() {
        this.modalWindowService.isTextEditor
            ? this.signatureService.getInsertedInformation.next({ eventName: "TextEditor" })
            : this.signatureService.getInsertedInformation.next({ eventName: "ImageEditor" });
        this.model.showDraggableModalWindow = false;
    }
    onMouseMove(event) {
        if (this.isDragging) {
            let deltaX = event.clientX - this.startX;
            let deltaY = event.clientY - this.startY;
            if (this.startComponentX + deltaX < 0) {
                this.modalWindowService.editorX = 0;
            }
            else if (this.startComponentX + deltaX > window.innerWidth - this.modalWindowService.editorWidth) {
                this.modalWindowService.editorX = window.innerWidth - this.modalWindowService.editorWidth;
            }
            else {
                this.modalWindowService.editorX = this.startComponentX + deltaX;
            }
            if (this.startComponentY + deltaY < 0) {
                this.modalWindowService.editorY = 0;
            }
            else if (this.startComponentY + deltaY > window.innerHeight - this.modalWindowService.editorHeight) {
                this.modalWindowService.editorY = window.innerHeight - this.modalWindowService.editorHeight;
            }
            else {
                this.modalWindowService.editorY = this.startComponentY + deltaY;
            }
        }
    }
    ngOnInit() {
        this.modalWindowService.editorX = (window.innerWidth - this.modalWindowService.editorWidth) / 2;
        this.modalWindowService.editorY = (window.innerHeight - this.modalWindowService.editorHeight) / 2;
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.isDragging = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
    }
}
StiDraggableModalWindowComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDraggableModalWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiDraggableModalWindowService }, { token: i4.SignatureService }, { token: i5.StiMouseService }], target: i0.ɵɵFactoryTarget.Component });
StiDraggableModalWindowComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiDraggableModalWindowComponent, selector: "sti-draggable-modal-window", ngImport: i0, template: `<div
    class="draggable-modal-window-container"
    [style.left.px]="modalWindowService.editorX"
    [style.top.px]="modalWindowService.editorY"
  >
    <div class="draggable-modal-window-navbar" (mousedown)="startDrag($event)">
      <span [style.flex]="1">{{ header }}</span>
      <div class="close-button" (click)="model.showDraggableModalWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="content-container">
      <embed-text-editor *ngIf="modalWindowService.isTextEditor"></embed-text-editor>
      <embed-image-editor *ngIf="modalWindowService.isImageEditor"></embed-image-editor>
    </div>
    <div class="setup-accept">
      <div class="accept button" (click)="accept()">
        <span [style.margin-left.px]="0">{{ loc.getP("Insert").replace("&amp", "").replace(";", "") }}</span>
      </div>
      <div class="cancel button" (click)="model.showDraggableModalWindow = false">
        <span [style.margin-left.px]="0">{{ loc.getP("Cancel") }}</span>
      </div>
    </div>
  </div> `, isInline: true, styles: [".draggable-modal-window-container{background-color:var(--back-color);position:absolute;left:calc(50% - 400px);top:calc(50% - 255px);z-index:999;width:800px;height:510px;overflow:hidden;display:flex;flex-direction:column;box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:12px;border-radius:5px;font-family:Arial;-webkit-user-select:none}.draggable-modal-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.draggable-modal-window-navbar span{font-size:13px;margin-left:10px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.content-container{height:100%;width:100%}.setup-accept{padding:8px;display:flex;align-items:flex-end;justify-content:flex-end}.button{height:24px;width:80px;border-radius:3px;margin:3px 5px;display:flex;align-items:center;justify-content:center;border:1px solid transparent}.accept:active{background-color:#355da0;border-color:#264c7d}.cancel:active{background-color:#e2e2e2;border-color:#838383}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiEmbedTextEditorComponent, selector: "embed-text-editor" }, { kind: "component", type: i8.StiEmbedImageEditorComponent, selector: "embed-image-editor" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDraggableModalWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-draggable-modal-window", template: `<div
    class="draggable-modal-window-container"
    [style.left.px]="modalWindowService.editorX"
    [style.top.px]="modalWindowService.editorY"
  >
    <div class="draggable-modal-window-navbar" (mousedown)="startDrag($event)">
      <span [style.flex]="1">{{ header }}</span>
      <div class="close-button" (click)="model.showDraggableModalWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="content-container">
      <embed-text-editor *ngIf="modalWindowService.isTextEditor"></embed-text-editor>
      <embed-image-editor *ngIf="modalWindowService.isImageEditor"></embed-image-editor>
    </div>
    <div class="setup-accept">
      <div class="accept button" (click)="accept()">
        <span [style.margin-left.px]="0">{{ loc.getP("Insert").replace("&amp", "").replace(";", "") }}</span>
      </div>
      <div class="cancel button" (click)="model.showDraggableModalWindow = false">
        <span [style.margin-left.px]="0">{{ loc.getP("Cancel") }}</span>
      </div>
    </div>
  </div> `, styles: [".draggable-modal-window-container{background-color:var(--back-color);position:absolute;left:calc(50% - 400px);top:calc(50% - 255px);z-index:999;width:800px;height:510px;overflow:hidden;display:flex;flex-direction:column;box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:12px;border-radius:5px;font-family:Arial;-webkit-user-select:none}.draggable-modal-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.draggable-modal-window-navbar span{font-size:13px;margin-left:10px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.content-container{height:100%;width:100%}.setup-accept{padding:8px;display:flex;align-items:flex-end;justify-content:flex-end}.button{height:24px;width:80px;border-radius:3px;margin:3px 5px;display:flex;align-items:center;justify-content:center;border:1px solid transparent}.accept:active{background-color:#355da0;border-color:#264c7d}.cancel:active{background-color:#e2e2e2;border-color:#838383}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiDraggableModalWindowService }, { type: i4.SignatureService }, { type: i5.StiMouseService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWRyYWdnYWJsZS1tb2RhbC13aW5kb3cuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2NvbXBvbmVudHMvc3RpLWRyYWdnYWJsZS1tb2RhbC13aW5kb3cvc3RpLWRyYWdnYWJsZS1tb2RhbC13aW5kb3cuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBaUIsU0FBUyxFQUFVLE1BQU0sZUFBZSxDQUFDOzs7Ozs7Ozs7O0FBb0lqRSxNQUFNLE9BQU8sZ0NBQWdDO0lBUTNDLFlBQ1MsS0FBc0IsRUFDdEIsR0FBMkIsRUFDM0Isa0JBQWtELEVBQ2xELGdCQUFrQyxFQUNsQyxZQUE2QjtRQUo3QixVQUFLLEdBQUwsS0FBSyxDQUFpQjtRQUN0QixRQUFHLEdBQUgsR0FBRyxDQUF3QjtRQUMzQix1QkFBa0IsR0FBbEIsa0JBQWtCLENBQWdDO1FBQ2xELHFCQUFnQixHQUFoQixnQkFBZ0IsQ0FBa0I7UUFDbEMsaUJBQVksR0FBWixZQUFZLENBQWlCO0lBQ25DLENBQUM7SUFDSixlQUFlO1FBQ2IsTUFBTSxRQUFRLEdBQUcsQ0FBQyxLQUFLLEVBQUUsRUFBRTtZQUN6QixJQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxHQUFHLENBQUMsTUFBTSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ2hHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLEdBQUcsQ0FBQyxNQUFNLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDcEcsQ0FBQyxDQUFDO1FBQ0YsTUFBTSxDQUFDLGdCQUFnQixDQUFDLFFBQVEsRUFBRSxRQUFRLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBQ0QsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsWUFBWTtZQUN6QyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsWUFBWSxFQUFFLGdCQUFnQixDQUFDO1lBQy9DLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUUsVUFBVSxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUNELFNBQVMsQ0FBQyxLQUFLO1FBQ2IsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzVCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM1QixJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLENBQUM7UUFDdkQsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxDQUFDO1FBQ3ZELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO0lBQ3pCLENBQUM7SUFDRCxNQUFNO1FBQ0osSUFBSSxDQUFDLGtCQUFrQixDQUFDLFlBQVk7WUFDbEMsQ0FBQyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsRUFBRSxTQUFTLEVBQUUsWUFBWSxFQUFFLENBQUM7WUFDaEYsQ0FBQyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsRUFBRSxTQUFTLEVBQUUsYUFBYSxFQUFFLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsS0FBSyxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQztJQUM5QyxDQUFDO0lBQ0QsV0FBVyxDQUFDLEtBQUs7UUFDZixJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDbkIsSUFBSSxNQUFNLEdBQUcsS0FBSyxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDO1lBQ3pDLElBQUksTUFBTSxHQUFHLEtBQUssQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztZQUN6QyxJQUFJLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxHQUFHLENBQUMsRUFBRTtnQkFDckMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sR0FBRyxDQUFDLENBQUM7YUFDckM7aUJBQU0sSUFBSSxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sR0FBRyxNQUFNLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLEVBQUU7Z0JBQ2xHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxDQUFDO2FBQzNGO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUM7YUFDakU7WUFFRCxJQUFJLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxHQUFHLENBQUMsRUFBRTtnQkFDckMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sR0FBRyxDQUFDLENBQUM7YUFDckM7aUJBQU0sSUFBSSxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sR0FBRyxNQUFNLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLEVBQUU7Z0JBQ3BHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsWUFBWSxDQUFDO2FBQzdGO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUM7YUFDakU7U0FDRjtJQUNILENBQUM7SUFDRCxRQUFRO1FBQ04sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sR0FBRyxDQUFDLE1BQU0sQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNoRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxHQUFHLENBQUMsTUFBTSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ2xHLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLGtCQUFrQixFQUFFLENBQUMsU0FBUyxDQUFDLEdBQUcsRUFBRTtZQUMvRSxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztRQUMxQixDQUFDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLG9CQUFvQixFQUFFLENBQUMsU0FBUyxDQUFDLENBQUMsS0FBaUIsRUFBRSxFQUFFO1lBQ3BHLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDMUIsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDOzs2SEF0RVUsZ0NBQWdDO2lIQUFoQyxnQ0FBZ0Msa0VBMUhqQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7VUF1QkY7MkZBbUdHLGdDQUFnQztrQkE1SDVDLFNBQVM7K0JBQ0UsNEJBQTRCLFlBQzVCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztVQXVCRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFmdGVyVmlld0luaXQsIENvbXBvbmVudCwgT25Jbml0IH0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTG9jYWxpemF0aW9uU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9zdGktbG9jYWxpemF0aW9uLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpRHJhZ2dhYmxlTW9kYWxXaW5kb3dTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL3N0aS1kcmFnZ2FibGUtbW9kYWwtd2luZG93LnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTW91c2VTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL21vdXNlLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3Vic2NyaXB0aW9uIH0gZnJvbSBcInJ4anNcIjtcclxuaW1wb3J0IHsgU2lnbmF0dXJlU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9zdGktc2lnbmF0dXJlLnNlcnZpY2VcIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcInN0aS1kcmFnZ2FibGUtbW9kYWwtd2luZG93XCIsXHJcbiAgdGVtcGxhdGU6IGA8ZGl2XHJcbiAgICBjbGFzcz1cImRyYWdnYWJsZS1tb2RhbC13aW5kb3ctY29udGFpbmVyXCJcclxuICAgIFtzdHlsZS5sZWZ0LnB4XT1cIm1vZGFsV2luZG93U2VydmljZS5lZGl0b3JYXCJcclxuICAgIFtzdHlsZS50b3AucHhdPVwibW9kYWxXaW5kb3dTZXJ2aWNlLmVkaXRvcllcIlxyXG4gID5cclxuICAgIDxkaXYgY2xhc3M9XCJkcmFnZ2FibGUtbW9kYWwtd2luZG93LW5hdmJhclwiIChtb3VzZWRvd24pPVwic3RhcnREcmFnKCRldmVudClcIj5cclxuICAgICAgPHNwYW4gW3N0eWxlLmZsZXhdPVwiMVwiPnt7IGhlYWRlciB9fTwvc3Bhbj5cclxuICAgICAgPGRpdiBjbGFzcz1cImNsb3NlLWJ1dHRvblwiIChjbGljayk9XCJtb2RlbC5zaG93RHJhZ2dhYmxlTW9kYWxXaW5kb3cgPSBmYWxzZVwiPlxyXG4gICAgICAgIDxpbWcgW3NyY109XCJtb2RlbC5nZXRJbWFnZSgnaW1hZ2VzLk90aGVyLkNsb3NlRm9ybS5wbmcnKVwiIC8+XHJcbiAgICAgIDwvZGl2PlxyXG4gICAgPC9kaXY+XHJcbiAgICA8ZGl2IGNsYXNzPVwiY29udGVudC1jb250YWluZXJcIj5cclxuICAgICAgPGVtYmVkLXRleHQtZWRpdG9yICpuZ0lmPVwibW9kYWxXaW5kb3dTZXJ2aWNlLmlzVGV4dEVkaXRvclwiPjwvZW1iZWQtdGV4dC1lZGl0b3I+XHJcbiAgICAgIDxlbWJlZC1pbWFnZS1lZGl0b3IgKm5nSWY9XCJtb2RhbFdpbmRvd1NlcnZpY2UuaXNJbWFnZUVkaXRvclwiPjwvZW1iZWQtaW1hZ2UtZWRpdG9yPlxyXG4gICAgPC9kaXY+XHJcbiAgICA8ZGl2IGNsYXNzPVwic2V0dXAtYWNjZXB0XCI+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJhY2NlcHQgYnV0dG9uXCIgKGNsaWNrKT1cImFjY2VwdCgpXCI+XHJcbiAgICAgICAgPHNwYW4gW3N0eWxlLm1hcmdpbi1sZWZ0LnB4XT1cIjBcIj57eyBsb2MuZ2V0UChcIkluc2VydFwiKS5yZXBsYWNlKFwiJmFtcFwiLCBcIlwiKS5yZXBsYWNlKFwiO1wiLCBcIlwiKSB9fTwvc3Bhbj5cclxuICAgICAgPC9kaXY+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJjYW5jZWwgYnV0dG9uXCIgKGNsaWNrKT1cIm1vZGVsLnNob3dEcmFnZ2FibGVNb2RhbFdpbmRvdyA9IGZhbHNlXCI+XHJcbiAgICAgICAgPHNwYW4gW3N0eWxlLm1hcmdpbi1sZWZ0LnB4XT1cIjBcIj57eyBsb2MuZ2V0UChcIkNhbmNlbFwiKSB9fTwvc3Bhbj5cclxuICAgICAgPC9kaXY+XHJcbiAgICA8L2Rpdj5cclxuICA8L2Rpdj4gYCxcclxuICBzdHlsZXM6IFtcclxuICAgIGBcclxuICAgICAgLmRyYWdnYWJsZS1tb2RhbC13aW5kb3ctY29udGFpbmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1iYWNrLWNvbG9yKTtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgbGVmdDogY2FsYyg1MCUgLSA0MDBweCk7XHJcbiAgICAgICAgdG9wOiBjYWxjKDUwJSAtIDI1NXB4KTtcclxuICAgICAgICB6LWluZGV4OiA5OTk7XHJcbiAgICAgICAgd2lkdGg6IDgwMHB4O1xyXG4gICAgICAgIGhlaWdodDogNTEwcHg7XHJcbiAgICAgICAgb3ZlcmZsb3c6IGhpZGRlbjtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XHJcbiAgICAgICAgLW1vei1ib3gtc2hhZG93OiAwcHggMHB4IDdweCByZ2JhKDAsIDAsIDAsIDAuNik7XHJcbiAgICAgICAgLXdlYmtpdC1ib3gtc2hhZG93OiAwcHggMHB4IDdweCByZ2IoMCAwIDAgLyA2MCUpO1xyXG4gICAgICAgIGJveC1zaGFkb3c6IDAgMCA3cHggcmdiKDAgMCAwIC8gMzAlKTtcclxuICAgICAgICBib3JkZXI6IDFweCBzb2xpZCByZ2IoMjUsIDcxLCAxMzgpO1xyXG4gICAgICAgIGNvbG9yOiB2YXIoLS10ZXh0LWNvbG9yKTtcclxuICAgICAgICBmb250LXNpemU6IDEycHg7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogNXB4O1xyXG4gICAgICAgIGZvbnQtZmFtaWx5OiBcIkFyaWFsXCI7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgfVxyXG4gICAgICAuZHJhZ2dhYmxlLW1vZGFsLXdpbmRvdy1uYXZiYXIge1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgaGVpZ2h0OiAzMHB4O1xyXG4gICAgICAgIGJvcmRlci10b3AtbGVmdC1yYWRpdXM6IDNweDtcclxuICAgICAgICBib3JkZXItdG9wLXJpZ2h0LXJhZGl1czogM3B4O1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYig4MSwgOTIsIDEwNik7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgICBjb2xvcjogd2hpdGU7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAuZHJhZ2dhYmxlLW1vZGFsLXdpbmRvdy1uYXZiYXIgc3BhbiB7XHJcbiAgICAgICAgZm9udC1zaXplOiAxM3B4O1xyXG4gICAgICAgIG1hcmdpbi1sZWZ0OiAxMHB4O1xyXG4gICAgICB9XHJcbiAgICAgIC5jbG9zZS1idXR0b24ge1xyXG4gICAgICAgIGhlaWdodDogMzBweDtcclxuICAgICAgICB3aWR0aDogMzBweDtcclxuICAgICAgICBib3JkZXItcmFkaXVzOiAzcHg7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xyXG4gICAgICB9XHJcbiAgICAgIC5jbG9zZS1idXR0b246aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyMTgsIDIxOCwgMjE4KTtcclxuICAgICAgfVxyXG4gICAgICAuY2xvc2UtYnV0dG9uIGltZyB7XHJcbiAgICAgICAgaGVpZ2h0OiAxNnB4O1xyXG4gICAgICAgIHdpZHRoOiAxNnB4O1xyXG4gICAgICAgIGZpbHRlcjogYnJpZ2h0bmVzcygwKSBpbnZlcnQoMSk7XHJcbiAgICAgIH1cclxuICAgICAgLmNvbnRlbnQtY29udGFpbmVyIHtcclxuICAgICAgICBoZWlnaHQ6IDEwMCU7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgIH1cclxuICAgICAgLnNldHVwLWFjY2VwdCB7XHJcbiAgICAgICAgcGFkZGluZzogOHB4O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGZsZXgtZW5kO1xyXG4gICAgICAgIGp1c3RpZnktY29udGVudDogZmxleC1lbmQ7XHJcbiAgICAgIH1cclxuICAgICAgLmJ1dHRvbiB7XHJcbiAgICAgICAgaGVpZ2h0OiAyNHB4O1xyXG4gICAgICAgIHdpZHRoOiA4MHB4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgICBtYXJnaW46IDNweCA1cHg7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xyXG4gICAgICAgIGJvcmRlcjogMXB4IHNvbGlkIHRyYW5zcGFyZW50O1xyXG4gICAgICB9XHJcbiAgICAgIC5hY2NlcHQ6YWN0aXZlIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoNTMsIDkzLCAxNjApO1xyXG4gICAgICAgIGJvcmRlci1jb2xvcjogcmdiKDM4LCA3NiwgMTI1KTtcclxuICAgICAgfVxyXG4gICAgICAuY2FuY2VsOmFjdGl2ZSB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIyNiwgMjI2LCAyMjYpO1xyXG4gICAgICAgIGJvcmRlci1jb2xvcjogcmdiKDEzMSwgMTMxLCAxMzEpO1xyXG4gICAgICB9XHJcbiAgICAgIC5hY2NlcHQge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyNSwgNzEsIDEzOCk7XHJcbiAgICAgICAgY29sb3I6IHdoaXRlO1xyXG4gICAgICB9XHJcbiAgICAgIC5hY2NlcHQ6aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYig2MSwgOTgsIDE1Mik7XHJcbiAgICAgIH1cclxuICAgICAgLmNhbmNlbCB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIyMSwgMjIxLCAyMjEpO1xyXG4gICAgICAgIGNvbG9yOiByZ2IoNjgsIDY4LCA2OCk7XHJcbiAgICAgIH1cclxuICAgICAgLmNhbmNlbDpob3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIxMywgMjEzLCAyMTMpO1xyXG4gICAgICB9XHJcbiAgICBgLFxyXG4gIF0sXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBTdGlEcmFnZ2FibGVNb2RhbFdpbmRvd0NvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCwgQWZ0ZXJWaWV3SW5pdCB7XHJcbiAgcHVibGljIHN0YXJ0WDogbnVtYmVyO1xyXG4gIHB1YmxpYyBzdGFydFk6IG51bWJlcjtcclxuICBwdWJsaWMgc3RhcnRDb21wb25lbnRYOiBudW1iZXI7XHJcbiAgcHVibGljIHN0YXJ0Q29tcG9uZW50WTogbnVtYmVyO1xyXG4gIHB1YmxpYyBpc0RyYWdnaW5nOiBib29sZWFuO1xyXG4gIG1vdXNlVXBTdWJzY3JpcHRpb246IFN1YnNjcmlwdGlvbjtcclxuICBtb3VzZU1vdmVTdWJzY3JpcHRpb246IFN1YnNjcmlwdGlvbjtcclxuICBjb25zdHJ1Y3RvcihcclxuICAgIHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlLFxyXG4gICAgcHVibGljIGxvYzogU3RpTG9jYWxpemF0aW9uU2VydmljZSxcclxuICAgIHB1YmxpYyBtb2RhbFdpbmRvd1NlcnZpY2U6IFN0aURyYWdnYWJsZU1vZGFsV2luZG93U2VydmljZSxcclxuICAgIHB1YmxpYyBzaWduYXR1cmVTZXJ2aWNlOiBTaWduYXR1cmVTZXJ2aWNlLFxyXG4gICAgcHVibGljIG1vdXNlU2VydmljZTogU3RpTW91c2VTZXJ2aWNlXHJcbiAgKSB7fVxyXG4gIG5nQWZ0ZXJWaWV3SW5pdCgpOiB2b2lkIHtcclxuICAgIGNvbnN0IG9uUmVzaXplID0gKGV2ZW50KSA9PiB7XHJcbiAgICAgIHRoaXMubW9kYWxXaW5kb3dTZXJ2aWNlLmVkaXRvclggPSAod2luZG93LmlubmVyV2lkdGggLSB0aGlzLm1vZGFsV2luZG93U2VydmljZS5lZGl0b3JXaWR0aCkgLyAyO1xyXG4gICAgICB0aGlzLm1vZGFsV2luZG93U2VydmljZS5lZGl0b3JZID0gKHdpbmRvdy5pbm5lckhlaWdodCAtIHRoaXMubW9kYWxXaW5kb3dTZXJ2aWNlLmVkaXRvckhlaWdodCkgLyAyO1xyXG4gICAgfTtcclxuICAgIHdpbmRvdy5hZGRFdmVudExpc3RlbmVyKFwicmVzaXplXCIsIG9uUmVzaXplKTtcclxuICB9XHJcbiAgcHVibGljIGdldCBoZWFkZXIoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5tb2RhbFdpbmRvd1NlcnZpY2UuaXNUZXh0RWRpdG9yXHJcbiAgICAgID8gdGhpcy5sb2MuZ2V0MihcIkZvcm1UaXRsZXNcIiwgXCJUZXh0RWRpdG9yRm9ybVwiKVxyXG4gICAgICA6IHRoaXMubG9jLmdldDIoXCJDb21wb25lbnRzXCIsIFwiU3RpSW1hZ2VcIik7XHJcbiAgfVxyXG4gIHN0YXJ0RHJhZyhldmVudCkge1xyXG4gICAgdGhpcy5zdGFydFggPSBldmVudC5jbGllbnRYO1xyXG4gICAgdGhpcy5zdGFydFkgPSBldmVudC5jbGllbnRZO1xyXG4gICAgdGhpcy5zdGFydENvbXBvbmVudFggPSB0aGlzLm1vZGFsV2luZG93U2VydmljZS5lZGl0b3JYO1xyXG4gICAgdGhpcy5zdGFydENvbXBvbmVudFkgPSB0aGlzLm1vZGFsV2luZG93U2VydmljZS5lZGl0b3JZO1xyXG4gICAgdGhpcy5pc0RyYWdnaW5nID0gdHJ1ZTtcclxuICB9XHJcbiAgYWNjZXB0KCkge1xyXG4gICAgdGhpcy5tb2RhbFdpbmRvd1NlcnZpY2UuaXNUZXh0RWRpdG9yXHJcbiAgICAgID8gdGhpcy5zaWduYXR1cmVTZXJ2aWNlLmdldEluc2VydGVkSW5mb3JtYXRpb24ubmV4dCh7IGV2ZW50TmFtZTogXCJUZXh0RWRpdG9yXCIgfSlcclxuICAgICAgOiB0aGlzLnNpZ25hdHVyZVNlcnZpY2UuZ2V0SW5zZXJ0ZWRJbmZvcm1hdGlvbi5uZXh0KHsgZXZlbnROYW1lOiBcIkltYWdlRWRpdG9yXCIgfSk7XHJcbiAgICB0aGlzLm1vZGVsLnNob3dEcmFnZ2FibGVNb2RhbFdpbmRvdyA9IGZhbHNlO1xyXG4gIH1cclxuICBvbk1vdXNlTW92ZShldmVudCkge1xyXG4gICAgaWYgKHRoaXMuaXNEcmFnZ2luZykge1xyXG4gICAgICBsZXQgZGVsdGFYID0gZXZlbnQuY2xpZW50WCAtIHRoaXMuc3RhcnRYO1xyXG4gICAgICBsZXQgZGVsdGFZID0gZXZlbnQuY2xpZW50WSAtIHRoaXMuc3RhcnRZO1xyXG4gICAgICBpZiAodGhpcy5zdGFydENvbXBvbmVudFggKyBkZWx0YVggPCAwKSB7XHJcbiAgICAgICAgdGhpcy5tb2RhbFdpbmRvd1NlcnZpY2UuZWRpdG9yWCA9IDA7XHJcbiAgICAgIH0gZWxzZSBpZiAodGhpcy5zdGFydENvbXBvbmVudFggKyBkZWx0YVggPiB3aW5kb3cuaW5uZXJXaWR0aCAtIHRoaXMubW9kYWxXaW5kb3dTZXJ2aWNlLmVkaXRvcldpZHRoKSB7XHJcbiAgICAgICAgdGhpcy5tb2RhbFdpbmRvd1NlcnZpY2UuZWRpdG9yWCA9IHdpbmRvdy5pbm5lcldpZHRoIC0gdGhpcy5tb2RhbFdpbmRvd1NlcnZpY2UuZWRpdG9yV2lkdGg7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgdGhpcy5tb2RhbFdpbmRvd1NlcnZpY2UuZWRpdG9yWCA9IHRoaXMuc3RhcnRDb21wb25lbnRYICsgZGVsdGFYO1xyXG4gICAgICB9XHJcblxyXG4gICAgICBpZiAodGhpcy5zdGFydENvbXBvbmVudFkgKyBkZWx0YVkgPCAwKSB7XHJcbiAgICAgICAgdGhpcy5tb2RhbFdpbmRvd1NlcnZpY2UuZWRpdG9yWSA9IDA7XHJcbiAgICAgIH0gZWxzZSBpZiAodGhpcy5zdGFydENvbXBvbmVudFkgKyBkZWx0YVkgPiB3aW5kb3cuaW5uZXJIZWlnaHQgLSB0aGlzLm1vZGFsV2luZG93U2VydmljZS5lZGl0b3JIZWlnaHQpIHtcclxuICAgICAgICB0aGlzLm1vZGFsV2luZG93U2VydmljZS5lZGl0b3JZID0gd2luZG93LmlubmVySGVpZ2h0IC0gdGhpcy5tb2RhbFdpbmRvd1NlcnZpY2UuZWRpdG9ySGVpZ2h0O1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHRoaXMubW9kYWxXaW5kb3dTZXJ2aWNlLmVkaXRvclkgPSB0aGlzLnN0YXJ0Q29tcG9uZW50WSArIGRlbHRhWTtcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuICBuZ09uSW5pdCgpIHtcclxuICAgIHRoaXMubW9kYWxXaW5kb3dTZXJ2aWNlLmVkaXRvclggPSAod2luZG93LmlubmVyV2lkdGggLSB0aGlzLm1vZGFsV2luZG93U2VydmljZS5lZGl0b3JXaWR0aCkgLyAyO1xyXG4gICAgdGhpcy5tb2RhbFdpbmRvd1NlcnZpY2UuZWRpdG9yWSA9ICh3aW5kb3cuaW5uZXJIZWlnaHQgLSB0aGlzLm1vZGFsV2luZG93U2VydmljZS5lZGl0b3JIZWlnaHQpIC8gMjtcclxuICAgIHRoaXMubW91c2VVcFN1YnNjcmlwdGlvbiA9IHRoaXMubW91c2VTZXJ2aWNlLmdldERvY3VtZW50TW91c2VVcCgpLnN1YnNjcmliZSgoKSA9PiB7XHJcbiAgICAgIHRoaXMuaXNEcmFnZ2luZyA9IGZhbHNlO1xyXG4gICAgfSk7XHJcbiAgICB0aGlzLm1vdXNlTW92ZVN1YnNjcmlwdGlvbiA9IHRoaXMubW91c2VTZXJ2aWNlLmdldERvY3VtZW50TW91c2VNb3ZlKCkuc3Vic2NyaWJlKChldmVudDogTW91c2VFdmVudCkgPT4ge1xyXG4gICAgICB0aGlzLm9uTW91c2VNb3ZlKGV2ZW50KTtcclxuICAgIH0pO1xyXG4gIH1cclxufVxyXG4iXX0=