import { Component, Input, ViewChild } from "@angular/core";
import { StiDateTimeBoxValueChoise, StiDateTimeBoxType, StiHorizontalAlignment } from "../../system/enums";
import { StiInputTextItem } from "../../helper/StiInputTextItem";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../../services/sti-editable-content.service";
import * as i4 from "../sti-component";
import * as i5 from "../sti-editable-content.component";
import * as i6 from "../svg.components/svg.checkbox.component";
import * as i7 from "../sti-tooltip/sti-tooltip.directive";
export class StiDateTimeBoxComponent {
    constructor(model, date, editableService) {
        this.model = model;
        this.date = date;
        this.editableService = editableService;
        this.isClone = false;
    }
    get isCurrent() {
        return this.element.initialState == StiDateTimeBoxValueChoise.Current;
    }
    get isReadOnly() {
        return this.element.readOnly;
    }
    get needToFill() {
        return (this.element.required &&
            (this.element.allowNull ? !this.element.dateTimeValueIsNotNull : !this.element.value) &&
            this.model.hasEmptyReuiredFields);
    }
    get align() {
        return "start";
    }
    get isMozila() {
        return this.model.getBrowserType() == "firefox" ? true : false;
    }
    get horizontalAlignment() {
        if (this.element.contentAlignment == StiHorizontalAlignment.Left) {
            return "start";
        }
        else if (this.element.contentAlignment == StiHorizontalAlignment.Right) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    get format() {
        return this.element.valueType == StiDateTimeBoxType.Date
            ? this.element.dateFormat
            : this.element.valueType == StiDateTimeBoxType.Time
                ? this.element.timeFormat
                : this.element.dateTimeFormat;
    }
    get today() {
        if (this.isCurrent && this.isReadOnly) {
            this.element.currentDate = new Date();
            this.element.dateValue = this.date.transform(new Date(this.element.currentDate), this.formattingDate(this.format));
            //this.model.formEvents.next({ name: "ValueChanged" });
        }
        else if (this.isCurrent && !this.isReadOnly && this.element.currentDate != this.element.customDate) {
            this.element.currentDate = this.element.customDate;
            this.element.dateValue = this.date.transform(new Date(this.element.currentDate), this.formattingDate(this.format));
        }
        return this.element.dateValue;
    }
    get custom() {
        if (!this.element.customDate) {
            this.element.customDate = new Date();
        }
        this.element.dateValue = this.date.transform(new Date(this.element.customDate), this.formattingDate(this.format));
        return this.element.dateValue;
    }
    parseDate(value) {
        if (value.length > 0) {
            this.element.customDate = new Date(value);
            this.model.formEvents.next({ name: "ValueChanged" });
        }
        else {
            this.element.customDate = new Date();
        }
    }
    formattingDate(dateFormat) {
        let result = dateFormat
            .replace(/M/g, "k")
            .replace(/m/g, "r")
            .replace(/tt/g, "a")
            .replace(/k/g, "m")
            .replace(/r/g, "M");
        return result;
    }
    changeState() {
        this.element.dateTimeValueIsNotNull = !this.element.dateTimeValueIsNotNull;
    }
    borderWidth() {
        return `${this.element.borderWeight}px`;
    }
    inFocus() {
        event.stopPropagation();
        setTimeout(() => {
            let editableContent = new StiInputTextItem("", this.element.font, this.element.textColor, this.element.backgroundColor, this.element.contentAlignment);
            editableContent.element = this.element;
            this.editableService.editableContent = editableContent;
            this.editableService.usedElement = this.element;
        }, 0);
    }
    ngOnInit() { }
}
StiDateTimeBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDateTimeBoxComponent, deps: [{ token: i1.StiModelService }, { token: i2.DatePipe }, { token: i3.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component });
StiDateTimeBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiDateTimeBoxComponent, selector: "sti-datetimebox-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "inputDate", first: true, predicate: ["inputDate"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-date-time-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.position]="'relative'">
          <div
            class="date-time-box-container"
            [style.align-self]="align"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="element?.htmlStyle()"
            [style.justify-content]="horizontalAlignment"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.background-color]="this.element.backgroundColor.toHtmlColor()"
            [style.border-width]="borderWidth()"
            (click)="inFocus(); inputDate.click()"
          >
            <sti-svg-checkbox-component
              *ngIf="element.allowNull && !model.isPreviewMode"
              [style.margin-top.px]="margin"
              [style.align-self]="align"
              [style.margin-block]="'auto'"
              [element]="element"
              [id]="element?.name"
              [text]=""
              [state]="element?.dateTimeValueIsNotNull"
              [disablePlaceHolder]="true"
              (buttonClick)="changeState()"
            ></sti-svg-checkbox-component>
            <span
              [style.width]="'100%'"
              [style.opacity]="!element.dateTimeValueIsNotNull && element.allowNull ? 0 : 1"
              [style.pointer-events]="!element.dateTimeValueIsNotNull && element.allowNull ? 'none' : ''"
              [style.color]="this.element.textColor.toHtmlColor()"
              (click)="inputDate.click()"
              >{{ isCurrent ? today : custom }}</span
            >
            <div
              class="date-picker"
              [style.pointer-events]="!element.dateTimeValueIsNotNull && element.allowNull ? 'none' : ''"
              [style.opacity]="!element.dateTimeValueIsNotNull && element.allowNull ? 0 : 1"
              *ngIf="!isReadOnly"
            >
              <label [style.display]="'flex'" [style.align-items]="'center'" [style.justify-content]="'center'"
                ><i class="pi pi-chevron-down"></i
              ></label>
            </div>
            <input
              #inputDate
              [style.left.px]="element.allowNull ? 20 : 0"
              [type]="isMozila ? 'date' : 'datetime-local'"
              (input)="parseDate($event.target.value)"
              [tabIndex]="element['tabIndex']"
              [disabled]="element.readOnly"
              (select)="inputDate.click()"
            />
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: [".date-time-box-container{align-items:center;padding:3px 4px;display:flex;width:100%;border:1px solid transparent}.date-time-box-container:hover{border-color:#a3bde3!important}input{opacity:0;position:absolute;left:0;top:0;width:100%;height:100%}input::-webkit-datetime-edit{display:none}input::-webkit-calendar-picker-indicator{cursor:pointer;width:100%}.date-picker{background-color:transparent;width:16px;position:relative;height:16px;display:flex;align-items:center;justify-content:center;margin-left:4px;padding-right:1px}i{color:#d3d3d3}.pi-chevron-down{font-size:.575rem;font-weight:700;color:#c5c5c5;padding-top:1px}img{vertical-align:middle;margin-left:0;height:16px;width:16px}table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i5.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i6.StiSvgCheckBoxComponent, selector: "sti-svg-checkbox-component", inputs: ["element", "id", "text", "state", "useCustomOption", "disablePlaceHolder", "tabIndex"], outputs: ["buttonClick"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDateTimeBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-datetimebox-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-date-time-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.position]="'relative'">
          <div
            class="date-time-box-container"
            [style.align-self]="align"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="element?.htmlStyle()"
            [style.justify-content]="horizontalAlignment"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.background-color]="this.element.backgroundColor.toHtmlColor()"
            [style.border-width]="borderWidth()"
            (click)="inFocus(); inputDate.click()"
          >
            <sti-svg-checkbox-component
              *ngIf="element.allowNull && !model.isPreviewMode"
              [style.margin-top.px]="margin"
              [style.align-self]="align"
              [style.margin-block]="'auto'"
              [element]="element"
              [id]="element?.name"
              [text]=""
              [state]="element?.dateTimeValueIsNotNull"
              [disablePlaceHolder]="true"
              (buttonClick)="changeState()"
            ></sti-svg-checkbox-component>
            <span
              [style.width]="'100%'"
              [style.opacity]="!element.dateTimeValueIsNotNull && element.allowNull ? 0 : 1"
              [style.pointer-events]="!element.dateTimeValueIsNotNull && element.allowNull ? 'none' : ''"
              [style.color]="this.element.textColor.toHtmlColor()"
              (click)="inputDate.click()"
              >{{ isCurrent ? today : custom }}</span
            >
            <div
              class="date-picker"
              [style.pointer-events]="!element.dateTimeValueIsNotNull && element.allowNull ? 'none' : ''"
              [style.opacity]="!element.dateTimeValueIsNotNull && element.allowNull ? 0 : 1"
              *ngIf="!isReadOnly"
            >
              <label [style.display]="'flex'" [style.align-items]="'center'" [style.justify-content]="'center'"
                ><i class="pi pi-chevron-down"></i
              ></label>
            </div>
            <input
              #inputDate
              [style.left.px]="element.allowNull ? 20 : 0"
              [type]="isMozila ? 'date' : 'datetime-local'"
              (input)="parseDate($event.target.value)"
              [tabIndex]="element['tabIndex']"
              [disabled]="element.readOnly"
              (select)="inputDate.click()"
            />
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: [".date-time-box-container{align-items:center;padding:3px 4px;display:flex;width:100%;border:1px solid transparent}.date-time-box-container:hover{border-color:#a3bde3!important}input{opacity:0;position:absolute;left:0;top:0;width:100%;height:100%}input::-webkit-datetime-edit{display:none}input::-webkit-calendar-picker-indicator{cursor:pointer;width:100%}.date-picker{background-color:transparent;width:16px;position:relative;height:16px;display:flex;align-items:center;justify-content:center;margin-left:4px;padding-right:1px}i{color:#d3d3d3}.pi-chevron-down{font-size:.575rem;font-weight:700;color:#c5c5c5;padding-top:1px}img{vertical-align:middle;margin-left:0;height:16px;width:16px}table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.DatePipe }, { type: i3.StiEditableContentService }]; }, propDecorators: { inputDate: [{
                type: ViewChild,
                args: ["inputDate"]
            }], element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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