import { Component, Input, ViewChild } from "@angular/core";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import { StiDragPreviewElement } from "../elements/StiDragPreviewElement";
import { StiBorderArea } from "../properties/StiBorderArea";
import { StiLabelAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "./sti-text-box/sti-text-box.component";
import * as i3 from "./sti-number-box/sti-number-box.component";
import * as i4 from "./sti-combo-box/sti-combo-box.component";
import * as i5 from "./sti-list-box/sti-list-box.component";
import * as i6 from "./sti-single-selection/sti-single-selection.component";
import * as i7 from "./sti-multiple-selection/sti-multiple-selection.component";
import * as i8 from "./sti-check-box/sti-check-box.component";
import * as i9 from "./sti-line/sti-line.component";
import * as i10 from "./sti-signature/sti-signature.component";
import * as i11 from "./sti-date-time-box/sti-date-time-box.component";
import * as i12 from "./sti-table/sti-table.component";
import * as i13 from "./sti-image/sti-image.component";
import * as i14 from "./sti-button/sti-button.component";
import * as i15 from "./sti-barcode/sti-barcode.component";
import * as i16 from "./sti-text/sti-text.component";
import * as i17 from "./sti-drag-preview-adorner/sti-drag-preview-adorner.component";
import * as i18 from "./sti-label/sti-label.component";
import * as i19 from "./sti-address/sti-address.component";
import * as i20 from "./sti-pdf-signature/sti-pdf-signature.component";
import * as i21 from "../services/model.service";
import * as i22 from "./sti-component";
import * as i23 from "./sti-editable-content.component";
export class StiComponentHolderComponent {
    constructor() {
        this.isClone = false;
    }
    ngOnInit() { }
}
StiComponentHolderComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponentHolderComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
StiComponentHolderComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiComponentHolderComponent, selector: "sti-component-holder", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: `
    <ng-container *ngIf="element != null">
      <sti-address-component
        [element]="element"
        *ngIf="element.type === 'AddressElement'"
        [isClone]="isClone"
      ></sti-address-component>
      <sti-textbox-component
        [element]="element"
        *ngIf="element.type === 'Text_BoxElement'"
        [isClone]="isClone"
      ></sti-textbox-component>
      <sti-text-component
        [element]="element"
        *ngIf="element.type === 'TextElement'"
        [isClone]="isClone"
      ></sti-text-component>
      <sti-table-component
        [element]="element"
        *ngIf="element.type === 'TableElement'"
        [isClone]="isClone"
      ></sti-table-component>
      <sti-singleselection-component
        [element]="element"
        *ngIf="element.type === 'Single_SelectionElement'"
        [isClone]="isClone"
      ></sti-singleselection-component>
      <sti-signature-component [element]="element" *ngIf="element.type === 'SignatureElement'" [isClone]="isClone">
      </sti-signature-component>
      <sti-pdf-signature-component
        [element]="element"
        *ngIf="element.type === 'PDFSignatureElement'"
        [isClone]="isClone"
      ></sti-pdf-signature-component>
      <sti-panel-component
        [element]="element"
        *ngIf="element.type === 'PanelElement'"
        [isClone]="isClone"
      ></sti-panel-component>
      <sti-numberbox-component
        [element]="element"
        *ngIf="element.type === 'Number_BoxElement'"
        [isClone]="isClone"
      ></sti-numberbox-component>
      <sti-multipleselection-component
        [element]="element"
        *ngIf="element.type === 'Multiple_SelectionElement'"
        [isClone]="isClone"
      ></sti-multipleselection-component>
      <sti-listbox-component
        [element]="element"
        *ngIf="element.type === 'List_BoxElement'"
        [isClone]="isClone"
      ></sti-listbox-component>
      <sti-label-component
        [element]="element"
        *ngIf="element.type === 'LabelElement'"
        [isClone]="isClone"
      ></sti-label-component>
      <sti-image-component
        [element]="element"
        *ngIf="element.type === 'ImageElement'"
        [isClone]="isClone"
      ></sti-image-component>
      <sti-drag-preview-adorner [element]="element" *ngIf="element.type === 'Drag_Preview'"></sti-drag-preview-adorner>
      <sti-line-component
        [element]="element"
        *ngIf="element.type === 'LineElement'"
        [isClone]="isClone"
      ></sti-line-component>
      <sti-datetimebox-component
        [element]="element"
        *ngIf="element.type === 'DateTime_BoxElement'"
        [isClone]="isClone"
      ></sti-datetimebox-component>
      <sti-combobox-component
        [element]="element"
        *ngIf="element.type === 'Combo_BoxElement'"
        [isClone]="isClone"
      ></sti-combobox-component>
      <sti-checkbox-component
        [element]="element"
        *ngIf="element.type === 'Check_BoxElement'"
        [isClone]="isClone"
      ></sti-checkbox-component>
      <sti-button-component
        [element]="element"
        *ngIf="element.type === 'ButtonElement'"
        [isClone]="isClone"
      ></sti-button-component>
      <sti-barcode-component
        [element]="element"
        *ngIf="element.type === 'BarCodeElement'"
        [isClone]="isClone"
      ></sti-barcode-component>
    </ng-container>
  `, isInline: true, dependencies: [{ kind: "directive", type: i0.forwardRef(function () { return i1.NgIf; }), selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i0.forwardRef(function () { return i2.StiTextBoxComponent; }), selector: "sti-textbox-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i3.StiNumberBoxComponent; }), selector: "sti-numberbox-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i4.StiComboBoxComponent; }), selector: "sti-combobox-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i5.StiListBoxComponent; }), selector: "sti-listbox-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i6.StiSingleSelectionComponent; }), selector: "sti-singleselection-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i7.StiMultipleSelectionComponent; }), selector: "sti-multipleselection-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i8.StiCheckBoxComponent; }), selector: "sti-checkbox-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i9.StiLineComponent; }), selector: "sti-line-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i10.StiSignatureComponent; }), selector: "sti-signature-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return StiPanelComponent; }), selector: "sti-panel-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i11.StiDateTimeBoxComponent; }), selector: "sti-datetimebox-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i12.StiTableComponent; }), selector: "sti-table-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i13.StiImageComponent; }), selector: "sti-image-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i14.StiButtonComponent; }), selector: "sti-button-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i15.StiBarcodeComponent; }), selector: "sti-barcode-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i16.StiTextComponent; }), selector: "sti-text-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i17.StiDragPreviewAdornerComponent; }), selector: "sti-drag-preview-adorner", inputs: ["element"] }, { kind: "component", type: i0.forwardRef(function () { return i18.StiLabelComponent; }), selector: "sti-label-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i19.StiAddressComponent; }), selector: "sti-address-component", inputs: ["element", "isClone"] }, { kind: "component", type: i0.forwardRef(function () { return i20.StiPDFSignatureComponent; }), selector: "sti-pdf-signature-component", inputs: ["element", "isClone"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponentHolderComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-component-holder",
                    template: `
    <ng-container *ngIf="element != null">
      <sti-address-component
        [element]="element"
        *ngIf="element.type === 'AddressElement'"
        [isClone]="isClone"
      ></sti-address-component>
      <sti-textbox-component
        [element]="element"
        *ngIf="element.type === 'Text_BoxElement'"
        [isClone]="isClone"
      ></sti-textbox-component>
      <sti-text-component
        [element]="element"
        *ngIf="element.type === 'TextElement'"
        [isClone]="isClone"
      ></sti-text-component>
      <sti-table-component
        [element]="element"
        *ngIf="element.type === 'TableElement'"
        [isClone]="isClone"
      ></sti-table-component>
      <sti-singleselection-component
        [element]="element"
        *ngIf="element.type === 'Single_SelectionElement'"
        [isClone]="isClone"
      ></sti-singleselection-component>
      <sti-signature-component [element]="element" *ngIf="element.type === 'SignatureElement'" [isClone]="isClone">
      </sti-signature-component>
      <sti-pdf-signature-component
        [element]="element"
        *ngIf="element.type === 'PDFSignatureElement'"
        [isClone]="isClone"
      ></sti-pdf-signature-component>
      <sti-panel-component
        [element]="element"
        *ngIf="element.type === 'PanelElement'"
        [isClone]="isClone"
      ></sti-panel-component>
      <sti-numberbox-component
        [element]="element"
        *ngIf="element.type === 'Number_BoxElement'"
        [isClone]="isClone"
      ></sti-numberbox-component>
      <sti-multipleselection-component
        [element]="element"
        *ngIf="element.type === 'Multiple_SelectionElement'"
        [isClone]="isClone"
      ></sti-multipleselection-component>
      <sti-listbox-component
        [element]="element"
        *ngIf="element.type === 'List_BoxElement'"
        [isClone]="isClone"
      ></sti-listbox-component>
      <sti-label-component
        [element]="element"
        *ngIf="element.type === 'LabelElement'"
        [isClone]="isClone"
      ></sti-label-component>
      <sti-image-component
        [element]="element"
        *ngIf="element.type === 'ImageElement'"
        [isClone]="isClone"
      ></sti-image-component>
      <sti-drag-preview-adorner [element]="element" *ngIf="element.type === 'Drag_Preview'"></sti-drag-preview-adorner>
      <sti-line-component
        [element]="element"
        *ngIf="element.type === 'LineElement'"
        [isClone]="isClone"
      ></sti-line-component>
      <sti-datetimebox-component
        [element]="element"
        *ngIf="element.type === 'DateTime_BoxElement'"
        [isClone]="isClone"
      ></sti-datetimebox-component>
      <sti-combobox-component
        [element]="element"
        *ngIf="element.type === 'Combo_BoxElement'"
        [isClone]="isClone"
      ></sti-combobox-component>
      <sti-checkbox-component
        [element]="element"
        *ngIf="element.type === 'Check_BoxElement'"
        [isClone]="isClone"
      ></sti-checkbox-component>
      <sti-button-component
        [element]="element"
        *ngIf="element.type === 'ButtonElement'"
        [isClone]="isClone"
      ></sti-button-component>
      <sti-barcode-component
        [element]="element"
        *ngIf="element.type === 'BarCodeElement'"
        [isClone]="isClone"
      ></sti-barcode-component>
    </ng-container>
  `,
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//==========================================================
export class StiPanelComponent {
    constructor(model, render) {
        this.model = model;
        this.render = render;
        this.isClone = false;
    }
    get elements() {
        return this.element?.elements;
    }
    get borderArea() {
        if (!this.isClone) {
            let borderArea = new StiBorderArea();
            borderArea.top =
                this.ref?.nativeElement?.offsetTop -
                    (this.element.label.alignment != StiLabelAlignment.Top ? this.element.padding.top : 0);
            borderArea.left = this.ref?.nativeElement?.offsetLeft;
            borderArea.width = this.ref?.nativeElement?.offsetWidth - this.element.padding.left - this.element.padding.right;
            borderArea.height = this.ref?.nativeElement?.offsetHeight;
            borderArea.border = this.element.border;
            return borderArea;
        }
    }
    get align() {
        return "start";
    }
    get minWidth() {
        if (this.elements?.length > 0) {
            let minWidth = this.elements[0]?.x + this.elements[0]?.width;
            this.elements.forEach((element) => {
                if (minWidth < element.x + element.width) {
                    minWidth = element.x + element.width;
                }
            });
            return minWidth;
        }
        return "min-content";
    }
    get minHeight() {
        if (!this.model.draggingElement) {
            if (this.elements?.length > 0) {
                let maxBottomPoint = 0;
                this.elements?.forEach((element) => {
                    if (!(element instanceof StiDragPreviewElement) && element.geometry.bottom > maxBottomPoint) {
                        maxBottomPoint = element.geometry.bottom;
                    }
                });
                if (this.currentBottomPoint != maxBottomPoint) {
                    this.render.insertElement(this.element);
                    this.render.checkOutputs(this.model.getElementPage(this.element));
                    this.currentBottomPoint = maxBottomPoint;
                }
                return maxBottomPoint > 0 ? maxBottomPoint : 5;
            }
            else {
                return 5;
            }
        }
    }
    ngAfterViewInit() {
        if (!this.isClone) {
            this.element.element = this.ref;
        }
    }
    ngOnInit() { }
}
StiPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPanelComponent, deps: [{ token: i21.StiModelService }, { token: StiRectangleGeometryLayout }], target: i0.ɵɵFactoryTarget.Component });
StiPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiPanelComponent, selector: "sti-panel-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "ref", first: true, predicate: ["ref"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" [borderArea]="borderArea" [isClone]="isClone" class="sti-panel">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.text-align]="element?.getContentAlign()"
      [style.align-self]="align"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'100%'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.height]="'100%'">
          <div
            #ref
            class="sti-panel-container"
            [style.height]="'100%'"
            [style.min-width.px]="minWidth"
            [style.min-height.px]="minHeight"
            [style.align-self]="'center'"
            [style.overflow]="'hidden'"
            [style.background-color]="
              (!element.isAdded &&
                element.backgroundColor.r == 255 &&
                element.backgroundColor.g == 255 &&
                element.backgroundColor.b == 255) ||
              element.backgroundColor.a == 0
                ? 'transparent'
                : element?.backgroundColor.toHtmlColor()
            "
          >
            <div *ngFor="let element of elements" [disabled]="element?.readOnly ? true : false">
              <sti-component-holder [element]="element"></sti-component-holder>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-panel-container{min-height:5px;position:relative}\n"], dependencies: [{ kind: "directive", type: i1.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i22.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: StiComponentHolderComponent, selector: "sti-component-holder", inputs: ["element", "isClone"] }, { kind: "component", type: i23.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPanelComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-panel-component", template: ` <sti-component [element]="element" [borderArea]="borderArea" [isClone]="isClone" class="sti-panel">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.text-align]="element?.getContentAlign()"
      [style.align-self]="align"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'100%'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.height]="'100%'">
          <div
            #ref
            class="sti-panel-container"
            [style.height]="'100%'"
            [style.min-width.px]="minWidth"
            [style.min-height.px]="minHeight"
            [style.align-self]="'center'"
            [style.overflow]="'hidden'"
            [style.background-color]="
              (!element.isAdded &&
                element.backgroundColor.r == 255 &&
                element.backgroundColor.g == 255 &&
                element.backgroundColor.b == 255) ||
              element.backgroundColor.a == 0
                ? 'transparent'
                : element?.backgroundColor.toHtmlColor()
            "
          >
            <div *ngFor="let element of elements" [disabled]="element?.readOnly ? true : false">
              <sti-component-holder [element]="element"></sti-component-holder>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-panel-container{min-height:5px;position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i21.StiModelService }, { type: StiRectangleGeometryLayout }]; }, propDecorators: { ref: [{
                type: ViewChild,
                args: ["ref"]
            }], element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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