import { Component, Input } from "@angular/core";
import { Subject } from "rxjs";
import { StiButtonElement } from "../elements/StiButtonElement";
import { StiImageElement } from "../elements/StiImageElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiTextElement } from "../elements/StiTextElement";
import { StiDraggableService } from "../services/sti-draggable.service";
import { StiLabelAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-draggable.service";
import * as i3 from "../services/mouse.service";
import * as i4 from "../services/sti-helper.service";
import * as i5 from "../services/sti-name.service";
import * as i6 from "../services/sti-component-resizer.service";
import * as i7 from "../services/sti-signature.service";
import * as i8 from "@angular/common";
import * as i9 from "./sti-component-resizer.component";
import * as i10 from "./sti-corner-radius.component";
export class StiComponent {
    constructor(model, draggableService, mouseService, helper, nameService, resizer, signatureService) {
        this.model = model;
        this.draggableService = draggableService;
        this.mouseService = mouseService;
        this.helper = helper;
        this.nameService = nameService;
        this.resizer = resizer;
        this.signatureService = signatureService;
        this.isClone = false;
        this.subject = new Subject();
        this.hover = false;
        this.canDrag = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.mouseMoveSubscription?.unsubscribe();
        this.needToSelectedSubscription?.unsubscribe();
    }
    get borderInnerWidth() {
        return (Number(this.borderArea?.width) +
            Number(this.borderArea?.border?.pen.width) +
            (this.element.label.alignment == StiLabelAlignment.Top ? this.element.padding.left : 0) +
            this.element.padding.right);
    }
    get borderInnerHeight() {
        return (Number(this.borderArea?.height) +
            Number(this.borderArea?.border?.pen.width) +
            (this.element.label.alignment != StiLabelAlignment.Top
                ? this.element.padding.bottom + this.element.padding.top
                : 0));
    }
    haveAreaContainer() {
        return this.borderArea && (this.element instanceof StiPanelElement || this.element instanceof StiImageElement)
            ? this.element instanceof StiPanelElement && !this.element.isAdded
                ? false
                : true
            : false;
    }
    get overflow() {
        return this.element instanceof StiTableElement ||
            this.element instanceof StiLabelElement ||
            this.element instanceof StiTextElement ||
            this.element instanceof StiImageElement ||
            this.element instanceof StiPanelElement
            ? ""
            : "hidden";
    }
    get className() {
        return "sti-component " + this.class;
    }
    get direction() {
        return this.element?.label?.alignment == StiLabelAlignment.Top || this.element instanceof StiButtonElement
            ? "column"
            : "row";
    }
    get computedX() {
        if (this.isClone) {
            return 0;
        }
        else {
            return (this.element.x +
                (this.model.getElementPage(this.element) ? this.model.getElementPage(this.element).padding.left : 0));
        }
    }
    get cursor() {
        return !this.model.isPreviewMode ? this.model.cursor : "default";
    }
    get computedY() {
        if (this.isClone) {
            return 0;
        }
        else {
            return Number((this.element.y +
                (this.model.getElementPage(this.element) ? this.model.getElementPage(this.element).padding.top : 0)).toFixed(3));
        }
    }
    get width() {
        if (this.isClone) {
            return "auto";
        }
        else {
            return Number(this.element.width) + "px";
        }
    }
    get height() {
        //
        if (this.isClone || (this.model.draggingElement == this.element && this.draggableService.newElement)) {
            return "auto";
        }
        else {
            return Number(this.element.height) + "px";
        }
    }
    get position() {
        if (this.isClone) {
            return "relative";
        }
        else {
            return this.element?.position;
        }
    }
    get align() {
        return this.element instanceof StiButtonElement ? "center" : "normal";
    }
    getMessage() {
        return this.subject.asObservable();
    }
    withoutBorder() {
        if (this.model.selectedComponent?.element["border"] &&
            !(this.model.selectedComponent?.element instanceof StiTableElement) &&
            (this.model.selectedComponent?.element["border"]["drawLeft"] ||
                this.model.selectedComponent?.element["border"]["drawTop"] ||
                this.model.selectedComponent?.element["border"]["drawRight"] ||
                this.model.selectedComponent?.element["border"]["drawBottom"]) &&
            this.model.selectedComponent?.element["border"]["pen"]["color"]["a"] > 0) {
            return false;
        }
        else {
            return true;
        }
    }
    onMouseMove(event) {
        if (this.model.draggingElement) {
            return;
        }
        if (event.ctrlKey &&
            this.canDrag &&
            this.model.canDrag &&
            Math.max(Math.abs(this.mouseDownX - event.clientX), Math.abs(this.mouseDownY - event.clientY)) >
                StiDraggableService.MOUSE_DELTA) {
            let copy = this.helper.clone(this.element);
            copy.name = this.nameService.getComponentName(copy);
            this.draggableService.startDrag(event, copy, false, true);
            this.canDrag = false;
        }
        else if (this.canDrag &&
            this.model.canDrag &&
            Math.max(Math.abs(this.mouseDownX - event.clientX), Math.abs(this.mouseDownY - event.clientY)) >
                StiDraggableService.MOUSE_DELTA) {
            this.draggableService.startDrag(event, this.element, false, false, this.layerX, this.layerY, this.elementPage);
            this.canDrag = false;
        }
    }
    onMouseDown(event) {
        this.signatureService.drawingMode = false;
        event.stopPropagation();
        if (!this.model.isPreviewMode && event.button == 0) {
            let form = document.querySelector("stimulsoft-forms");
            form?.classList.add("unselectable");
            if (!event["fromEditableContent"]) {
                this.mouseDownX = event.clientX;
                this.mouseDownY = event.clientY;
                this.canDrag = true;
            }
            else {
            }
            this.model.lastFormState = this.model.form.saveToJsonObject().serialize();
            if (this.model.selectedComponent != this) {
                this.model.previousSelectedComponent = this.model.selectedComponent;
                this.model.selectedComponent = this;
            }
            this.elementPage = this.model.getElementPage(this.element);
            let pos = this.model.getMouseOverPagePosition(event);
            let geometry = this.element.getOverPageGeometry(this.model.form);
            this.layerY = pos?.y - geometry.y * this.model.zoom;
            this.layerX = pos?.x - geometry.x * this.model.zoom;
        }
        else if (!this.model.isPreviewMode && event.button != 0) {
            if (this.model.selectedComponent != this) {
                this.model.previousSelectedComponent = this.model.selectedComponent;
                this.model.selectedComponent = this;
            }
        }
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.canDrag = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
        this.needToSelectedSubscription = this.model.needToSelectedComponent.subscribe((element) => {
            if (!this.isClone && element == this.element) {
                this.model.selectedComponent = this;
            }
        });
        setTimeout(() => {
            if (!this.isClone) {
                if (this.element.needToSelectComponent) {
                    this.model.selectedComponent = this;
                    this.element.needToSelectComponent = false;
                }
            }
        }, 0);
    }
}
StiComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiDraggableService }, { token: i3.StiMouseService }, { token: i4.StiHelperService }, { token: i5.StiNameService }, { token: i6.StiComponentResizerService }, { token: i7.SignatureService }], target: i0.ɵɵFactoryTarget.Component });
StiComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiComponent, selector: "sti-component", inputs: { element: "element", class: "class", isClone: "isClone", borderArea: "borderArea" }, ngImport: i0, template: `
    <div
      draggable="false"
      [id]="element?.guid"
      [class]="className"
      [style.left.px]="computedX"
      [style.top.px]="computedY"
      [style.width]="width"
      [style.height]="height"
      [style.position]="position"
      [style.overflow]="overflow"
      [style.display]="'flex'"
      [style.flex-direction]="direction"
      [style.align-items]="align"
      [style.cursor]="cursor"
      [style.transition]="
        element?.position == 'absolute' && resizer.element != element
          ? 'top 0.1s ease 0s,left 0.1s ease 0s,border-color 0.1s ease 0s'
          : ''
      "
      [style.padding-left.px]="element?.padding.left"
      [style.padding-right.px]="element?.padding.right"
      [style.padding-top.px]="element?.padding.top"
      [style.padding-bottom.px]="element?.padding.bottom"
      [style.visibility]="!element?.visible && this.model.isPreviewMode ? 'hidden' : 'visible'"
      (mousedown)="onMouseDown($event)"
      (mouseenter)="this.hover = true; this.model.cursor = 'move'"
      (mouseleave)="this.hover = false; this.model.cursor = 'default'"
      (dragstart)="$event.preventDefault()"
    >
      <ng-content></ng-content>
      <sti-corner-radius-component
        [style.position]="'absolute'"
        [style.pointer-events]="'none'"
        [style.width]="width"
        [style.height]="height"
        [style.left.px]="0"
        [style.top.px]="0"
        *ngIf="model.showCornerRadius && !model.isPreviewMode && element != model.draggingElement"
      ></sti-corner-radius-component>
      <div
        *ngIf="withoutBorder()"
        style="position: absolute; border: 1px solid rgb(126, 180, 234); pointer-events: none"
        [style.width]="width"
        [style.transition]="'opacity 0.2s ease, border-color 0.2s ease'"
        [style.height]="height"
        [style.left.px]="0"
        [style.top.px]="0"
        [style.border-color]="
          model.selectedComponent == this && !model.isPreviewMode && element?.position == 'absolute'
            ? 'rgb(146, 146, 146, 0.35)'
            : 'rgba(213, 213, 213, 0.35)'
        "
        [style.opacity]="
          (model.selectedComponent == this && !model.isPreviewMode && element?.position == 'absolute') ||
          (hover && !model.isPreviewMode && element?.position == 'absolute')
            ? 1
            : 0
        "
      ></div>
      <div
        *ngIf="haveAreaContainer()"
        style="position: absolute; border: 1px solid rgb(126, 180, 234); pointer-events: none"
        [style.width.px]="borderInnerWidth"
        [style.height.px]="borderInnerHeight"
        [style.left.px]="borderArea?.left - borderArea?.border?.pen.width / 2"
        [style.top.px]="borderArea?.top - borderArea?.border?.pen.width / 2"
        [style.border-top]="borderArea?.border.drawTop ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-left]="borderArea?.border.drawLeft ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-right]="borderArea?.border.drawRight ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-bottom]="borderArea?.border.drawBottom ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
      ></div>
      <i *ngIf="!element?.visible" class="pi pi-eye-slash" style="opacity: 0.3;"></i>
    </div>
    <sti-component-resizer
      [component]="this"
      [left]="computedX + element.width"
      [top]="computedY + element.height"
    ></sti-component-resizer>
    <style>
      .sti-component {
        width: 100%;
        font-size: 1px;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        position: relative;
        padding: 10px;
        z-index: 11;
      }

      .sti-component i {
        position: absolute;
        right: 5px;
        top: 5px;
      }
    </style>
  `, isInline: true, styles: ["\n      .sti-component {\n        width: 100%;\n        font-size: 1px;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n        position: relative;\n        padding: 10px;\n        z-index: 11;\n      }\n\n      .sti-component i {\n        position: absolute;\n        right: 5px;\n        top: 5px;\n      }\n    "], dependencies: [{ kind: "directive", type: i8.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9.StiComponentResizerComponent, selector: "sti-component-resizer", inputs: ["left", "top", "size", "component"] }, { kind: "component", type: i10.StiCornerRadiusComponent, selector: "sti-corner-radius-component" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-component",
                    template: `
    <div
      draggable="false"
      [id]="element?.guid"
      [class]="className"
      [style.left.px]="computedX"
      [style.top.px]="computedY"
      [style.width]="width"
      [style.height]="height"
      [style.position]="position"
      [style.overflow]="overflow"
      [style.display]="'flex'"
      [style.flex-direction]="direction"
      [style.align-items]="align"
      [style.cursor]="cursor"
      [style.transition]="
        element?.position == 'absolute' && resizer.element != element
          ? 'top 0.1s ease 0s,left 0.1s ease 0s,border-color 0.1s ease 0s'
          : ''
      "
      [style.padding-left.px]="element?.padding.left"
      [style.padding-right.px]="element?.padding.right"
      [style.padding-top.px]="element?.padding.top"
      [style.padding-bottom.px]="element?.padding.bottom"
      [style.visibility]="!element?.visible && this.model.isPreviewMode ? 'hidden' : 'visible'"
      (mousedown)="onMouseDown($event)"
      (mouseenter)="this.hover = true; this.model.cursor = 'move'"
      (mouseleave)="this.hover = false; this.model.cursor = 'default'"
      (dragstart)="$event.preventDefault()"
    >
      <ng-content></ng-content>
      <sti-corner-radius-component
        [style.position]="'absolute'"
        [style.pointer-events]="'none'"
        [style.width]="width"
        [style.height]="height"
        [style.left.px]="0"
        [style.top.px]="0"
        *ngIf="model.showCornerRadius && !model.isPreviewMode && element != model.draggingElement"
      ></sti-corner-radius-component>
      <div
        *ngIf="withoutBorder()"
        style="position: absolute; border: 1px solid rgb(126, 180, 234); pointer-events: none"
        [style.width]="width"
        [style.transition]="'opacity 0.2s ease, border-color 0.2s ease'"
        [style.height]="height"
        [style.left.px]="0"
        [style.top.px]="0"
        [style.border-color]="
          model.selectedComponent == this && !model.isPreviewMode && element?.position == 'absolute'
            ? 'rgb(146, 146, 146, 0.35)'
            : 'rgba(213, 213, 213, 0.35)'
        "
        [style.opacity]="
          (model.selectedComponent == this && !model.isPreviewMode && element?.position == 'absolute') ||
          (hover && !model.isPreviewMode && element?.position == 'absolute')
            ? 1
            : 0
        "
      ></div>
      <div
        *ngIf="haveAreaContainer()"
        style="position: absolute; border: 1px solid rgb(126, 180, 234); pointer-events: none"
        [style.width.px]="borderInnerWidth"
        [style.height.px]="borderInnerHeight"
        [style.left.px]="borderArea?.left - borderArea?.border?.pen.width / 2"
        [style.top.px]="borderArea?.top - borderArea?.border?.pen.width / 2"
        [style.border-top]="borderArea?.border.drawTop ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-left]="borderArea?.border.drawLeft ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-right]="borderArea?.border.drawRight ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-bottom]="borderArea?.border.drawBottom ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
      ></div>
      <i *ngIf="!element?.visible" class="pi pi-eye-slash" style="opacity: 0.3;"></i>
    </div>
    <sti-component-resizer
      [component]="this"
      [left]="computedX + element.width"
      [top]="computedY + element.height"
    ></sti-component-resizer>
    <style>
      .sti-component {
        width: 100%;
        font-size: 1px;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        position: relative;
        padding: 10px;
        z-index: 11;
      }

      .sti-component i {
        position: absolute;
        right: 5px;
        top: 5px;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiDraggableService }, { type: i3.StiMouseService }, { type: i4.StiHelperService }, { type: i5.StiNameService }, { type: i6.StiComponentResizerService }, { type: i7.SignatureService }]; }, propDecorators: { element: [{
                type: Input
            }], class: [{
                type: Input
            }], isClone: [{
                type: Input
            }], borderArea: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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