import { animate, state, style, transition, trigger } from "@angular/animations";
import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-component-resizer.service";
export class StiComponentResizerComponent {
    constructor(model, componentResizerService) {
        this.model = model;
        this.componentResizerService = componentResizerService;
        this.size = 5;
        this.leftOffset = 2;
        this.rightOffset = 3;
    }
    get visible() {
        return (this.model.selectedComponent == this.component &&
            !this.model.isPreviewMode &&
            this.component.element.position == "absolute");
    }
    get width() {
        return this.component.element.width;
    }
    get height() {
        return this.component.element.height;
    }
    ngOnInit() { }
}
StiComponentResizerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponentResizerComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiComponentResizerService }], target: i0.ɵɵFactoryTarget.Component });
StiComponentResizerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiComponentResizerComponent, selector: "sti-component-resizer", inputs: { left: "left", top: "top", size: "size", component: "component" }, ngImport: i0, template: `
    <div
      class="bottom-right resizer"
      style="position: absolute;cursor: nwse-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - rightOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottomRight')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="right resizer"
      style="position: absolute;cursor: ew-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - rightOffset"
      [style.top.px]="top - height / 2 - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromRight')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="bottom resizer"
      style="position: absolute;cursor: ns-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width / 2 - rightOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottom')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="bottom-left resizer"
      style="position: absolute;cursor: nesw-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width - leftOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottomLeft')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="left resizer"
      style="position: absolute;cursor: ew-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width - leftOffset"
      [style.top.px]="top - height / 2 - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromLeft')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
  `, isInline: true, animations: [
        trigger("visibility", [
            // ...
            state("visible", style({
                visibility: "",
            })),
            state("hidden", style({
                visibility: "hidden",
            })),
            transition("visible => hidden", [animate("0s 0.2s")]),
            transition("hidden => visible", [animate("0s")]),
        ]),
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponentResizerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-component-resizer",
                    template: `
    <div
      class="bottom-right resizer"
      style="position: absolute;cursor: nwse-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - rightOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottomRight')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="right resizer"
      style="position: absolute;cursor: ew-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - rightOffset"
      [style.top.px]="top - height / 2 - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromRight')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="bottom resizer"
      style="position: absolute;cursor: ns-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width / 2 - rightOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottom')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="bottom-left resizer"
      style="position: absolute;cursor: nesw-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width - leftOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottomLeft')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="left resizer"
      style="position: absolute;cursor: ew-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width - leftOffset"
      [style.top.px]="top - height / 2 - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromLeft')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
  `,
                    animations: [
                        trigger("visibility", [
                            // ...
                            state("visible", style({
                                visibility: "",
                            })),
                            state("hidden", style({
                                visibility: "hidden",
                            })),
                            transition("visible => hidden", [animate("0s 0.2s")]),
                            transition("hidden => visible", [animate("0s")]),
                        ]),
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiComponentResizerService }]; }, propDecorators: { left: [{
                type: Input
            }], top: [{
                type: Input
            }], size: [{
                type: Input
            }], component: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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