import { Component, Input } from "@angular/core";
import { StiTextItem } from "../../elements/text/StiTextItem";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-editable-content.service";
import * as i3 from "@angular/common";
import * as i4 from "@angular/forms";
import * as i5 from "../sti-component";
import * as i6 from "../sti-editable-content.component";
import * as i7 from "../sti-tooltip/sti-tooltip.directive";
export class StiComboBoxComponent {
    constructor(model, editableService) {
        this.model = model;
        this.editableService = editableService;
        this.isClone = false;
    }
    get align() {
        return "start";
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    get needToFill() {
        return this.element.required && !this.element.value && this.model.hasEmptyReuiredFields;
    }
    ngOnInit() { }
    get selectedOption() {
        return this.element.selectedOption;
    }
    set selectedOption(value) {
        this.element.selectedOption = value;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    borderWidth() {
        return `${this.element.borderWeight}px`;
    }
    inFocus() {
        setTimeout(() => {
            this.editableService.editableContent = new StiTextItem(this.element.selectedOption, this.element.font, this.element.textColor, this.element.backgroundColor);
            this.editableService.usedElement = this.element;
        }, 0);
    }
    lostFocus() {
        if (this.model.selectedComponent?.element != this.element) {
            this.editableService.editableContent = null;
        }
    }
}
StiComboBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComboBoxComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component });
StiComboBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiComboBoxComponent, selector: "sti-combobox-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-combo-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <select
            class="selection"
            name=""
            id=""
            [(ngModel)]="selectedOption"
            [style.margin-top.px]="element?.getTopMargin()"
            [style.align-self]="align"
            [style]="element?.htmlStyle()"
            [style.color]="element?.textColor.toHtmlColor()"
            [style.background-color]="element?.backgroundColor.toHtmlColor()"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.border-width]="borderWidth()"
            [disabled]="element?.readOnly ? true : false"
            [required]="element?.required"
            [stiTooltip]="element?.tooltip"
            [tabIndex]="element['tabIndex']"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="disableDrag($event)"
            (mouseup)="this.model.canDrag = true"
            (focus)="inFocus()"
            (blur)="lostFocus()"
          >
            <option
              [style.background-color]="element?.backgroundColor.toHtmlColor()"
              *ngFor="let option of element?.options"
            >
              {{ option }}
            </option>
          </select>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.selection{width:100%;border:1px solid rgb(198,198,198);background-color:#fff;height:-moz-fit-content;height:fit-content;padding:3px 4px;margin-top:10px;-webkit-appearance:none;appearance:none;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDA2IDc5LjE2NDc1MywgMjAyMS8wMi8xNS0xMTo1MjoxMyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDphNzFiNTVkYi0wMGZlLTVjNDctYmVkZS1jYTVhNjk0NjdkNjgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6N0UxNDE5MzBBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6N0UxNDE5MkZBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIyLjMgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6YTcxYjU1ZGItMDBmZS01YzQ3LWJlZGUtY2E1YTY5NDY3ZDY4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmE3MWI1NWRiLTAwZmUtNWM0Ny1iZWRlLWNhNWE2OTQ2N2Q2OCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pg8NmFEAAABPSURBVHjaYmxsbGSgBDAxUAiGqQH1eNTXE2NAAw5D6qFyBA1oxGIITDNGnLPgcAEDmm0NSAYTNACbIVg14zMAmwsYSDUAr8bRpIwAAAEGAFUJDal4N9jVAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:right 5px top 50%;background-size:14px auto}.selection:hover{border-color:#a3bde3!important;background-color:#e2effc!important}.selection:focus{outline:none;border-color:#a3bde3!important}.sti-combo-box option:hover{box-shadow:0 0 10px 100px orange inset}select:focus>option:checked{background-color:#f6f6f6!important}select option:hover{box-shadow:0 0 10px 100px orange inset}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i4.NgSelectOption, selector: "option", inputs: ["ngValue", "value"] }, { kind: "directive", type: i4.ɵNgSelectMultipleOption, selector: "option", inputs: ["ngValue", "value"] }, { kind: "directive", type: i4.SelectControlValueAccessor, selector: "select:not([multiple])[formControlName],select:not([multiple])[formControl],select:not([multiple])[ngModel]", inputs: ["compareWith"] }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.RequiredValidator, selector: ":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]", inputs: ["required"] }, { kind: "directive", type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "component", type: i5.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i6.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComboBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-combobox-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-combo-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <select
            class="selection"
            name=""
            id=""
            [(ngModel)]="selectedOption"
            [style.margin-top.px]="element?.getTopMargin()"
            [style.align-self]="align"
            [style]="element?.htmlStyle()"
            [style.color]="element?.textColor.toHtmlColor()"
            [style.background-color]="element?.backgroundColor.toHtmlColor()"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.border-width]="borderWidth()"
            [disabled]="element?.readOnly ? true : false"
            [required]="element?.required"
            [stiTooltip]="element?.tooltip"
            [tabIndex]="element['tabIndex']"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="disableDrag($event)"
            (mouseup)="this.model.canDrag = true"
            (focus)="inFocus()"
            (blur)="lostFocus()"
          >
            <option
              [style.background-color]="element?.backgroundColor.toHtmlColor()"
              *ngFor="let option of element?.options"
            >
              {{ option }}
            </option>
          </select>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.selection{width:100%;border:1px solid rgb(198,198,198);background-color:#fff;height:-moz-fit-content;height:fit-content;padding:3px 4px;margin-top:10px;-webkit-appearance:none;appearance:none;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDA2IDc5LjE2NDc1MywgMjAyMS8wMi8xNS0xMTo1MjoxMyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDphNzFiNTVkYi0wMGZlLTVjNDctYmVkZS1jYTVhNjk0NjdkNjgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6N0UxNDE5MzBBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6N0UxNDE5MkZBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIyLjMgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6YTcxYjU1ZGItMDBmZS01YzQ3LWJlZGUtY2E1YTY5NDY3ZDY4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmE3MWI1NWRiLTAwZmUtNWM0Ny1iZWRlLWNhNWE2OTQ2N2Q2OCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pg8NmFEAAABPSURBVHjaYmxsbGSgBDAxUAiGqQH1eNTXE2NAAw5D6qFyBA1oxGIITDNGnLPgcAEDmm0NSAYTNACbIVg14zMAmwsYSDUAr8bRpIwAAAEGAFUJDal4N9jVAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:right 5px top 50%;background-size:14px auto}.selection:hover{border-color:#a3bde3!important;background-color:#e2effc!important}.selection:focus{outline:none;border-color:#a3bde3!important}.sti-combo-box option:hover{box-shadow:0 0 10px 100px orange inset}select:focus>option:checked{background-color:#f6f6f6!important}select option:hover{box-shadow:0 0 10px 100px orange inset}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiEditableContentService }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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