import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-color-dialog.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "../../services/sti-rich-text.service";
import * as i5 from "@angular/common";
import * as i6 from "@angular/forms";
export class StiColorOptionsDialogComponent {
    constructor(model, colorService, loc, richText) {
        this.model = model;
        this.colorService = colorService;
        this.loc = loc;
        this.richText = richText;
        this.currentState = "custom";
        this.currentSelectedItem = "Transparent";
    }
    checkRange(event, object, property) {
        if (parseInt(event.target.value)) {
            if (parseInt(event.target.value) > 255) {
                object[property] = 255;
            }
            else if (parseInt(event.target.value) < 0) {
                object[property] = 0;
            }
            else {
                object[property] = parseInt(event.target.value);
            }
        }
        else {
            object[property] = 0;
        }
        event.target.value = object[property];
    }
    checkHex(event) {
        if (event.target.value) {
            if (event.target.value.length > 7) {
                let value = event.target.value.slice(0, 6);
                this.hex = value;
            }
            else {
                this.hex = event.target.value;
            }
        }
        else {
            this.hex = "#000000";
        }
        event.target.value = this.hex;
    }
    changeState(state) {
        this.currentState = state;
    }
    get hex() {
        return this.colorService.cloneOfCurrentColorObject.toHexColor();
    }
    set hex(value) {
        this.colorService.cloneOfCurrentColorObject.hexColor = value;
    }
    changeColor() {
        if (this.currentState == "custom") {
            this.colorService.currentColorObject.hexColor = this.colorService.cloneOfCurrentColorObject.hexColor;
        }
        else {
            let colorObj = this.colorService.browserColors.find((color) => color.name == this.currentSelectedItem);
            if (colorObj.name != "Transparent") {
                this.colorService.currentColorObject.hexColor = this.colorService.rgbToHex(colorObj.color);
            }
            else {
                this.colorService.currentColorObject.a = 0;
            }
        }
        if (this.colorService.isRichText) {
            this.richText.insertForeColor();
        }
        this.model.showMoreColorDialog = false;
        this.model.showColorDialog = false;
    }
    getColor(color) {
        return `rgb(${color})`;
    }
    ngOnInit() { }
}
StiColorOptionsDialogComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColorOptionsDialogComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiColorDialogService }, { token: i3.StiLocalizationService }, { token: i4.StiRichTextService }], target: i0.ɵɵFactoryTarget.Component });
StiColorOptionsDialogComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiColorOptionsDialogComponent, selector: "sti-color-options-dialog", ngImport: i0, template: `
    <div class="color-options-dialog">
      <div class="dialog-navigation">
        <div class="header-navigation">
          <span> {{ loc.get2("Gui", "colorpickerdialog_caption") }}</span>
          <div class="close-button" (click)="model.showMoreColorDialog = false">
            <i class="pi pi-times"></i>
          </div>
        </div>
        <div class="content-navigation">
          <div class="content-button {{ currentState == 'custom' ? 'current' : '' }}" (click)="changeState('custom')">
            <span>{{ loc.get2("Gui", "colorpickerdialog_tabcustom") }}</span>
            <div class="horizontal-line"></div>
          </div>
          <div class="content-button {{ currentState == 'web' ? 'current' : '' }}" (click)="changeState('web')">
            <span>{{ "Web" }}</span>
            <div class="horizontal-line"></div>
          </div>
        </div>
      </div>
      <div class="dialog-content">
        <div class="custom-dialog" *ngIf="currentState == 'custom'">
          <div class="input-fields">
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_alphalabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.a"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'a')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'a')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_redlabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.r"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'r')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'r')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_greenlabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.g"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'g')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'g')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_bluelabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.b"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'b')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'b')"
              />
            </div>
            <div class="field">
              <span>{{ "Hex" }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="hex"
                (keyup.enter)="checkHex($event)"
                (blur)="checkHex($event)"
              />
            </div>
          </div>
          <div class="color-preview">
            <div class="preview" [style.background-color]="colorService.cloneOfCurrentColorObject.toHtmlColor()"></div>
          </div>
        </div>
        <div class="web-dialog" *ngIf="currentState == 'web'">
          <div
            class="color-item {{ currentSelectedItem == item.name ? 'selected' : '' }}"
            *ngFor="let item of colorService.browserColors"
            (click)="currentSelectedItem = item.name"
          >
            <div class="mini-color-preview" [style.background-color]="getColor(item.color)"></div>
            <span> {{ item.name }}</span>
          </div>
        </div>
      </div>
      <div class="footer-navigation">
        <div class="footer-button accept" (click)="changeColor()">
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="footer-button cancel" [style.margin-right.px]="10" (click)="model.showMoreColorDialog = false">
          <span>{{ loc.get2("PropertyMain", "Cancel") }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".selected{background-color:#e5e5e5}.web-dialog{height:190px;overflow:auto;width:calc(100% - 20px);margin:5px 10px}.mini-color-preview{width:64px;height:15px;border-radius:3px;border:1px solid #ababab;cursor:default;margin:0 4px}.color-item span{color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default}.color-item{height:24px;display:flex;width:calc(100% - 2px);align-items:center;border-radius:3px;margin:1px}.color-item:hover{background-color:#dadada}.field{display:flex;width:100%;flex:1;align-items:center}.field span{width:100%;color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default}.field input{width:80px;height:21px;font-size:12px;margin:0;padding:0 0 0 4px;border-radius:3px;font-family:Arial;outline:none;max-width:inherit;border:1px solid #ababab;color:#444}.custom-dialog{display:flex;padding-left:19px;padding-top:5px}.input-fields{width:140px;height:180px;display:flex;flex-direction:column}.preview{height:128px;width:128px;border:1px solid #c6c6c6}.color-preview{height:180px;width:180px;display:flex;align-items:center;justify-content:center}.pi{font-size:.5rem}.color-options-dialog{min-height:315px;-webkit-user-select:none;-moz-user-select:none;width:345px;left:calc(50% - 172.5px);top:calc(50% - 157.5px);position:absolute;border:1px solid #19478a;background:#ffffff;color:#444;box-shadow:0 0 7px #0000004d;cursor:default;display:flex;flex-direction:column;z-index:99999}.header-navigation{display:flex;width:100%;height:30px;align-items:center;padding-left:15px;padding-right:3px}.header-navigation span{font-family:Arial;font-size:13px;font-weight:700;color:#19478a;cursor:default;width:100%}.close-button{width:28px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#d3d3d3}.content-navigation{width:calc(100% - 20px);height:40px;display:flex;border-bottom:1px solid lightgray;align-items:center;margin:0 12px}.content-button{min-width:35px;height:26px;border-radius:3px;display:flex;flex-direction:column;justify-content:center;margin-right:2px}.content-button:hover{background-color:#dadada}.content-button span{color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default;text-align:center;margin:0 10px}.horizontal-line{height:3px;border-radius:3px;margin:0 10px}.current{background-color:#e5e5e5}.current .horizontal-line{background-color:#19478a}.footer-button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px 10px;-webkit-user-select:none;font-family:Arial;font-size:12px}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.footer-navigation{display:flex;justify-content:end}.dialog-content{height:100%;width:100%;flex:1}\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i6.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i6.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColorOptionsDialogComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-color-options-dialog", template: `
    <div class="color-options-dialog">
      <div class="dialog-navigation">
        <div class="header-navigation">
          <span> {{ loc.get2("Gui", "colorpickerdialog_caption") }}</span>
          <div class="close-button" (click)="model.showMoreColorDialog = false">
            <i class="pi pi-times"></i>
          </div>
        </div>
        <div class="content-navigation">
          <div class="content-button {{ currentState == 'custom' ? 'current' : '' }}" (click)="changeState('custom')">
            <span>{{ loc.get2("Gui", "colorpickerdialog_tabcustom") }}</span>
            <div class="horizontal-line"></div>
          </div>
          <div class="content-button {{ currentState == 'web' ? 'current' : '' }}" (click)="changeState('web')">
            <span>{{ "Web" }}</span>
            <div class="horizontal-line"></div>
          </div>
        </div>
      </div>
      <div class="dialog-content">
        <div class="custom-dialog" *ngIf="currentState == 'custom'">
          <div class="input-fields">
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_alphalabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.a"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'a')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'a')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_redlabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.r"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'r')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'r')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_greenlabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.g"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'g')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'g')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_bluelabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.b"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'b')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'b')"
              />
            </div>
            <div class="field">
              <span>{{ "Hex" }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="hex"
                (keyup.enter)="checkHex($event)"
                (blur)="checkHex($event)"
              />
            </div>
          </div>
          <div class="color-preview">
            <div class="preview" [style.background-color]="colorService.cloneOfCurrentColorObject.toHtmlColor()"></div>
          </div>
        </div>
        <div class="web-dialog" *ngIf="currentState == 'web'">
          <div
            class="color-item {{ currentSelectedItem == item.name ? 'selected' : '' }}"
            *ngFor="let item of colorService.browserColors"
            (click)="currentSelectedItem = item.name"
          >
            <div class="mini-color-preview" [style.background-color]="getColor(item.color)"></div>
            <span> {{ item.name }}</span>
          </div>
        </div>
      </div>
      <div class="footer-navigation">
        <div class="footer-button accept" (click)="changeColor()">
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="footer-button cancel" [style.margin-right.px]="10" (click)="model.showMoreColorDialog = false">
          <span>{{ loc.get2("PropertyMain", "Cancel") }}</span>
        </div>
      </div>
    </div>
  `, styles: [".selected{background-color:#e5e5e5}.web-dialog{height:190px;overflow:auto;width:calc(100% - 20px);margin:5px 10px}.mini-color-preview{width:64px;height:15px;border-radius:3px;border:1px solid #ababab;cursor:default;margin:0 4px}.color-item span{color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default}.color-item{height:24px;display:flex;width:calc(100% - 2px);align-items:center;border-radius:3px;margin:1px}.color-item:hover{background-color:#dadada}.field{display:flex;width:100%;flex:1;align-items:center}.field span{width:100%;color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default}.field input{width:80px;height:21px;font-size:12px;margin:0;padding:0 0 0 4px;border-radius:3px;font-family:Arial;outline:none;max-width:inherit;border:1px solid #ababab;color:#444}.custom-dialog{display:flex;padding-left:19px;padding-top:5px}.input-fields{width:140px;height:180px;display:flex;flex-direction:column}.preview{height:128px;width:128px;border:1px solid #c6c6c6}.color-preview{height:180px;width:180px;display:flex;align-items:center;justify-content:center}.pi{font-size:.5rem}.color-options-dialog{min-height:315px;-webkit-user-select:none;-moz-user-select:none;width:345px;left:calc(50% - 172.5px);top:calc(50% - 157.5px);position:absolute;border:1px solid #19478a;background:#ffffff;color:#444;box-shadow:0 0 7px #0000004d;cursor:default;display:flex;flex-direction:column;z-index:99999}.header-navigation{display:flex;width:100%;height:30px;align-items:center;padding-left:15px;padding-right:3px}.header-navigation span{font-family:Arial;font-size:13px;font-weight:700;color:#19478a;cursor:default;width:100%}.close-button{width:28px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#d3d3d3}.content-navigation{width:calc(100% - 20px);height:40px;display:flex;border-bottom:1px solid lightgray;align-items:center;margin:0 12px}.content-button{min-width:35px;height:26px;border-radius:3px;display:flex;flex-direction:column;justify-content:center;margin-right:2px}.content-button:hover{background-color:#dadada}.content-button span{color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default;text-align:center;margin:0 10px}.horizontal-line{height:3px;border-radius:3px;margin:0 10px}.current{background-color:#e5e5e5}.current .horizontal-line{background-color:#19478a}.footer-button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px 10px;-webkit-user-select:none;font-family:Arial;font-size:12px}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.footer-navigation{display:flex;justify-content:end}.dialog-content{height:100%;width:100%;flex:1}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiColorDialogService }, { type: i3.StiLocalizationService }, { type: i4.StiRichTextService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWNvbG9yLW9wdGlvbnMtZGlhbG9nLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9jb21wb25lbnRzL3N0aS1jb2xvci1kaWFsb2cvc3RpLWNvbG9yLW9wdGlvbnMtZGlhbG9nLmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFVLE1BQU0sZUFBZSxDQUFDOzs7Ozs7OztBQWdWbEQsTUFBTSxPQUFPLDhCQUE4QjtJQUd6QyxZQUNTLEtBQXNCLEVBQ3RCLFlBQW1DLEVBQ25DLEdBQTJCLEVBQzNCLFFBQTRCO1FBSDVCLFVBQUssR0FBTCxLQUFLLENBQWlCO1FBQ3RCLGlCQUFZLEdBQVosWUFBWSxDQUF1QjtRQUNuQyxRQUFHLEdBQUgsR0FBRyxDQUF3QjtRQUMzQixhQUFRLEdBQVIsUUFBUSxDQUFvQjtRQU45QixpQkFBWSxHQUFHLFFBQVEsQ0FBQztRQUN4Qix3QkFBbUIsR0FBRyxhQUFhLENBQUM7SUFNeEMsQ0FBQztJQUVKLFVBQVUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLFFBQVE7UUFDaEMsSUFBSSxRQUFRLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUNoQyxJQUFJLFFBQVEsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxHQUFHLEdBQUcsRUFBRTtnQkFDdEMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxHQUFHLEdBQUcsQ0FBQzthQUN4QjtpQkFBTSxJQUFJLFFBQVEsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsRUFBRTtnQkFDM0MsTUFBTSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsQ0FBQzthQUN0QjtpQkFBTTtnQkFDTCxNQUFNLENBQUMsUUFBUSxDQUFDLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7YUFDakQ7U0FDRjthQUFNO1lBQ0wsTUFBTSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsQ0FBQztTQUN0QjtRQUNELEtBQUssQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBQ0QsUUFBUSxDQUFDLEtBQUs7UUFDWixJQUFJLEtBQUssQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFO1lBQ3RCLElBQUksS0FBSyxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtnQkFDakMsSUFBSSxLQUFLLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztnQkFDM0MsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7YUFDbEI7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQzthQUMvQjtTQUNGO2FBQU07WUFDTCxJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQztTQUN0QjtRQUNELEtBQUssQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDaEMsQ0FBQztJQUNELFdBQVcsQ0FBQyxLQUFLO1FBQ2YsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNELElBQUksR0FBRztRQUNMLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQyx5QkFBeUIsQ0FBQyxVQUFVLEVBQUUsQ0FBQztJQUNsRSxDQUFDO0lBQ0QsSUFBSSxHQUFHLENBQUMsS0FBSztRQUNYLElBQUksQ0FBQyxZQUFZLENBQUMseUJBQXlCLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUMvRCxDQUFDO0lBQ0QsV0FBVztRQUNULElBQUksSUFBSSxDQUFDLFlBQVksSUFBSSxRQUFRLEVBQUU7WUFDakMsSUFBSSxDQUFDLFlBQVksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyx5QkFBeUIsQ0FBQyxRQUFRLENBQUM7U0FDdEc7YUFBTTtZQUNMLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQztZQUN2RyxJQUFJLFFBQVEsQ0FBQyxJQUFJLElBQUksYUFBYSxFQUFFO2dCQUNsQyxJQUFJLENBQUMsWUFBWSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7YUFDNUY7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLFlBQVksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2FBQzVDO1NBQ0Y7UUFDRCxJQUFJLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxFQUFFO1lBQ2hDLElBQUksQ0FBQyxRQUFRLENBQUMsZUFBZSxFQUFFLENBQUM7U0FDakM7UUFDRCxJQUFJLENBQUMsS0FBSyxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQztRQUN2QyxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDckMsQ0FBQztJQUNELFFBQVEsQ0FBQyxLQUFLO1FBQ1osT0FBTyxPQUFPLEtBQUssR0FBRyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxRQUFRLEtBQUksQ0FBQzs7MkhBbEVGLDhCQUE4QjsrR0FBOUIsOEJBQThCLGdFQXZVL0I7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQStHVDsyRkF3TlUsOEJBQThCO2tCQXpVMUMsU0FBUzsrQkFDRSwwQkFBMEIsWUFDMUI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQStHVCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgT25Jbml0IH0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpQ29sb3JEaWFsb2dTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL3N0aS1jb2xvci1kaWFsb2cuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL3N0aS1sb2NhbGl6YXRpb24uc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlSaWNoVGV4dFNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vc2VydmljZXMvc3RpLXJpY2gtdGV4dC5zZXJ2aWNlXCI7XHJcbmltcG9ydCBDb2xvciBmcm9tIFwiLi4vLi4vc3lzdGVtL0NvbG9yXCI7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogXCJzdGktY29sb3Itb3B0aW9ucy1kaWFsb2dcIixcclxuICB0ZW1wbGF0ZTogYFxyXG4gICAgPGRpdiBjbGFzcz1cImNvbG9yLW9wdGlvbnMtZGlhbG9nXCI+XHJcbiAgICAgIDxkaXYgY2xhc3M9XCJkaWFsb2ctbmF2aWdhdGlvblwiPlxyXG4gICAgICAgIDxkaXYgY2xhc3M9XCJoZWFkZXItbmF2aWdhdGlvblwiPlxyXG4gICAgICAgICAgPHNwYW4+IHt7IGxvYy5nZXQyKFwiR3VpXCIsIFwiY29sb3JwaWNrZXJkaWFsb2dfY2FwdGlvblwiKSB9fTwvc3Bhbj5cclxuICAgICAgICAgIDxkaXYgY2xhc3M9XCJjbG9zZS1idXR0b25cIiAoY2xpY2spPVwibW9kZWwuc2hvd01vcmVDb2xvckRpYWxvZyA9IGZhbHNlXCI+XHJcbiAgICAgICAgICAgIDxpIGNsYXNzPVwicGkgcGktdGltZXNcIj48L2k+XHJcbiAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICA8L2Rpdj5cclxuICAgICAgICA8ZGl2IGNsYXNzPVwiY29udGVudC1uYXZpZ2F0aW9uXCI+XHJcbiAgICAgICAgICA8ZGl2IGNsYXNzPVwiY29udGVudC1idXR0b24ge3sgY3VycmVudFN0YXRlID09ICdjdXN0b20nID8gJ2N1cnJlbnQnIDogJycgfX1cIiAoY2xpY2spPVwiY2hhbmdlU3RhdGUoJ2N1c3RvbScpXCI+XHJcbiAgICAgICAgICAgIDxzcGFuPnt7IGxvYy5nZXQyKFwiR3VpXCIsIFwiY29sb3JwaWNrZXJkaWFsb2dfdGFiY3VzdG9tXCIpIH19PC9zcGFuPlxyXG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwiaG9yaXpvbnRhbC1saW5lXCI+PC9kaXY+XHJcbiAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgIDxkaXYgY2xhc3M9XCJjb250ZW50LWJ1dHRvbiB7eyBjdXJyZW50U3RhdGUgPT0gJ3dlYicgPyAnY3VycmVudCcgOiAnJyB9fVwiIChjbGljayk9XCJjaGFuZ2VTdGF0ZSgnd2ViJylcIj5cclxuICAgICAgICAgICAgPHNwYW4+e3sgXCJXZWJcIiB9fTwvc3Bhbj5cclxuICAgICAgICAgICAgPGRpdiBjbGFzcz1cImhvcml6b250YWwtbGluZVwiPjwvZGl2PlxyXG4gICAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgPC9kaXY+XHJcbiAgICAgIDwvZGl2PlxyXG4gICAgICA8ZGl2IGNsYXNzPVwiZGlhbG9nLWNvbnRlbnRcIj5cclxuICAgICAgICA8ZGl2IGNsYXNzPVwiY3VzdG9tLWRpYWxvZ1wiICpuZ0lmPVwiY3VycmVudFN0YXRlID09ICdjdXN0b20nXCI+XHJcbiAgICAgICAgICA8ZGl2IGNsYXNzPVwiaW5wdXQtZmllbGRzXCI+XHJcbiAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJmaWVsZFwiPlxyXG4gICAgICAgICAgICAgIDxzcGFuPnt7XHJcbiAgICAgICAgICAgICAgICBsb2MuZ2V0MihcIkd1aVwiLCBcImNvbG9ycGlja2VyZGlhbG9nX2FscGhhbGFiZWxcIikucmVwbGFjZShcIiZhbXBcIiwgXCJcIikucmVwbGFjZShcIjtcIiwgXCJcIikucmVwbGFjZShcIjpcIiwgXCJcIilcclxuICAgICAgICAgICAgICB9fTwvc3Bhbj5cclxuICAgICAgICAgICAgICA8aW5wdXRcclxuICAgICAgICAgICAgICAgIHR5cGU9XCJ0ZXh0XCJcclxuICAgICAgICAgICAgICAgIG5hbWU9XCJcIlxyXG4gICAgICAgICAgICAgICAgaWQ9XCJcIlxyXG4gICAgICAgICAgICAgICAgW25nTW9kZWxdPVwiY29sb3JTZXJ2aWNlLmNsb25lT2ZDdXJyZW50Q29sb3JPYmplY3QuYVwiXHJcbiAgICAgICAgICAgICAgICAoa2V5dXAuZW50ZXIpPVwiY2hlY2tSYW5nZSgkZXZlbnQsIGNvbG9yU2VydmljZS5jbG9uZU9mQ3VycmVudENvbG9yT2JqZWN0LCAnYScpXCJcclxuICAgICAgICAgICAgICAgIChibHVyKT1cImNoZWNrUmFuZ2UoJGV2ZW50LCBjb2xvclNlcnZpY2UuY2xvbmVPZkN1cnJlbnRDb2xvck9iamVjdCwgJ2EnKVwiXHJcbiAgICAgICAgICAgICAgLz5cclxuICAgICAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJmaWVsZFwiPlxyXG4gICAgICAgICAgICAgIDxzcGFuPnt7XHJcbiAgICAgICAgICAgICAgICBsb2MuZ2V0MihcIkd1aVwiLCBcImNvbG9ycGlja2VyZGlhbG9nX3JlZGxhYmVsXCIpLnJlcGxhY2UoXCImYW1wXCIsIFwiXCIpLnJlcGxhY2UoXCI7XCIsIFwiXCIpLnJlcGxhY2UoXCI6XCIsIFwiXCIpXHJcbiAgICAgICAgICAgICAgfX08L3NwYW4+XHJcbiAgICAgICAgICAgICAgPGlucHV0XHJcbiAgICAgICAgICAgICAgICB0eXBlPVwidGV4dFwiXHJcbiAgICAgICAgICAgICAgICBuYW1lPVwiXCJcclxuICAgICAgICAgICAgICAgIGlkPVwiXCJcclxuICAgICAgICAgICAgICAgIFtuZ01vZGVsXT1cImNvbG9yU2VydmljZS5jbG9uZU9mQ3VycmVudENvbG9yT2JqZWN0LnJcIlxyXG4gICAgICAgICAgICAgICAgKGtleXVwLmVudGVyKT1cImNoZWNrUmFuZ2UoJGV2ZW50LCBjb2xvclNlcnZpY2UuY2xvbmVPZkN1cnJlbnRDb2xvck9iamVjdCwgJ3InKVwiXHJcbiAgICAgICAgICAgICAgICAoYmx1cik9XCJjaGVja1JhbmdlKCRldmVudCwgY29sb3JTZXJ2aWNlLmNsb25lT2ZDdXJyZW50Q29sb3JPYmplY3QsICdyJylcIlxyXG4gICAgICAgICAgICAgIC8+XHJcbiAgICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwiZmllbGRcIj5cclxuICAgICAgICAgICAgICA8c3Bhbj57e1xyXG4gICAgICAgICAgICAgICAgbG9jLmdldDIoXCJHdWlcIiwgXCJjb2xvcnBpY2tlcmRpYWxvZ19ncmVlbmxhYmVsXCIpLnJlcGxhY2UoXCImYW1wXCIsIFwiXCIpLnJlcGxhY2UoXCI7XCIsIFwiXCIpLnJlcGxhY2UoXCI6XCIsIFwiXCIpXHJcbiAgICAgICAgICAgICAgfX08L3NwYW4+XHJcbiAgICAgICAgICAgICAgPGlucHV0XHJcbiAgICAgICAgICAgICAgICB0eXBlPVwidGV4dFwiXHJcbiAgICAgICAgICAgICAgICBuYW1lPVwiXCJcclxuICAgICAgICAgICAgICAgIGlkPVwiXCJcclxuICAgICAgICAgICAgICAgIFtuZ01vZGVsXT1cImNvbG9yU2VydmljZS5jbG9uZU9mQ3VycmVudENvbG9yT2JqZWN0LmdcIlxyXG4gICAgICAgICAgICAgICAgKGtleXVwLmVudGVyKT1cImNoZWNrUmFuZ2UoJGV2ZW50LCBjb2xvclNlcnZpY2UuY2xvbmVPZkN1cnJlbnRDb2xvck9iamVjdCwgJ2cnKVwiXHJcbiAgICAgICAgICAgICAgICAoYmx1cik9XCJjaGVja1JhbmdlKCRldmVudCwgY29sb3JTZXJ2aWNlLmNsb25lT2ZDdXJyZW50Q29sb3JPYmplY3QsICdnJylcIlxyXG4gICAgICAgICAgICAgIC8+XHJcbiAgICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwiZmllbGRcIj5cclxuICAgICAgICAgICAgICA8c3Bhbj57e1xyXG4gICAgICAgICAgICAgICAgbG9jLmdldDIoXCJHdWlcIiwgXCJjb2xvcnBpY2tlcmRpYWxvZ19ibHVlbGFiZWxcIikucmVwbGFjZShcIiZhbXBcIiwgXCJcIikucmVwbGFjZShcIjtcIiwgXCJcIikucmVwbGFjZShcIjpcIiwgXCJcIilcclxuICAgICAgICAgICAgICB9fTwvc3Bhbj5cclxuICAgICAgICAgICAgICA8aW5wdXRcclxuICAgICAgICAgICAgICAgIHR5cGU9XCJ0ZXh0XCJcclxuICAgICAgICAgICAgICAgIG5hbWU9XCJcIlxyXG4gICAgICAgICAgICAgICAgaWQ9XCJcIlxyXG4gICAgICAgICAgICAgICAgW25nTW9kZWxdPVwiY29sb3JTZXJ2aWNlLmNsb25lT2ZDdXJyZW50Q29sb3JPYmplY3QuYlwiXHJcbiAgICAgICAgICAgICAgICAoa2V5dXAuZW50ZXIpPVwiY2hlY2tSYW5nZSgkZXZlbnQsIGNvbG9yU2VydmljZS5jbG9uZU9mQ3VycmVudENvbG9yT2JqZWN0LCAnYicpXCJcclxuICAgICAgICAgICAgICAgIChibHVyKT1cImNoZWNrUmFuZ2UoJGV2ZW50LCBjb2xvclNlcnZpY2UuY2xvbmVPZkN1cnJlbnRDb2xvck9iamVjdCwgJ2InKVwiXHJcbiAgICAgICAgICAgICAgLz5cclxuICAgICAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJmaWVsZFwiPlxyXG4gICAgICAgICAgICAgIDxzcGFuPnt7IFwiSGV4XCIgfX08L3NwYW4+XHJcbiAgICAgICAgICAgICAgPGlucHV0XHJcbiAgICAgICAgICAgICAgICB0eXBlPVwidGV4dFwiXHJcbiAgICAgICAgICAgICAgICBuYW1lPVwiXCJcclxuICAgICAgICAgICAgICAgIGlkPVwiXCJcclxuICAgICAgICAgICAgICAgIFtuZ01vZGVsXT1cImhleFwiXHJcbiAgICAgICAgICAgICAgICAoa2V5dXAuZW50ZXIpPVwiY2hlY2tIZXgoJGV2ZW50KVwiXHJcbiAgICAgICAgICAgICAgICAoYmx1cik9XCJjaGVja0hleCgkZXZlbnQpXCJcclxuICAgICAgICAgICAgICAvPlxyXG4gICAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgPGRpdiBjbGFzcz1cImNvbG9yLXByZXZpZXdcIj5cclxuICAgICAgICAgICAgPGRpdiBjbGFzcz1cInByZXZpZXdcIiBbc3R5bGUuYmFja2dyb3VuZC1jb2xvcl09XCJjb2xvclNlcnZpY2UuY2xvbmVPZkN1cnJlbnRDb2xvck9iamVjdC50b0h0bWxDb2xvcigpXCI+PC9kaXY+XHJcbiAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICA8L2Rpdj5cclxuICAgICAgICA8ZGl2IGNsYXNzPVwid2ViLWRpYWxvZ1wiICpuZ0lmPVwiY3VycmVudFN0YXRlID09ICd3ZWInXCI+XHJcbiAgICAgICAgICA8ZGl2XHJcbiAgICAgICAgICAgIGNsYXNzPVwiY29sb3ItaXRlbSB7eyBjdXJyZW50U2VsZWN0ZWRJdGVtID09IGl0ZW0ubmFtZSA/ICdzZWxlY3RlZCcgOiAnJyB9fVwiXHJcbiAgICAgICAgICAgICpuZ0Zvcj1cImxldCBpdGVtIG9mIGNvbG9yU2VydmljZS5icm93c2VyQ29sb3JzXCJcclxuICAgICAgICAgICAgKGNsaWNrKT1cImN1cnJlbnRTZWxlY3RlZEl0ZW0gPSBpdGVtLm5hbWVcIlxyXG4gICAgICAgICAgPlxyXG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwibWluaS1jb2xvci1wcmV2aWV3XCIgW3N0eWxlLmJhY2tncm91bmQtY29sb3JdPVwiZ2V0Q29sb3IoaXRlbS5jb2xvcilcIj48L2Rpdj5cclxuICAgICAgICAgICAgPHNwYW4+IHt7IGl0ZW0ubmFtZSB9fTwvc3Bhbj5cclxuICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgIDwvZGl2PlxyXG4gICAgICA8L2Rpdj5cclxuICAgICAgPGRpdiBjbGFzcz1cImZvb3Rlci1uYXZpZ2F0aW9uXCI+XHJcbiAgICAgICAgPGRpdiBjbGFzcz1cImZvb3Rlci1idXR0b24gYWNjZXB0XCIgKGNsaWNrKT1cImNoYW5nZUNvbG9yKClcIj5cclxuICAgICAgICAgIDxzcGFuPnt7IGxvYy5nZXQyKFwiQnV0dG9uc1wiLCBcIk9rXCIpLnJlcGxhY2UoXCImYW1wXCIsIFwiXCIpLnJlcGxhY2UoXCI7XCIsIFwiXCIpIH19PC9zcGFuPlxyXG4gICAgICAgIDwvZGl2PlxyXG4gICAgICAgIDxkaXYgY2xhc3M9XCJmb290ZXItYnV0dG9uIGNhbmNlbFwiIFtzdHlsZS5tYXJnaW4tcmlnaHQucHhdPVwiMTBcIiAoY2xpY2spPVwibW9kZWwuc2hvd01vcmVDb2xvckRpYWxvZyA9IGZhbHNlXCI+XHJcbiAgICAgICAgICA8c3Bhbj57eyBsb2MuZ2V0MihcIlByb3BlcnR5TWFpblwiLCBcIkNhbmNlbFwiKSB9fTwvc3Bhbj5cclxuICAgICAgICA8L2Rpdj5cclxuICAgICAgPC9kaXY+XHJcbiAgICA8L2Rpdj5cclxuICBgLFxyXG4gIHN0eWxlczogW1xyXG4gICAgYFxyXG4gICAgICAuc2VsZWN0ZWQge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6ICNlNWU1ZTU7XHJcbiAgICAgIH1cclxuICAgICAgLndlYi1kaWFsb2cge1xyXG4gICAgICAgIGhlaWdodDogMTkwcHg7XHJcbiAgICAgICAgb3ZlcmZsb3c6IGF1dG87XHJcbiAgICAgICAgd2lkdGg6IGNhbGMoMTAwJSAtIDIwcHgpO1xyXG4gICAgICAgIG1hcmdpbjogNXB4IDEwcHg7XHJcbiAgICAgIH1cclxuICAgICAgLm1pbmktY29sb3ItcHJldmlldyB7XHJcbiAgICAgICAgd2lkdGg6IDY0cHg7XHJcbiAgICAgICAgaGVpZ2h0OiAxNXB4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgICBib3JkZXI6IDFweCBzb2xpZCAjYWJhYmFiO1xyXG4gICAgICAgIGN1cnNvcjogZGVmYXVsdDtcclxuICAgICAgICBtYXJnaW46IDBweCA0cHg7XHJcbiAgICAgIH1cclxuICAgICAgLmNvbG9yLWl0ZW0gc3BhbiB7XHJcbiAgICAgICAgY29sb3I6ICM0NDQ0NDQ7XHJcbiAgICAgICAgZm9udC1mYW1pbHk6IEFyaWFsO1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMTJweDtcclxuICAgICAgICBmb250LXdlaWdodDogbm9ybWFsO1xyXG4gICAgICAgIGN1cnNvcjogZGVmYXVsdDtcclxuICAgICAgfVxyXG4gICAgICAuY29sb3ItaXRlbSB7XHJcbiAgICAgICAgaGVpZ2h0OiAyNHB4O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgd2lkdGg6IGNhbGMoMTAwJSAtIDJweCk7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgICBib3JkZXItcmFkaXVzOiAzcHg7XHJcbiAgICAgICAgbWFyZ2luOiAxcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmNvbG9yLWl0ZW06aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6ICNkYWRhZGE7XHJcbiAgICAgIH1cclxuICAgICAgLmZpZWxkIHtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIGZsZXg6IDE7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAuZmllbGQgc3BhbiB7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgY29sb3I6ICM0NDQ0NDQ7XHJcbiAgICAgICAgZm9udC1mYW1pbHk6IEFyaWFsO1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMTJweDtcclxuICAgICAgICBmb250LXdlaWdodDogbm9ybWFsO1xyXG4gICAgICAgIGN1cnNvcjogZGVmYXVsdDtcclxuICAgICAgfVxyXG4gICAgICAuZmllbGQgaW5wdXQge1xyXG4gICAgICAgIHdpZHRoOiA4MHB4O1xyXG4gICAgICAgIGhlaWdodDogMjFweDtcclxuICAgICAgICBmb250LXNpemU6IDEycHg7XHJcbiAgICAgICAgbWFyZ2luOiAwcHg7XHJcbiAgICAgICAgcGFkZGluZzogMHB4IDBweCAwcHggNHB4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgICBmb250LWZhbWlseTogQXJpYWw7XHJcbiAgICAgICAgb3V0bGluZTogbm9uZTtcclxuICAgICAgICBtYXgtd2lkdGg6IGluaGVyaXQ7XHJcbiAgICAgICAgYm9yZGVyOiAxcHggc29saWQgI2FiYWJhYjtcclxuICAgICAgICBjb2xvcjogIzQ0NDQ0NDtcclxuICAgICAgfVxyXG4gICAgICAuY3VzdG9tLWRpYWxvZyB7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBwYWRkaW5nLWxlZnQ6IDE5cHg7XHJcbiAgICAgICAgcGFkZGluZy10b3A6IDVweDtcclxuICAgICAgfVxyXG4gICAgICAuaW5wdXQtZmllbGRzIHtcclxuICAgICAgICB3aWR0aDogMTQwcHg7XHJcbiAgICAgICAgaGVpZ2h0OiAxODBweDtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XHJcbiAgICAgIH1cclxuICAgICAgLnByZXZpZXcge1xyXG4gICAgICAgIGhlaWdodDogMTI4cHg7XHJcbiAgICAgICAgd2lkdGg6IDEyOHB4O1xyXG4gICAgICAgIGJvcmRlcjogMXB4IHNvbGlkICNjNmM2YzY7XHJcbiAgICAgIH1cclxuICAgICAgLmNvbG9yLXByZXZpZXcge1xyXG4gICAgICAgIGhlaWdodDogMTgwcHg7XHJcbiAgICAgICAgd2lkdGg6IDE4MHB4O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAucGkge1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMC41cmVtO1xyXG4gICAgICB9XHJcbiAgICAgIC5jb2xvci1vcHRpb25zLWRpYWxvZyB7XHJcbiAgICAgICAgbWluLWhlaWdodDogMzE1cHg7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgICAtbW96LXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICAgIHdpZHRoOiAzNDVweDtcclxuICAgICAgICBsZWZ0OiBjYWxjKDUwJSAtIDE3Mi41cHgpO1xyXG4gICAgICAgIHRvcDogY2FsYyg1MCUgLSAxNTcuNXB4KTtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgYm9yZGVyOiAxcHggc29saWQgIzE5NDc4YTtcclxuICAgICAgICBiYWNrZ3JvdW5kOiAjZmZmZmZmO1xyXG4gICAgICAgIGNvbG9yOiAjNDQ0NDQ0O1xyXG4gICAgICAgIC1tb3otYm94LXNoYWRvdzogMHB4IDBweCA3cHggcmdiYSgwLCAwLCAwLCAwLjYpO1xyXG4gICAgICAgIC13ZWJraXQtYm94LXNoYWRvdzogMHB4IDBweCA3cHggcmdiKDAgMCAwIC8gNjAlKTtcclxuICAgICAgICBib3gtc2hhZG93OiAwIDAgN3B4IHJnYigwIDAgMCAvIDMwJSk7XHJcbiAgICAgICAgY3Vyc29yOiBkZWZhdWx0O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcclxuICAgICAgICB6LWluZGV4OiA5OTk5OTtcclxuICAgICAgfVxyXG4gICAgICAuaGVhZGVyLW5hdmlnYXRpb24ge1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgaGVpZ2h0OiAzMHB4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAgcGFkZGluZy1sZWZ0OiAxNXB4O1xyXG4gICAgICAgIHBhZGRpbmctcmlnaHQ6IDNweDtcclxuICAgICAgfVxyXG4gICAgICAuaGVhZGVyLW5hdmlnYXRpb24gc3BhbiB7XHJcbiAgICAgICAgZm9udC1mYW1pbHk6IEFyaWFsO1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMTNweDtcclxuICAgICAgICBmb250LXdlaWdodDogYm9sZDtcclxuICAgICAgICBjb2xvcjogIzE5NDc4YTtcclxuICAgICAgICBjdXJzb3I6IGRlZmF1bHQ7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgIH1cclxuICAgICAgLmNsb3NlLWJ1dHRvbiB7XHJcbiAgICAgICAgd2lkdGg6IDI4cHg7XHJcbiAgICAgICAgaGVpZ2h0OiAyNHB4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XHJcbiAgICAgIH1cclxuICAgICAgLmNsb3NlLWJ1dHRvbjpob3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogbGlnaHRncmF5O1xyXG4gICAgICB9XHJcbiAgICAgIC5jb250ZW50LW5hdmlnYXRpb24ge1xyXG4gICAgICAgIHdpZHRoOiBjYWxjKDEwMCUgLSAyMHB4KTtcclxuICAgICAgICBoZWlnaHQ6IDQwcHg7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBib3JkZXItYm90dG9tOiAxcHggc29saWQgbGlnaHRncmF5O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAgbWFyZ2luOiAwcHggMTJweDtcclxuICAgICAgfVxyXG4gICAgICAuY29udGVudC1idXR0b24ge1xyXG4gICAgICAgIG1pbi13aWR0aDogMzVweDtcclxuICAgICAgICBoZWlnaHQ6IDI2cHg7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogM3B4O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcclxuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcclxuICAgICAgICBtYXJnaW4tcmlnaHQ6IDJweDtcclxuICAgICAgfVxyXG4gICAgICAuY29udGVudC1idXR0b246aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6ICNkYWRhZGE7XHJcbiAgICAgIH1cclxuICAgICAgLmNvbnRlbnQtYnV0dG9uIHNwYW4ge1xyXG4gICAgICAgIGNvbG9yOiAjNDQ0NDQ0O1xyXG4gICAgICAgIGZvbnQtZmFtaWx5OiBBcmlhbDtcclxuICAgICAgICBmb250LXNpemU6IDEycHg7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6IG5vcm1hbDtcclxuICAgICAgICBjdXJzb3I6IGRlZmF1bHQ7XHJcbiAgICAgICAgdGV4dC1hbGlnbjogY2VudGVyO1xyXG4gICAgICAgIG1hcmdpbjogMHB4IDEwcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmhvcml6b250YWwtbGluZSB7XHJcbiAgICAgICAgaGVpZ2h0OiAzcHg7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogM3B4O1xyXG4gICAgICAgIG1hcmdpbjogMHB4IDEwcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmN1cnJlbnQge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6ICNlNWU1ZTU7XHJcbiAgICAgIH1cclxuICAgICAgLmN1cnJlbnQgLmhvcml6b250YWwtbGluZSB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDI1LCA3MSwgMTM4KTtcclxuICAgICAgfVxyXG4gICAgICAuZm9vdGVyLWJ1dHRvbiB7XHJcbiAgICAgICAgd2lkdGg6IDgwcHg7XHJcbiAgICAgICAgaGVpZ2h0OiAyNHB4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XHJcbiAgICAgICAgbWFyZ2luOiAwIDVweDtcclxuICAgICAgICAtd2Via2l0LXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICAgIGZvbnQtZmFtaWx5OiBBcmlhbDtcclxuICAgICAgICBmb250LXNpemU6IDEycHg7XHJcbiAgICAgICAgbWFyZ2luLWJvdHRvbTogMTBweDtcclxuICAgICAgfVxyXG4gICAgICAuYWNjZXB0IHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjUsIDcxLCAxMzgpO1xyXG4gICAgICAgIGNvbG9yOiB3aGl0ZTtcclxuICAgICAgfVxyXG4gICAgICAuYWNjZXB0OmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoNjEsIDk4LCAxNTIpO1xyXG4gICAgICB9XHJcbiAgICAgIC5jYW5jZWwge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyMjEsIDIyMSwgMjIxKTtcclxuICAgICAgICBjb2xvcjogcmdiKDY4LCA2OCwgNjgpO1xyXG4gICAgICB9XHJcbiAgICAgIC5jYW5jZWw6aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyMTMsIDIxMywgMjEzKTtcclxuICAgICAgfVxyXG4gICAgICAuZm9vdGVyLW5hdmlnYXRpb24ge1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAganVzdGlmeS1jb250ZW50OiBlbmQ7XHJcbiAgICAgIH1cclxuICAgICAgLmRpYWxvZy1jb250ZW50IHtcclxuICAgICAgICBoZWlnaHQ6IDEwMCU7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgZmxleDogMTtcclxuICAgICAgfVxyXG4gICAgYCxcclxuICBdLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgU3RpQ29sb3JPcHRpb25zRGlhbG9nQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcclxuICBwdWJsaWMgY3VycmVudFN0YXRlID0gXCJjdXN0b21cIjtcclxuICBwdWJsaWMgY3VycmVudFNlbGVjdGVkSXRlbSA9IFwiVHJhbnNwYXJlbnRcIjtcclxuICBjb25zdHJ1Y3RvcihcclxuICAgIHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlLFxyXG4gICAgcHVibGljIGNvbG9yU2VydmljZTogU3RpQ29sb3JEaWFsb2dTZXJ2aWNlLFxyXG4gICAgcHVibGljIGxvYzogU3RpTG9jYWxpemF0aW9uU2VydmljZSxcclxuICAgIHB1YmxpYyByaWNoVGV4dDogU3RpUmljaFRleHRTZXJ2aWNlXHJcbiAgKSB7fVxyXG5cclxuICBjaGVja1JhbmdlKGV2ZW50LCBvYmplY3QsIHByb3BlcnR5KSB7XHJcbiAgICBpZiAocGFyc2VJbnQoZXZlbnQudGFyZ2V0LnZhbHVlKSkge1xyXG4gICAgICBpZiAocGFyc2VJbnQoZXZlbnQudGFyZ2V0LnZhbHVlKSA+IDI1NSkge1xyXG4gICAgICAgIG9iamVjdFtwcm9wZXJ0eV0gPSAyNTU7XHJcbiAgICAgIH0gZWxzZSBpZiAocGFyc2VJbnQoZXZlbnQudGFyZ2V0LnZhbHVlKSA8IDApIHtcclxuICAgICAgICBvYmplY3RbcHJvcGVydHldID0gMDtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICBvYmplY3RbcHJvcGVydHldID0gcGFyc2VJbnQoZXZlbnQudGFyZ2V0LnZhbHVlKTtcclxuICAgICAgfVxyXG4gICAgfSBlbHNlIHtcclxuICAgICAgb2JqZWN0W3Byb3BlcnR5XSA9IDA7XHJcbiAgICB9XHJcbiAgICBldmVudC50YXJnZXQudmFsdWUgPSBvYmplY3RbcHJvcGVydHldO1xyXG4gIH1cclxuICBjaGVja0hleChldmVudCkge1xyXG4gICAgaWYgKGV2ZW50LnRhcmdldC52YWx1ZSkge1xyXG4gICAgICBpZiAoZXZlbnQudGFyZ2V0LnZhbHVlLmxlbmd0aCA+IDcpIHtcclxuICAgICAgICBsZXQgdmFsdWUgPSBldmVudC50YXJnZXQudmFsdWUuc2xpY2UoMCwgNik7XHJcbiAgICAgICAgdGhpcy5oZXggPSB2YWx1ZTtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLmhleCA9IGV2ZW50LnRhcmdldC52YWx1ZTtcclxuICAgICAgfVxyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy5oZXggPSBcIiMwMDAwMDBcIjtcclxuICAgIH1cclxuICAgIGV2ZW50LnRhcmdldC52YWx1ZSA9IHRoaXMuaGV4O1xyXG4gIH1cclxuICBjaGFuZ2VTdGF0ZShzdGF0ZSkge1xyXG4gICAgdGhpcy5jdXJyZW50U3RhdGUgPSBzdGF0ZTtcclxuICB9XHJcbiAgZ2V0IGhleCgpIHtcclxuICAgIHJldHVybiB0aGlzLmNvbG9yU2VydmljZS5jbG9uZU9mQ3VycmVudENvbG9yT2JqZWN0LnRvSGV4Q29sb3IoKTtcclxuICB9XHJcbiAgc2V0IGhleCh2YWx1ZSkge1xyXG4gICAgdGhpcy5jb2xvclNlcnZpY2UuY2xvbmVPZkN1cnJlbnRDb2xvck9iamVjdC5oZXhDb2xvciA9IHZhbHVlO1xyXG4gIH1cclxuICBjaGFuZ2VDb2xvcigpIHtcclxuICAgIGlmICh0aGlzLmN1cnJlbnRTdGF0ZSA9PSBcImN1c3RvbVwiKSB7XHJcbiAgICAgIHRoaXMuY29sb3JTZXJ2aWNlLmN1cnJlbnRDb2xvck9iamVjdC5oZXhDb2xvciA9IHRoaXMuY29sb3JTZXJ2aWNlLmNsb25lT2ZDdXJyZW50Q29sb3JPYmplY3QuaGV4Q29sb3I7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICBsZXQgY29sb3JPYmogPSB0aGlzLmNvbG9yU2VydmljZS5icm93c2VyQ29sb3JzLmZpbmQoKGNvbG9yKSA9PiBjb2xvci5uYW1lID09IHRoaXMuY3VycmVudFNlbGVjdGVkSXRlbSk7XHJcbiAgICAgIGlmIChjb2xvck9iai5uYW1lICE9IFwiVHJhbnNwYXJlbnRcIikge1xyXG4gICAgICAgIHRoaXMuY29sb3JTZXJ2aWNlLmN1cnJlbnRDb2xvck9iamVjdC5oZXhDb2xvciA9IHRoaXMuY29sb3JTZXJ2aWNlLnJnYlRvSGV4KGNvbG9yT2JqLmNvbG9yKTtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLmNvbG9yU2VydmljZS5jdXJyZW50Q29sb3JPYmplY3QuYSA9IDA7XHJcbiAgICAgIH1cclxuICAgIH1cclxuICAgIGlmICh0aGlzLmNvbG9yU2VydmljZS5pc1JpY2hUZXh0KSB7XHJcbiAgICAgIHRoaXMucmljaFRleHQuaW5zZXJ0Rm9yZUNvbG9yKCk7XHJcbiAgICB9XHJcbiAgICB0aGlzLm1vZGVsLnNob3dNb3JlQ29sb3JEaWFsb2cgPSBmYWxzZTtcclxuICAgIHRoaXMubW9kZWwuc2hvd0NvbG9yRGlhbG9nID0gZmFsc2U7XHJcbiAgfVxyXG4gIGdldENvbG9yKGNvbG9yKSB7XHJcbiAgICByZXR1cm4gYHJnYigke2NvbG9yfSlgO1xyXG4gIH1cclxuICBuZ09uSW5pdCgpIHt9XHJcbn1cclxuIl19