import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/sti-color-dialog.service";
import * as i2 from "../../services/model.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "../../services/sti-rich-text.service";
import * as i5 from "@angular/common";
export class StiColorDialogComponent {
    constructor(colorService, model, loc, richText) {
        this.colorService = colorService;
        this.model = model;
        this.loc = loc;
        this.richText = richText;
    }
    get colorRowsCount() {
        return new Array(5).fill(1);
    }
    get colorColumnsCount() {
        return new Array(10).fill(2);
    }
    getColor(index, type) {
        return type == "theme"
            ? `rgb(${this.colorService?.themeColors[index].color})`
            : `rgb(${this.colorService?.standardColors[index].color})`;
    }
    setTransparent() {
        this.colorService.currentColorObject.a = 0;
        if (this.colorService.isRichText) {
            this.richText.insertForeColor();
        }
        this.model.showColorDialog = false;
    }
    setColor(color) {
        this.colorService.currentColorObject.hexColor = this.colorService.rgbToHex(color.replace("rgb(", "").replace(")", ""));
        if (this.colorService.isRichText) {
            this.richText.insertForeColor();
        }
        this.model.showColorDialog = false;
    }
    ngOnInit() { }
}
StiColorDialogComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColorDialogComponent, deps: [{ token: i1.StiColorDialogService }, { token: i2.StiModelService }, { token: i3.StiLocalizationService }, { token: i4.StiRichTextService }], target: i0.ɵɵFactoryTarget.Component });
StiColorDialogComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiColorDialogComponent, selector: "sti-color-dialog", ngImport: i0, template: `<div class="color-dialog" [style.left.px]="colorService.dialogX" [style.top.px]="colorService.dialogY">
    <div class="header">
      <span>{{ loc.get2("Gui", "colorpicker_themecolorslabel") }}</span>
    </div>
    <div class="color-preview">
      <div class="preview-row">
        <div
          class="color-button"
          *ngFor="let column of colorColumnsCount; let i = index"
          [style.background-color]="getColor(i, 'theme')"
          [style.margin-bottom.px]="6"
          (click)="setColor(getColor(i, 'theme'))"
        ></div>
      </div>
      <div class="preview-row" *ngFor="let row of colorRowsCount; let ind = index">
        <div
          class="color-button"
          *ngFor="let column of colorColumnsCount; let idx = index"
          [style.background-color]="getColor((ind + 1) * colorColumnsCount.length + idx, 'theme')"
          (click)="setColor(getColor((ind + 1) * colorColumnsCount.length + idx, 'theme'))"
        ></div>
      </div>
    </div>
    <div class="header">
      <span>{{ loc.get2("Gui", "colorpicker_standardcolorslabel") }}</span>
    </div>
    <div class="color-preview" [style.border-bottom]="'1px dotted rgb(226,228,231)'">
      <div class="preview-row">
        <div
          class="color-button"
          *ngFor="let column of colorColumnsCount; let id = index"
          [style.background-color]="getColor(id, 'standard')"
          (click)="setColor(getColor(id, 'standard'))"
        ></div>
      </div>
    </div>
    <div class="transparent panel" [style.border-bottom]="'1px dotted rgb(226,228,231)'" (click)="setTransparent()">
      <img [src]="model.getImage('images.Other.TransparentColorIcon.png')" />
      <span>{{ loc.get2("Gui", "colorpicker_nofill").replace("&amp", "").replace(";", "") }}</span>
    </div>
    <div class="other-colors panel" (click)="model.showMoreColorDialog = true; model.showColorDialog = false">
      <img [src]="model.getImage('images.Other.MoreColorsIcon.png')" />
      <span>{{ loc.get2("Gui", "colorpicker_morecolors").replace("&amp", "").replace(";", "") }}</span>
    </div>
  </div>`, isInline: true, styles: [".color-dialog{position:absolute;left:calc(50% - 92.5px);top:calc(50% - 112.5px);padding:1px;width:185px;min-height:225px;border-radius:3px;border:1px solid #c6c6c6;background-color:var(--back-color);color:var(--text-color);box-shadow:0 0 7px #0000004d;cursor:default;display:flex;flex-direction:column;z-index:999999}.header{width:100%;height:26px;background:#eeeeee;font-family:Arial;font-size:12px;color:#8f8f8f;cursor:default;display:flex;align-items:center;padding-left:7px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none}.color-preview{width:100%;display:flex;flex-direction:column}.preview-row{width:100%;display:flex}.color-button{height:14px;width:14px;border:1px solid rgb(226,228,231);cursor:default;margin:2px}.color-button:hover{border-color:#f29436}.panel{width:100%;display:flex;cursor:default;color:#444;font-family:Arial;font-size:12px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;height:25px;align-items:center;border-radius:3px}.panel:hover{background-color:#dadada}.panel img{width:16px;height:16px;margin:0 4px}\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColorDialogComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-color-dialog", template: `<div class="color-dialog" [style.left.px]="colorService.dialogX" [style.top.px]="colorService.dialogY">
    <div class="header">
      <span>{{ loc.get2("Gui", "colorpicker_themecolorslabel") }}</span>
    </div>
    <div class="color-preview">
      <div class="preview-row">
        <div
          class="color-button"
          *ngFor="let column of colorColumnsCount; let i = index"
          [style.background-color]="getColor(i, 'theme')"
          [style.margin-bottom.px]="6"
          (click)="setColor(getColor(i, 'theme'))"
        ></div>
      </div>
      <div class="preview-row" *ngFor="let row of colorRowsCount; let ind = index">
        <div
          class="color-button"
          *ngFor="let column of colorColumnsCount; let idx = index"
          [style.background-color]="getColor((ind + 1) * colorColumnsCount.length + idx, 'theme')"
          (click)="setColor(getColor((ind + 1) * colorColumnsCount.length + idx, 'theme'))"
        ></div>
      </div>
    </div>
    <div class="header">
      <span>{{ loc.get2("Gui", "colorpicker_standardcolorslabel") }}</span>
    </div>
    <div class="color-preview" [style.border-bottom]="'1px dotted rgb(226,228,231)'">
      <div class="preview-row">
        <div
          class="color-button"
          *ngFor="let column of colorColumnsCount; let id = index"
          [style.background-color]="getColor(id, 'standard')"
          (click)="setColor(getColor(id, 'standard'))"
        ></div>
      </div>
    </div>
    <div class="transparent panel" [style.border-bottom]="'1px dotted rgb(226,228,231)'" (click)="setTransparent()">
      <img [src]="model.getImage('images.Other.TransparentColorIcon.png')" />
      <span>{{ loc.get2("Gui", "colorpicker_nofill").replace("&amp", "").replace(";", "") }}</span>
    </div>
    <div class="other-colors panel" (click)="model.showMoreColorDialog = true; model.showColorDialog = false">
      <img [src]="model.getImage('images.Other.MoreColorsIcon.png')" />
      <span>{{ loc.get2("Gui", "colorpicker_morecolors").replace("&amp", "").replace(";", "") }}</span>
    </div>
  </div>`, styles: [".color-dialog{position:absolute;left:calc(50% - 92.5px);top:calc(50% - 112.5px);padding:1px;width:185px;min-height:225px;border-radius:3px;border:1px solid #c6c6c6;background-color:var(--back-color);color:var(--text-color);box-shadow:0 0 7px #0000004d;cursor:default;display:flex;flex-direction:column;z-index:999999}.header{width:100%;height:26px;background:#eeeeee;font-family:Arial;font-size:12px;color:#8f8f8f;cursor:default;display:flex;align-items:center;padding-left:7px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none}.color-preview{width:100%;display:flex;flex-direction:column}.preview-row{width:100%;display:flex}.color-button{height:14px;width:14px;border:1px solid rgb(226,228,231);cursor:default;margin:2px}.color-button:hover{border-color:#f29436}.panel{width:100%;display:flex;cursor:default;color:#444;font-family:Arial;font-size:12px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;height:25px;align-items:center;border-radius:3px}.panel:hover{background-color:#dadada}.panel img{width:16px;height:16px;margin:0 4px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiColorDialogService }, { type: i2.StiModelService }, { type: i3.StiLocalizationService }, { type: i4.StiRichTextService }]; } });
//# sourceMappingURL=data:application/json;base64,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