import { Component, Input } from "@angular/core";
import { StiButtonType } from "../../system/enums";
import { StiTextBoxElement } from "../../elements/StiTextBoxElement";
import { StiNumberBoxElement } from "../../elements/StiNumberBoxElement";
import { StiComboBoxElement } from "../../elements/StiComboBoxElement";
import { StiListBoxElement } from "../../elements/StiListBoxElement";
import { StiSingleSelectionElement } from "../../elements/StiSingleSelectionElement";
import { StiMultipleSelectionElement } from "../../elements/StiMultipleSelectionElement";
import { StiCheckBoxElement } from "../../elements/StiCheckBoxElement";
import { StiDateTimeBoxElement } from "../../elements/StiDateTimeBoxElement";
import { StiBarcodeElement } from "../../elements/StiBarcodeElement";
import { StiLabelElement } from "../../elements/StiLabelElement";
import { StiTableElement } from "../../elements/StiTableElement";
import { StiTextBoxCellItem } from "../../elements/table/cells/StiTextBoxCellItem";
import { StiRadioButtonCellItem } from "../../elements/table/cells/StiRadioButtonCellItem";
import { StiNumberBoxCellItem } from "../../elements/table/cells/StiNumberBoxCellItem";
import { StiComboBoxCellItem } from "../../elements/table/cells/StiComboBoxCellItem";
import { StiCheckBoxCellItem } from "../../elements/table/cells/StiCheckBoxCellItem";
import { StiAddressElement } from "../../elements/StiAddressElement";
import { catchError } from "rxjs/operators";
import { throwError } from "rxjs";
import { StiLocalizationService } from "../../services/sti-localization.service";
import { StiRadioButtonColumnItem } from "../../elements/table/columns/StiRadioButtonColumnItem";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common/http";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../sti-tooltip/sti-tooltip.directive";
export class StiButtonComponent {
    constructor(model, httpClient) {
        this.model = model;
        this.httpClient = httpClient;
        this.isClone = false;
    }
    ngOnDestroy() {
        this.retryEvent?.unsubscribe();
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    clickEvent() {
        if (this.element.buttonType == StiButtonType.ClearForm && this.model.isPreviewMode) {
            this.model.form.pages.forEach((page) => {
                page.allElements.forEach((element) => {
                    element.setDefaultValues();
                });
            });
        }
        else if (this.element.buttonType == StiButtonType.SendForm && this.model.isPreviewMode) {
            this.model.errorWindowMessage = this.element.submissionMessage;
            if (this.element.formSendURL) {
                this.model.showProgress = true;
                let xml = this.createXml();
                let url;
                if (this.element.formSendURL.trim().toLocaleLowerCase() == "stimulsoft cloud" ||
                    this.element.formSendURL.trim().toLocaleLowerCase() == "cloud.stimulsoft.com") {
                    url = "https://submit.stimulsoft.com/submit";
                }
                else {
                    url = this.element.formSendURL;
                }
                if (this.formHasEmptyRequiredFields()) {
                    let elem = this.formHasEmptyRequiredFields();
                    this.model.errorWindowMessage = StiLocalizationService.get("Errors", "FieldRequire").replace("{0}", elem["label"] ? elem["label"]["value"] : elem["name"]);
                    this.model.showErrorWindow = true;
                    this.model.showProgress = false;
                    this.scrollToRequired(elem);
                    return;
                }
                this.httpClient
                    .post(url, xml)
                    .pipe(catchError((data) => {
                    this.model.showProgress = false;
                    this.model.showError(StiLocalizationService.get("DesignerFx", "ConnectionError"), true, this.element);
                    this.model.interfaceEvent.next({ name: "FormSubmittedError", data: data });
                    return throwError("Something bad happened; please try again later.");
                }))
                    .subscribe((data) => {
                    this.model.showProgress = false;
                    this.model.interfaceEvent.next({ name: "FormSubmitted", data: data });
                    if (this.element.submissionMessage != null && this.element.submissionMessage.length > 0) {
                        this.model.showButtonMessageWindow = true;
                    }
                });
            }
            else {
                this.model.interfaceEvent.next({ name: "FormSubmitted" });
                if (this.element.submissionMessage != null &&
                    this.element.submissionMessage.length > 0 &&
                    this.element.formSendURL) {
                    this.model.showButtonMessageWindow = true;
                }
            }
        }
        else if (this.element.buttonType == StiButtonType.AttachFiles && this.model.isPreviewMode) {
            this.model.loadAttachedFile();
        }
    }
    get selected() {
        return this.model.selectedComponent?.element == this.element;
    }
    scrollToRequired(elem) {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let domElement = document.getElementById(elem.guid);
        let elementRect = this.model.getPositionRelativeToForm(domElement);
        const componentHeader = 38;
        let currentScrollPosition = workspace.scrollTop;
        if (elementRect.top < 0) {
            workspace.scrollTop = currentScrollPosition - (Math.abs(elementRect?.top) + componentHeader);
        }
        else {
            workspace.scrollTop = currentScrollPosition + (elementRect?.top - componentHeader);
        }
    }
    createXml() {
        let string = `<?xml version="1.0" encoding="UTF-8"?>
    <xfdf xmlns="http://ns.adobe.com/xfdf/" xml:space="preserve">
    <fields>` +
            this.addXmlField({ name: "StiFormGuid", value: this.model.form.guid }) +
            (this.model.form.versionKey != null && this.model.form.versionKey.length > 0
                ? this.addXmlField({ name: "StiVersionKey", value: this.model.form.versionKey })
                : "") +
            //this.addXmlField({ name: "StiUserId", value: this.model.form.userId }) +
            this.createFields() +
            this.addAttachedFiles() +
            this.addAdditionsFormField() +
            `</fields>
    </xfdf>`;
        return string;
    }
    createFields() {
        let fields = "";
        this.model.form.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element instanceof StiTableElement) {
                    this.model.removeUnusedCells(element);
                    fields += this.getXmlTableField(element);
                }
                else if (element instanceof StiAddressElement) {
                    fields += this.getXmlAddressField(element);
                }
                else {
                    let field = this.addXmlField(this.getValue(element));
                    if (field) {
                        fields += field;
                    }
                }
            });
        });
        return fields;
    }
    formHasEmptyRequiredFields() {
        this.model.hasEmptyReuiredFields = false;
        let emptyRequiredElement = null;
        for (let page of this.model.form.pages) {
            for (let elem of page.allElements) {
                if ((!elem["value"] || elem["value"].length == 0) && elem["required"]) {
                    emptyRequiredElement = elem;
                    break;
                }
            }
            if (emptyRequiredElement) {
                break;
            }
        }
        if (emptyRequiredElement) {
            this.model.hasEmptyReuiredFields = true;
            return emptyRequiredElement;
        }
        return null;
    }
    addAdditionsFormField() {
        let string = "";
        this.model.form.additionalFormFields.forEach((field) => {
            string += this.addXmlField({ name: field.key, value: field.value });
        });
        return string;
    }
    addXmlField(elementInfo) {
        if (elementInfo && (elementInfo.values != null || elementInfo.value != null)) {
            let val = "";
            (elementInfo.values ?? [elementInfo.value]).forEach((value) => {
                val += `<value>${this.encodeHTML(value)}</value>`;
            });
            return `<field name="${elementInfo.name}">${val}</field>`;
        }
        return "";
    }
    encodeHTML(str) {
        return str != null && typeof str == "string"
            ? str
                .replace(/&/g, "&amp;")
                .replace(/</g, "&lt;")
                .replace(/>/g, "&gt;")
                .replace(/"/g, "&quot;")
                .replace(/'/g, "&apos;")
            : str;
    }
    getXmlTableField(element) {
        let field = `<field name="${element.name}">
    ` +
            this.createTableFields(element) +
            `</field>
    `;
        return field;
    }
    addAttachedFiles() {
        let string = "";
        this.model.attachedFiles.forEach((file, index) => {
            string += this.addXmlField({ name: "AttachedFile" + index, value: file });
        });
        return string;
    }
    getXmlAddressField(element) {
        let field = `<field name="${element.name}">
    ` +
            this.createAddressField(element) +
            `</field>
    `;
        return field;
    }
    createAddressField(element) {
        let fields = "";
        if (element.useCountry) {
            fields += this.addXmlField({
                name: "Country",
                value: element.country,
            });
        }
        if (element.useCity) {
            fields += this.addXmlField({
                name: "City",
                value: element.city,
            });
        }
        if (element.useState) {
            fields += this.addXmlField({
                name: "State",
                value: element.state,
            });
        }
        if (element.useStreetAddress) {
            fields += this.addXmlField({
                name: "StreetAddress",
                value: element.streetAddress,
            });
        }
        if (element.useStreetAddress2) {
            fields += this.addXmlField({
                name: "StreetAddress2",
                value: element.streetAddress2,
            });
        }
        if (element.useZipCode) {
            fields += this.addXmlField({
                name: "ZipCode",
                value: element.zipCode,
            });
        }
        return fields;
    }
    createTableFields(element) {
        let fields = "";
        element.columns.forEach((column, index) => {
            let columnIndex = index;
            column["cells"].forEach((cell, index) => {
                fields += this.addXmlField(this.getTableCellValue(column, columnIndex, cell, index));
            });
        });
        element.totalsFields.forEach((field, index) => {
            fields += this.addXmlField(this.getTableFieldValue(field, index));
        });
        element.rowLabels.forEach((row, index) => {
            element.columns.forEach((column, idx) => {
                if (column instanceof StiRadioButtonColumnItem && column.cells[index].isChecked) {
                    fields += this.addXmlField(this.getRowValue(index, idx));
                }
            });
        });
        return fields;
    }
    getTableFieldValue(field, fieldIndex) {
        return { name: "TotalsField" + fieldIndex, value: field.value };
    }
    getRowValue(rowIndex, columnIndex) {
        return { name: `Row-${rowIndex}-SingleSelection`, value: `Column-${columnIndex}` };
    }
    getTableCellValue(column, columnIndex, cell, cellIndex) {
        let name = "Cell" +
            "-" +
            columnIndex +
            "-" +
            cellIndex +
            "-" +
            (cell instanceof StiRadioButtonCellItem ? "SingleSelection" : column["type"].replace("Column", ""));
        let value = cell;
        if (cell instanceof StiTextBoxCellItem) {
            value = cell.text;
        }
        else if (cell instanceof StiRadioButtonCellItem) {
            return;
            value = cell.isChecked;
        }
        else if (cell instanceof StiNumberBoxCellItem) {
            value = cell.value;
        }
        else if (cell instanceof StiComboBoxCellItem) {
            value = column.comboBoxOptions[cell.selectedIndex];
        }
        else if (cell instanceof StiCheckBoxCellItem) {
            value = cell.isChecked;
        }
        return { name: name, value: value };
    }
    getValue(element) {
        let name = element.name ?? element.guid;
        let value, values;
        if (element instanceof StiTextBoxElement) {
            value = element.text;
        }
        else if (element instanceof StiNumberBoxElement) {
            value = element.value;
        }
        else if (element instanceof StiComboBoxElement) {
            value = element.selectedOption;
        }
        else if (element instanceof StiListBoxElement) {
            values = element.selectedOptions;
        }
        else if (element instanceof StiSingleSelectionElement) {
            value = element.selectedOption;
        }
        else if (element instanceof StiMultipleSelectionElement) {
            values = element.selectedOptions;
        }
        else if (element instanceof StiCheckBoxElement) {
            value = element.isChecked;
        } /* else if (element instanceof StiSignatureElement) {
          value = element.contentImage ;
        } */
        else if (element instanceof StiDateTimeBoxElement) {
            value = element.dateValue;
        }
        else if (element instanceof StiBarcodeElement) {
            value = element.img;
        }
        else if (element instanceof StiLabelElement) {
            value = element.displayValue != undefined ? element.displayValue : element.text.value;
        }
        return { name: name, value: value, values: values };
    }
    ngOnInit() {
        if ((this.model.isCloudMode || this.model.isWebView) && this.element.formSendURL?.length == 0) {
            this.element.formSendURL = "cloud.stimulsoft.com";
        }
        this.retryEvent = this.model.retryButtonRequest.subscribe((element) => {
            if (element == this.element && !this.isClone) {
                this.clickEvent();
            }
        });
    }
}
StiButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiButtonComponent, deps: [{ token: i1.StiModelService }, { token: i2.HttpClient }], target: i0.ɵɵFactoryTarget.Component });
StiButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiButtonComponent, selector: "sti-button-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" [style.align-items]="'center'" class="StiButton">
    <div
      class="button {{ element?.readOnly ? 'disabled' : '' }}"
      [style.background-color]="element?.text.backgroundColor.toHtmlColor()"
      [style.border]="'1px solid' + element?.text.backgroundColor.toHtmlColor()"
      [stiTooltip]="element?.tooltip"
      (click)="clickEvent()"
      tooltipPosition="bottom"
      showDelay="500"
    >
      <sti-editable-content-component
        [hideEmpty]="false"
        [editableContent]="element.text"
        [fromButton]="true"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
  </sti-component>`, isInline: true, styles: [".disabled{pointer-events:none}.button{width:-moz-fit-content;width:fit-content;padding:10px;background-color:#d3d3d3;height:100%;width:100%;display:flex;align-items:center;justify-content:center}.button:hover{opacity:.5}\n"], dependencies: [{ kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-button-component", template: ` <sti-component [element]="element" [isClone]="isClone" [style.align-items]="'center'" class="StiButton">
    <div
      class="button {{ element?.readOnly ? 'disabled' : '' }}"
      [style.background-color]="element?.text.backgroundColor.toHtmlColor()"
      [style.border]="'1px solid' + element?.text.backgroundColor.toHtmlColor()"
      [stiTooltip]="element?.tooltip"
      (click)="clickEvent()"
      tooltipPosition="bottom"
      showDelay="500"
    >
      <sti-editable-content-component
        [hideEmpty]="false"
        [editableContent]="element.text"
        [fromButton]="true"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
  </sti-component>`, styles: [".disabled{pointer-events:none}.button{width:-moz-fit-content;width:fit-content;padding:10px;background-color:#d3d3d3;height:100%;width:100%;display:flex;align-items:center;justify-content:center}.button:hover{opacity:.5}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.HttpClient }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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