import { Component, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "@angular/common";
export class StiButtonMessageWindowComponent {
    constructor(model, loc) {
        this.model = model;
        this.loc = loc;
        this.windowWidth = 250;
        this.windowHeight = 130;
    }
    get left() {
        if (this.messageWindow) {
            return `calc(50% - ${this.windowWidth / 2}px)`;
        }
        else {
            return `calc(50% - 125px)`;
        }
    }
    get top() {
        if (this.messageWindow) {
            return `calc(50% - ${this.windowHeight / 2}px)`;
        }
        else {
            return `calc(50% - 65px)`;
        }
    }
    retry() {
        this.model.showButtonMessageWindow = false;
        this.model.showErrorWindow = false;
        this.model.sendedFromButton = false;
        this.model.retryButtonRequest.next(this.model.currentUsedButtonElement);
    }
    ngAfterViewInit() {
        if (this.messageWindow) {
            this.windowWidth = this.messageWindow.nativeElement.offsetWidth;
            this.windowHeight = this.messageWindow.nativeElement.offsetHeight;
        }
    }
    ngOnInit() { }
}
StiButtonMessageWindowComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiButtonMessageWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiButtonMessageWindowComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiButtonMessageWindowComponent, selector: "button-message-window", viewQueries: [{ propertyName: "messageWindow", first: true, predicate: ["messageWindow"], descendants: true }], ngImport: i0, template: `
    <div #messageWindow [style.left]="left" [style.top]="top" class="message-window">
      <div class="navigation">
        <div class="navigation-title">
          <span>{{ loc.get2("Permissions", "ItemForms") }}</span>
        </div>
        <div
          class="close-button"
          *ngIf="!model.showErrorWindow"
          (click)="model.showButtonMessageWindow = !model.showButtonMessageWindow"
        >
          <img [src]="model.getImage('images.Other.CloseForm.png')" />
        </div>
      </div>
      <div class="content">
        <span>{{ model.errorWindowMessage }}</span>
      </div>
      <div class="accept-container">
        <div
          class="accept button"
          *ngIf="!model.sendedFromButton"
          (click)="model.showButtonMessageWindow = false; model.showErrorWindow = false"
        >
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="error button" *ngIf="model.sendedFromButton" (click)="retry()">
          <span>{{ loc.get2("PropertyEnum", "DialogResultRetry") }}</span>
        </div>
        <div
          class="error button"
          *ngIf="model.sendedFromButton"
          (click)="model.showButtonMessageWindow = false; model.showErrorWindow = false; model.sendedFromButton = false"
        >
          <span>{{ loc.get2("PropertyMain", "Cancel") }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".message-window{position:absolute;z-index:99999999;background-color:var(--back-color);border:1px solid rgb(25,71,138);min-width:250px;max-width:1000px;min-height:130px;max-height:1000px;top:calc(50% - 65px);display:flex;flex-direction:column;overflow:hidden;border-radius:5px;box-shadow:0 0 7px #0000004d}.navigation{height:30px;width:100%;display:flex;justify-content:flex-end;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a}.navigation-title{flex:1;color:#fff;font-family:Arial;font-size:13px;display:flex;align-items:center;padding-left:10px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none}.close-button{width:30px;height:100%;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#d3d3d3}.close-button:active{background-color:var(--active-color)}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.content{width:100%;height:100%;flex:1;display:flex;align-items:center;justify-content:center;padding:10px}.content span{color:var(--text-color);font-size:12px;font-family:Segoe UI;word-wrap:break-word;cursor:default;-webkit-user-select:none;user-select:none}.accept-container{height:50px;width:100%;display:flex;justify-content:center;align-items:center}.accept{width:80px;height:30px}.error{width:70px;height:30px;margin:5px}.button{background-color:#19478a;color:#fff;border-radius:3px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:#3d6298}.button span{font-size:12px;font-family:Segoe UI;cursor:default;-webkit-user-select:none;user-select:none}\n"], dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiButtonMessageWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "button-message-window", template: `
    <div #messageWindow [style.left]="left" [style.top]="top" class="message-window">
      <div class="navigation">
        <div class="navigation-title">
          <span>{{ loc.get2("Permissions", "ItemForms") }}</span>
        </div>
        <div
          class="close-button"
          *ngIf="!model.showErrorWindow"
          (click)="model.showButtonMessageWindow = !model.showButtonMessageWindow"
        >
          <img [src]="model.getImage('images.Other.CloseForm.png')" />
        </div>
      </div>
      <div class="content">
        <span>{{ model.errorWindowMessage }}</span>
      </div>
      <div class="accept-container">
        <div
          class="accept button"
          *ngIf="!model.sendedFromButton"
          (click)="model.showButtonMessageWindow = false; model.showErrorWindow = false"
        >
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="error button" *ngIf="model.sendedFromButton" (click)="retry()">
          <span>{{ loc.get2("PropertyEnum", "DialogResultRetry") }}</span>
        </div>
        <div
          class="error button"
          *ngIf="model.sendedFromButton"
          (click)="model.showButtonMessageWindow = false; model.showErrorWindow = false; model.sendedFromButton = false"
        >
          <span>{{ loc.get2("PropertyMain", "Cancel") }}</span>
        </div>
      </div>
    </div>
  `, styles: [".message-window{position:absolute;z-index:99999999;background-color:var(--back-color);border:1px solid rgb(25,71,138);min-width:250px;max-width:1000px;min-height:130px;max-height:1000px;top:calc(50% - 65px);display:flex;flex-direction:column;overflow:hidden;border-radius:5px;box-shadow:0 0 7px #0000004d}.navigation{height:30px;width:100%;display:flex;justify-content:flex-end;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a}.navigation-title{flex:1;color:#fff;font-family:Arial;font-size:13px;display:flex;align-items:center;padding-left:10px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none}.close-button{width:30px;height:100%;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#d3d3d3}.close-button:active{background-color:var(--active-color)}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.content{width:100%;height:100%;flex:1;display:flex;align-items:center;justify-content:center;padding:10px}.content span{color:var(--text-color);font-size:12px;font-family:Segoe UI;word-wrap:break-word;cursor:default;-webkit-user-select:none;user-select:none}.accept-container{height:50px;width:100%;display:flex;justify-content:center;align-items:center}.accept{width:80px;height:30px}.error{width:70px;height:30px;margin:5px}.button{background-color:#19478a;color:#fff;border-radius:3px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:#3d6298}.button span{font-size:12px;font-family:Segoe UI;cursor:default;-webkit-user-select:none;user-select:none}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }]; }, propDecorators: { messageWindow: [{
                type: ViewChild,
                args: ["messageWindow"]
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWJ1dHRvbi1tZXNzYWdlLXdpbmRvdy5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvY29tcG9uZW50cy9zdGktYnV0dG9uL3N0aS1idXR0b24tbWVzc2FnZS13aW5kb3cuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBaUIsU0FBUyxFQUFzQixTQUFTLEVBQUUsTUFBTSxlQUFlLENBQUM7Ozs7O0FBNkp4RixNQUFNLE9BQU8sK0JBQStCO0lBbUIxQyxZQUFtQixLQUFzQixFQUFTLEdBQTJCO1FBQTFELFVBQUssR0FBTCxLQUFLLENBQWlCO1FBQVMsUUFBRyxHQUFILEdBQUcsQ0FBd0I7UUFqQnRFLGdCQUFXLEdBQVcsR0FBRyxDQUFDO1FBQzFCLGlCQUFZLEdBQVcsR0FBRyxDQUFDO0lBZ0I4QyxDQUFDO0lBZGpGLElBQVcsSUFBSTtRQUNiLElBQUksSUFBSSxDQUFDLGFBQWEsRUFBRTtZQUN0QixPQUFPLGNBQWMsSUFBSSxDQUFDLFdBQVcsR0FBRyxDQUFDLEtBQUssQ0FBQztTQUNoRDthQUFNO1lBQ0wsT0FBTyxtQkFBbUIsQ0FBQztTQUM1QjtJQUNILENBQUM7SUFDRCxJQUFXLEdBQUc7UUFDWixJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUU7WUFDdEIsT0FBTyxjQUFjLElBQUksQ0FBQyxZQUFZLEdBQUcsQ0FBQyxLQUFLLENBQUM7U0FDakQ7YUFBTTtZQUNMLE9BQU8sa0JBQWtCLENBQUM7U0FDM0I7SUFDSCxDQUFDO0lBRUQsS0FBSztRQUNILElBQUksQ0FBQyxLQUFLLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDO1FBQzNDLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztRQUNuQyxJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztRQUNwQyxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDMUUsQ0FBQztJQUNELGVBQWU7UUFDYixJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUU7WUFDdEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQUM7WUFDaEUsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQUM7U0FDbkU7SUFDSCxDQUFDO0lBRUQsUUFBUSxLQUFJLENBQUM7OzRIQWpDRiwrQkFBK0I7Z0hBQS9CLCtCQUErQiw2S0F0SmhDOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBcUNUOzJGQWlIVSwrQkFBK0I7a0JBeEozQyxTQUFTOytCQUNFLHVCQUF1QixZQUN2Qjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQXFDVDsySUFrSDJCLGFBQWE7c0JBQXhDLFNBQVM7dUJBQUMsZUFBZSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFmdGVyVmlld0luaXQsIENvbXBvbmVudCwgRWxlbWVudFJlZiwgT25Jbml0LCBWaWV3Q2hpbGQgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgeyBTdGlCdXR0b25FbGVtZW50IH0gZnJvbSBcIi4uLy4uL2VsZW1lbnRzL1N0aUJ1dHRvbkVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTG9jYWxpemF0aW9uU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9zdGktbG9jYWxpemF0aW9uLnNlcnZpY2VcIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcImJ1dHRvbi1tZXNzYWdlLXdpbmRvd1wiLFxyXG4gIHRlbXBsYXRlOiBgXHJcbiAgICA8ZGl2ICNtZXNzYWdlV2luZG93IFtzdHlsZS5sZWZ0XT1cImxlZnRcIiBbc3R5bGUudG9wXT1cInRvcFwiIGNsYXNzPVwibWVzc2FnZS13aW5kb3dcIj5cclxuICAgICAgPGRpdiBjbGFzcz1cIm5hdmlnYXRpb25cIj5cclxuICAgICAgICA8ZGl2IGNsYXNzPVwibmF2aWdhdGlvbi10aXRsZVwiPlxyXG4gICAgICAgICAgPHNwYW4+e3sgbG9jLmdldDIoXCJQZXJtaXNzaW9uc1wiLCBcIkl0ZW1Gb3Jtc1wiKSB9fTwvc3Bhbj5cclxuICAgICAgICA8L2Rpdj5cclxuICAgICAgICA8ZGl2XHJcbiAgICAgICAgICBjbGFzcz1cImNsb3NlLWJ1dHRvblwiXHJcbiAgICAgICAgICAqbmdJZj1cIiFtb2RlbC5zaG93RXJyb3JXaW5kb3dcIlxyXG4gICAgICAgICAgKGNsaWNrKT1cIm1vZGVsLnNob3dCdXR0b25NZXNzYWdlV2luZG93ID0gIW1vZGVsLnNob3dCdXR0b25NZXNzYWdlV2luZG93XCJcclxuICAgICAgICA+XHJcbiAgICAgICAgICA8aW1nIFtzcmNdPVwibW9kZWwuZ2V0SW1hZ2UoJ2ltYWdlcy5PdGhlci5DbG9zZUZvcm0ucG5nJylcIiAvPlxyXG4gICAgICAgIDwvZGl2PlxyXG4gICAgICA8L2Rpdj5cclxuICAgICAgPGRpdiBjbGFzcz1cImNvbnRlbnRcIj5cclxuICAgICAgICA8c3Bhbj57eyBtb2RlbC5lcnJvcldpbmRvd01lc3NhZ2UgfX08L3NwYW4+XHJcbiAgICAgIDwvZGl2PlxyXG4gICAgICA8ZGl2IGNsYXNzPVwiYWNjZXB0LWNvbnRhaW5lclwiPlxyXG4gICAgICAgIDxkaXZcclxuICAgICAgICAgIGNsYXNzPVwiYWNjZXB0IGJ1dHRvblwiXHJcbiAgICAgICAgICAqbmdJZj1cIiFtb2RlbC5zZW5kZWRGcm9tQnV0dG9uXCJcclxuICAgICAgICAgIChjbGljayk9XCJtb2RlbC5zaG93QnV0dG9uTWVzc2FnZVdpbmRvdyA9IGZhbHNlOyBtb2RlbC5zaG93RXJyb3JXaW5kb3cgPSBmYWxzZVwiXHJcbiAgICAgICAgPlxyXG4gICAgICAgICAgPHNwYW4+e3sgbG9jLmdldDIoXCJCdXR0b25zXCIsIFwiT2tcIikucmVwbGFjZShcIiZhbXBcIiwgXCJcIikucmVwbGFjZShcIjtcIiwgXCJcIikgfX08L3NwYW4+XHJcbiAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgPGRpdiBjbGFzcz1cImVycm9yIGJ1dHRvblwiICpuZ0lmPVwibW9kZWwuc2VuZGVkRnJvbUJ1dHRvblwiIChjbGljayk9XCJyZXRyeSgpXCI+XHJcbiAgICAgICAgICA8c3Bhbj57eyBsb2MuZ2V0MihcIlByb3BlcnR5RW51bVwiLCBcIkRpYWxvZ1Jlc3VsdFJldHJ5XCIpIH19PC9zcGFuPlxyXG4gICAgICAgIDwvZGl2PlxyXG4gICAgICAgIDxkaXZcclxuICAgICAgICAgIGNsYXNzPVwiZXJyb3IgYnV0dG9uXCJcclxuICAgICAgICAgICpuZ0lmPVwibW9kZWwuc2VuZGVkRnJvbUJ1dHRvblwiXHJcbiAgICAgICAgICAoY2xpY2spPVwibW9kZWwuc2hvd0J1dHRvbk1lc3NhZ2VXaW5kb3cgPSBmYWxzZTsgbW9kZWwuc2hvd0Vycm9yV2luZG93ID0gZmFsc2U7IG1vZGVsLnNlbmRlZEZyb21CdXR0b24gPSBmYWxzZVwiXHJcbiAgICAgICAgPlxyXG4gICAgICAgICAgPHNwYW4+e3sgbG9jLmdldDIoXCJQcm9wZXJ0eU1haW5cIiwgXCJDYW5jZWxcIikgfX08L3NwYW4+XHJcbiAgICAgICAgPC9kaXY+XHJcbiAgICAgIDwvZGl2PlxyXG4gICAgPC9kaXY+XHJcbiAgYCxcclxuICBzdHlsZXM6IFtcclxuICAgIGBcclxuICAgICAgLm1lc3NhZ2Utd2luZG93IHtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgei1pbmRleDogOTk5OTk5OTk7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tYmFjay1jb2xvcik7XHJcbiAgICAgICAgYm9yZGVyOiAxcHggc29saWQgcmdiKDI1LCA3MSwgMTM4KTtcclxuICAgICAgICBtaW4td2lkdGg6IDI1MHB4O1xyXG4gICAgICAgIG1heC13aWR0aDogMTAwMHB4O1xyXG4gICAgICAgIG1pbi1oZWlnaHQ6IDEzMHB4O1xyXG4gICAgICAgIG1heC1oZWlnaHQ6IDEwMDBweDtcclxuICAgICAgICB0b3A6IGNhbGMoNTAlIC0gNjVweCk7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xyXG4gICAgICAgIG92ZXJmbG93OiBoaWRkZW47XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogNXB4O1xyXG4gICAgICAgIC1tb3otYm94LXNoYWRvdzogMHB4IDBweCA3cHggcmdiYSgwLCAwLCAwLCAwLjYpO1xyXG4gICAgICAgIC13ZWJraXQtYm94LXNoYWRvdzogMHB4IDBweCA3cHggcmdiKDAgMCAwIC8gNjAlKTtcclxuICAgICAgICBib3gtc2hhZG93OiAwIDAgN3B4IHJnYigwIDAgMCAvIDMwJSk7XHJcbiAgICAgIH1cclxuICAgICAgLm5hdmlnYXRpb24ge1xyXG4gICAgICAgIGhlaWdodDogMzBweDtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGp1c3RpZnktY29udGVudDogZmxleC1lbmQ7XHJcbiAgICAgICAgYm9yZGVyLXRvcC1sZWZ0LXJhZGl1czogM3B4O1xyXG4gICAgICAgIGJvcmRlci10b3AtcmlnaHQtcmFkaXVzOiAzcHg7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDgxLCA5MiwgMTA2KTtcclxuICAgICAgfVxyXG4gICAgICAubmF2aWdhdGlvbi10aXRsZSB7XHJcbiAgICAgICAgZmxleDogMTtcclxuICAgICAgICBjb2xvcjogd2hpdGU7XHJcbiAgICAgICAgZm9udC1mYW1pbHk6IEFyaWFsO1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMTNweDtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAgcGFkZGluZy1sZWZ0OiAxMHB4O1xyXG4gICAgICAgIC1tb3otdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgICAgLWtodG1sLXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgIH1cclxuICAgICAgLmNsb3NlLWJ1dHRvbiB7XHJcbiAgICAgICAgd2lkdGg6IDMwcHg7XHJcbiAgICAgICAgaGVpZ2h0OiAxMDAlO1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAuY2xvc2UtYnV0dG9uOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiBsaWdodGdyYXk7XHJcbiAgICAgIH1cclxuICAgICAgLmNsb3NlLWJ1dHRvbjphY3RpdmUge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHZhcigtLWFjdGl2ZS1jb2xvcik7XHJcbiAgICAgIH1cclxuICAgICAgLmNsb3NlLWJ1dHRvbiBpbWcge1xyXG4gICAgICAgIGhlaWdodDogMTZweDtcclxuICAgICAgICB3aWR0aDogMTZweDtcclxuICAgICAgICBmaWx0ZXI6IGJyaWdodG5lc3MoMCkgaW52ZXJ0KDEpO1xyXG4gICAgICB9XHJcbiAgICAgIC5jb250ZW50IHtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBoZWlnaHQ6IDEwMCU7XHJcbiAgICAgICAgZmxleDogMTtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XHJcbiAgICAgICAgcGFkZGluZzogMTBweDtcclxuICAgICAgfVxyXG4gICAgICAuY29udGVudCBzcGFuIHtcclxuICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1jb2xvcik7XHJcbiAgICAgICAgZm9udC1zaXplOiAxMnB4O1xyXG4gICAgICAgIGZvbnQtZmFtaWx5OiBcIlNlZ29lIFVJXCI7XHJcbiAgICAgICAgd29yZC13cmFwOiBicmVhay13b3JkO1xyXG4gICAgICAgIGN1cnNvcjogZGVmYXVsdDtcclxuICAgICAgICB1c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgfVxyXG4gICAgICAuYWNjZXB0LWNvbnRhaW5lciB7XHJcbiAgICAgICAgaGVpZ2h0OiA1MHB4O1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAuYWNjZXB0IHtcclxuICAgICAgICB3aWR0aDogODBweDtcclxuICAgICAgICBoZWlnaHQ6IDMwcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmVycm9yIHtcclxuICAgICAgICB3aWR0aDogNzBweDtcclxuICAgICAgICBoZWlnaHQ6IDMwcHg7XHJcbiAgICAgICAgbWFyZ2luOiA1cHg7XHJcbiAgICAgIH1cclxuICAgICAgLmJ1dHRvbiB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDI1LCA3MSwgMTM4KTtcclxuICAgICAgICBjb2xvcjogd2hpdGU7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogM3B4O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAuYnV0dG9uOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoNjEsIDk4LCAxNTIpO1xyXG4gICAgICB9XHJcbiAgICAgIC5idXR0b24gc3BhbiB7XHJcbiAgICAgICAgZm9udC1zaXplOiAxMnB4O1xyXG4gICAgICAgIGZvbnQtZmFtaWx5OiBcIlNlZ29lIFVJXCI7XHJcbiAgICAgICAgY3Vyc29yOiBkZWZhdWx0O1xyXG4gICAgICAgIHVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICB9XHJcbiAgICBgLFxyXG4gIF0sXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBTdGlCdXR0b25NZXNzYWdlV2luZG93Q29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0LCBBZnRlclZpZXdJbml0IHtcclxuICBAVmlld0NoaWxkKFwibWVzc2FnZVdpbmRvd1wiKSBtZXNzYWdlV2luZG93OiBFbGVtZW50UmVmO1xyXG4gIHB1YmxpYyB3aW5kb3dXaWR0aDogbnVtYmVyID0gMjUwO1xyXG4gIHB1YmxpYyB3aW5kb3dIZWlnaHQ6IG51bWJlciA9IDEzMDtcclxuXHJcbiAgcHVibGljIGdldCBsZWZ0KCkge1xyXG4gICAgaWYgKHRoaXMubWVzc2FnZVdpbmRvdykge1xyXG4gICAgICByZXR1cm4gYGNhbGMoNTAlIC0gJHt0aGlzLndpbmRvd1dpZHRoIC8gMn1weClgO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgcmV0dXJuIGBjYWxjKDUwJSAtIDEyNXB4KWA7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgdG9wKCkge1xyXG4gICAgaWYgKHRoaXMubWVzc2FnZVdpbmRvdykge1xyXG4gICAgICByZXR1cm4gYGNhbGMoNTAlIC0gJHt0aGlzLndpbmRvd0hlaWdodCAvIDJ9cHgpYDtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHJldHVybiBgY2FsYyg1MCUgLSA2NXB4KWA7XHJcbiAgICB9XHJcbiAgfVxyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlLCBwdWJsaWMgbG9jOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlKSB7fVxyXG4gIHJldHJ5KCkge1xyXG4gICAgdGhpcy5tb2RlbC5zaG93QnV0dG9uTWVzc2FnZVdpbmRvdyA9IGZhbHNlO1xyXG4gICAgdGhpcy5tb2RlbC5zaG93RXJyb3JXaW5kb3cgPSBmYWxzZTtcclxuICAgIHRoaXMubW9kZWwuc2VuZGVkRnJvbUJ1dHRvbiA9IGZhbHNlO1xyXG4gICAgdGhpcy5tb2RlbC5yZXRyeUJ1dHRvblJlcXVlc3QubmV4dCh0aGlzLm1vZGVsLmN1cnJlbnRVc2VkQnV0dG9uRWxlbWVudCk7XHJcbiAgfVxyXG4gIG5nQWZ0ZXJWaWV3SW5pdCgpOiB2b2lkIHtcclxuICAgIGlmICh0aGlzLm1lc3NhZ2VXaW5kb3cpIHtcclxuICAgICAgdGhpcy53aW5kb3dXaWR0aCA9IHRoaXMubWVzc2FnZVdpbmRvdy5uYXRpdmVFbGVtZW50Lm9mZnNldFdpZHRoO1xyXG4gICAgICB0aGlzLndpbmRvd0hlaWdodCA9IHRoaXMubWVzc2FnZVdpbmRvdy5uYXRpdmVFbGVtZW50Lm9mZnNldEhlaWdodDtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIG5nT25Jbml0KCkge31cclxufVxyXG4iXX0=