import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
export class StiAutoCompleteComponent {
    constructor(model) {
        this.model = model;
        this.valueChange = new EventEmitter();
        this.completeItems = [];
        this.isSearching = false;
        this.delay = 300;
    }
    ngOnDestroy() {
        this.hideSubscription.unsubscribe();
        this.checkUpdates();
    }
    blurEvent(event) {
        this.checkUpdates();
    }
    selectItem(item) {
        this.value = item;
        this.valueChange.emit(this.value);
        this.showItemsList = false;
        this.showCompleteItemsList = false;
    }
    inputEvent(value) {
        this.showItemsList = false;
        this.isSearching = true;
        this.showCompleteItemsList = false;
        this.value = value;
        this.valueChange.emit(this.value);
        this.filterItems(value);
        setTimeout(() => {
            this.isSearching = false;
        });
    }
    clearTimeout() {
        if (this.timeout) {
            clearTimeout(this.timeout);
            this.timeout = null;
        }
    }
    removeItem(url, event) {
        event.stopPropagation();
        if (url == this.value && this.model.isCloudMode) {
            this.value = "cloud.stimulsoft.com";
        }
        this.model.enteredUrls.splice(this.model.enteredUrls.indexOf(url), 1);
        this.updateStore();
    }
    checkUpdates() {
        if (this.value.length > 0 && !this.items.find((item) => item == this.value)) {
            if (this.model.enteredUrls.length == 20) {
                this.model.enteredUrls.splice(19, 1);
            }
            this.model.enteredUrls.splice(0, 0, this.value);
            this.updateStore();
        }
    }
    filterItems(query) {
        this.completeItems = [];
        let filtered = [];
        for (let i = 0; i < this.items.length; i++) {
            let item = this.items[i];
            if (item.toLowerCase().indexOf(query.toLowerCase()) == 0) {
                filtered.push(item);
            }
        }
        this.completeItems = filtered;
        if (query && filtered) {
            setTimeout(() => {
                if (!this.isSearching) {
                    this.showCompleteItemsList = true;
                }
            }, this.delay);
        }
    }
    updateStore() {
        localStorage.removeItem("StiButtonLinks");
        localStorage.setItem("StiButtonLinks", this.model.enteredUrls.toString());
    }
    ngOnInit() {
        this.hideSubscription = this.model.hideActiveAutocompleteList.subscribe(() => {
            if (this.showItemsList || this.showCompleteItemsList) {
                this.showCompleteItemsList = false;
                this.showItemsList = false;
            }
        });
    }
}
StiAutoCompleteComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiAutoCompleteComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiAutoCompleteComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiAutoCompleteComponent, selector: "sti-autoComplete", inputs: { value: "value", items: "items" }, outputs: { valueChange: "valueChange" }, ngImport: i0, template: `
    <div class="autoComplete-container">
      <div class="autoComplete-input">
        <input type="text" [value]="value" (input)="inputEvent($event.target.value)" (blur)="blurEvent($event)" />
        <div class="autoComplete-select-button" (click)="showItemsList = !showItemsList; showCompleteItemsList = false">
          <i class="pi pi-chevron-down"></i>
        </div>
      </div>
      <div
        class="autoComplete-list-container"
        *ngIf="showItemsList"
        [style.border]="items.length == 0 ? 'none' : '1px solid #c8c8c8'"
      >
        <div class="list-item" *ngFor="let item of items" (click)="selectItem(item)">
          <span class="label">{{ item }}</span>
          <span *ngIf="item != 'cloud.stimulsoft.com'" class="delete-button" (click)="removeItem(item, $event)"
            ><img [src]="model.getImage('images.Other.CloseForm.png')"
          /></span>
        </div>
      </div>
      <div
        class="autoComplete-list-container"
        *ngIf="showCompleteItemsList"
        [style.border]="completeItems.length == 0 ? 'none' : '1px solid #c8c8c8'"
      >
        <div class="list-item" *ngFor="let option of completeItems" (click)="selectItem(option)">
          <span class="label">{{ option }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".list-item{display:flex;align-items:center;font-weight:400;font-size:12px;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;width:100%;color:#333;padding:.429rem .857rem}.list-item:hover{background:#eaeaea;cursor:pointer}.label{width:100%}.autoComplete-container{position:relative}.autoComplete-list-container{position:absolute;top:24px;z-index:1001;width:100%;border-radius:3px;border:1px solid #c8c8c8;background-color:#fff;overflow:auto;max-height:400px;box-shadow:0 3px 6px #00000029}.autoComplete-container{height:24px;width:100%;border-radius:3px;border:1px solid rgb(107,107,107);margin-top:1px}.autoComplete-input{width:100%;display:flex;align-items:center}.autoComplete-input input{width:100%;outline:none;border:0;height:100%;border-radius:3px;font-size:12px;font-weight:500;padding:3px 5px}.autoComplete-select-button{width:22px;height:24px;display:flex;justify-content:center;align-items:center;color:#d3d3d3}.autoComplete-select-button:hover{cursor:pointer}img{height:16px;width:16px}.delete-button:hover img{filter:saturate(500%) contrast(100%) brightness(900%) invert(900%) sepia(50%)}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiAutoCompleteComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-autoComplete", template: `
    <div class="autoComplete-container">
      <div class="autoComplete-input">
        <input type="text" [value]="value" (input)="inputEvent($event.target.value)" (blur)="blurEvent($event)" />
        <div class="autoComplete-select-button" (click)="showItemsList = !showItemsList; showCompleteItemsList = false">
          <i class="pi pi-chevron-down"></i>
        </div>
      </div>
      <div
        class="autoComplete-list-container"
        *ngIf="showItemsList"
        [style.border]="items.length == 0 ? 'none' : '1px solid #c8c8c8'"
      >
        <div class="list-item" *ngFor="let item of items" (click)="selectItem(item)">
          <span class="label">{{ item }}</span>
          <span *ngIf="item != 'cloud.stimulsoft.com'" class="delete-button" (click)="removeItem(item, $event)"
            ><img [src]="model.getImage('images.Other.CloseForm.png')"
          /></span>
        </div>
      </div>
      <div
        class="autoComplete-list-container"
        *ngIf="showCompleteItemsList"
        [style.border]="completeItems.length == 0 ? 'none' : '1px solid #c8c8c8'"
      >
        <div class="list-item" *ngFor="let option of completeItems" (click)="selectItem(option)">
          <span class="label">{{ option }}</span>
        </div>
      </div>
    </div>
  `, styles: [".list-item{display:flex;align-items:center;font-weight:400;font-size:12px;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;width:100%;color:#333;padding:.429rem .857rem}.list-item:hover{background:#eaeaea;cursor:pointer}.label{width:100%}.autoComplete-container{position:relative}.autoComplete-list-container{position:absolute;top:24px;z-index:1001;width:100%;border-radius:3px;border:1px solid #c8c8c8;background-color:#fff;overflow:auto;max-height:400px;box-shadow:0 3px 6px #00000029}.autoComplete-container{height:24px;width:100%;border-radius:3px;border:1px solid rgb(107,107,107);margin-top:1px}.autoComplete-input{width:100%;display:flex;align-items:center}.autoComplete-input input{width:100%;outline:none;border:0;height:100%;border-radius:3px;font-size:12px;font-weight:500;padding:3px 5px}.autoComplete-select-button{width:22px;height:24px;display:flex;justify-content:center;align-items:center;color:#d3d3d3}.autoComplete-select-button:hover{cursor:pointer}img{height:16px;width:16px}.delete-button:hover img{filter:saturate(500%) contrast(100%) brightness(900%) invert(900%) sepia(50%)}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { value: [{
                type: Input
            }], items: [{
                type: Input
            }], valueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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