import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-user-service";
export class StiAboutWindowComponent {
    constructor(model, userService) {
        this.model = model;
        this.userService = userService;
    }
    get align() {
        return "start";
    }
    get version() {
        return this.model.assemblyInfo
            ? this.model.assemblyInfo["version"].slice(0, this.model.assemblyInfo["version"].lastIndexOf("."))
            : "2022.4.1";
    }
    get releaseDate() {
        return this.model.assemblyInfo ? this.model.assemblyInfo["creationDate"] : " 27 Semptember 2022";
    }
    get copyright() {
        return this.model.assemblyInfo ? this.model.assemblyInfo["copyright"] : "";
    }
    get userMail() {
        return this.userService.currentUser
            ? this.userService.currentUser.userName
            : this.model.userName
                ? this.model.userName
                : "";
    }
    get hasLicense() {
        return this.userService.licenseProducts.find((product) => product.ident == "Ultimate" ||
            product.ident == "FormsWeb" ||
            product.ident == 1 ||
            product.ident == 4 ||
            product.ident == "BICloud" ||
            product.ident == 18);
    }
    close() {
        this.model.showAboutWindow = false;
    }
    ngOnInit() { }
}
StiAboutWindowComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiAboutWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiUserService }], target: i0.ɵɵFactoryTarget.Component });
StiAboutWindowComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiAboutWindowComponent, selector: "sti-about-window-component", ngImport: i0, template: `
    <div class="about-window">
      <div class="close-bar">
        <div class="close-button" (click)="close()"><img [src]="model.getImage('images.Other.CloseForm.png')" /></div>
      </div>
      <div class="content">
        <span [style.margin-bottom]="'20px'" [style.color]="'rgb(0,112,184)'" [style.font-size]="'24px'"
          >Stimulsoft Forms</span
        >
        <img [src]="model.getImage('images.Other.About.png')" alt="" />
        <span [style.margin-top]="'20px'">{{ copyright }}</span>
        <span>Version: {{ version }} from {{ releaseDate }}, Angular</span>
        <span> All rights reserved</span>
        <span [style.font-weight]="'bold'" [style.color]="!hasLicense ? 'red' : ''">{{
          userMail + (userMail && !hasLicense ? ", " : "") + (!hasLicense ? "Trial Version" : "")
        }}</span>
        <a href="http://stimulsoft.com" target="_blank">www.stimulsoft.com</a>
      </div>
    </div>
  `, isInline: true, styles: ["a{margin-top:15px;font-size:12px;color:#3a90ff}span{margin:10px;font-size:12px}.about-window{-webkit-touch-callout:none;-webkit-user-select:none;font-family:Arial;position:absolute;z-index:1000;left:calc(50% - 275px);top:calc(50% - 190px);background-color:#fff;width:550px;height:380px;border-radius:5px;border:1px solid rgb(25,71,138);box-shadow:0 0 7px #0000004d;padding:0}.close-bar{height:30px;width:100%;display:flex;flex-direction:row-reverse}.close-button{padding:0;margin:0;border-top-right-radius:5px;height:30px;width:30px;background-color:#fff;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px}.close-button:hover{background-color:#e81123}.close-button:hover img{filter:brightness(0) invert(1)}.content{display:flex;flex-direction:column;height:100%;align-items:center}img{height:100px;width:100px}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiAboutWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-about-window-component", template: `
    <div class="about-window">
      <div class="close-bar">
        <div class="close-button" (click)="close()"><img [src]="model.getImage('images.Other.CloseForm.png')" /></div>
      </div>
      <div class="content">
        <span [style.margin-bottom]="'20px'" [style.color]="'rgb(0,112,184)'" [style.font-size]="'24px'"
          >Stimulsoft Forms</span
        >
        <img [src]="model.getImage('images.Other.About.png')" alt="" />
        <span [style.margin-top]="'20px'">{{ copyright }}</span>
        <span>Version: {{ version }} from {{ releaseDate }}, Angular</span>
        <span> All rights reserved</span>
        <span [style.font-weight]="'bold'" [style.color]="!hasLicense ? 'red' : ''">{{
          userMail + (userMail && !hasLicense ? ", " : "") + (!hasLicense ? "Trial Version" : "")
        }}</span>
        <a href="http://stimulsoft.com" target="_blank">www.stimulsoft.com</a>
      </div>
    </div>
  `, styles: ["a{margin-top:15px;font-size:12px;color:#3a90ff}span{margin:10px;font-size:12px}.about-window{-webkit-touch-callout:none;-webkit-user-select:none;font-family:Arial;position:absolute;z-index:1000;left:calc(50% - 275px);top:calc(50% - 190px);background-color:#fff;width:550px;height:380px;border-radius:5px;border:1px solid rgb(25,71,138);box-shadow:0 0 7px #0000004d;padding:0}.close-bar{height:30px;width:100%;display:flex;flex-direction:row-reverse}.close-button{padding:0;margin:0;border-top-right-radius:5px;height:30px;width:30px;background-color:#fff;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px}.close-button:hover{background-color:#e81123}.close-button:hover img{filter:brightness(0) invert(1)}.content{display:flex;flex-direction:column;height:100%;align-items:center}img{height:100px;width:100px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiUserService }]; } });
//# sourceMappingURL=data:application/json;base64,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