import { Component } from "@angular/core";
import { StiTableElement } from "../../../../../elements/StiTableElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/sti-localization.service";
import * as i2 from "../../../../../services/model.service";
export class TableNavigationComponent {
    constructor(loc, model) {
        this.loc = loc;
        this.model = model;
        model.currentTablePropertyHeader.subscribe((header) => {
            this.model.currentTableHeader = header;
        });
    }
    setTablePropertyHeader(header) {
        this.model.currentTableHeader = header;
        if (this.model.selectedComponent.element instanceof StiTableElement) {
            if (header == "Columns") {
                this.model.selectedComponent.element.showColumnsEditor = true;
            }
            else if (header == "Rows") {
                this.model.selectedComponent.element.showRowsEditor = true;
            }
            else if (header == "Totals") {
                this.model.selectedComponent.element.showTotalsEditor = true;
            }
            else {
                this.model.selectedComponent.element.showHeaderEditor = true;
            }
        }
        this.model.needToRefresh.next(true);
    }
    getClass(header) {
        return this.model.currentTableHeader == header ? "current" : "other";
    }
    ngOnInit() { }
}
TableNavigationComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TableNavigationComponent, deps: [{ token: i1.StiLocalizationService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
TableNavigationComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: TableNavigationComponent, selector: "table-navigation", ngImport: i0, template: `
    <div class="table-property-header">
      <a (click)="setTablePropertyHeader('Main')"
        ><span [class]="getClass('Main')">{{ loc.get2("FormOptions", "Main") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Columns')"
        ><span [class]="getClass('Columns')">{{ loc.getP("Columns") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Rows')"
        ><span [class]="getClass('Rows')">{{ loc.getP("Rows") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Totals')"
        ><span [class]="getClass('Totals')" (click)="setTablePropertyHeader('Totals')">{{
          loc.getP("Totals")
        }}</span></a
      >
    </div>
  `, isInline: true, styles: [".table-property-header{display:flex;height:30px;align-items:center;background-color:var(--back-color);width:100%;-webkit-touch-callout:none;-webkit-user-select:none;font-family:Segoe UI;font-size:13px}a span{height:100%;padding:6px 3px 3px;align-items:center;justify-items:center}.table-property-header a{height:100%;width:100%;text-decoration:none;text-align:center;font-size:13px;cursor:default;display:flex;align-items:center;justify-content:center}.table-property-header a:hover{background-color:var(--hover-color)}a:hover span{width:100%}.current{color:var(--text-color);font-weight:700;border-bottom:2px solid rgb(42,115,197)}.other{color:var(--text-color)}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TableNavigationComponent, decorators: [{
            type: Component,
            args: [{ selector: "table-navigation", template: `
    <div class="table-property-header">
      <a (click)="setTablePropertyHeader('Main')"
        ><span [class]="getClass('Main')">{{ loc.get2("FormOptions", "Main") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Columns')"
        ><span [class]="getClass('Columns')">{{ loc.getP("Columns") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Rows')"
        ><span [class]="getClass('Rows')">{{ loc.getP("Rows") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Totals')"
        ><span [class]="getClass('Totals')" (click)="setTablePropertyHeader('Totals')">{{
          loc.getP("Totals")
        }}</span></a
      >
    </div>
  `, styles: [".table-property-header{display:flex;height:30px;align-items:center;background-color:var(--back-color);width:100%;-webkit-touch-callout:none;-webkit-user-select:none;font-family:Segoe UI;font-size:13px}a span{height:100%;padding:6px 3px 3px;align-items:center;justify-items:center}.table-property-header a{height:100%;width:100%;text-decoration:none;text-align:center;font-size:13px;cursor:default;display:flex;align-items:center;justify-content:center}.table-property-header a:hover{background-color:var(--hover-color)}a:hover span{width:100%}.current{color:var(--text-color);font-weight:700;border-bottom:2px solid rgb(42,115,197)}.other{color:var(--text-color)}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiLocalizationService }, { type: i2.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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