import { Component, Input, ViewChild } from "@angular/core";
import { StiTableElement } from "../../../../../elements/StiTableElement";
import { RotateAnimation } from "../../../../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/model.service";
import * as i2 from "../../../../../services/sti-helper.service";
import * as i3 from "../../../../../services/theme.service";
import * as i4 from "../../../../../services/sti-localization.service";
import * as i5 from "../../../../../services/sti-column-draggable.service";
import * as i6 from "../../../../../services/mouse.service";
import * as i7 from "@angular/common";
import * as i8 from "../table-column-editor/table-column-editor.component";
export class StiTableColumnsEditorComponent {
    constructor(model, helper, theme, loc, draggableService, mouseService) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.draggableService = draggableService;
        this.mouseService = mouseService;
        this.arrayOfStates = [];
        this.minWidth = 40;
        this.isDrag = false;
    }
    getMaxWidth() {
        return this.model.propertyGridWidth - 20;
    }
    get disabled() {
        return this.property.property != "columns" &&
            this.model?.selectedComponent?.element instanceof StiTableElement &&
            this.model?.selectedComponent?.element.columns.length == 0
            ? true
            : false;
    }
    ngOnInit() {
        if (this.items.length != this.arrayOfStates.length) {
            this.items.forEach(() => {
                this.arrayOfStates.push("default");
            });
            this.model.currentContentEditableItem.subscribe((index) => this.refreshState(index));
        }
    }
    get items() {
        return this.helper.getProperty(this.model.selectedComponent.element, this.property.property);
    }
    onHeaderClick(event, item) {
        event.preventDefault();
        this.draggableService.startX = event["offsetX"];
        this.draggableService.startY = event["offsetY"];
        this.draggableService.containerWidth = this.booleanButton?.nativeElement.offsetWidth;
        this.draggableService.onHeaderClick(event, item, this.items);
    }
    refreshState(index) {
        if (this.arrayOfStates.length != this.items.length) {
            this.arrayOfStates = [];
            this.items.forEach(() => {
                this.arrayOfStates.push("default");
            });
        }
        this.arrayOfStates.forEach((state, i) => {
            if (i != index) {
                this.arrayOfStates[i] = "default";
            }
            else {
                this.arrayOfStates[i] = "rotated";
            }
        });
    }
    changeState(i) {
        if (!this.isDrag) {
            this.arrayOfStates[i] = this.arrayOfStates[i] == "default" ? "rotated" : "default";
        }
    }
    addItem(event, element) {
        if (this.model.selectedComponent.element instanceof StiTableElement) {
            if (this.property.property == "columns") {
                this.model.selectedComponent.element.addColumn();
                this.model.showColumnPreview(this.items.length - 1);
            }
            else {
                this.helper.addTotalMenuItems = null;
                this.model.toggleTieredMenu(element);
            }
        }
    }
    deleteItem(i) {
        this.items.splice(i, 1);
    }
}
StiTableColumnsEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableColumnsEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }, { token: i5.StiColumnDraggableService }, { token: i6.StiMouseService }], target: i0.ɵɵFactoryTarget.Component });
StiTableColumnsEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableColumnsEditorComponent, selector: "sti-table-columns-editor", inputs: { property: "property" }, viewQueries: [{ propertyName: "booleanButton", first: true, predicate: ["booleanButton"], descendants: true }], ngImport: i0, template: `
    <table class="sti-clear drop-area" [style]="{ width: '100%' }">
      <tr *ngIf="draggableService.isDragging && !draggableService.fromTable">
        <td [style]="{ height: '3px', width: '100%' }" (mousemove)="draggableService.insertIndex = 0">
          <div
            class="drag-preview"
            [style.margin-bottom]="'-5px'"
            [style.height.px]="draggableService.insertIndex == 0 ? 6 : 0"
          >
            <div class="middle-part" *ngIf="draggableService.insertIndex == 0"></div>
          </div>
        </td>
      </tr>

      <tr *ngFor="let item of items; index as i">
        <td
          colspan="7"
          *ngIf="(!draggableService.fromTable && draggableService.item != item) || draggableService.fromTable"
        >
          <div
            #booleanButton
            class="boolean-button"
            [style.max-width.px]="getMaxWidth()"
            (click)="changeState(i)"
            (mouseover)="overIndex = i"
            (mouseleave)="overIndex = null"
            (mousedown)="onHeaderClick($event, item)"
            (mousemove)="!draggableService.fromTable ? (draggableService.insertIndex = i + 1) : return"
          >
            <div class="arrow" [@rotatedState]="arrayOfStates[i]">
              <span class="select-button"><i class="pi pi-chevron-right"></i></span>
            </div>
            <div class="content">
              {{
                this.property.property == "columns"
                  ? item.label
                    ? item.label
                    : "Column " + (i + 1)
                  : item.header
                  ? item.header
                  : "Total Field " + (i + 1)
              }}
            </div>
            <div class="delete" *ngIf="draggableService.insertIndex == -1">
              <div class="delete-button" (click)="deleteItem(i)" *ngIf="overIndex == i">
                <img [src]="model.getImage('images.Ribbon.Delete.png')" />
              </div>
            </div>
          </div>
          <sti-table-column-editor
            [column]="item"
            [state]="arrayOfStates[i] == 'default' ? false : true"
            [index]="i"
            [expression]="item?.calculationAlgorithm?.expression"
          ></sti-table-column-editor>
          <div
            class="drag-preview"
            [style.height.px]="!draggableService.fromTable && draggableService.insertIndex == i + 1 ? 6 : 0"
          >
            <div class="middle-part" *ngIf="!draggableService.fromTable && draggableService.insertIndex == i + 1"></div>
          </div>
        </td>
      </tr>
      <tr [style.text-align]="'start'">
        <td>
          <button #addButton class="add-button" [disabled]="disabled" (click)="addItem($event, addButton)">
            <!--addItem()-->
            {{
              this.property.property == "columns"
                ? loc.get2("FormDictionaryDesigner", "ColumnNew")
                : loc.get2("FormDictionaryDesigner", "NewItem")
            }}
          </button>
        </td>
      </tr>
    </table>
    <style>
      .middle-part {
        position: absolute;
        width: 100%;
        left: 0;
        top: 50%;
        border-bottom: 3px solid rgb(198, 198, 198);
      }
      tr {
        padding: 3px 0px 3px 0px;
      }
      i {
        width: 10px;
        height: 10px;
      }
      .arrow {
        width: 20px;
        text-align: center;
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .content {
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        flex: 1;
        overflow: hidden;
      }
      .delete {
        width: 45px;
        display: flex;
        height: 100%;
      }
      .delete-button {
        width: 22px;
        height: 100%;
        border-radius: 3px;
        background-color: var(--hover-color);
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .delete-button img {
        height: 16px;
        width: 16px;
      }
      .delete-button:hover {
        background-color: var(--columnDeleteHover-color);
      }
      .delete-button:active {
        background-color: var(--hover-color);
      }
      .boolean-button {
        width: 100%;
        height: 22px;
        margin-top: 2px;
        display: flex;
        flex-direction: row;
        color: var(--text-color);
        background-color: var(--hover-color);
        border-top: 2px solid var(--toolbarResizerBorder-color);
      }

      .drag-preview {
        width: 100%;
        margin-bottom: -3px;
        background-color: transparent;
        position: relative;
        transition: height 50ms ease-in-out;
      }
      .add-button {
        min-width: 100px;
        min-height: 22px;
        padding: 3px 6px;
        margin-top: 5px;
        text-decoration: none;
        font-weight: 600;
        font-size: 12px;
        color: var(--text-color);
        text-align: center;
        justify-content: center;
        background-color: var(--input-color);
        border-top: 2px solid var(--toolbarResizerBorder-color);
        border-left: 1px solid var(--toolbarResizerBorder-color);
        border-right: 1px solid var(--toolbarResizerBorder-color);
        border-bottom: 1px solid var(--toolbarResizerBorder-color);
        border-radius: 3px;
      }
      .add-button:not([disabled]):hover {
        background-color: var(--hover-color);
      }
      .add-button[disabled] {
        opacity: 0.7;
        pointer-events: none;
        background-color: var(--hover-color);
      }
      .add-button:active {
        background-color: var(--active-color);
      }
    </style>
  `, isInline: true, styles: ["\n      .middle-part {\n        position: absolute;\n        width: 100%;\n        left: 0;\n        top: 50%;\n        border-bottom: 3px solid rgb(198, 198, 198);\n      }\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      i {\n        width: 10px;\n        height: 10px;\n      }\n      .arrow {\n        width: 20px;\n        text-align: center;\n        cursor: default;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .content {\n        cursor: default;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n        flex: 1;\n        overflow: hidden;\n      }\n      .delete {\n        width: 45px;\n        display: flex;\n        height: 100%;\n      }\n      .delete-button {\n        width: 22px;\n        height: 100%;\n        border-radius: 3px;\n        background-color: var(--hover-color);\n        display: flex;\n        align-items: center;\n        justify-content: center;\n      }\n      .delete-button img {\n        height: 16px;\n        width: 16px;\n      }\n      .delete-button:hover {\n        background-color: var(--columnDeleteHover-color);\n      }\n      .delete-button:active {\n        background-color: var(--hover-color);\n      }\n      .boolean-button {\n        width: 100%;\n        height: 22px;\n        margin-top: 2px;\n        display: flex;\n        flex-direction: row;\n        color: var(--text-color);\n        background-color: var(--hover-color);\n        border-top: 2px solid var(--toolbarResizerBorder-color);\n      }\n\n      .drag-preview {\n        width: 100%;\n        margin-bottom: -3px;\n        background-color: transparent;\n        position: relative;\n        transition: height 50ms ease-in-out;\n      }\n      .add-button {\n        min-width: 100px;\n        min-height: 22px;\n        padding: 3px 6px;\n        margin-top: 5px;\n        text-decoration: none;\n        font-weight: 600;\n        font-size: 12px;\n        color: var(--text-color);\n        text-align: center;\n        justify-content: center;\n        background-color: var(--input-color);\n        border-top: 2px solid var(--toolbarResizerBorder-color);\n        border-left: 1px solid var(--toolbarResizerBorder-color);\n        border-right: 1px solid var(--toolbarResizerBorder-color);\n        border-bottom: 1px solid var(--toolbarResizerBorder-color);\n        border-radius: 3px;\n      }\n      .add-button:not([disabled]):hover {\n        background-color: var(--hover-color);\n      }\n      .add-button[disabled] {\n        opacity: 0.7;\n        pointer-events: none;\n        background-color: var(--hover-color);\n      }\n      .add-button:active {\n        background-color: var(--active-color);\n      }\n    "], dependencies: [{ kind: "directive", type: i7.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i8.StiTableColumnEditorComponent, selector: "sti-table-column-editor", inputs: ["column", "state", "index", "expression"] }], animations: [RotateAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableColumnsEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-table-columns-editor",
                    template: `
    <table class="sti-clear drop-area" [style]="{ width: '100%' }">
      <tr *ngIf="draggableService.isDragging && !draggableService.fromTable">
        <td [style]="{ height: '3px', width: '100%' }" (mousemove)="draggableService.insertIndex = 0">
          <div
            class="drag-preview"
            [style.margin-bottom]="'-5px'"
            [style.height.px]="draggableService.insertIndex == 0 ? 6 : 0"
          >
            <div class="middle-part" *ngIf="draggableService.insertIndex == 0"></div>
          </div>
        </td>
      </tr>

      <tr *ngFor="let item of items; index as i">
        <td
          colspan="7"
          *ngIf="(!draggableService.fromTable && draggableService.item != item) || draggableService.fromTable"
        >
          <div
            #booleanButton
            class="boolean-button"
            [style.max-width.px]="getMaxWidth()"
            (click)="changeState(i)"
            (mouseover)="overIndex = i"
            (mouseleave)="overIndex = null"
            (mousedown)="onHeaderClick($event, item)"
            (mousemove)="!draggableService.fromTable ? (draggableService.insertIndex = i + 1) : return"
          >
            <div class="arrow" [@rotatedState]="arrayOfStates[i]">
              <span class="select-button"><i class="pi pi-chevron-right"></i></span>
            </div>
            <div class="content">
              {{
                this.property.property == "columns"
                  ? item.label
                    ? item.label
                    : "Column " + (i + 1)
                  : item.header
                  ? item.header
                  : "Total Field " + (i + 1)
              }}
            </div>
            <div class="delete" *ngIf="draggableService.insertIndex == -1">
              <div class="delete-button" (click)="deleteItem(i)" *ngIf="overIndex == i">
                <img [src]="model.getImage('images.Ribbon.Delete.png')" />
              </div>
            </div>
          </div>
          <sti-table-column-editor
            [column]="item"
            [state]="arrayOfStates[i] == 'default' ? false : true"
            [index]="i"
            [expression]="item?.calculationAlgorithm?.expression"
          ></sti-table-column-editor>
          <div
            class="drag-preview"
            [style.height.px]="!draggableService.fromTable && draggableService.insertIndex == i + 1 ? 6 : 0"
          >
            <div class="middle-part" *ngIf="!draggableService.fromTable && draggableService.insertIndex == i + 1"></div>
          </div>
        </td>
      </tr>
      <tr [style.text-align]="'start'">
        <td>
          <button #addButton class="add-button" [disabled]="disabled" (click)="addItem($event, addButton)">
            <!--addItem()-->
            {{
              this.property.property == "columns"
                ? loc.get2("FormDictionaryDesigner", "ColumnNew")
                : loc.get2("FormDictionaryDesigner", "NewItem")
            }}
          </button>
        </td>
      </tr>
    </table>
    <style>
      .middle-part {
        position: absolute;
        width: 100%;
        left: 0;
        top: 50%;
        border-bottom: 3px solid rgb(198, 198, 198);
      }
      tr {
        padding: 3px 0px 3px 0px;
      }
      i {
        width: 10px;
        height: 10px;
      }
      .arrow {
        width: 20px;
        text-align: center;
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .content {
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        flex: 1;
        overflow: hidden;
      }
      .delete {
        width: 45px;
        display: flex;
        height: 100%;
      }
      .delete-button {
        width: 22px;
        height: 100%;
        border-radius: 3px;
        background-color: var(--hover-color);
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .delete-button img {
        height: 16px;
        width: 16px;
      }
      .delete-button:hover {
        background-color: var(--columnDeleteHover-color);
      }
      .delete-button:active {
        background-color: var(--hover-color);
      }
      .boolean-button {
        width: 100%;
        height: 22px;
        margin-top: 2px;
        display: flex;
        flex-direction: row;
        color: var(--text-color);
        background-color: var(--hover-color);
        border-top: 2px solid var(--toolbarResizerBorder-color);
      }

      .drag-preview {
        width: 100%;
        margin-bottom: -3px;
        background-color: transparent;
        position: relative;
        transition: height 50ms ease-in-out;
      }
      .add-button {
        min-width: 100px;
        min-height: 22px;
        padding: 3px 6px;
        margin-top: 5px;
        text-decoration: none;
        font-weight: 600;
        font-size: 12px;
        color: var(--text-color);
        text-align: center;
        justify-content: center;
        background-color: var(--input-color);
        border-top: 2px solid var(--toolbarResizerBorder-color);
        border-left: 1px solid var(--toolbarResizerBorder-color);
        border-right: 1px solid var(--toolbarResizerBorder-color);
        border-bottom: 1px solid var(--toolbarResizerBorder-color);
        border-radius: 3px;
      }
      .add-button:not([disabled]):hover {
        background-color: var(--hover-color);
      }
      .add-button[disabled] {
        opacity: 0.7;
        pointer-events: none;
        background-color: var(--hover-color);
      }
      .add-button:active {
        background-color: var(--active-color);
      }
    </style>
  `,
                    animations: [RotateAnimation],
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }, { type: i5.StiColumnDraggableService }, { type: i6.StiMouseService }]; }, propDecorators: { property: [{
                type: Input
            }], booleanButton: [{
                type: ViewChild,
                args: ["booleanButton"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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