import { Component, Input } from "@angular/core";
import { StiComboBoxColumnItem } from "../../../../../elements/table/columns/StiComboBoxColumnItem";
import { StiLabelColumnItem } from "../../../../../elements/table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "../../../../../elements/table/columns/StiNumberBoxColumnItem";
import { StiColumnItem } from "../../../../../elements/table/StiColumnItem";
import { StiTotalsFieldItem } from "../../../../../elements/table/StiTotalsFieldItem";
import { StiLocalizationService } from "../../../../../services/sti-localization.service";
import { StiNumberType } from "../../../../../system/enums";
import { SlideInOutAnimation } from "../../../../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/model.service";
import * as i2 from "../../../../../services/sti-helper.service";
import * as i3 from "../../../../../services/theme.service";
import * as i4 from "../../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../../sti-bool-editor/sti-bool-editor.component";
import * as i7 from "../../sti-color-editor/sti-color-editor.component";
import * as i8 from "../../sti-enum-editor/sti-enum-editor.component";
import * as i9 from "../../sti-font-editor/sti-font-editor.component";
import * as i10 from "../../sti-multiline-string-editor/sti-multiline-string-editor.component";
import * as i11 from "../../sti-number-editor/sti-number-editor.component";
import * as i12 from "../../sti-text-editor/sti-text-editor.component";
import * as i13 from "../../sti-horizontal-alignment-editor/sti-horizontal-alignment-editor";
import * as i14 from "../../sti-select-button-editor.component";
import * as i15 from "../../../../sti-divider/sti-divider.component";
export class StiTableColumnEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.properties = [];
    }
    ngOnInit() {
        this.updateProperties();
        this.model.needToRefreshInnerProperties.subscribe(() => this.updateProperties());
    }
    needToDisable(property) {
        if (this.column instanceof StiLabelColumnItem || this.column instanceof StiTotalsFieldItem) {
            if (this.column.prefix.length > 0 && property.property == "suffix") {
                return true;
            }
            else if (this.column.suffix.length > 0 && property.property == "prefix") {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }
    updateProperties() {
        this.properties = [];
        if (this.column instanceof StiColumnItem) {
            this.properties.push({ type: "enum", property: "type", label: this.loc.getP("Type") });
            this.properties.push({ type: "TextEditor", property: "label", label: this.loc.getP("Label") });
            if (this.column instanceof StiLabelColumnItem) {
                this.properties.push({ type: "TextEditor", property: "expression", label: this.loc.getP("Expression") });
            }
            this.properties.push({ type: "divider" });
            this.properties.push({ type: "FontEditor", property: "font", label: this.loc.getP("Header") });
            this.properties.push({ type: "color", property: "headerBackColor", label: this.loc.getP("BackColor") });
            this.properties.push({ type: "color", property: "headerForeColor", label: this.loc.getP("ForeColor") });
            this.properties.push({
                type: "horizontalAlignment",
                property: "headerAlignment",
                label: this.loc.getP("Alignment"),
            });
            this.properties.push({
                type: "checkbox",
                property: "useWordWrap",
                checkbox: StiLocalizationService.get("PropertyEnum", "StiTextSizeModeWordWrap"),
                label: " ",
            });
            this.properties.push({ type: "divider" });
            if (!(this.column instanceof StiComboBoxColumnItem)) {
                this.properties.push({
                    type: "horizontalAlignment",
                    property: "cellAlignment",
                    label: this.loc.getP("Cell") + " " + this.loc.getP("Alignment"),
                });
            }
            if (this.column instanceof StiComboBoxColumnItem) {
                this.properties.push({
                    type: "MultilineEditor",
                    property: "comboBoxOptions",
                    label: this.loc.getP("Options"),
                });
            }
            if (this.column instanceof StiNumberBoxColumnItem || this.column instanceof StiLabelColumnItem) {
                if (this.column instanceof StiNumberBoxColumnItem) {
                    this.properties.push({
                        type: "enum",
                        property: "numberType",
                        label: StiLocalizationService.get("PropertyMain", "ValueType"),
                    });
                }
                this.properties.push({
                    type: "enum",
                    property: "thousandSeparator",
                    label: this.loc.get2("Export", "Separator").replace(":", ""),
                });
                this.properties.push({
                    type: "Number",
                    property: "decimalDigits",
                    label: this.loc.get2("FormFormatEditor", "DecimalDigits").replace(":", ""),
                });
                if (this.column instanceof StiLabelColumnItem) {
                    this.properties.push({
                        type: "TextEditor",
                        property: "prefix",
                        label: StiLocalizationService.get("PropertyMain", "Prefix"),
                    });
                    this.properties.push({
                        type: "TextEditor",
                        property: "suffix",
                        label: StiLocalizationService.get("PropertyMain", "Suffix"),
                    });
                }
                if (this.column instanceof StiNumberBoxColumnItem && this.column.numberType == StiNumberType.Decimal) {
                    this.properties.push({
                        type: "TextEditor",
                        property: "unitLabel",
                        label: StiLocalizationService.get("PropertyMain", "Unit"),
                    });
                    this.properties.push({
                        type: "enum",
                        property: "unitAlignment",
                        label: StiLocalizationService.get("PropertyMain", "UnitAlignment"),
                    });
                }
                else if (this.column instanceof StiNumberBoxColumnItem && this.column.numberType == StiNumberType.Currency) {
                    this.properties.push({
                        type: "enum",
                        property: "currency",
                        label: StiLocalizationService.get("FormFormatEditor", "Currency"),
                    });
                    this.properties.push({
                        type: "enum",
                        property: "unitAlignment",
                        label: StiLocalizationService.get("PropertyMain", "UnitAlignment"),
                    });
                    this.properties.push({
                        type: "labelFormat",
                        property: "currencyLabelFormat",
                        label: StiLocalizationService.get("PropertyMain", "ShowAs"),
                    });
                }
            }
            this.properties.push({ type: "color", property: "backgroundColor", label: this.loc.getP("BackColor") });
            this.properties.push({ type: "color", property: "cellBackColor", label: this.loc.getP("CellBackColor") });
            this.properties.push({ type: "color", property: "cellForeColor", label: this.loc.getP("CellForeColor") });
            if (!(this.column instanceof StiLabelColumnItem)) {
                this.properties.push({ type: "color", property: "cellBorderColor", label: this.loc.getP("BorderColor") });
            }
        }
        else if (this.column instanceof StiTotalsFieldItem) {
            this.properties.push({ type: "TextEditor", property: "header", label: this.loc.getP("Header") });
            this.properties.push({ type: "TextEditor", property: "expression", label: this.loc.getP("Expression") });
            this.properties.push({
                type: "horizontalAlignment",
                property: "headerAlignment",
                label: this.loc.getP("HeaderAlignment"),
            });
            this.properties.push({
                type: "horizontalAlignment",
                property: "valueAlignment",
                label: this.loc.getP("Value") + " " + this.loc.getP("Alignment"),
            });
            this.properties.push({ type: "color", property: "headerColor", label: " " });
            this.properties.push({
                type: "enum",
                property: "thousandSeparator",
                label: this.loc.get2("Export", "Separator").replace(":", ""),
            });
            this.properties.push({
                type: "Number",
                property: "decimalDigits",
                label: this.loc.get2("FormFormatEditor", "DecimalDigits").replace(":", ""),
            });
            this.properties.push({
                type: "TextEditor",
                property: "prefix",
                label: StiLocalizationService.get("PropertyMain", "Prefix"),
            });
            this.properties.push({
                type: "TextEditor",
                property: "suffix",
                label: StiLocalizationService.get("PropertyMain", "Suffix"),
            });
        }
    }
}
StiTableColumnEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableColumnEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiTableColumnEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableColumnEditorComponent, selector: "sti-table-column-editor", inputs: { column: "column", state: "state", index: "index", expression: "expression" }, ngImport: i0, template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="column-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let property of properties">
          <td *ngIf="property.label" [style.vertical-align]="property.type == 'FontEditor' ? 'top' : ''">
            <div class="label" [style.margin-top.px]="index == '0' ? 5 : 0">
              {{ property.label }}
            </div>
          </td>
          <td [colSpan]="property.type === 'divider' ? 8 : ''">
            <sti-font-editor
              *ngIf="property.type === 'FontEditor'"
              [object]="column"
              [property]="property"
            ></sti-font-editor>
            <sti-text-editor
              *ngIf="property.type === 'TextEditor'"
              [object]="column"
              [property]="property"
              [disabled]="needToDisable(property)"
            ></sti-text-editor>
            <sti-horizontal-alignment-editor
              [property]="property"
              *ngIf="property.type === 'horizontalAlignment'"
              [style]="{ width: '95%' }"
              [object]="column"
            ></sti-horizontal-alignment-editor>
            <sti-color-editor
              *ngIf="property.type === 'color'"
              [obj]="column"
              [property]="property"
              [style]="{ width: '95%' }"
            ></sti-color-editor>
            <sti-enum-editor
              *ngIf="property.type === 'enum'"
              [property]="property"
              [style]="{ width: '95%' }"
              [object]="column"
              [index]="index"
            ></sti-enum-editor>
            <sti-bool-editor
              [property]="property"
              *ngIf="property.type === 'checkbox'"
              [style]="{ width: '95%' }"
              [object]="column"
            ></sti-bool-editor>
            <sti-multiline-string-editor
              *ngIf="property.type === 'MultilineEditor'"
              [property]="property"
              [object]="column"
            ></sti-multiline-string-editor>
            <sti-number-editor
              *ngIf="property.type === 'Number'"
              [obj]="column"
              [property]="property"
            ></sti-number-editor>
            <sti-select-button-editor
              *ngIf="property.type === 'labelFormat'"
              [propertyType]="property.type"
              [object]="column"
              [property]="property.property"
            >
            </sti-select-button-editor>
            <sti-divider *ngIf="property.type === 'divider'"></sti-divider>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 150px;
        white-space: nowrap;
        color: var(--property-label-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .column-editor {
        overflow: hidden;
      }
      img {
        height: 16px;
        width: 16px;
        vertical-align: bottom;
      }
    </style>
  `, isInline: true, styles: ["\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      .label {\n        font-size: 13px;\n        font-weight: normal;\n        min-width: 150px;\n        white-space: nowrap;\n        color: var(--property-label-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .column-editor {\n        overflow: hidden;\n      }\n      img {\n        height: 16px;\n        width: 16px;\n        vertical-align: bottom;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiBoolEditorComponent, selector: "sti-bool-editor", inputs: ["property", "object"] }, { kind: "component", type: i7.StiColorEditorComponent, selector: "sti-color-editor", inputs: ["property", "textColor", "obj"] }, { kind: "component", type: i8.StiEnumEditorComponent, selector: "sti-enum-editor", inputs: ["property", "object", "index"] }, { kind: "component", type: i9.StiFontEditorComponent, selector: "sti-font-editor", inputs: ["property", "object"] }, { kind: "component", type: i10.StiMultilineStringEditorComponent, selector: "sti-multiline-string-editor", inputs: ["property", "object"] }, { kind: "component", type: i11.StiNumberEditorComponent, selector: "sti-number-editor", inputs: ["property", "obj"] }, { kind: "component", type: i12.StiTextEditorComponent, selector: "sti-text-editor", inputs: ["property", "object", "disabled"] }, { kind: "component", type: i13.StiHorizontalAlignmentEditorComponent, selector: "sti-horizontal-alignment-editor", inputs: ["property", "object"] }, { kind: "component", type: i14.StiSelectButtonEditorComponent, selector: "sti-select-button-editor", inputs: ["propertyType", "property", "object"] }, { kind: "component", type: i15.StiDividerComponent, selector: "sti-divider" }], animations: [SlideInOutAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableColumnEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-table-column-editor",
                    template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="column-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let property of properties">
          <td *ngIf="property.label" [style.vertical-align]="property.type == 'FontEditor' ? 'top' : ''">
            <div class="label" [style.margin-top.px]="index == '0' ? 5 : 0">
              {{ property.label }}
            </div>
          </td>
          <td [colSpan]="property.type === 'divider' ? 8 : ''">
            <sti-font-editor
              *ngIf="property.type === 'FontEditor'"
              [object]="column"
              [property]="property"
            ></sti-font-editor>
            <sti-text-editor
              *ngIf="property.type === 'TextEditor'"
              [object]="column"
              [property]="property"
              [disabled]="needToDisable(property)"
            ></sti-text-editor>
            <sti-horizontal-alignment-editor
              [property]="property"
              *ngIf="property.type === 'horizontalAlignment'"
              [style]="{ width: '95%' }"
              [object]="column"
            ></sti-horizontal-alignment-editor>
            <sti-color-editor
              *ngIf="property.type === 'color'"
              [obj]="column"
              [property]="property"
              [style]="{ width: '95%' }"
            ></sti-color-editor>
            <sti-enum-editor
              *ngIf="property.type === 'enum'"
              [property]="property"
              [style]="{ width: '95%' }"
              [object]="column"
              [index]="index"
            ></sti-enum-editor>
            <sti-bool-editor
              [property]="property"
              *ngIf="property.type === 'checkbox'"
              [style]="{ width: '95%' }"
              [object]="column"
            ></sti-bool-editor>
            <sti-multiline-string-editor
              *ngIf="property.type === 'MultilineEditor'"
              [property]="property"
              [object]="column"
            ></sti-multiline-string-editor>
            <sti-number-editor
              *ngIf="property.type === 'Number'"
              [obj]="column"
              [property]="property"
            ></sti-number-editor>
            <sti-select-button-editor
              *ngIf="property.type === 'labelFormat'"
              [propertyType]="property.type"
              [object]="column"
              [property]="property.property"
            >
            </sti-select-button-editor>
            <sti-divider *ngIf="property.type === 'divider'"></sti-divider>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 150px;
        white-space: nowrap;
        color: var(--property-label-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .column-editor {
        overflow: hidden;
      }
      img {
        height: 16px;
        width: 16px;
        vertical-align: bottom;
      }
    </style>
  `,
                    animations: [SlideInOutAnimation],
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }]; }, propDecorators: { column: [{
                type: Input
            }], state: [{
                type: Input
            }], index: [{
                type: Input
            }], expression: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGFibGUtY29sdW1uLWVkaXRvci5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvY29tcG9uZW50cy9wcm9wZXJ0eUdyaWQvZWRpdG9ycy90YWJsZS90YWJsZS1jb2x1bW4tZWRpdG9yL3RhYmxlLWNvbHVtbi1lZGl0b3IuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBRXpELE9BQU8sRUFBRSxxQkFBcUIsRUFBRSxNQUFNLDZEQUE2RCxDQUFDO0FBQ3BHLE9BQU8sRUFBRSxrQkFBa0IsRUFBRSxNQUFNLDBEQUEwRCxDQUFDO0FBQzlGLE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxNQUFNLDhEQUE4RCxDQUFDO0FBQ3RHLE9BQU8sRUFBRSxhQUFhLEVBQUUsTUFBTSw2Q0FBNkMsQ0FBQztBQUM1RSxPQUFPLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSxrREFBa0QsQ0FBQztBQUl0RixPQUFPLEVBQUUsc0JBQXNCLEVBQUUsTUFBTSxrREFBa0QsQ0FBQztBQUUxRixPQUFPLEVBQUUsYUFBYSxFQUFFLE1BQU0sNkJBQTZCLENBQUM7QUFDNUQsT0FBTyxFQUFFLG1CQUFtQixFQUFFLE1BQU0sbUNBQW1DLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBaUd4RSxNQUFNLE9BQU8sNkJBQTZCO0lBTXhDLFlBQ1MsS0FBc0IsRUFDdEIsTUFBd0IsRUFDeEIsS0FBc0IsRUFDdEIsR0FBMkI7UUFIM0IsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsV0FBTSxHQUFOLE1BQU0sQ0FBa0I7UUFDeEIsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsUUFBRyxHQUFILEdBQUcsQ0FBd0I7UUFMN0IsZUFBVSxHQUFHLEVBQUUsQ0FBQztJQU1wQixDQUFDO0lBRUosUUFBUTtRQUNOLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxLQUFLLENBQUMsNEJBQTRCLENBQUMsU0FBUyxDQUFDLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLENBQUM7SUFDbkYsQ0FBQztJQUNNLGFBQWEsQ0FBQyxRQUFRO1FBQzNCLElBQUksSUFBSSxDQUFDLE1BQU0sWUFBWSxrQkFBa0IsSUFBSSxJQUFJLENBQUMsTUFBTSxZQUFZLGtCQUFrQixFQUFFO1lBQzFGLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBTSxHQUFHLENBQUMsSUFBSSxRQUFRLENBQUMsUUFBUSxJQUFJLFFBQVEsRUFBRTtnQkFDbEUsT0FBTyxJQUFJLENBQUM7YUFDYjtpQkFBTSxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQU0sR0FBRyxDQUFDLElBQUksUUFBUSxDQUFDLFFBQVEsSUFBSSxRQUFRLEVBQUU7Z0JBQ3pFLE9BQU8sSUFBSSxDQUFDO2FBQ2I7aUJBQU07Z0JBQ0wsT0FBTyxLQUFLLENBQUM7YUFDZDtTQUNGO2FBQU07WUFDTCxPQUFPLEtBQUssQ0FBQztTQUNkO0lBQ0gsQ0FBQztJQUNELGdCQUFnQjtRQUNkLElBQUksQ0FBQyxVQUFVLEdBQUcsRUFBRSxDQUFDO1FBQ3JCLElBQUksSUFBSSxDQUFDLE1BQU0sWUFBWSxhQUFhLEVBQUU7WUFDeEMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsTUFBTSxFQUFFLFFBQVEsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUN2RixJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxZQUFZLEVBQUUsUUFBUSxFQUFFLE9BQU8sRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDO1lBQy9GLElBQUksSUFBSSxDQUFDLE1BQU0sWUFBWSxrQkFBa0IsRUFBRTtnQkFDN0MsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsWUFBWSxFQUFFLFFBQVEsRUFBRSxZQUFZLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUMsQ0FBQzthQUMxRztZQUNELElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUM7WUFDMUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsWUFBWSxFQUFFLFFBQVEsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUMvRixJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsUUFBUSxFQUFFLGlCQUFpQixFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsRUFBRSxDQUFDLENBQUM7WUFDeEcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLFFBQVEsRUFBRSxpQkFBaUIsRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLEVBQUUsQ0FBQyxDQUFDO1lBQ3hHLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO2dCQUNuQixJQUFJLEVBQUUscUJBQXFCO2dCQUMzQixRQUFRLEVBQUUsaUJBQWlCO2dCQUMzQixLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO2FBQ2xDLENBQUMsQ0FBQztZQUNILElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO2dCQUNuQixJQUFJLEVBQUUsVUFBVTtnQkFDaEIsUUFBUSxFQUFFLGFBQWE7Z0JBQ3ZCLFFBQVEsRUFBRSxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLHlCQUF5QixDQUFDO2dCQUMvRSxLQUFLLEVBQUUsR0FBRzthQUNYLENBQUMsQ0FBQztZQUNILElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUM7WUFDMUMsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLE1BQU0sWUFBWSxxQkFBcUIsQ0FBQyxFQUFFO2dCQUNuRCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztvQkFDbkIsSUFBSSxFQUFFLHFCQUFxQjtvQkFDM0IsUUFBUSxFQUFFLGVBQWU7b0JBQ3pCLEtBQUssRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxHQUFHLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO2lCQUNoRSxDQUFDLENBQUM7YUFDSjtZQUNELElBQUksSUFBSSxDQUFDLE1BQU0sWUFBWSxxQkFBcUIsRUFBRTtnQkFDaEQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7b0JBQ25CLElBQUksRUFBRSxpQkFBaUI7b0JBQ3ZCLFFBQVEsRUFBRSxpQkFBaUI7b0JBQzNCLEtBQUssRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7aUJBQ2hDLENBQUMsQ0FBQzthQUNKO1lBQ0QsSUFBSSxJQUFJLENBQUMsTUFBTSxZQUFZLHNCQUFzQixJQUFJLElBQUksQ0FBQyxNQUFNLFlBQVksa0JBQWtCLEVBQUU7Z0JBQzlGLElBQUksSUFBSSxDQUFDLE1BQU0sWUFBWSxzQkFBc0IsRUFBRTtvQkFDakQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7d0JBQ25CLElBQUksRUFBRSxNQUFNO3dCQUNaLFFBQVEsRUFBRSxZQUFZO3dCQUN0QixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxXQUFXLENBQUM7cUJBQy9ELENBQUMsQ0FBQztpQkFDSjtnQkFDRCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztvQkFDbkIsSUFBSSxFQUFFLE1BQU07b0JBQ1osUUFBUSxFQUFFLG1CQUFtQjtvQkFDN0IsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxXQUFXLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQztpQkFDN0QsQ0FBQyxDQUFDO2dCQUNILElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO29CQUNuQixJQUFJLEVBQUUsUUFBUTtvQkFDZCxRQUFRLEVBQUUsZUFBZTtvQkFDekIsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGtCQUFrQixFQUFFLGVBQWUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDO2lCQUMzRSxDQUFDLENBQUM7Z0JBQ0gsSUFBSSxJQUFJLENBQUMsTUFBTSxZQUFZLGtCQUFrQixFQUFFO29CQUM3QyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQzt3QkFDbkIsSUFBSSxFQUFFLFlBQVk7d0JBQ2xCLFFBQVEsRUFBRSxRQUFRO3dCQUNsQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxRQUFRLENBQUM7cUJBQzVELENBQUMsQ0FBQztvQkFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQzt3QkFDbkIsSUFBSSxFQUFFLFlBQVk7d0JBQ2xCLFFBQVEsRUFBRSxRQUFRO3dCQUNsQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxRQUFRLENBQUM7cUJBQzVELENBQUMsQ0FBQztpQkFDSjtnQkFDRCxJQUFJLElBQUksQ0FBQyxNQUFNLFlBQVksc0JBQXNCLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVLElBQUksYUFBYSxDQUFDLE9BQU8sRUFBRTtvQkFDcEcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7d0JBQ25CLElBQUksRUFBRSxZQUFZO3dCQUNsQixRQUFRLEVBQUUsV0FBVzt3QkFDckIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDO3FCQUMxRCxDQUFDLENBQUM7b0JBQ0gsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7d0JBQ25CLElBQUksRUFBRSxNQUFNO3dCQUNaLFFBQVEsRUFBRSxlQUFlO3dCQUN6QixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxlQUFlLENBQUM7cUJBQ25FLENBQUMsQ0FBQztpQkFDSjtxQkFBTSxJQUFJLElBQUksQ0FBQyxNQUFNLFlBQVksc0JBQXNCLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVLElBQUksYUFBYSxDQUFDLFFBQVEsRUFBRTtvQkFDNUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7d0JBQ25CLElBQUksRUFBRSxNQUFNO3dCQUNaLFFBQVEsRUFBRSxVQUFVO3dCQUNwQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGtCQUFrQixFQUFFLFVBQVUsQ0FBQztxQkFDbEUsQ0FBQyxDQUFDO29CQUNILElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO3dCQUNuQixJQUFJLEVBQUUsTUFBTTt3QkFDWixRQUFRLEVBQUUsZUFBZTt3QkFDekIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsZUFBZSxDQUFDO3FCQUNuRSxDQUFDLENBQUM7b0JBQ0gsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7d0JBQ25CLElBQUksRUFBRSxhQUFhO3dCQUNuQixRQUFRLEVBQUUscUJBQXFCO3dCQUMvQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxRQUFRLENBQUM7cUJBQzVELENBQUMsQ0FBQztpQkFDSjthQUNGO1lBRUQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLFFBQVEsRUFBRSxpQkFBaUIsRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLEVBQUUsQ0FBQyxDQUFDO1lBQ3hHLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxRQUFRLEVBQUUsZUFBZSxFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsRUFBRSxDQUFDLENBQUM7WUFDMUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLFFBQVEsRUFBRSxlQUFlLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUMxRyxJQUFJLENBQUMsQ0FBQyxJQUFJLENBQUMsTUFBTSxZQUFZLGtCQUFrQixDQUFDLEVBQUU7Z0JBQ2hELElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxRQUFRLEVBQUUsaUJBQWlCLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxFQUFFLENBQUMsQ0FBQzthQUMzRztTQUNGO2FBQU0sSUFBSSxJQUFJLENBQUMsTUFBTSxZQUFZLGtCQUFrQixFQUFFO1lBQ3BELElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLFlBQVksRUFBRSxRQUFRLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLENBQUM7WUFDakcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsWUFBWSxFQUFFLFFBQVEsRUFBRSxZQUFZLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUN6RyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztnQkFDbkIsSUFBSSxFQUFFLHFCQUFxQjtnQkFDM0IsUUFBUSxFQUFFLGlCQUFpQjtnQkFDM0IsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO2FBQ3hDLENBQUMsQ0FBQztZQUNILElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO2dCQUNuQixJQUFJLEVBQUUscUJBQXFCO2dCQUMzQixRQUFRLEVBQUUsZ0JBQWdCO2dCQUMxQixLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQzthQUNqRSxDQUFDLENBQUM7WUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsUUFBUSxFQUFFLGFBQWEsRUFBRSxLQUFLLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztZQUM3RSxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztnQkFDbkIsSUFBSSxFQUFFLE1BQU07Z0JBQ1osUUFBUSxFQUFFLG1CQUFtQjtnQkFDN0IsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxXQUFXLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQzthQUM3RCxDQUFDLENBQUM7WUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztnQkFDbkIsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsUUFBUSxFQUFFLGVBQWU7Z0JBQ3pCLEtBQUssRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxlQUFlLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQzthQUMzRSxDQUFDLENBQUM7WUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztnQkFDbkIsSUFBSSxFQUFFLFlBQVk7Z0JBQ2xCLFFBQVEsRUFBRSxRQUFRO2dCQUNsQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxRQUFRLENBQUM7YUFDNUQsQ0FBQyxDQUFDO1lBQ0gsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQ25CLElBQUksRUFBRSxZQUFZO2dCQUNsQixRQUFRLEVBQUUsUUFBUTtnQkFDbEIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsUUFBUSxDQUFDO2FBQzVELENBQUMsQ0FBQztTQUNKO0lBQ0gsQ0FBQzs7MEhBektVLDZCQUE2Qjs4R0FBN0IsNkJBQTZCLHVKQTdGOUI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQTBGVCxzK0RBQ1csQ0FBQyxtQkFBbUIsQ0FBQzsyRkFFdEIsNkJBQTZCO2tCQS9GekMsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUseUJBQXlCO29CQUNuQyxRQUFRLEVBQUU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQTBGVDtvQkFDRCxVQUFVLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQztpQkFDbEM7d01BRVUsTUFBTTtzQkFBZCxLQUFLO2dCQUNHLEtBQUs7c0JBQWIsS0FBSztnQkFDRyxLQUFLO3NCQUFiLEtBQUs7Z0JBQ0csVUFBVTtzQkFBbEIsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE9uSW5pdCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aVRhYmxlRWxlbWVudCB9IGZyb20gXCIuLi8uLi8uLi8uLi8uLi9lbGVtZW50cy9TdGlUYWJsZUVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpQ29tYm9Cb3hDb2x1bW5JdGVtIH0gZnJvbSBcIi4uLy4uLy4uLy4uLy4uL2VsZW1lbnRzL3RhYmxlL2NvbHVtbnMvU3RpQ29tYm9Cb3hDb2x1bW5JdGVtXCI7XHJcbmltcG9ydCB7IFN0aUxhYmVsQ29sdW1uSXRlbSB9IGZyb20gXCIuLi8uLi8uLi8uLi8uLi9lbGVtZW50cy90YWJsZS9jb2x1bW5zL1N0aUxhYmVsQ29sdW1uSXRlbVwiO1xyXG5pbXBvcnQgeyBTdGlOdW1iZXJCb3hDb2x1bW5JdGVtIH0gZnJvbSBcIi4uLy4uLy4uLy4uLy4uL2VsZW1lbnRzL3RhYmxlL2NvbHVtbnMvU3RpTnVtYmVyQm94Q29sdW1uSXRlbVwiO1xyXG5pbXBvcnQgeyBTdGlDb2x1bW5JdGVtIH0gZnJvbSBcIi4uLy4uLy4uLy4uLy4uL2VsZW1lbnRzL3RhYmxlL1N0aUNvbHVtbkl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpVG90YWxzRmllbGRJdGVtIH0gZnJvbSBcIi4uLy4uLy4uLy4uLy4uL2VsZW1lbnRzL3RhYmxlL1N0aVRvdGFsc0ZpZWxkSXRlbVwiO1xyXG5pbXBvcnQgeyBTdGlNb2RlbFNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vLi4vLi4vc2VydmljZXMvbW9kZWwuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlFZGl0b3JQcm9wZXJ0eSB9IGZyb20gXCIuLi8uLi8uLi8uLi8uLi9zZXJ2aWNlcy9vYmplY3RzXCI7XHJcbmltcG9ydCB7IFN0aUhlbHBlclNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vLi4vLi4vc2VydmljZXMvc3RpLWhlbHBlci5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUxvY2FsaXphdGlvblNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vLi4vLi4vc2VydmljZXMvc3RpLWxvY2FsaXphdGlvbi5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aVRoZW1lU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi8uLi9zZXJ2aWNlcy90aGVtZS5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aU51bWJlclR5cGUgfSBmcm9tIFwiLi4vLi4vLi4vLi4vLi4vc3lzdGVtL2VudW1zXCI7XHJcbmltcG9ydCB7IFNsaWRlSW5PdXRBbmltYXRpb24gfSBmcm9tIFwiLi4vLi4vLi4vLi4vYW5pbWF0aW9ucy9hbmltYXRpb25zXCI7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogXCJzdGktdGFibGUtY29sdW1uLWVkaXRvclwiLFxyXG4gIHRlbXBsYXRlOiBgXHJcbiAgICA8ZGl2IFtAc2xpZGVJbk91dF09XCJzdGF0ZSA/ICdpbicgOiAnb3V0J1wiIGNsYXNzPVwiY29sdW1uLWVkaXRvclwiPlxyXG4gICAgICA8dGFibGUgY2xhc3M9XCJzdGktY2xlYXJcIiBbc3R5bGVdPVwieyB3aWR0aDogJzEwMCUnIH1cIj5cclxuICAgICAgICA8dHIgKm5nRm9yPVwibGV0IHByb3BlcnR5IG9mIHByb3BlcnRpZXNcIj5cclxuICAgICAgICAgIDx0ZCAqbmdJZj1cInByb3BlcnR5LmxhYmVsXCIgW3N0eWxlLnZlcnRpY2FsLWFsaWduXT1cInByb3BlcnR5LnR5cGUgPT0gJ0ZvbnRFZGl0b3InID8gJ3RvcCcgOiAnJ1wiPlxyXG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwibGFiZWxcIiBbc3R5bGUubWFyZ2luLXRvcC5weF09XCJpbmRleCA9PSAnMCcgPyA1IDogMFwiPlxyXG4gICAgICAgICAgICAgIHt7IHByb3BlcnR5LmxhYmVsIH19XHJcbiAgICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgPC90ZD5cclxuICAgICAgICAgIDx0ZCBbY29sU3Bhbl09XCJwcm9wZXJ0eS50eXBlID09PSAnZGl2aWRlcicgPyA4IDogJydcIj5cclxuICAgICAgICAgICAgPHN0aS1mb250LWVkaXRvclxyXG4gICAgICAgICAgICAgICpuZ0lmPVwicHJvcGVydHkudHlwZSA9PT0gJ0ZvbnRFZGl0b3InXCJcclxuICAgICAgICAgICAgICBbb2JqZWN0XT1cImNvbHVtblwiXHJcbiAgICAgICAgICAgICAgW3Byb3BlcnR5XT1cInByb3BlcnR5XCJcclxuICAgICAgICAgICAgPjwvc3RpLWZvbnQtZWRpdG9yPlxyXG4gICAgICAgICAgICA8c3RpLXRleHQtZWRpdG9yXHJcbiAgICAgICAgICAgICAgKm5nSWY9XCJwcm9wZXJ0eS50eXBlID09PSAnVGV4dEVkaXRvcidcIlxyXG4gICAgICAgICAgICAgIFtvYmplY3RdPVwiY29sdW1uXCJcclxuICAgICAgICAgICAgICBbcHJvcGVydHldPVwicHJvcGVydHlcIlxyXG4gICAgICAgICAgICAgIFtkaXNhYmxlZF09XCJuZWVkVG9EaXNhYmxlKHByb3BlcnR5KVwiXHJcbiAgICAgICAgICAgID48L3N0aS10ZXh0LWVkaXRvcj5cclxuICAgICAgICAgICAgPHN0aS1ob3Jpem9udGFsLWFsaWdubWVudC1lZGl0b3JcclxuICAgICAgICAgICAgICBbcHJvcGVydHldPVwicHJvcGVydHlcIlxyXG4gICAgICAgICAgICAgICpuZ0lmPVwicHJvcGVydHkudHlwZSA9PT0gJ2hvcml6b250YWxBbGlnbm1lbnQnXCJcclxuICAgICAgICAgICAgICBbc3R5bGVdPVwieyB3aWR0aDogJzk1JScgfVwiXHJcbiAgICAgICAgICAgICAgW29iamVjdF09XCJjb2x1bW5cIlxyXG4gICAgICAgICAgICA+PC9zdGktaG9yaXpvbnRhbC1hbGlnbm1lbnQtZWRpdG9yPlxyXG4gICAgICAgICAgICA8c3RpLWNvbG9yLWVkaXRvclxyXG4gICAgICAgICAgICAgICpuZ0lmPVwicHJvcGVydHkudHlwZSA9PT0gJ2NvbG9yJ1wiXHJcbiAgICAgICAgICAgICAgW29ial09XCJjb2x1bW5cIlxyXG4gICAgICAgICAgICAgIFtwcm9wZXJ0eV09XCJwcm9wZXJ0eVwiXHJcbiAgICAgICAgICAgICAgW3N0eWxlXT1cInsgd2lkdGg6ICc5NSUnIH1cIlxyXG4gICAgICAgICAgICA+PC9zdGktY29sb3ItZWRpdG9yPlxyXG4gICAgICAgICAgICA8c3RpLWVudW0tZWRpdG9yXHJcbiAgICAgICAgICAgICAgKm5nSWY9XCJwcm9wZXJ0eS50eXBlID09PSAnZW51bSdcIlxyXG4gICAgICAgICAgICAgIFtwcm9wZXJ0eV09XCJwcm9wZXJ0eVwiXHJcbiAgICAgICAgICAgICAgW3N0eWxlXT1cInsgd2lkdGg6ICc5NSUnIH1cIlxyXG4gICAgICAgICAgICAgIFtvYmplY3RdPVwiY29sdW1uXCJcclxuICAgICAgICAgICAgICBbaW5kZXhdPVwiaW5kZXhcIlxyXG4gICAgICAgICAgICA+PC9zdGktZW51bS1lZGl0b3I+XHJcbiAgICAgICAgICAgIDxzdGktYm9vbC1lZGl0b3JcclxuICAgICAgICAgICAgICBbcHJvcGVydHldPVwicHJvcGVydHlcIlxyXG4gICAgICAgICAgICAgICpuZ0lmPVwicHJvcGVydHkudHlwZSA9PT0gJ2NoZWNrYm94J1wiXHJcbiAgICAgICAgICAgICAgW3N0eWxlXT1cInsgd2lkdGg6ICc5NSUnIH1cIlxyXG4gICAgICAgICAgICAgIFtvYmplY3RdPVwiY29sdW1uXCJcclxuICAgICAgICAgICAgPjwvc3RpLWJvb2wtZWRpdG9yPlxyXG4gICAgICAgICAgICA8c3RpLW11bHRpbGluZS1zdHJpbmctZWRpdG9yXHJcbiAgICAgICAgICAgICAgKm5nSWY9XCJwcm9wZXJ0eS50eXBlID09PSAnTXVsdGlsaW5lRWRpdG9yJ1wiXHJcbiAgICAgICAgICAgICAgW3Byb3BlcnR5XT1cInByb3BlcnR5XCJcclxuICAgICAgICAgICAgICBbb2JqZWN0XT1cImNvbHVtblwiXHJcbiAgICAgICAgICAgID48L3N0aS1tdWx0aWxpbmUtc3RyaW5nLWVkaXRvcj5cclxuICAgICAgICAgICAgPHN0aS1udW1iZXItZWRpdG9yXHJcbiAgICAgICAgICAgICAgKm5nSWY9XCJwcm9wZXJ0eS50eXBlID09PSAnTnVtYmVyJ1wiXHJcbiAgICAgICAgICAgICAgW29ial09XCJjb2x1bW5cIlxyXG4gICAgICAgICAgICAgIFtwcm9wZXJ0eV09XCJwcm9wZXJ0eVwiXHJcbiAgICAgICAgICAgID48L3N0aS1udW1iZXItZWRpdG9yPlxyXG4gICAgICAgICAgICA8c3RpLXNlbGVjdC1idXR0b24tZWRpdG9yXHJcbiAgICAgICAgICAgICAgKm5nSWY9XCJwcm9wZXJ0eS50eXBlID09PSAnbGFiZWxGb3JtYXQnXCJcclxuICAgICAgICAgICAgICBbcHJvcGVydHlUeXBlXT1cInByb3BlcnR5LnR5cGVcIlxyXG4gICAgICAgICAgICAgIFtvYmplY3RdPVwiY29sdW1uXCJcclxuICAgICAgICAgICAgICBbcHJvcGVydHldPVwicHJvcGVydHkucHJvcGVydHlcIlxyXG4gICAgICAgICAgICA+XHJcbiAgICAgICAgICAgIDwvc3RpLXNlbGVjdC1idXR0b24tZWRpdG9yPlxyXG4gICAgICAgICAgICA8c3RpLWRpdmlkZXIgKm5nSWY9XCJwcm9wZXJ0eS50eXBlID09PSAnZGl2aWRlcidcIj48L3N0aS1kaXZpZGVyPlxyXG4gICAgICAgICAgPC90ZD5cclxuICAgICAgICA8L3RyPlxyXG4gICAgICA8L3RhYmxlPlxyXG4gICAgPC9kaXY+XHJcbiAgICA8c3R5bGU+XHJcbiAgICAgIHRyIHtcclxuICAgICAgICBwYWRkaW5nOiAzcHggMHB4IDNweCAwcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmxhYmVsIHtcclxuICAgICAgICBmb250LXNpemU6IDEzcHg7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6IG5vcm1hbDtcclxuICAgICAgICBtaW4td2lkdGg6IDE1MHB4O1xyXG4gICAgICAgIHdoaXRlLXNwYWNlOiBub3dyYXA7XHJcbiAgICAgICAgY29sb3I6IHZhcigtLXByb3BlcnR5LWxhYmVsLWNvbG9yKTtcclxuICAgICAgICAtd2Via2l0LXRvdWNoLWNhbGxvdXQ6IG5vbmU7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgfVxyXG4gICAgICAuY29sdW1uLWVkaXRvciB7XHJcbiAgICAgICAgb3ZlcmZsb3c6IGhpZGRlbjtcclxuICAgICAgfVxyXG4gICAgICBpbWcge1xyXG4gICAgICAgIGhlaWdodDogMTZweDtcclxuICAgICAgICB3aWR0aDogMTZweDtcclxuICAgICAgICB2ZXJ0aWNhbC1hbGlnbjogYm90dG9tO1xyXG4gICAgICB9XHJcbiAgICA8L3N0eWxlPlxyXG4gIGAsXHJcbiAgYW5pbWF0aW9uczogW1NsaWRlSW5PdXRBbmltYXRpb25dLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgU3RpVGFibGVDb2x1bW5FZGl0b3JDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG4gIEBJbnB1dCgpIGNvbHVtbjtcclxuICBASW5wdXQoKSBzdGF0ZTogYm9vbGVhbjtcclxuICBASW5wdXQoKSBpbmRleDtcclxuICBASW5wdXQoKSBleHByZXNzaW9uPztcclxuICBwdWJsaWMgcHJvcGVydGllcyA9IFtdO1xyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgcHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UsXHJcbiAgICBwdWJsaWMgaGVscGVyOiBTdGlIZWxwZXJTZXJ2aWNlLFxyXG4gICAgcHVibGljIHRoZW1lOiBTdGlUaGVtZVNlcnZpY2UsXHJcbiAgICBwdWJsaWMgbG9jOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlXHJcbiAgKSB7fVxyXG5cclxuICBuZ09uSW5pdCgpOiB2b2lkIHtcclxuICAgIHRoaXMudXBkYXRlUHJvcGVydGllcygpO1xyXG4gICAgdGhpcy5tb2RlbC5uZWVkVG9SZWZyZXNoSW5uZXJQcm9wZXJ0aWVzLnN1YnNjcmliZSgoKSA9PiB0aGlzLnVwZGF0ZVByb3BlcnRpZXMoKSk7XHJcbiAgfVxyXG4gIHB1YmxpYyBuZWVkVG9EaXNhYmxlKHByb3BlcnR5KSB7XHJcbiAgICBpZiAodGhpcy5jb2x1bW4gaW5zdGFuY2VvZiBTdGlMYWJlbENvbHVtbkl0ZW0gfHwgdGhpcy5jb2x1bW4gaW5zdGFuY2VvZiBTdGlUb3RhbHNGaWVsZEl0ZW0pIHtcclxuICAgICAgaWYgKHRoaXMuY29sdW1uLnByZWZpeC5sZW5ndGggPiAwICYmIHByb3BlcnR5LnByb3BlcnR5ID09IFwic3VmZml4XCIpIHtcclxuICAgICAgICByZXR1cm4gdHJ1ZTtcclxuICAgICAgfSBlbHNlIGlmICh0aGlzLmNvbHVtbi5zdWZmaXgubGVuZ3RoID4gMCAmJiBwcm9wZXJ0eS5wcm9wZXJ0eSA9PSBcInByZWZpeFwiKSB7XHJcbiAgICAgICAgcmV0dXJuIHRydWU7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xyXG4gICAgICB9XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gZmFsc2U7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHVwZGF0ZVByb3BlcnRpZXMoKSB7XHJcbiAgICB0aGlzLnByb3BlcnRpZXMgPSBbXTtcclxuICAgIGlmICh0aGlzLmNvbHVtbiBpbnN0YW5jZW9mIFN0aUNvbHVtbkl0ZW0pIHtcclxuICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goeyB0eXBlOiBcImVudW1cIiwgcHJvcGVydHk6IFwidHlwZVwiLCBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIlR5cGVcIikgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJUZXh0RWRpdG9yXCIsIHByb3BlcnR5OiBcImxhYmVsXCIsIGxhYmVsOiB0aGlzLmxvYy5nZXRQKFwiTGFiZWxcIikgfSk7XHJcbiAgICAgIGlmICh0aGlzLmNvbHVtbiBpbnN0YW5jZW9mIFN0aUxhYmVsQ29sdW1uSXRlbSkge1xyXG4gICAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJUZXh0RWRpdG9yXCIsIHByb3BlcnR5OiBcImV4cHJlc3Npb25cIiwgbGFiZWw6IHRoaXMubG9jLmdldFAoXCJFeHByZXNzaW9uXCIpIH0pO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJkaXZpZGVyXCIgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJGb250RWRpdG9yXCIsIHByb3BlcnR5OiBcImZvbnRcIiwgbGFiZWw6IHRoaXMubG9jLmdldFAoXCJIZWFkZXJcIikgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJjb2xvclwiLCBwcm9wZXJ0eTogXCJoZWFkZXJCYWNrQ29sb3JcIiwgbGFiZWw6IHRoaXMubG9jLmdldFAoXCJCYWNrQ29sb3JcIikgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJjb2xvclwiLCBwcm9wZXJ0eTogXCJoZWFkZXJGb3JlQ29sb3JcIiwgbGFiZWw6IHRoaXMubG9jLmdldFAoXCJGb3JlQ29sb3JcIikgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcImhvcml6b250YWxBbGlnbm1lbnRcIixcclxuICAgICAgICBwcm9wZXJ0eTogXCJoZWFkZXJBbGlnbm1lbnRcIixcclxuICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkFsaWdubWVudFwiKSxcclxuICAgICAgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcImNoZWNrYm94XCIsXHJcbiAgICAgICAgcHJvcGVydHk6IFwidXNlV29yZFdyYXBcIixcclxuICAgICAgICBjaGVja2JveDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eUVudW1cIiwgXCJTdGlUZXh0U2l6ZU1vZGVXb3JkV3JhcFwiKSxcclxuICAgICAgICBsYWJlbDogXCIgXCIsXHJcbiAgICAgIH0pO1xyXG4gICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7IHR5cGU6IFwiZGl2aWRlclwiIH0pO1xyXG4gICAgICBpZiAoISh0aGlzLmNvbHVtbiBpbnN0YW5jZW9mIFN0aUNvbWJvQm94Q29sdW1uSXRlbSkpIHtcclxuICAgICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgICAgICB0eXBlOiBcImhvcml6b250YWxBbGlnbm1lbnRcIixcclxuICAgICAgICAgIHByb3BlcnR5OiBcImNlbGxBbGlnbm1lbnRcIixcclxuICAgICAgICAgIGxhYmVsOiB0aGlzLmxvYy5nZXRQKFwiQ2VsbFwiKSArIFwiIFwiICsgdGhpcy5sb2MuZ2V0UChcIkFsaWdubWVudFwiKSxcclxuICAgICAgICB9KTtcclxuICAgICAgfVxyXG4gICAgICBpZiAodGhpcy5jb2x1bW4gaW5zdGFuY2VvZiBTdGlDb21ib0JveENvbHVtbkl0ZW0pIHtcclxuICAgICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgICAgICB0eXBlOiBcIk11bHRpbGluZUVkaXRvclwiLFxyXG4gICAgICAgICAgcHJvcGVydHk6IFwiY29tYm9Cb3hPcHRpb25zXCIsXHJcbiAgICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIk9wdGlvbnNcIiksXHJcbiAgICAgICAgfSk7XHJcbiAgICAgIH1cclxuICAgICAgaWYgKHRoaXMuY29sdW1uIGluc3RhbmNlb2YgU3RpTnVtYmVyQm94Q29sdW1uSXRlbSB8fCB0aGlzLmNvbHVtbiBpbnN0YW5jZW9mIFN0aUxhYmVsQ29sdW1uSXRlbSkge1xyXG4gICAgICAgIGlmICh0aGlzLmNvbHVtbiBpbnN0YW5jZW9mIFN0aU51bWJlckJveENvbHVtbkl0ZW0pIHtcclxuICAgICAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICAgICAgdHlwZTogXCJlbnVtXCIsXHJcbiAgICAgICAgICAgIHByb3BlcnR5OiBcIm51bWJlclR5cGVcIixcclxuICAgICAgICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiVmFsdWVUeXBlXCIpLFxyXG4gICAgICAgICAgfSk7XHJcbiAgICAgICAgfVxyXG4gICAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICAgIHR5cGU6IFwiZW51bVwiLFxyXG4gICAgICAgICAgcHJvcGVydHk6IFwidGhvdXNhbmRTZXBhcmF0b3JcIixcclxuICAgICAgICAgIGxhYmVsOiB0aGlzLmxvYy5nZXQyKFwiRXhwb3J0XCIsIFwiU2VwYXJhdG9yXCIpLnJlcGxhY2UoXCI6XCIsIFwiXCIpLFxyXG4gICAgICAgIH0pO1xyXG4gICAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICAgIHR5cGU6IFwiTnVtYmVyXCIsXHJcbiAgICAgICAgICBwcm9wZXJ0eTogXCJkZWNpbWFsRGlnaXRzXCIsXHJcbiAgICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0MihcIkZvcm1Gb3JtYXRFZGl0b3JcIiwgXCJEZWNpbWFsRGlnaXRzXCIpLnJlcGxhY2UoXCI6XCIsIFwiXCIpLFxyXG4gICAgICAgIH0pO1xyXG4gICAgICAgIGlmICh0aGlzLmNvbHVtbiBpbnN0YW5jZW9mIFN0aUxhYmVsQ29sdW1uSXRlbSkge1xyXG4gICAgICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgICAgICB0eXBlOiBcIlRleHRFZGl0b3JcIixcclxuICAgICAgICAgICAgcHJvcGVydHk6IFwicHJlZml4XCIsXHJcbiAgICAgICAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIlByZWZpeFwiKSxcclxuICAgICAgICAgIH0pO1xyXG4gICAgICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgICAgICB0eXBlOiBcIlRleHRFZGl0b3JcIixcclxuICAgICAgICAgICAgcHJvcGVydHk6IFwic3VmZml4XCIsXHJcbiAgICAgICAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIlN1ZmZpeFwiKSxcclxuICAgICAgICAgIH0pO1xyXG4gICAgICAgIH1cclxuICAgICAgICBpZiAodGhpcy5jb2x1bW4gaW5zdGFuY2VvZiBTdGlOdW1iZXJCb3hDb2x1bW5JdGVtICYmIHRoaXMuY29sdW1uLm51bWJlclR5cGUgPT0gU3RpTnVtYmVyVHlwZS5EZWNpbWFsKSB7XHJcbiAgICAgICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgICAgICAgIHR5cGU6IFwiVGV4dEVkaXRvclwiLFxyXG4gICAgICAgICAgICBwcm9wZXJ0eTogXCJ1bml0TGFiZWxcIixcclxuICAgICAgICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiVW5pdFwiKSxcclxuICAgICAgICAgIH0pO1xyXG4gICAgICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgICAgICB0eXBlOiBcImVudW1cIixcclxuICAgICAgICAgICAgcHJvcGVydHk6IFwidW5pdEFsaWdubWVudFwiLFxyXG4gICAgICAgICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJVbml0QWxpZ25tZW50XCIpLFxyXG4gICAgICAgICAgfSk7XHJcbiAgICAgICAgfSBlbHNlIGlmICh0aGlzLmNvbHVtbiBpbnN0YW5jZW9mIFN0aU51bWJlckJveENvbHVtbkl0ZW0gJiYgdGhpcy5jb2x1bW4ubnVtYmVyVHlwZSA9PSBTdGlOdW1iZXJUeXBlLkN1cnJlbmN5KSB7XHJcbiAgICAgICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgICAgICAgIHR5cGU6IFwiZW51bVwiLFxyXG4gICAgICAgICAgICBwcm9wZXJ0eTogXCJjdXJyZW5jeVwiLFxyXG4gICAgICAgICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJGb3JtRm9ybWF0RWRpdG9yXCIsIFwiQ3VycmVuY3lcIiksXHJcbiAgICAgICAgICB9KTtcclxuICAgICAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICAgICAgdHlwZTogXCJlbnVtXCIsXHJcbiAgICAgICAgICAgIHByb3BlcnR5OiBcInVuaXRBbGlnbm1lbnRcIixcclxuICAgICAgICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiVW5pdEFsaWdubWVudFwiKSxcclxuICAgICAgICAgIH0pO1xyXG4gICAgICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgICAgICB0eXBlOiBcImxhYmVsRm9ybWF0XCIsXHJcbiAgICAgICAgICAgIHByb3BlcnR5OiBcImN1cnJlbmN5TGFiZWxGb3JtYXRcIixcclxuICAgICAgICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiU2hvd0FzXCIpLFxyXG4gICAgICAgICAgfSk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcblxyXG4gICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7IHR5cGU6IFwiY29sb3JcIiwgcHJvcGVydHk6IFwiYmFja2dyb3VuZENvbG9yXCIsIGxhYmVsOiB0aGlzLmxvYy5nZXRQKFwiQmFja0NvbG9yXCIpIH0pO1xyXG4gICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7IHR5cGU6IFwiY29sb3JcIiwgcHJvcGVydHk6IFwiY2VsbEJhY2tDb2xvclwiLCBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkNlbGxCYWNrQ29sb3JcIikgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJjb2xvclwiLCBwcm9wZXJ0eTogXCJjZWxsRm9yZUNvbG9yXCIsIGxhYmVsOiB0aGlzLmxvYy5nZXRQKFwiQ2VsbEZvcmVDb2xvclwiKSB9KTtcclxuICAgICAgaWYgKCEodGhpcy5jb2x1bW4gaW5zdGFuY2VvZiBTdGlMYWJlbENvbHVtbkl0ZW0pKSB7XHJcbiAgICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goeyB0eXBlOiBcImNvbG9yXCIsIHByb3BlcnR5OiBcImNlbGxCb3JkZXJDb2xvclwiLCBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkJvcmRlckNvbG9yXCIpIH0pO1xyXG4gICAgICB9XHJcbiAgICB9IGVsc2UgaWYgKHRoaXMuY29sdW1uIGluc3RhbmNlb2YgU3RpVG90YWxzRmllbGRJdGVtKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJUZXh0RWRpdG9yXCIsIHByb3BlcnR5OiBcImhlYWRlclwiLCBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkhlYWRlclwiKSB9KTtcclxuICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goeyB0eXBlOiBcIlRleHRFZGl0b3JcIiwgcHJvcGVydHk6IFwiZXhwcmVzc2lvblwiLCBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkV4cHJlc3Npb25cIikgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcImhvcml6b250YWxBbGlnbm1lbnRcIixcclxuICAgICAgICBwcm9wZXJ0eTogXCJoZWFkZXJBbGlnbm1lbnRcIixcclxuICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkhlYWRlckFsaWdubWVudFwiKSxcclxuICAgICAgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcImhvcml6b250YWxBbGlnbm1lbnRcIixcclxuICAgICAgICBwcm9wZXJ0eTogXCJ2YWx1ZUFsaWdubWVudFwiLFxyXG4gICAgICAgIGxhYmVsOiB0aGlzLmxvYy5nZXRQKFwiVmFsdWVcIikgKyBcIiBcIiArIHRoaXMubG9jLmdldFAoXCJBbGlnbm1lbnRcIiksXHJcbiAgICAgIH0pO1xyXG4gICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7IHR5cGU6IFwiY29sb3JcIiwgcHJvcGVydHk6IFwiaGVhZGVyQ29sb3JcIiwgbGFiZWw6IFwiIFwiIH0pO1xyXG4gICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgICAgdHlwZTogXCJlbnVtXCIsXHJcbiAgICAgICAgcHJvcGVydHk6IFwidGhvdXNhbmRTZXBhcmF0b3JcIixcclxuICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0MihcIkV4cG9ydFwiLCBcIlNlcGFyYXRvclwiKS5yZXBsYWNlKFwiOlwiLCBcIlwiKSxcclxuICAgICAgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcIk51bWJlclwiLFxyXG4gICAgICAgIHByb3BlcnR5OiBcImRlY2ltYWxEaWdpdHNcIixcclxuICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0MihcIkZvcm1Gb3JtYXRFZGl0b3JcIiwgXCJEZWNpbWFsRGlnaXRzXCIpLnJlcGxhY2UoXCI6XCIsIFwiXCIpLFxyXG4gICAgICB9KTtcclxuICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgIHR5cGU6IFwiVGV4dEVkaXRvclwiLFxyXG4gICAgICAgIHByb3BlcnR5OiBcInByZWZpeFwiLFxyXG4gICAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIlByZWZpeFwiKSxcclxuICAgICAgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcIlRleHRFZGl0b3JcIixcclxuICAgICAgICBwcm9wZXJ0eTogXCJzdWZmaXhcIixcclxuICAgICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJTdWZmaXhcIiksXHJcbiAgICAgIH0pO1xyXG4gICAgfVxyXG4gIH1cclxufVxyXG4iXX0=