import { Component, Input } from "@angular/core";
import { SlideInOutAnimation } from "../../../../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/model.service";
import * as i2 from "../../../../../services/sti-helper.service";
import * as i3 from "../../../../../services/theme.service";
import * as i4 from "../../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../../sti-color-editor/sti-color-editor.component";
import * as i7 from "../../sti-enum-editor/sti-enum-editor.component";
import * as i8 from "../../sti-number-editor/sti-number-editor.component";
import * as i9 from "../border-sides-editor/border-sides-editor.component";
export class StiTableBorderEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.properties = [];
    }
    ngOnInit() {
        this.properties = [];
        this.properties.push({
            type: "borderAlignment",
            property: this.getProperty(this.property.property),
            label: this.loc.getP("Sides"),
        });
        this.properties.push({ type: "color", property: "color", label: this.loc.getP("Color") });
        this.properties.push({ type: "Number", property: "width", label: this.loc.getP("LineWidth") });
        this.properties.push({ type: "enum", property: "style", label: this.loc.getP("Style") });
        //
    }
    getProperty(property) {
        if (property == "showBorderEditor") {
            return "border";
        }
        else if (property == "showColumnsBorderEditor") {
            return "columnHeadersBorder";
        }
        else if (property == "showRowsBorderEditor") {
            return "rowHeadersBorder";
        }
        else {
            return "gridLines";
        }
    }
    get content() {
        return this.helper.getProperty(this.model.selectedComponent.element, this.property.property);
    }
    set content(value) {
        this.helper.setProperty(this.model.selectedComponent.element, this.property.property, value);
    }
}
StiTableBorderEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableBorderEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiTableBorderEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableBorderEditorComponent, selector: "sti-table-border-editor", inputs: { property: "property", state: "state", object: "object" }, ngImport: i0, template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="border-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let prop of properties; index as i">
          <td *ngIf="prop.label">
            <div class="label" [style.margin-top.px]="i == '0' ? 5 : 0">
              {{ prop.label }}
            </div>
          </td>
          <td>
            <sti-border-sides-editor
              *ngIf="prop.type === 'borderAlignment'"
              [property]="prop"
              [object]="object"
              [style]="{ width: '95%' }"
            ></sti-border-sides-editor>
            <sti-color-editor
              *ngIf="prop.type === 'color'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [obj]="object?.pen"
            ></sti-color-editor>
            <sti-enum-editor
              *ngIf="prop.type === 'enum'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [object]="object?.pen"
            ></sti-enum-editor>
            <sti-number-editor *ngIf="prop.type === 'Number'" [obj]="object?.pen" [property]="prop"></sti-number-editor>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 150px;
        white-space: nowrap;
        color: var(--property-label-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .border-editor {
        overflow: hidden;
      }
    </style>
  `, isInline: true, styles: ["\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      .label {\n        font-size: 13px;\n        font-weight: normal;\n        min-width: 150px;\n        white-space: nowrap;\n        color: var(--property-label-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .border-editor {\n        overflow: hidden;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiColorEditorComponent, selector: "sti-color-editor", inputs: ["property", "textColor", "obj"] }, { kind: "component", type: i7.StiEnumEditorComponent, selector: "sti-enum-editor", inputs: ["property", "object", "index"] }, { kind: "component", type: i8.StiNumberEditorComponent, selector: "sti-number-editor", inputs: ["property", "obj"] }, { kind: "component", type: i9.StiBorderSidesEditorComponent, selector: "sti-border-sides-editor", inputs: ["property", "object"] }], animations: [SlideInOutAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableBorderEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-table-border-editor",
                    template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="border-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let prop of properties; index as i">
          <td *ngIf="prop.label">
            <div class="label" [style.margin-top.px]="i == '0' ? 5 : 0">
              {{ prop.label }}
            </div>
          </td>
          <td>
            <sti-border-sides-editor
              *ngIf="prop.type === 'borderAlignment'"
              [property]="prop"
              [object]="object"
              [style]="{ width: '95%' }"
            ></sti-border-sides-editor>
            <sti-color-editor
              *ngIf="prop.type === 'color'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [obj]="object?.pen"
            ></sti-color-editor>
            <sti-enum-editor
              *ngIf="prop.type === 'enum'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [object]="object?.pen"
            ></sti-enum-editor>
            <sti-number-editor *ngIf="prop.type === 'Number'" [obj]="object?.pen" [property]="prop"></sti-number-editor>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 150px;
        white-space: nowrap;
        color: var(--property-label-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .border-editor {
        overflow: hidden;
      }
    </style>
  `,
                    animations: [SlideInOutAnimation],
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }]; }, propDecorators: { property: [{
                type: Input
            }], state: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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