import { Component, Input } from "@angular/core";
import StiInnerBorder from "../../../../../properties/StiInnerBorder";
import { StiBorder } from "../../../../../properties/StiBorder";
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/model.service";
import * as i2 from "../../../../../services/sti-helper.service";
import * as i3 from "../../../../../services/theme.service";
import * as i4 from "../../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../../../../sti-tooltip/sti-tooltip.directive";
export class StiBorderSidesEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
    }
    get borderAlignments() {
        let alignments = this.helper.getProperty(this.model.selectedComponent.element, this.property.property);
        return alignments.values;
    }
    set borderAlignments(value) {
        this.helper.getProperty(this.model.selectedComponent.element, this.property.property).addValues(value);
    }
    setAll() {
        if (this.object instanceof StiBorder) {
            this.object.drawTop = true;
            this.object.drawLeft = true;
            this.object.drawBottom = true;
            this.object.drawRight = true;
        }
        else if (this.object instanceof StiInnerBorder) {
            this.object.drawHorizontal = true;
            this.object.drawVertical = true;
        }
    }
    setNone() {
        if (this.object instanceof StiBorder) {
            this.object.drawTop = false;
            this.object.drawLeft = false;
            this.object.drawBottom = false;
            this.object.drawRight = false;
        }
        else if (this.object instanceof StiInnerBorder) {
            this.object.drawHorizontal = false;
            this.object.drawVertical = false;
        }
    }
    changeState(value) {
        this.object[value] = !this.object[value];
    }
    ngOnInit() { }
}
StiBorderSidesEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBorderSidesEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiBorderSidesEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiBorderSidesEditorComponent, selector: "sti-border-sides-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7" *ngIf="property.property != 'gridLines'">
          <div class="button-group">
            <div
              class="button {{
                object.drawTop && object.drawLeft && object.drawBottom && object.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('All')" alt="" />
            </div>
            <div
              class="button {{
                !object.drawTop && !object.drawLeft && !object.drawBottom && !object.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('None')" alt="" />
            </div>
            <div
              class="button {{ object.drawTop ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Top')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawTop')"
            >
              <img [src]="theme.getIcon('Top')" alt="" />
            </div>
            <div
              class="button {{ object.drawLeft ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Left')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawLeft')"
            >
              <img [src]="theme.getIcon('Left')" alt="" />
            </div>
            <div
              class="button {{ object.drawBottom ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Bottom')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawBottom')"
            >
              <img [src]="theme.getIcon('Bottom')" alt="" />
            </div>
            <div
              class="button {{ object.drawRight ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Right')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawRight')"
            >
              <img [src]="theme.getIcon('Right')" alt="" />
            </div>
          </div>
        </td>
        <td colspan="7" *ngIf="property.property == 'gridLines'">
          <div class="button-group">
            <div
              class="button {{ object.drawHorizontal && object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('GridAll')" alt="" />
            </div>
            <div
              class="button {{ !object.drawHorizontal && !object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('GridNone')" alt="" />
            </div>
            <div
              class="button {{ object.drawHorizontal ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'StiOrientationHorizontal')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawHorizontal')"
            >
              <img [src]="theme.getIcon('Horizontal')" alt="" />
            </div>
            <div
              class="button {{ object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'StiOrientationVertical')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawVertical')"
            >
              <img [src]="theme.getIcon('Vertical')" alt="" />
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        text-align: end;
      }
      tr {
        padding: 3px 0px 3px 0px;
      }
      .active {
        background-color: var(--active-color) !important;
      }
      .active:hover {
        background-color: var(--active-color) !important;
      }
      .button-group {
        display: flex;
        width: 100%;
        flex-direction: row;
        justify-content: start;
      }
      .button {
        height: 22px;
        width: 28px;
        background-color: var(--back-color);
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .button img {
        height: 16px;
        width: 16px;
      }
      .button:hover {
        background-color: var(--hover-color);
      }
      .button:active {
        background-color: var(--active-color);
      }
      .draw-grid-all {
        background: var(--gridAll-icon);
      }
      .draw-grid-none {
        background: var(--gridNone-icon);
      }
      .draw-horizontal {
        background: var(--gridHorizontal-icon);
      }
      .draw-vertical {
        background: var(--gridVertical-icon);
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        text-align: end;\n      }\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      .active {\n        background-color: var(--active-color) !important;\n      }\n      .active:hover {\n        background-color: var(--active-color) !important;\n      }\n      .button-group {\n        display: flex;\n        width: 100%;\n        flex-direction: row;\n        justify-content: start;\n      }\n      .button {\n        height: 22px;\n        width: 28px;\n        background-color: var(--back-color);\n        display: flex;\n        align-items: center;\n        justify-content: center;\n      }\n      .button img {\n        height: 16px;\n        width: 16px;\n      }\n      .button:hover {\n        background-color: var(--hover-color);\n      }\n      .button:active {\n        background-color: var(--active-color);\n      }\n      .draw-grid-all {\n        background: var(--gridAll-icon);\n      }\n      .draw-grid-none {\n        background: var(--gridNone-icon);\n      }\n      .draw-horizontal {\n        background: var(--gridHorizontal-icon);\n      }\n      .draw-vertical {\n        background: var(--gridVertical-icon);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBorderSidesEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-border-sides-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7" *ngIf="property.property != 'gridLines'">
          <div class="button-group">
            <div
              class="button {{
                object.drawTop && object.drawLeft && object.drawBottom && object.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('All')" alt="" />
            </div>
            <div
              class="button {{
                !object.drawTop && !object.drawLeft && !object.drawBottom && !object.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('None')" alt="" />
            </div>
            <div
              class="button {{ object.drawTop ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Top')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawTop')"
            >
              <img [src]="theme.getIcon('Top')" alt="" />
            </div>
            <div
              class="button {{ object.drawLeft ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Left')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawLeft')"
            >
              <img [src]="theme.getIcon('Left')" alt="" />
            </div>
            <div
              class="button {{ object.drawBottom ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Bottom')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawBottom')"
            >
              <img [src]="theme.getIcon('Bottom')" alt="" />
            </div>
            <div
              class="button {{ object.drawRight ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Right')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawRight')"
            >
              <img [src]="theme.getIcon('Right')" alt="" />
            </div>
          </div>
        </td>
        <td colspan="7" *ngIf="property.property == 'gridLines'">
          <div class="button-group">
            <div
              class="button {{ object.drawHorizontal && object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('GridAll')" alt="" />
            </div>
            <div
              class="button {{ !object.drawHorizontal && !object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('GridNone')" alt="" />
            </div>
            <div
              class="button {{ object.drawHorizontal ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'StiOrientationHorizontal')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawHorizontal')"
            >
              <img [src]="theme.getIcon('Horizontal')" alt="" />
            </div>
            <div
              class="button {{ object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'StiOrientationVertical')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawVertical')"
            >
              <img [src]="theme.getIcon('Vertical')" alt="" />
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        text-align: end;
      }
      tr {
        padding: 3px 0px 3px 0px;
      }
      .active {
        background-color: var(--active-color) !important;
      }
      .active:hover {
        background-color: var(--active-color) !important;
      }
      .button-group {
        display: flex;
        width: 100%;
        flex-direction: row;
        justify-content: start;
      }
      .button {
        height: 22px;
        width: 28px;
        background-color: var(--back-color);
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .button img {
        height: 16px;
        width: 16px;
      }
      .button:hover {
        background-color: var(--hover-color);
      }
      .button:active {
        background-color: var(--active-color);
      }
      .draw-grid-all {
        background: var(--gridAll-icon);
      }
      .draw-grid-none {
        background: var(--gridNone-icon);
      }
      .draw-horizontal {
        background: var(--gridHorizontal-icon);
      }
      .draw-vertical {
        background: var(--gridVertical-icon);
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }]; }, propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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