import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "../../../sti-tooltip/sti-tooltip.directive";
import * as i6 from "../../../sti-select-button/sti-select-button.component";
export class StiVerticalAlignmentEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.hasName = false;
        this.required = false;
    }
    get object() {
        return this.model.selectedComponent?.element ?? this.model.form.settings;
    }
    get alignment() {
        return this.helper.getProperty(this.object, this.property.property);
    }
    set alignment(value) {
        this.helper.setProperty(this.object, this.property.property, value);
    }
    ngOnInit() { }
}
StiVerticalAlignmentEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiVerticalAlignmentEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiVerticalAlignmentEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiVerticalAlignmentEditorComponent, selector: "sti-vertical-alignment-editor", inputs: { property: "property" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.verticalAlignment"
            [(value)]="alignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>

    <style>
      input {
        font-size: 13px;
        font-weight: 600;
        padding: 2px 4px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
      td {
        padding: 0;
      }
    </style>
  `, isInline: true, styles: ["\n      input {\n        font-size: 13px;\n        font-weight: 600;\n        padding: 2px 4px;\n      }\n      .valid {\n        border-color: rgb(0, 128, 0);\n      }\n      td {\n        padding: 0;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i6.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiVerticalAlignmentEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-vertical-alignment-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.verticalAlignment"
            [(value)]="alignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>

    <style>
      input {
        font-size: 13px;
        font-weight: 600;
        padding: 2px 4px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
      td {
        padding: 0;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }]; }, propDecorators: { property: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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